#!/bin/bash
#
# VERSION=2
# CHANGES="always reboot if device can not be accessed locally => redirect service"

BEROCONF=/usr/fallback/beroconf

## ${1} == restore on 'Restore and Reboot' action
## skipping the part blocking part
if [ -z "${1}" ]; then
	# if activity on gui - do not restart
	[ -f /tmp/has_activity ] && exit 0

	# if installation process running from beroCloud - do not restart
	[ -f /tmp/hasUpdateFromCloud ] && exit 0

	TIMER=5
	# TLSv1.2 issue (increase timer to not reboot every 5 min but every 30 min instead)
	[ ! "$(${BEROCONF} get root TLSv1.2-disabled | /bin/grep -v failed)" = "" ] && TIMER=30

	# check uptime: if lower than 5 min, do not reboot
	if /usr/bin/uptime | /bin/grep min &>/dev/null; then
		upTime=$(/usr/bin/uptime | /usr/bin/awk '{ print $3; }')
		if [ "${upTime}" -lt "${TIMER}" ]; then
			exit 0
		fi
	fi
fi

# restart the device (not an expected recovery-mode ??)
${BEROCONF} delete root boot_recoverymode

/usr/bin/env -i bash -c "/usr/php/backupManagement.php restore" >/dev/null

${BEROCONF} set root boot_skipReset 1

/sbin/reboot
exit 0
