<?php

### ALSO CHANGE LOCAL IP-ADDRESS
/* [INCLUDES] */
include('/usr/www/include/berogui_small.class.php');
$gui = new berogui_small('beroNet SBC / VoIP Gateway: Reproduce');

/* [GLOBAL VARIABLES] */
$_SAVE = '/tmp/reproduce.data';

$_FILES = array(
	'root.jffs2',
	'app.jffs2',
	'userapps.jffs2',
	'conf.jffs2',
);

/* [INTERN FUNCTIONS] */
function checkRemoteIpAddr($ip) {
	$res = exec("/bin/ping -c 1 $ip &>/dev/null && /bin/echo 1 || /bin/echo 0");
	return($res == 1);
}

function checkFilesExist($ip, &$path = null, $files, &$error = '') {
	if (substr($path, 0, 1) == '/') {
		$path = substr($path, 1);
	}
	if (substr($path, -1) == '/') {
		$path = substr($path, 0, -1); 
	}
	foreach ($files as $file) {
		exec("cd /tmp && /bin/echo 'get $path/$file' | /usr/bin/tftp $ip &>/dev/null", $output);
		if (!file_exists("/tmp/$file") || filesize("/tmp/$file") == 0) {
			$error = $file;
			return(0);
		}
		@unlink("/tmp/$file");
	}
	return(1);
}

function downloadMd5sumList($firmware) {
	if (file_exists('/tmp/reproduce.md5sum')) {
		return(1);
	}
	$md5sums = @file("ftp://appliance.beronet.com/beronet_gateway/reproduce/$firmware.md5sum");
	if (is_array($md5sums)) {
		file_put_contents('/tmp/reproduce.md5sum', implode("\n", $md5sums));
		return(1);
	}
	return(0);
}

/* [POST ACTIONS] */
function doCheck($save, $data, $files, &$error = null) {
	@unlink($save);
	$file = '';
	if (!file_exists('/usr/bin/tftp')) {
		$error = "TFTP binary missing. Does the Firmware-Storage has been reset ?<br/>Please install a firmware before to reproduce your device";
		return(0);
	}
	else if (!downloadMd5sumList($data['firmware'])) {
		$error = "Impossible to download the md5sum.list from beroNet server. Please check your internet connection or the given firmware";
		return(0);
	}
	else if (!checkRemoteIpAddr($data['remoteIp'])) {
		$error = "TFTP Server unavailable (IP-Address={$data['remoteIp']}). Please check your connection: TFTP Server or IP-Address of your beroNet device";
		return(0);
	}
	else if (!checkFilesExist($data['remoteIp'], $data['remotePath'], $files, $file)) {
		$error = "The file '$file' does not exist. Please check your TFTP server or the given path '{$data['remotePath']}'";
		return(0);
	}
	$ini = '';
	foreach ($data as $key => $value) {
		$ini .= "$key=$value\n";
	}
	file_put_contents($save, $ini);
	return(1);
}

function doReproduce($save, &$error = null) {
	$data = parse_ini_file($save);
	unset($data['firmware']);
	file_put_contents('/tmp/reproduce.gui', 1);
	exec('/usr/fallback/reproduce.sh '. implode(' ', $data) .'>/dev/null 2>&1 &');
	return(2);
}

/* [HTML] */
function mainBody($file, $state, $error) {
	// init
	$data = array(
		'firmware' 	=> '',
		'localIp' 	=> '',
		'remoteIp' 	=> '',
		'remotePath'=> '',
	);
	// action message
	$message = '';
	$color = 'green';
	switch	($state) {
	case '1':
		$message = 'TFTP Checking successful. You can reproduce your beroNet device';
		break;
	case '2':
		$html = "<script type='text/javascript'>window.setTimeout('setRequest()',300000);</script>\n"
					.	"\t<div style='text-align:center;'>\n"
					.	"Your beroNet SBC / VoIP Gateway is in reproduction phase.<br/>\n"
					. "Please wait until the Normal-Mode GUI has been loaded.<br/>\n"
					. "Please do not plug off the power supply or the Ethernel cable. It will break the device.<br/>\n"
					. "\t</div>\n";
		return($html);
	default:
		$color = 'red';
		$message = $error;
		break;
	}
	$message = "\t\t<div style='text-align:center;color:$color;margin-bottom:15px;'>$message</div>\n";
	// fetch data from previous submit
	if (file_exists($file)) {
		$data = parse_ini_file($file);
		$html = "\t\t<hr style='width:40%;margin-top:15px;margin-bottom:15px;'>\n"
					. "\t\t<b>Please Note</b><br/><br/>\n"
					. "\t\tReproducing your beroNet SBC / VoIP Gateway will take several minutes.<br/>\n"
					. "\t\tDo not remove the ethernet or power cable to avoid breaking the device.<br/>\n"
					. "\t\tPlease wait until the GUI has been reloaded!\n"
					.	"\t\t<form name='reproduce-reproduceform' method='POST' action='reproduce.php' style='margin-top:15px;'>\n"
					.	"\t\t\t<input type='hidden' name='action' value='reproduce'>\n"
					. "\t\t\t<input type='submit' value='Reproduce' onclick='return(confirm(\"Do you want to continue?\"));'>\n"
					. "\t\t</form>\n";
	}
	// fetch local ip-addr
	else {
		$hasIp = 0;
		foreach (array('eth0.10', 'eth0') as $iface) {
			$data['localIp'] = exec('/usr/bin/expr match "$(/sbin/ifconfig '. $iface .')" ".*inet addr:\([0-9\.]*\)"');
			if (strlen($data['localIp'])) {
				$hasIp = 1;
				break;
			}
		}
		if (!$hasIp) {
			$html = "\t<div style='text-align:center;>\n"
						.	"\t\t<b>Please Note</b><br/>\n"
						. "\t\tImpossible to fetch the local IP-Address. Please reboot in Normal-Mode and in Recovery-Mode.<br/>\n"
						. "\t\tIf the problem persits, Please contact the beroNet Support Team.\n"
						. "\t</div>\n";
			return($html);
		}
	}
	// body
	
	$html = "\t<div style='text-align:center;'>\n"
				. "\t\t<h3>Flashing the filesystem via TFTP</h3>\n"
				. "\t\tBefore proceeding: <b>Please read the documentation in our wiki:</b><br/>\n"
				. "\t\t<a target='_blank' href='https://beronet.atlassian.net/wiki/spaces/PUB/pages/3259760641/Recover+the+Gateways+SBCs+Filesystem+via+TFTP+21.03'>Recover the Gateways/SBCs Filesystem via TFTP</a><br/><br/>\n"
			. "\t</div>\n"
			. "\t<div style='text-align:center;'>\n"
				.	"\t\t<form name='check-reproduceform' method='POST' action='reproduce.php'>\n"
					. "\t\t\t<input type='hidden' name='action' value='check'>\n"
					. "\t\t\t<input type='hidden' name='data[localIp]' value='{$data['localIp']}'>\n"	
				. "\t\t\t<table style='text-align:center;'>\n"
				. "\t\t\t\t<tr><th colspan='2'>TFTP-Settings</th></tr>\n"
				. "\t\t\t\t<tr><td>Firmware Version</td><td><input type='text' name='data[firmware]' value='{$data['firmware']}'></td></tr>\n"
				. "\t\t\t\t<tr><td>Local IP-Address</td><td>{$data['localIp']}</td></tr>\n"
				. "\t\t\t\t<tr><td>Remote IP-Address</td><td><input type='text' name='data[remoteIp]' value='{$data['remoteIp']}'></td></tr>\n"
				. "\t\t\t\t<tr><td>Remote Path</td><td><input type='text' name='data[remotePath]' value='{$data['remotePath']}'></td></tr>\n"
				. "\t\t\t\t<tr><td colspan='2'><input type='submit' value='Check TFTP-Connection'></td></tr>\n"
				. "\t\t\t</table>\n"
				. "\t\t</form>\n"
				. $html
				. "\t</div>\n";
	return($message.$html);
}

/* [MAIN] */
$error = '';
$state = 0;
switch ($_POST['action']) {
case 'check':
	$state = doCheck($_SAVE, $_POST['data'], $_FILES, $error);
	break;
case 'reproduce':
	$state = doReproduce($_SAVE, $error);
	break;
default:
	break;
}

print $gui->header()
		.	mainBody($_SAVE, $state, $error)
		.	$gui->footer('reproduce');
?>
