<?php
# VERSION=11
# CHANGES="New GUI-Design."

include_once("/usr/www/include/SQLite2ToSQLite3.php");
include('/usr/fallback/beroConf.php');
include('/usr/www/include/berogui_small.class.php');

function get_app_master ($app_root) {

	if (!is_dir($app_root) || !($dh = opendir($app_root))) {
		return(NULL);
	}

	while (($app_name = readdir($dh)) !== false) {
		if (($app_name == '.') || ($app_name == '..')) {
			continue;
		}

		$app_version = $app_root . '/' . $app_name . '/VERSION';

		if (!($fp = @fopen($app_version, 'r'))) {
			continue;
		}

		$fcont = fread($fp, filesize($app_version));
		fclose($fp);

		if (strstr($fcont, 'CLASS=master')) {
			closedir($dh);
			return($app_name);
		}

	}

	closedir($dh);

	return(NULL);
}

function body() {
	$str =	"\t<div style='text-align:center;'>\n"
				. "\t\t<h3>Welcome to the beroNet Recovery-Utility!</h3>\n"
				. "\t\tThese pages are only displayed if you started the device in Recovery-Mode or something has gone terribly wrong.<br/>\n"
				. "\t\tVisit our wiki at <a href='https://wiki.beronet.com' target='_blank'>wiki.beronet.com</a> for more information or reach us at <a href='https://support.beronet.com' target='_blank'>support.beronet.com</a>!<br/><br/>\n"
				. "\t\tFrom here you can perform a full reset of the system, install a new firmware or download the generated configuration file.<br/><br/>\n";
	$str .=		  "\t\t<h3>Recovery Options</h3>\n"
				. "\t\tPlease note: The Factory Reset may take some time. After the process is completed, install the <b>latest firmware</b>!<br/><br/>\n"
				. "\t\t<div style='display:inline-flex;'>\n";
	if (!file_exists('/tmp/reset-full')) {
		$str .=  "\t\t\t<form name='full-reset' method='POST' action='cgi-bin/management.php'>\n"
						. "\t\t\t\t<input type='hidden' name='action' value='full-reset'>\n"
						. "\t\t\t\t<input type='submit' value='Factory Reset' onclick='return(confirm(\"All data will be lost. Do you want to continue?\"));'>\n"
					. "\t\t\t</form>\n";
	}
	$str .= "\t\t\t<form name='rstr-backupform' method='POST' action='cgi-bin/update-tool.php'>\n"
						. "\t\t\t\t<input type='submit' value='Firmware Update'>\n"
					. "\t\t\t</form>\n"
				. "\t\t</div>\n"
				. "\t\t<br/>\n"
			. "\t</div>\n";
	if (file_exists('/tmp/beroNetVoIPGateway_recoverymode.config.xml')) {
		$str .= "\t<div style='text-align:center;margin-top:15px;'>\n"
					. "\t\t<h3>Backup</h3>\n"
					. "\t\t<div style='display:inline-flex;'>\n"
					. "\t\t\t<form name='dl-backupform' method='GET' action='cgi-bin/backup.php'>\n"
					. "\t\t\t\t<input type='hidden' name='action' value='download'>\n"
					. "\t\t\t\t<input type='hidden' name='filename' value='beroNetVoIPGateway_recoverymode.config.xml'>\n"
					. "\t\t\t\t<input type='submit' value='Download'>\n"
					. "\t\t\t</form>\n";
		$sshCnts = glob('/usr/conf/ssh/*');
		if (file_exists('/usr/local/VERSION') && function_exists('curl_init') && !empty($sshCnts)) {
			$str .= "\t\t\t<form name='rstr-backupform' method='POST' action='cgi-bin/reboot.php'>\n"
						. "\t\t\t\t<input type='hidden' name='action' value='restore'>\n"
						. "\t\t\t\t<input type='submit' value='Restore & Reboot'>\n"
						. "\t\t\t</form>\n";
		}
		$str .= "\t\t</div>\n"
					.	"\t</div>\n";
	}
	$str .=	"\t<div style='text-align:center;margin-top:15px;'>\n"
				. "\t\tGood luck!<br/><br/>Your beroNet Development Team\n"
			. "\t</div>\n";

	return($str);
}

## php script loaded -> has activity. We avoid cron task to reboot the device
file_put_contents('/tmp/has_activity', 1);

$userapp_root		= '/apps';
$userapp_master_dir	= get_app_master($userapp_root);
$userapp_master_www	= file_exists($userapp_root . '/' . $userapp_master_dir . '/www/index.php');

$bc = new beroConf('root');
require_once('/usr/www/include/redirect.php');

$gui = new berogui_small('beroNet SBC / VoIP Gateway: Recovery-Utility');

echo	$gui->header()
		.	body()
		.	$gui->footer();
?>
