#!/bin/bash
#
# VERSION=26
# CHANGES="clean new libcrypto and libssl libraries path during downgrade"
#

# constants #
PIDFILE=/var/run/install_daemon.pid
PIPEFILE=/tmp/install_pipe

# main #
if [ -z "${1}" ]; then
	echo "ERROR: No Package specified, leaving."
	exit 1
fi

# check if there is a PIDFILE
if [ -f ${PIDFILE} ]; then
	echo "ERROR: An Installation-Process seems to be running already, leaving."
	exit 2
fi

#check the /mnt/images link
mntimages=`readlink /mnt/images|sed 's/\/$//'`
if [[ "$mntimages" != /tmp/images ]]; then
	rm -f /mnt/images
	ln -s /tmp/images /mnt/images
fi

#check the VERSION file
### appfs: located under tmp
### others: located at the root
if ! tar xzf /mnt/images/${1} tmp/VERSION -C / ; then 
	if ! tar xzf /mnt/images/${1} VERSION -C /tmp; then
		echo "ERROR: Extracting VERSION file failed. Leaving."
		exit 3
	fi
fi


# create named pipe to catch output
rm -f ${PIPEFILE}
/bin/mknod ${PIPEFILE} p

if [ "${1}" == "rootfs.tar.gz" ]; then
	/sbin/start-stop-daemon -S -b -m -p ${PIDFILE} -x /usr/sbin/install_rootfs_daemon.sh -- ${1}
	sleep 2
else
	/sbin/start-stop-daemon -S -b -m -p ${PIDFILE} -x /usr/sbin/install_daemon.sh -- ${1}
	sleep 2
fi

while true; do
	if [ ! -f ${PIDFILE} ]; then
		killall -3 tail
		break
	fi
	sleep 2
done &

tail -f ${PIPEFILE}

sleep 1
rm -f ${PIPEFILE}

#delete the install package
if [ -f /mnt/images/"$1" ]; then
	rm /mnt/images/"$1"
fi

exit 0
