<?php

if (!defined('_PROVISIONINGTOOL_CLASS')) {
	define('_PROVISIONINGTOOL_CLASS', true);

	include('/usr/fallback/beroConf.php');
	require_once("/usr/www/include/SQLite2ToSQLite3.php");
	require_once('/usr/php/include/rootHelper.class.php');
	require_once('/usr/local/php/include/restore.Class.php');

	class provisioningTool {

		private $_beroConf;
		private $_restore;

		private $_provMode;
		private $_provUrl;
		private $_pollingInterval;
		private $_provPath;
		private $_provFile;
		private $_provOpts;
		private $_provLock = '/tmp/provisioning.lock';
		private $_provUseragent = 'beroNet VoIP Gateway';

		private $_stdout = '';

		private $_tempPath;
		private $_confPath;

		private $_configFileMandatoryListOld;
		
		private $_configFileOtherListOld;
		private $_configFileListOld;

		private $_isNormalMode = true;
		private $_isNewProvFile = false;
		private $_isNewConfigFormat = null;

		private $_logPath = '/usr/conf/permlog/outgoing';
		private $_logFile;

		private $_xmlParsed = array(
		          'activate'     => null,
		          'apps'         => null,
		          'appsConfig'   => null,
		          'configEnabled'=> null,
		          'fw'           => null,
		          'parentClass'  => null,
		        );

		/* [CONSTRUCTOR | DESTRUCTOR] */
		function __construct ($apiCall = false) {
			$this->_confPath	= '/usr/conf/';
			$this->_tempPath	= '/tmp/provisioning';

			$this->_beroConf	= new beroConf('root');
			$this->_restore		= new restoreConfig(0);

			$this->_provMode	= $this->_beroConf->get('root', 'provisioning_mode');
			$this->_provUrl		= $this->_beroConf->get('root', 'provisioning_url');
			$this->_pollingInterval	= $this->_beroConf->get('root', 'polling_interval');

			if (($useragent = $this->_beroConf->get('root', 'provisioning_useragent')) != '') {
				$this->_provUseragent = str_replace(
					array('{FIRMWARE}', '{MAC}', '{SERIAL}', '{MODULES}'),
					array(rootHelper::getAppFsVersion(), rootHelper::getNetworkMacAddr(rootHelper::getNetworkIfaceByName('lan', $this->_beroConf)), rootHelper::getSerial(), implode('_', rootHelper::getLif())),
					$useragent
				);
			}

			if (!file_exists($this->_tempPath)) {
				rootHelper::mkdir(0, $this->_tempPath);
			}

			## provisioning running to recover the device
			if (file_exists('/tmp/recover.device')) {
				## checking curl status
				if (!function_exists('curl_init')) {
					## not working. using wget
					exec('/usr/sbin/recover.sh &');
					exit(false);
				}
				## curl working. enabling by default provisioning mode
				$this->_provMode = 'once';
				## checking url. if empty, using berocloud as provisioning webserver to restore device
				if (strlen($this->_provUrl) === 0) {
					$this->_provUrl = "http://www.beronet.com/wp-content/uploads/downloads/berofix/provisioning_recover/firmware-23.01.xml";
				}
			}

			## rotate and iniate log
			$logFile = 'provisioning.log';
			rootHelper::logRotate(0, $this->_logPath, $logFile);

			if (($this->_logFile = fopen("{$this->_logPath}/$logFile", 'w')) == null) {
				if ($apiCall) {
					return(false);
				}
				exit(false);
			}

			if (!strstr($this->_provUrl, 'http://') && !strstr($this->_provUrl, 'https://') && !strstr($this->_provUrl, 'tftp://')) {
				$this->_add2LogFile('ProvisioningTool', 'error', 'provisioning_url_malformed');
				if ($apiCall) {
					return(false);
				}
				exit(false);
			}

			// check the device mode
			//// config update in normal mode
			//// fw update in normal/update/recovery-mode
			$this->_isNormalMode &= ($this->_beroConf->get('root', 'boot_fwupdate') != 1) && ($this->_beroConf->get('root', 'boot_recoverymode') != 1);

			$this->_parseUrl();
			if (!$this->_checkTls()) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'client_certificate_issue');
				if ($apiCall) {
					return(false);
				}
				exit(false);
			}

			// get and check file
			if (file_exists($this->_provLock)) {
				## do nothing. old provisioning running
				return;
			}
			else if ($this->_provMode == 'off') {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'provisioning_disabled_by_gateway');
				if ($apiCall) {
					return(false);
				}
				exit(false);
			}
			else if ($this->_getFile($this->_provFile) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $this->_provFile);
				if ($apiCall) {
					return(false);
				}
				exit(false);
			}
			else if (strcmp(md5(file_get_contents("{$this->_tempPath}/{$this->_provFile}")), $this->_beroConf->get('root', 'provisioning_config_md5')) == 0) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'provisioningfile_on_server_not_updated', $this->_provFile);
				if ($apiCall) {
					return(false);
				}
				exit(false);
			}

			$this->_isNewProvFile = true;
			$this->_isNewConfigFormat = $this->_isNewConfigFormat();

			// parse xml file
			if (is_null($this->_isNewConfigFormat)) {
				$this->_isNewProvFile = false;
				if ($apiCall) {
					return(false);
				}
				exit(false);
			}
			else if ($this->_isNewConfigFormat) {
				include('/usr/php/include/configExportImportTool.class.php');
				$imp = new configExportImportTool("{$this->_tempPath}/{$this->_provFile}");
				$this->_xmlParsed = array(
					'activate'     => $imp->getConfigActivate(),
					'apps'         => $imp->getAppInstallInfo(),
					'configEnabled'=> $imp->getConfigEnabled('Config'),
					'fw'           => $imp->getFirmwareInstallInfo(),
					'parentClass'  => $imp,
				);
				return;
			}

			// manage old files
			$this->_configFileMandatoryListOld = array('isgw.conf', 'isgw.dialplan', 'isgw.sip', 'hardware.conf');
			$this->_configFileOtherListOld = array('isgw.isdn', 'isgw.gsm', 'isgw.analog', 'misc.conf', 'filter.conf', 'isgw.tones', 'isgw.causes');
			$this->_configFileListOld = array_merge($this->_configFileMandatoryListOld, $this->_configFileOtherListOld);
		}

		function __destruct () {
			fclose($this->_logFile);
			$this->_logFile = null;

			if ($this->_provMode == 'once') {
				$this->_beroConf->set('root', 'provisioning_mode', 'off');
			}
			rootHelper::system(0, "/bin/rm -rf {$this->_tempPath}");
		}

		/* [PUBLIC METHODS] */
		public function getStdout() {
			return($this->_stdout);
		}

		public function onBoot() {
			if ($this->_isNewProvFile && !file_exists($this->_provLock)) {
				// lock provisioning until task is finished
				file_put_contents($this->_provLock, '1');

				// old config format
				// same behavior than before: update config and update firmware
				if (!$this->_isNewConfigFormat && $this->_isNormalMode) {
					$this->_updateConfigOld();
					$this->_updateFirmwareOld();
					rootHelper::unlink(0, $this->_provLock);
					return($ret);
				}

				// new config format -> new behavior
				// if firmware update -> do both config and firmware update (and reboot)
				// if config update only -> old behavior: do update
				$keepCloud = array();
				$needActivate = false;
				if ($this->_hasConfigUpdate() && $this->_isNormalMode) {
					if ($this->_beroConf->get('root', 'redirect-provisioning-tls') == 1) {
						foreach (array('cloud_enable', 'cloud_key', 'cloudAddress', 'cloud_show_status') as $key) {
							$keepCloud[$key] = $this->_beroConf->get('root', $key);
						}
					}

					if (!$this->_updateConfig($needActivate)) {
						rootHelper::unlink(0, $this->_provLock);
						return(false);
					}
				}
				$this->_updateAppConfig();

				$needReboot = false;
				if ($this->_hasFwUpdate()) {
					if ($needActivate) {
						$needReboot = true;
						$this->_doActivate(true);
					}
					if (!$this->_updateFirmware($needReboot)) {
						rootHelper::unlink(0, $this->_provLock);
						return($needReboot ? rootHelper::reboot() : false);
					}
				}
				$this->_updateApps();

				if (!empty($keepCloud)) {
					$needActivate = true;
					foreach ($keepCloud as $key => $value) {
						$this->_beroConf->set('root', $key, $value);
					}
				}

				rootHelper::unlink(0, $this->_provLock);
				$this->_beroConf->set('root', 'provisioning_config_md5', md5(file_get_contents("{$this->_tempPath}/{$this->_provFile}")));
				if ($needActivate) {
					$this->_doActivate();
				}
				else if ($needReboot) {
					rootHelper::reboot();
				}

				return(true);
			}
			// do nothing
			return(null);
		}

		public function onRun() {
			if ($this->_isNewProvFile && !file_exists($this->_provLock)) {
				// set locking file
				file_put_contents($this->_provLock, '1');

				// old config format
				// same behavior than before: update configuration
				if (!$this->_isNewConfigFormat && $this->_isNormalMode) {
					$this->_updateConfigOld();
					rootHelper::unlink(0, $this->_provLock);
					return($ret);
				}

				// new config format -> new behavior
				// if firmware update, reboot the device
				// if config update, old behavior: do the update
				if ($this->_hasFwUpdate()) {
					rootHelper::unlink(0, $this->_provLock);
					rootHelper::reboot();
				}
				else if ($this->_hasConfigUpdate() && $this->_isNormalMode) {
					$keepCloud = array();
					$needActivate = false;
					if ($this->_beroConf->get('root', 'redirect-provisioning-tls') == 1) {
						foreach (array('cloud_enable', 'cloud_key', 'cloudAddress', 'cloud_show_status') as $key) {
							$keepCloud[$key] = $this->_beroConf->get('root', $key);
						}
					}
					if (!$this->_updateConfig($needActivate)) {
						rootHelper::unlink(0, $this->_provLock);
						return(false);
					}
					if (!empty($keepCloud)) {
						$needActivate = true;
						foreach ($keepCloud as $key => $value) {
							$this->_beroConf->set('root', $key, $value);
						}
					}
					$this->_updateAppConfig();
					rootHelper::unlink(0, $this->_provLock);
					$this->_beroConf->set('root', 'provisioning_config_md5', md5(file_get_contents("{$this->_tempPath}/{$this->_provFile}")));
					if ($needActivate) {
						return($this->_doActivate());
					}
				}
				rootHelper::unlink(0, $this->_provLock);
				return(true);
			}
			// do nothing
			return(null);
		}

		public function updateConfig() {
			if ($this->_isNewProvFile && $this->_hasConfigUpdate() && $this->_updateConfig()) {
				$this->_updateAppConfig();
				$this->_beroConf->set('root', 'provisioning_config_md5', md5(file_get_contents("{$this->_tempPath}/{$this->_provFile}")));
				return(true);
			}
			return($this->_updateConfigOld());
		}

		/* [PRIVATE METHODS] */
		private function _doActivate($skipReboot = false) {
			switch ($this->_xmlParsed['activate']) {
			case 1:
			case 2:
			case 3:
				$this->_add2LogFile(__FUNCTION__, 'success', "activation_level_{$this->_xmlParsed['activate']}_by_provisioning", $this->_provFile);
				require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
				Helper::activateApi($this->_xmlParsed['activate']);
				require_once('/usr/local/www/berogui/includes/fileManagement.php');
				$fm = new fileManagement();
				return($fm->activate(false, array(), $skipReboot));
			default:
				$this->_add2LogFile(__FUNCTION__, 'warning', "invalid_activation_level_{$this->_xmlParsed['activate']}", $this->_provFile);
				return(false);
			}
		}

		private function _hasConfigUpdate() {
			if ($this->_xmlParsed['configEnabled'] == false) {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'config_provisioning_disabled_by_server');
				return(false);
			}
			$this->_add2LogFile(__FUNCTION__, 'info', 'config_provisioning_enabled_by_server');
			return(true);
		}

		private function _hasFwUpdate() {
			if ($this->_xmlParsed['fw'] === false) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'no_firmware_provisioned');
				return(false);
			}
			else if ($this->_xmlParsed['fw']['install'] == 'no') {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'firmware_provisioning_disabled_by_server');
				return(false);
			}
			else if ($this->_isAcceptedFirmware($this->_xmlParsed['fw']['package']) == false) {
				$this->_add2LogFile(__FUNCTION__, 'info', 'older_firmware_than_21.X_unaccepted', $this->_provFile);
				return(false);
			}
			else if ($this->_firmwareDifferent($this->_xmlParsed['fw']['package']) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'firmware_provisioned_same_version', $this->_xmlParsed['fw']['package']);
				return(false);
			}
			$this->_add2LogFile(__FUNCTION__, 'info', 'fimware_provisioning_enabled_by_server');
			return(true);
		}

		private function _checkTls() {
			if (file_exists('/usr/conf/tls/client.crt')) {
				$error = '';
				if (!rootHelper::tlsRenewCertificate($this->_beroConf, $error)) {
					$this->_add2LogFile(__FUNCTION__, 'error', "TLS:error:$error");
					return(false);
				}
				if (!rootHelper::tlsCheckCertificate()) {
					$this->_add2LogFile(__FUNCTION__, 'error', 'TLS:error:client_certificate_issue');
					return(false);
				}
			}
			return(true);
		}

		public function replaceUrl($url, $bc) {
			defined('_ROOTHELPER_CLASS') or require_once('/usr/php/include/rootHelper.class.php');
			return(str_replace(
				array('{MAC}', '{SERIAL}', '{MODULES}'),
				array(strtoupper(str_replace(':','',rootHelper::getNetworkMacAddr(rootHelper::getNetworkIfaceByName('lan', $bc)))), rootHelper::getSerial(), implode('_', rootHelper::getLif())),
				$url
			));
		}

		private function _parseUrl() {
			// replace flags
			$this->_provUrl = $this->replaceUrl($this->_provUrl, $this->_beroConf);

			# split parts of URL
			$pathArray = pathinfo($this->_provUrl);
			$this->_provPath	= $pathArray['dirname'];
			if (strstr($pathArray['basename'], '?')) {
				$this->_provFile	= substr($pathArray['basename'], 0, strpos($pathArray['basename'], '?'));
				$this->_provOpts	= substr($pathArray['basename'], strpos($pathArray['basename'], '?'), strlen($pathArray['basename']));
			} else {
				if (substr($this->_provUrl, - 1) == '/') {
					$this->_provPath .= '/' . $pathArray['basename'];
					$this->_provFile = '';
				} else {
					$this->_provFile = $pathArray['basename'];
				}
				$this->_provOpts	= '';
			}
			unset($pathArray);

			if (strlen($this->_provFile) == 0) {
				$this->_provFile = 'conf-update.conf';
			}
		}

		private function _add2LogFile($function, $level, $message, $file = null, $stdout = 1) {
			if (($function == null) || ($level == null) || ($message == null)) {
				return;
			}

			$file = (($file != null) ? ':' . $file : '');
			$string = "$function:$level:$message$file\n";

			if ($stdout == 1) {
				$this->_stdout .= "$string<br/>";
			}

			if ($this->_logFile != null) {
				fwrite($this->_logFile, $string);
			}
		}

		private function _isAcceptedFirmware($firmware) {
			if (preg_match('/^appfs-(?<major>[0-9]{2}).([0-9.rc-]*)\.tar\.gz$/', $firmware, $matched)) {
				// firmware older than 21.X not accepted
				return($matched['major'] >= 21);
			}
			return(false);
		}

		private function _firmwareDifferent ($provisionedFirmware) {
			if (!file_exists('/usr/local/FILENAME')) {
				return(true);
			}

			$installedFirmware = file_get_contents('/usr/local/FILENAME');
			
			preg_match('/^appfs-(?<version>[0-9\.a-z-]*).tar.gz$/', $installedFirmware, $res['installed']);
			preg_match('/^appfs-(?<version>[0-9\.a-z-]*).tar.gz$/', $provisionedFirmware, $res['provisioned']);

			# always true, if we cannot determine the provisioned version
			if (!isset($res['provisioned']['version'])) {
				return(true);
			}

			# always install if firmware are different
			return($res['installed']['version'] != $res['provisioned']['version']);
		}

		private function _rootfsDifferent () {
			## check if the PKG_VERSION from VERSION.rootfs differs between the old and installed one
			## if differ, we reboot the sbc
			if (!file_exists('/pkginfo/VERSION.rootfs')) {
				return(true);
			}
			$oldRootfs = parse_ini_file('/pkginfo/VERSION.rootfs');

			$newRootfs = null;
			if (file_exists('/usr/local/conf/rootfs/VERSION.rootfs')) {
				$newRootfs = parse_ini_file('/usr/local/conf/rootfs/VERSION.rootfs');
			}
			else if (file_exists('/home/admin/conf/rootfs/VERSION.rootfs')) {
				$newRootfs = parse_ini_file('/home/admin/conf/rootfs/VERSION.rootfs');
			}
			return($oldRootfs['PKG_VERSION'] != $newRootfs['PKG_VERSION']);
		}

		private function _getFile($fileName, $Url = '') {
			if (file_exists("{$this->_tempPath}/$fileName")) {
				return(true);
			}
			require_once('/usr/php/include/Curl.class.php');

			// build cURL request
			$ch = new Curl($this->_beroConf, rootHelper::tlsGetCertificate());

			$logFile = 'provisioning.curl.log';
			rootHelper::logRotate(0, $this->_logPath, $logFile, array('size' => '10000')); // 10000 bytes = 100kb in berofix pov
			$ch->log_file = "{$this->_logPath}/$logFile";

			// set basic config / options
			$url = "{$this->_provPath}/$fileName" . (!strstr('tftp://', $this->_provPath) ? $this->_provOpts : '');
			if (strlen($Url)) {
				$url = $Url;
			}
			
			$options['useragent'] = $this->_provUseragent;
			if (substr($fileName, -3) == '.gz') {
				$options['header'] = array('AcceptEncoding: gzip');
			}

			foreach (array('debug', 'verifyhost', 'verifypeer') as $what) {
				$val = $this->_beroConf->get('root', "provisioning_$what");
				if (strlen($val)) {
					$options[$what] = $val;
				}
			}

			$info = array();
			$fileCont = $ch->sendRequest($url, array(), $options, $info);

			switch ($info['http_code']) {
			case '403':
				$this->_add2LogFile(__FUNCTION__, 'error', 'HTTP:response:forbidden');
				$this->_add2LogFile(__FUNCTION__, 'info', "URL={$this->_provUrl}|path={$this->_provPath}|file={$this->_provFile}|opts={$this->_provOpts}|useragent={$this->_provUseragent}");
				return(false);
			case '404':
				$this->_add2LogFile(__FUNCTION__, 'error', 'HTTP:response:not_found');
				$this->_add2LogFile(__FUNCTION__, 'info', "URL={$this->_provUrl}|path={$this->_provPath}|file={$this->_provFile}|opts={$this->_provOpts}|useragent={$this->_provUseragent}");
				return(false);
			case '500':
				$this->_add2LogFile(__FUNCTION__, 'error', 'HTTP:response:configuration_error');
				$this->_add2LogFile(__FUNCTION__, 'info', "URL={$this->_provUrl}|path={$this->_provPath}|file={$this->_provFile}|opts={$this->_provOpts}|useragent={$this->_provUseragent}");
				return(false);
			default:
				break;
			}

			if (($info['http_code'] < 200) || ($info['http_code'] >= 400)) {
				$this->_add2LogFile(__FUNCTION__, 'error', "HTTP:status:{$info['http_code']}");
				$this->_add2LogFile(__FUNCTION__, 'info', "URL={$this->_provUrl}|path={$this->_provPath}|file={$this->_provFile}|opts={$this->_provOpts}|useragent={$this->_provUseragent}");
				return(false);
			}

			return((file_put_contents("{$this->_tempPath}/$fileName", $fileCont) === false) ? false : true);
		}

		private function _restoreBackup () {
			if (!is_dir("{$this->_confPath}/backup")) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'directory_does_not_exist', "{$this->_confPath}/backup");
				return(false);
			}

			rootHelper::system(0, "/bin/cp {$this->_confPath}/backup/* {$this->_confPath}");
			$this->_restore->restoreConfig();
			rootHelper::system(0, "/bin/rm -rf {$this->_confPath}/backup");

			return(true);
		}

		// Update / Install methods
		private function _updateConfig(&$needActivate = null) {
			
			$logs =$this->_xmlParsed['parentClass']->import();
			if ($logs['warning']) foreach($logs["warning"] as $log){
				$this->_add2LogFile(__FUNCTION__, 'warning', $log);
			}
			if ($logs['info']) foreach($logs["info"] as $log){
				$this->_add2LogFile(__FUNCTION__, 'info', $log);
			}

			if ($this->_restore->restoreConfig() == true) {
				$this->_add2LogFile(__FUNCTION__, 'success', 'config_provisioning', $this->_provFile);
				$needActivate = true;
				return(true);
			}

			# Provisioning failed, restore Backup.
			$this->_restoreBackup();
			$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_update_configuration');
			return(false);
		}

		private function _updateFirmware(&$needReboot = null) {
			if (($fw = $this->_xmlParsed['fw']) !== false) {
				if (isset($fw['url']) && strlen($fw['url'])) {
					$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded_file', "[URL={$fw['url']}|package={$fw['package']}]");
					if ($this->_getFile($fw['package'], $fw['url']) == false) {
						$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', "[URL={$fw['url']}|package={$fw['package']}]");
						return(false);
					}
				}
				else {
					$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded_file', $fw['package']);
					if ($this->_getFile($fw['package']) == false) {
						$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $fw['package']);
						return(false);
					}
				}

				if (!file_exists('/tmp/images')) {
					rootHelper::mkdir(0, '/tmp/images');
				}
				rootHelper::system(0, "/bin/mv {$this->_tempPath}/{$fw['package']} /tmp/images/{$fw['package']}");

				include('/usr/php/include/updateTool.php');
				$upd = new updateTool();

				file_put_contents ("/tmp/nofpgareset", "nofpgareset\n");
				if ($upd->install($fw['package'], false) == false) {
					$this->_add2LogFile(__FUNCTION__, 'error', 'firmware_update_failed', $fw['package']);
					return(false);
				}

				$this->_add2LogFile(__FUNCTION__, 'success', 'firmware_updated', $fw['package']);
				$needReboot |= $this->_rootfsDifferent();
				return(true);
			}
			return(true);
		}


		private function _updateAppConfig() {
			if ($this->_xmlParsed['appsConfig'] != NULL && ($appConfigFiles = $this->_xmlParsed['appsConfig']) !== false) {
				foreach ($appConfigFiles as $app) {
					$this->_add2LogFile(__FUNCTION__, 'info', 'found_configuration_for_app', $app['name']);

					rootHelper::mkdir(0, "/usr/conf/userapp/{$app['name']}");

					if (empty($app['files'])) {
						continue;
					}

					foreach ($app['files'] as $appFile) {
						switch ($appFile['mode']) {
						case 'directory':
							rootHelper::system(0, "/bin/mkdir -p /usr/conf/userapp/{$appFile['name']}");
							break;
						case 'binary':
							$fileData = base64_decode($appFile['content']);
							break;
						default:
							$fileData = $appFile['content'];
							break;
						}

						if ($appFile['mode'] != 'directory') {
							rootHelper::unlink(0, "/usr/conf/userapp/{$appFile['name']}");
							$FP = fopen("/usr/conf/userapp/{$appFile['name']}", 'w');
							fwrite($FP, $fileData, strlen($fileData));
							fclose($FP);
							$FP = null;
							unset($fileData);
						}

						rootHelper::system(0, "/bin/chown admin:admin /usr/conf/userapp/{$appFile['name']}");
						$this->_add2LogFile(__FUNCTION__, 'info', 'installed_file', $appFile['name']);
					}
				}
			}
			return(true);
		}

		private function _updateApps() {
			if (($apps = $this->_xmlParsed['apps']) !== false) {
				foreach ($apps as $app) {
					if ($app['install'] != 'yes') {
						$this->_add2LogFile(__FUNCTION__, 'info', 'app_install_disabled', $app['package']);
						continue;
					}

					if ($this->_getFile($app['package']) == false) {
						$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $app['package']);
						return(false);
					}
					$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded_file', $app['package']);

					if (!is_dir('/tmp/images')) {
						rootHelper::exec(0, '/bin/mkdir -p /tmp/images');
					}

					rootHelper::exec(0, "/bin/mv {$this->_tempPath}/{$app['package']} /tmp/images/{$app['package']}", $out, $ret);
					if ($ret != 0) {
						$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_copy', $app['package']);
						continue;
					}
					unset($ret, $out);

					$last_line = rootHelper::exec(0, "/usr/sbin/userapp_pkg_install.sh {$app['package']} 1", $out, $ret);
					if ($ret != 0) {
						$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_install', $app['package']);
						$this->_add2LogFile(__FUNCTION__, 'error', 'last_output', $last_line);
						continue;
					}
					unset($ret, $out, $last_line);

					$this->_add2LogFile(__FUNCTION__, 'info', 'installed', $app['package']);
				}
			}
			return(true);
		}

		/* BEGIN: Functions for backwards-compatibility */
		private function _isNewConfigFormat () {
			if ($this->_isNewProvFile) {
				$xml = file_get_contents("{$this->_tempPath}/{$this->_provFile}");
				return(preg_match('/\<\?xml version\=(\"|\')1.0(\"|\') ?.*\?\>/', $xml) && preg_match('/\<beroNetProvisioning\>/', $xml));
			}
			return(null);
		}

		private function _parseConfigOld ($config) {
			if (count($config) == 0) {
				return(false);
			}

			foreach ($config as $line) {
				if (($line[0] == '#') || (strlen($line) == 0)) {
					continue;
				}
				$key_val = explode('=', trim($line));
				$ret[$key_val[0]] = $key_val[1];
			}

			return($ret);
		}

		private function _updateConfigOld () {
			$config = $this->_parseConfigOld(file("{$this->_tempPath}/{$this->_provFile}"));

			if (!in_array($config['CONF_DOWNLOAD'], array('1', 'yes'))) {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'config_download_disabled_by_server');
				return(true);
			}

			# get mandatory files
			foreach ($this->_configFileMandatoryListOld as $file) {
				if ($this->_getFile($file) == false) {
					$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $file);
					return(false);
				}
				$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded', $file);
			}

			# get other files
			foreach ($this->_configFileOtherListOld as $file) {
				$ret = $this->_getFile($file);
				$this->_add2LogFile(__FUNCTION__, (($ret == false) ? 'warning' : 'info'), (($ret == false) ? 'could_not_download' : 'downloaded'), $file);
			}

			# save old conf-files, move new config to /usr/conf
			rootHelper::mkdir(0, "{$this->_confPath}/backup");

			foreach ($this->_configFileListOld as $file) {
				# create Backup
				if (file_exists("{$this->_confPath}/$file")) {
					rootHelper::copy(0, "{$this->_confPath}/$file", "{$this->_confPath}/backup/$file");
					rootHelper::unlink(0, "{$this->_confPath}/$file");
				}

				# install provisioned files
				if (file_exists("{$this->_tempPath}/$file")) {
					$this->_add2LogFile(__FUNCTION__, 'info', 'installed', $file);
					rootHelper::copy(0, "{$this->_tempPath}/$file", "{$this->_confPath}/$file");
				}

				# files that are not provisioned, will be copied back from backup
				# and if they exist as backup
				if (!file_exists("{$this->_confPath}/$file") && file_exists("{$this->_confPath}/backup/$file")) {
					rootHelper::copy(0, "{$this->_confPath}/backup/$file", "{$this->_confPath}/$file");
				}
			}

			if ($this->_restore->restoreConfig() == true) {
				$this->_beroConf->set('root', 'provisioning_config_md5', md5(file_get_contents("{$this->_tempPath}/{$this->_provFile}")));
				$this->_add2LogFile(__FUNCTION__, 'success', 'configuration_updated');
				return(true);
			}

			# Provisioning failed, restore Backup.
			$this->_restoreBackup();
			$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_update_configuration');
			return(false);
		}

		private function _updateFirmwareOld() {
			// download firmware update configuration file
			if ($this->_getFile('firmware-update.conf') == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', 'firmware-update.conf');
				return(false);
			}
			$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded_file', 'firmware-update.conf');

			// check configuration file
			$config = $this->_parseConfigOld(file("{$this->_tempPath}/firmware-update.conf"));

			if (!isset($config['FIRMWARE_FILE']) || !isset($config['FIRMWARE_DOWNLOAD']) || !isset($config['FIRMWARE_INSTALL'])) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'malformed_config_file', 'firmware-update.conf');
				return(false);
			}
			else if ($this->_firmwareDifferent($config['FIRMWARE_FILE']) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'firmware_provisioned_same_version');
				return(false);
			}
			else if (!in_array($config['FIRMWARE_DOWNLOAD'], array('1', 'yes'))) {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'firmware_download_disabled_by_server');
				return(false);
			}
			else if ($this->_getFile($config['FIRMWARE_FILE']) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'could_not_download', $config['FIRMWARE_FILE']);
				return(false);
			}
			else if (!in_array($config['FIRMWARE_INSTALL'], array('1', 'yes'))) {
				$this->_add2LogFile(__FUNCTION__, 'warning', 'firmware_install_disabled_by_server');
				return(false);
			}
			$this->_add2LogFile(__FUNCTION__, 'info', 'downloaded_file', $config['FIRMWARE_FILE']);

			// install firmware
			if (!file_exists('/tmp/images')) {
				rootHelper::mkdir(0, '/tmp/images');
			}
			rootHelper::system(0, "/bin/mv {$this->_tempPath}/{$config['FIRMWARE_FILE']} /tmp/images/{$config['FIRMWARE_FILE']}");

			include('/usr/php/include/updateTool.php');
			$upd = new updateTool();

			if (($ret = $upd->install($config['FIRMWARE_FILE'], false)) == false) {
				$this->_add2LogFile(__FUNCTION__, 'error', 'firmware_update_failed', $config['FIRMWARE_FILE']);
				return(false);
			}

			$this->_add2LogFile(__FUNCTION__, 'success', 'firmware_updated', $config['FIRMWARE_FILE']);
			if ($this->_rootfsDifferent()) {
				rootHelper::exec(0, '/sbin/reboot >/dev/null 2>&1 &');
			}
			return(true);
		}
		/* END: Functions for backwards-compatibility */
	}
} /* _PROVISIONINGTOOL_CLASS */
?>
