#!/bin/bash
#
# VERSION=1
# CHANGES="restart a iface"

export PATH=$PATH:/sbin/:/bin:/usr/sbin:/usr/bin:/usr/fallback

## init
IFACE=$1
[ -z ${IFACE} ] && exit 1

## backup the ntp-host and proviosioning url/mode
## from the udhcpc/default.script  
NTPHOST=
NTPHOST_DEFAULT="pool.ntp.org"
[ -z ${NTPHOST} ] && NTPHOST=${NTPHOST_DEFAULT}

PROVISIONING_URL=
PROVISIONING_MODE=

## restart iface
ifdown ${IFACE} &>/dev/null
ifup ${IFACE} &>/dev/null

## check the restart
if [ "$?" -eq "0" ];
then
	## succeeded: remove crontask and update beroconf
	crontab -l | grep -v "cron_working" > /tmp/crontab
	sed -i "/.*restart_iface.sh ${IFACE}$/d" /tmp/crontab
	crontab /tmp/crontab
	rm -f /tmp/crontab

	beroconf set root ntphost ${NPTHOST}
	beroconf set root provisioning_url ${PROVISIONING_URL}
	beroconf set root provisioning_mode ${PROVISIONING_MODE}
fi

exit 0
