#!/bin/bash

APPS_HOME=/home/admin
APPS_ROOT=/apps

PKG_NAME=${1}
PKG_UPDT=${2}

PKG_ROOT=${APPS_ROOT}/${PKG_NAME}

PREFIX="[userapp_preremove]"

if [ -z ${PKG_NAME} ]; then
	echo "${PREFIX} no package name given, leaving."
	exit 1
fi

echo "${PREFIX} running for ${PKG_NAME} (${PKG_ROOT}):"

if [ -x ${PKG_ROOT}/setup/pre_remove.sh ]; then
	echo "${PREFIX} running ${PKG_NAME}s pre_remove."
	${PKG_ROOT}/setup/pre_remove.sh
fi

if [ "${PKG_UPDT}" != "update" ]; then
	if [ -d /usr/conf/userapp/${PKG_NAME} ]; then
		echo "${PREFIX} removing ${PKG_NAME}s configuration directory."
		rm -rf /usr/conf/userapp/${PKG_NAME}
	fi
fi

if [ -L /home/admin/www/${PKG_NAME} ]; then
	echo "${PREFIX} removing ${PKG_NAME}s www-symlink."
	rm -f /home/admin/www/${PKG_NAME}
fi
