<?php
require_once ("/usr/local/php/include/apiCall.class.php");

class FirmwareGetRootFsVersion extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		if (!file_exists('/pkginfo/VERSION.rootfs')) {
			$this->_execResult = false;
			$this->_execResponseCode = 404;
			return($this->_execResult);
		}


		$contents = file_get_contents('/pkginfo/VERSION.rootfs');

		preg_match('/PKG_VERSION=([0-9]*)/', $contents, $matches);
		$this->_execResultString .= ':' . $matches[1] . ';';

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . ($this->_execResult ? $this->_execResultString : 'error'));
	}

}?>