<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/php/include/shortMessageService.Class.php');

class SmsDeleteMessage extends apiCall {
	private $_sms;

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
		$this->_sms = new ShortMessageService();
	}

	function execute () {

		if (!isset($this->_parameters['SmsQueue']) || !isset($this->_parameters['SmsIdentifier'])) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$this->_sms->deleteMessage($this->_parameters['SmsQueue'], $this->_parameters['SmsIdentifier']);

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>