<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/fallback/beroConf.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

class beroCloudRegister extends apiCall {
	
	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		if (!isset($this->_parameters['CloudUser']) || !isset($this->_parameters['CloudPassword'])) {
			$this->_execResultString = 'error:credentials_missing;';
			$this->_execResult = false;
			$this->_execResponseCode = 406;
			return($this->_execResult);
		}

		// open databases
		$bc = new beroConf('root');

		// open berocloud api
		require_once('/usr/php/include/SbcApi.php');
		$cloud = new SbcApi($bc);
		$res = $cloud->send('register', array('cloud_username' => $this->_parameters['CloudUser'], 'cloud_password' => $this->_parameters['CloudPassword']));

		// evaluate result
		preg_match('/[^a-zA-Z0-9=]*?yaqwsx(?<key>.+)yaqwsx/', $res, $matches);
		$key = unserialize($matches['key']);
		if (!isset($key['key'])) {
			$this->_execResultString = 'error:' . trim($res) . ';';
			$this->_execResult = false;
			$this->_execResponseCode = 502;
			return($this->_execResult);
		}

		// save key in rootDB / enable cloud monitoring
		$bc->set('root', 'cloud_key', $key['key']);
		$bc->set('root', 'cloud_enable', 1);

		Helper::activate(1);

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>