<?php

include_once("/usr/local/www/berogui/includes/Helper/Helper.php");
abstract class apicall {

  protected $_parameters;
  protected $_allowedParameters = array('apiCommand'=>'alphanumeric');
  protected $_sanitizeOptions =array();
  protected $_execResult = true;
  protected $_execResultString ='success';
  protected $_execResponseCode = 200;

	protected $_name, $_files;

  abstract function execute();
  abstract function display();

  /**
   * constructor of the apicall class
   * Sets name, parameters and files
   *
   * @param array $get
   * @param array $post
   * @param array $files 
   */
	function __construct ($get = null, $post = null, $files = null) {
		$this->_parameters = array_merge($get, $post);
		$this->_files = $files;
	}

  /**
   * returns responsecode
   *
   * @return bool|int
   */
  public function responsecode () {
	  return($this->_execResponseCode);
  }

  /**
   * sanitizes inputs
   * if any invalid inputs are given, sets a <code>_execresultString</code>, the <code>_execResult</code> to false and the <code>_responseCode</code> to 405
   *
   * @return bool returns true on valid paramerts , false on invalid paramters
   */
	protected function sanitizeInputs(){
    $exec_ajax = 1;
		$invalid = array();
    $this->_parameters = Helper::sanitizePost($this->_parameters, $this->_allowedParameters, $exec_ajax, $invalid, $this->_sanitizeOptions);
    //if sanitization failed set execresult stuff and return false
    if (!$exec_ajax) {
			$this->_execResultString = 'error. Invalid parameter or parameter value: '.$invalid['key'];
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return false;
		}
    return true; 
	}
}

?>