<?php

/*
 * sipProfileDownloader.Class.php: Class to manage download of SIP-Profile-Packages.
 *
 * Copyright (C) 2016 beroNet GmbH
 *
 * Author: Florian Kraatz <fk@beronet.com>
 *
 * If you experience problems with this component, please contact <support@beronet.com>!
 */

if (!defined('_SIPPROFILEDOWNLOADER_CLASS')) {
	define('_SIPPROFILEDOWNLOADER_CLASS', true);

	class sipProfileDownloader {

		private $_fileListUrl;

		function __construct () {
			$this->_fileListUrl = 'ftp://appliance.beronet.com/beronet_gateway/sip-profiles.list';
		}

		public function readProfileList () {

			if (!($lines = @file($this->_fileListUrl))) {
				return(false);
			}

			foreach ($lines as $line) {
				if (($line == "\n") || ($line[0] == '#')) {
					continue;
				}
				$tmp = explode(';', trim($line, "\n\t"));
				$ret[] = array('name' => $tmp[0], 'version' => $tmp[1], 'url' => $tmp[2], 'meta-text' => $tmp[3]);
			}

			return($ret);
		}

		public function downloadProfile ($url) {

			$tmpArchive = '/tmp/' . basename($url);

			if (!isset($url)) {
				return(false);
			}

			if (($fp = fopen($tmpArchive, 'w')) == null) {
				return(false);
			}

			if (($ch = curl_init(str_replace(' ', '%20', $url))) == null) {
				return(false);
			}

			curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			curl_setopt($ch, CURLOPT_FILE, $fp);
			curl_exec($ch);
			$retcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			curl_close($ch);
			fclose($fp);

			if (($retcode < 200) || ($retcode >= 300)) {
				@unlink($tmpArchive);
				return(false);
			}

			@exec('/bin/tar -xzf ' . $tmpArchive . ' -C /usr/conf/profile/', $output, $retval);
			@exec('/bin/chown -R root:root /usr/conf/profile');
			@unlink($tmpArchive);

			return(($retval == 0) ? true : false);
		}
	}
}

?>
