#!/bin/bash
#
# This script is executed only once, immediately after the image
# tarball is unpacked to the app partition (/usr/local).
#

# global variables #
BEROCONF=/usr/fallback/beroconf
export PATH="/bin:/sbin:/usr/bin:/usr/sbin:/usr/fallback"

source /usr/local/VERSION
[ -f /usr/fallback/helper ] && source /usr/fallback/helper

# functions #
function log {
	prefix=${1:common}

	pipe=/tmp/install_pipe
	[ -p ${pipe} ] && echo "[install_${prefix}] $(date): ${2}" &>${pipe} ## show on GUI

	## write on logs / show on cmd line
	if type -t permlog 2>&1 >/dev/null; then
		permlog "install-postinstall-${prefix}" "[install_${prefix}]" "${2}" ${3}
	else
		echo "[install_${prefix}] $(date) ${2}" | tee -a /usr/conf/permlog/install-postinstall-${prefix}.log
	fi
}

function need_replace {

	old_c=$(grep "VERSION=[0-9]\{1,10\}" ${1})
	old_v=$(expr match "${old_c}" ".*=\([0-9]*\)")
	unset old_c

	new_c=$(grep "VERSION=[0-9]\{1,10\}" ${2})
	new_v=$(expr match "${new_c}" ".*=\([0-9]*\)")
	unset new_c

	if [ -z "${new_v}" ]; then
		echo 0
		return
	fi

	if [ -z "${old_v}" ] || [ ${old_v} -lt ${new_v} ]; then
		echo 1
		return
	fi

	echo 0
}

# main #
[ -f /usr/conf/permlog/install-postinstall-${TYPE:common}.log ] && rm -f /usr/conf/permlog/install-postinstall-${TYPE:common}.log 

# check if this RootFS uses already the new Package-Mechanism
MIG2TO3=0
if [ ! -d "/pkginfo" ]; then
	MIG2TO3=1
fi

# update conffs
log "${TYPE}" "Updating ConfFS."
conf_filelst="/usr/conf/snmpd_berofix.conf /usr/conf/isgw.tones /usr/conf/apiusers.conf"
for i in ${conf_filelst}; do
	conf_new="/usr/local/conf/conffs/${i//\/usr\/conf\//}"
	if [ "$(need_replace "${i}" "${conf_new}")" -eq 1 ] ; then
		cp ${conf_new} ${i}
	fi
done

# migrate isdn.conf to hardware.conf
if [ -f /usr/conf/isdn.conf ] ; then
	if grep -A2 "type=$" /usr/conf/isdn.conf | grep "clock=1" > /dev/null ; then
		sed "s/type=$/type=bf1E1/" /usr/conf/isdn.conf > /usr/conf/hardware.conf
		rm /usr/conf/isdn.conf
	else
		mv /usr/conf/isdn.conf /usr/conf/hardware.conf
	fi
	rm /usr/conf/ari.db
	/usr/bin/env -i bash -c "/usr/local/php/migration.php > /dev/null"
fi

# create www-api-directory if it does not exist
if [ ! -d /usr/local/www/api ] ; then
    mkdir -p /usr/local/www/api
fi

# configure lan-mtu to sane value
if [ "$(${BEROCONF} get root lan-mtu)" = "500" ] ; then
        ${BEROCONF} set root lan-mtu 1500
fi

# apply changes to database and create files
log "${TYPE}" "Applying Changes to database."
/usr/bin/env -i bash -c "/usr/local/php/post_update.php  > /dev/null"
sync
sleep 1

insmod /lib/modules/berofix-driver.ko &> /dev/null
/usr/bin/env -i bash -c "/usr/local/php/create_files.php  > /dev/null"

# migrate beroconf database to replace "yes" by 1
if [ "$(${BEROCONF} get root lan-dhcp | grep -v failed)" = "yes" ]; then
	${BEROCONF} set root lan-dhcp 1
fi

# Reboot if RootFS has been transformed to Package-Mechanism
if [ ${MIG2TO3} -eq 1 ]; then
	sync; sleep 1; sync
	${BEROCONF} set root boot_fwupdate 0
	/bin/mount -oremount,ro /usr/local
	echo 1 > /tmp/reboot_after_update
fi

