<?php

require_once('/usr/fallback/beroConf.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");

defined('_BEROARI_CLASS') or require('/usr/local/www/berogui/misc/database.php');

// normal behavior. aka, FW >= 21.03 on normal/update mode
if (file_exists('/usr/php/include/rootHelper.class.php')) {
	require_once('/usr/php/include/rootHelper.class.php');
}
// specific behavior. aka, FW installation from FW < 21.03 to FW >= 21.03
// so we use the file which gonna be installed on the next reboot
else if (file_exists('/home/admin/conf/rootfs/pkg/rootfs/usr/php/include/rootHelper.class.php')) {
	require_once('/home/admin/conf/rootfs/pkg/rootfs/usr/php/include/rootHelper.class.php');
}
// an installation process failed. we defined a dummy rootHelper class to avoid PHP errors
else {
	### BACKUP CLASS ###
	### PLEASE DO NOT USE IT, USE rootHelper instead
	class rootHelper {
		public static function convertSecondsToDaily($s) {
			return('');
		}
		public static function getDate() {
			return('');
		}
		public static function exec($is_sbc_vm, $cmd) {
			return(exec($cmd));
		}
		public static function getAppFsVersion() {
			return('');
		}
		public static function getFpgaVersion() {
			return('');
		}
		public static function getLif() {
			return(array());
		}
		public static function getLifCount() {
			return(0);
		}
		public static function getMtdblock() {
			return('');
		}
		public static function getNetworkGateway($Iface, $is_sbc_vm = 0) {
			return(exec('/usr/bin/expr match "$(/sbin/route -n | grep '. $Iface .' | grep UG)" "0.0.0.0 *\([0-9\.]*\)"'));
		}
		public static function getNetworkIfaceByName($Iface, $bc) {
			return(@file_get_contents('/sys/class/beronet/gateway/li_count') == 3 ? 'eth0.10' : 'eth0');
		}
		public static function getNetworkInfo() {
			return('');
		}
		public static function getNetworkIpAddr() {
			return('');
		}
		public static function getNetworkMask() {
			return('');
		}
		public static function getNetworkMacAddr() {
			return('');
		}
		public static function getNetworkNameserver() {
			$info = array();
			foreach (file('/etc/resolv.conf') as $line) {
				if (strstr($line, 'nameserver')) {
					$info[] = end(explode(" ", $line));
				}
			}
			return($info);
		}
		public static function getOpensslVersion() {
			return('');
		}
		public static function getPackageInformation() {
			return('');
		}
		public static function getPhpVersion() {
			return(PHP_VERSION);
		}
		public static function getResetJumper() {
			return(0);
		}
		public static function getRevision() {
			return('');
		}
		public static function getRootFsVersion() {
			return('');
		}
		public static function getSerial() {
			return(trim(@file_get_contents('/sys/class/beronet/gateway/serial')));
		}
		public static function getStorage() {
			return(array());
		}
		public static function getType() {
			return('');
		}
		public static function getUptime() {
			return('');
		}
		public static function reboot() {
		
			return( exec('/usr/local/init/rcK') && 
				exec('echo -ne 1 > /sys/class/beronet/fpga/reset') &&
				exec('/sbin/reboot'));
		}
	}
}

/**
 * Implementiert hilfreiche Funktionen die überall benutzt werden können
 * @author Miguel Palmer <mp@beronet.com>
 * @author Florian Kraatz <fk@beronet.com>
 */
class Helper extends rootHelper {

	public static function getTimezoneList() {
		$timezones = array(
			'GMT-1200' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'BIT',
				'std-offset'	=> '+12',
				'summer-winter' => false,
				'tz' 		=> '(GMT -12:00) Eniwetok, Kwajalein',
			),
			'GMT-1100' => array(
				'dst-abbr'	=> '',
				'sw-rules'	=> '',
				'std-abbr'	=> 'SST',
				'std-offset'	=> '+11',
				'summer-winter' => false,
				'tz' 		=> '(GMT -11:00) Midway Island, Samoa',
			),
			'GMT-1000' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'HAST',
				'std-offset'	=> '+10',
				'summer-winter' => false,
				'tz' 		=> '(GMT -10:00) Hawaii',
			),
			'GMT-0900' => array(
				'dst-abbr'	=> 'AKDT',
				'rules'		=> '',
				'std-abbr'	=> 'AKST',
				'std-offset'	=> '+9',
				'summer-winter' => false,
				'tz' 		=> '(GMT -9:00) Alaska',
			),
			'GMT-0800' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'PST',
				'std-offset'	=> '+8',
				'summer-winter' => false,
				'tz' 		=> '(GMT -8:00) Pacific Standard Time: (US &amp; Canada)',
			),
			'GMT-0700' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'MST',
				'std-offset'	=> '+7',
				'summer-winter' => false,
				'tz' 		=> '(GMT -7:00) Mountain Standard Time: (US &amp; Canada)',
			),
			'GMT-0600' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'CST',
				'std-offset'	=> '+6',
				'summer-winter' => false,
				'tz' 		=> '(GMT -6:00) Central Standard Time: Mexico City, (US &amp; Canada)',
			),
			'GMT-0500' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'EST',
				'std-offset'	=> '+5',
				'summer-winter' => false,
				'tz' 		=> '(GMT -5:00) Eastern Standard Time: Bogota, Lima, (US &amp; Canada)',
			),
			'GMT-0400' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'AST',
				'std-offset'	=> '+4',
				'summer-winter' => false,
				'tz' 		=> '(GMT -4:00) Atlantic Standard Time: Caracas, La Paz, (Canada)',
			),
			'GMT-0330' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'NST',
				'std-offset'	=> '+3:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT -3:30) Newfoundland',
			),
			'GMT-0300' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'ART',
				'std-offset'	=> '+3',
				'summer-winter' => false,
				'tz' 		=> '(GMT -3:00) Brasília, Buenos Aires, Georgetown',
			),
			'GMT-0200' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'AT',
				'std-offset'	=> '+2',
				'summer-winter' => false,
				'tz' 		=> '(GMT -2:00) Mid-Atlantic',
			),
			'GMT-0100' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'WAT',
				'std-offset'	=> '+1',
				'summer-winter' => false,
				'tz' 		=> '(GMT -1:00) West Africa Time: Alger, Jaunde, Rabat',
			),
			'GMT0000' => array(
				'dst-abbr'	=> 'WEST',
				'rules'		=> 'M3.5.0/02:00:00,M10.5.0/03:00:00',
				'std-abbr'	=> 'WET',
				'std-offset'	=> '+0',
				'summer-winter' => true,
				'tz' 		=> '(GMT) Western European Time: London, Lisbon, Casablanca',
			),
			'GMT+0100' => array(
				'dst-abbr'	=> 'CEST',
				'rules'		=> 'M3.5.0/02:00:00,M10.5.0/03:00:00',
				'std-abbr'	=> 'CET',
				'std-offset'	=> '-1',
				'summer-winter' => true,
				'tz' 		=> '(GMT +1:00) Central European Time: Berlin, Brussels, Copenhagen, Madrid, Paris',
			),
			'GMT+0200' => array(
				'dst-abbr'	=> 'EEST',
				'rules'		=> 'M3.5.0/02:00:00,M10.5.0/03:00:00',
				'std-abbr'	=> 'EET',
				'std-offset'	=> '-2',
				'summer-winter' => true,
				'tz' 		=> '(GMT +2:00) Eastern Europen Time: Athens, Bucharest, Helsinki, Sofia',
			),
			'GMT+0300' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'MSK',
				'std-offset'	=> '-3',
				'summer-winter' => false,
				'tz' 		=> '(GMT +3:00) Baghdad, Riyadh, Moscow, St. Petersburg',
			),
			'GMT+0330' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'IRST',
				'std-offset'	=> '-3:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT +3:30) Tehran',
			),
			'GMT+0400' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'AMT',
				'std-offset'	=> '-4',
				'summer-winter' => false,
				'tz' 		=> '(GMT +4:00) Abu Dhabi, Muscat, Baku, Tbilisi',
			),
			'GMT+0430' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'AFT',
				'std-offset'	=> '-4:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT +4:30) Kabul',
			),
			'GMT+0500' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'PKT',
				'std-offset'	=> '-5',
				'summer-winter' => false,
				'tz' 		=> '(GMT +5:00) Ekaterinburg, Islamabad, Karachi, Tashkent',
			),
			'GMT+0530' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'IST',
				'std-offset'	=> '-5:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT +5:30) Bombay, Calcutta, Madras, New Delhi',
			),
			'GMT+0545' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'NT',
				'std-offset'	=> '-5:45',
				'summer-winter' => false,
				'tz' 		=> '(GMT +5:45) Kathmandu',
			),
			'GMT+0600' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'OMSK',
				'std-offset'	=> '-6',
				'summer-winter' => false,
				'tz' 		=> '(GMT +6:00) Almaty, Dhaka, Colombo',
			),
			'GMT+0700' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'KRAT',
				'std-offset'	=> '-7',
				'summer-winter' => false,
				'tz' 		=> '(GMT +7:00) Bangkok, Hanoi, Jakarta',
			),
			'GMT+0800' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'CST',
				'std-offset'	=> '-8',
				'summer-winter' => false,
				'tz' 		=> '(GMT +8:00) Beijing, Perth, Singapore, Hong Kong',
			),
			'GMT+0900' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'JST',
				'std-offset'	=> '-9',
				'summer-winter' => false,
				'tz' 		=> '(GMT +9:00) Tokyo, Seoul, Osaka, Sapporo, Yakutsk',
			),
			'GMT+0930' => array(
				'dst-abbr'	=> 'ACDT',
				'rules'		=> '',
				'std-abbr'	=> 'ACST',
				'std-offset'	=> '-9:30',
				'summer-winter' => false,
				'tz' 		=> '(GMT +9:30) Adelaide, Darwin',
			),
			'GMT+1000' => array(
				'dst-abbr'	=> 'AEDT',
				'rules'		=> '',
				'std-abbr'	=> 'AEST',
				'std-offset'	=> '-10',
				'summer-winter' => false,
				'tz' 		=> '(GMT +10:00) Eastern Australia, Guam, Vladivostok',
			),
			'GMT+1100' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'SAKT',
				'std-offset'	=> '-11',
				'summer-winter' => false,
				'tz' 		=> '(GMT +11:00) Magadan, Solomon Islands, New Caledonia',
			),
			'GMT+1200' => array(
				'dst-abbr'	=> '',
				'rules'		=> '',
				'std-abbr'	=> 'HST',
				'std-offset'	=> '-12',
				'summer-winter' => false,
				'tz' 		=> '(GMT +12:00) Auckland, Wellington, Fiji, Kamchatka',
			),
		);

		return $timezones;
	}

	/**
	 * Activate button anzeigen
	 */
	public static function activate($option, $show = false, $m = "", $text = "activate", $given_ba = null) {
		//Ein neues Datenbankobjekt wird erzeugt.
		$ba = is_null($given_ba) ? new beroAri() : $given_ba;
		//ISDN Ports suchen
		$optionSaved = $ba->get("activate");
		
		if (file_exists ("/usr/conf/need_red_activate")) {
			$option = "3";
			unlink ("/usr/conf/need_red_activate");
		}
		
		// when graceful is active, don't show if lower than graceful
		$graceful = $ba->get('graceful_action');
		$gracefulcron = preg_match('/graceful-action.sh/', file_get_contents('/usr/conf/cron/root'));
		if ($option <= $graceful && $gracefulcron) {
			return;
		}

		if ($optionSaved <= $option) {
			$query = $ba->set('activate', $ba->get('is_sbc_vm') == 1 ? '1' : $option);
			if ($show)
				return "<script>aktivieren(1,'" . $m . "','" . $option . "','" . $text . "','" . (isset($_GET['opt']) ? Helper::sanitizeGet($_GET['opt'], 'opt') : '') . "');</script>";
		}
	}

	/**
	 * Activate option der API speichern
	 */
	public static function activateApi($option) {
		file_put_contents("/tmp/apioption", $option);
		$ba = new beroAri();
		$ba->set('activate', $option);
	}

	/**
	 * Gibt das aktuelle activate level zurück
	 * @return int
	 */
	public static function getActivateOption() {
		$ba = new beroAri();
		return $ba->get("activate");
	}

	/**
	 * Return the specific FXO country setting for the given country $c
	 * @param string $c
	 * @return array
	 */
	public static function getCountrySetting($c = "1TR110_DE") {
		$country = array(
			"FCC" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 1, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"TRB21" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ARGENTINA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"AUSTRALIA" => array('ohs' => 1, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x0', 'mini' => "0x3", 'ilim' => 0, 'acim' => '0x3'),
			"AUSTRIA" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x3'),
			"BAHRAIN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"BELGIUM" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"BRAZIL" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x0', 'mini' => "0x3", 'ilim' => 0, 'acim' => '0x0'),
			"BULGARIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x3'),
			"CANADA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"CHILE" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"CHINA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x0', 'mini' => "0x3", 'ilim' => 0, 'acim' => '0xf'),
			"COLOMBIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"CROATIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"CYPRUS" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"CZECH" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"DENMARK" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ECUADOR" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"EGYPT" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"ELSALVADOR" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"FINLAND" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"FRANCE" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"GERMANY" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x3'),
			"1TR110_DE" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 1, "rt2" => 1, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x3'),
			"GREECE" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"GUAM" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"HONGKONG" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"HUNGARY" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"ICELAND" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"INDIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x4'),
			"INDONESIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"IRELAND" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ISRAEL" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ITALY" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"JAPAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"JORDAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"KAZAKHSTAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"KUWAIT" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"LATVIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"LEBANON" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"LUXEMBOURG" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"MACAO" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"MALAYSIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"MALTA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"MEXICO" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"MOROCCO" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"NETHERLANDS" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"NEWZEALAND" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x4'),
			"NIGERIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"NORWAY" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"OMAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"PAKISTAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"PERU" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"PHILIPPINES" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"POLAND" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 1, "rt" => 1, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"PORTUGAL" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"ROMANIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"RUSSIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"SAUDIARABIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"SINGAPORE" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"SLOVAKIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x3'),
			"SLOVENIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x2'),
			"SOUTHAFRICA" => array('ohs' => 1, 'ohs2' => 0, 'rz' => 1, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x3'),
			"SOUTHKOREA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"SPAIN" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"SWEDEN" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"SWITZERLAND" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x2'),
			"SYRIA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"TAIWAN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"THAILAND" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"UAE" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"UK" => array('ohs' => 0, 'ohs2' => 1, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 1, 'acim' => '0x5'),
			"USA" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
			"YEMEN" => array('ohs' => 0, 'ohs2' => 0, 'rz' => 0, "rt" => 0, "rt2" => 0, 'dcv' => '0x3', 'mini' => "0x0", 'ilim' => 0, 'acim' => '0x0'),
		);
		return $country[$c];
	}

	public static function getDateByFormat($formatString = null) {
		@exec('/bin/date ' . (($formatString != null) ? $formatString : '-R'), $output);
		return(trim($output[0]));
	}

	public static function getInfo($bc = null, $ba = null, $isgw = null) {
		// default
		$infos = array(
			'appfs' 				=> 'getAppFsVersion',
			'date'					=> 'getDate', 
			'fpga'					=> 'getFpgaVersion',
			'hw_revision'		=> 'getRevision',
			'isgw_uptime'		=> 'getIsgwUptime',
			'lif'						=> 'getLifInfo',
			'msp_fw'				=> 'getMspFirmwareVersion', 
			'mtdblock'			=> 'getMtdblock',
			'network'				=> 'getNetworkInfo',
			'openssl'				=> 'getOpensslVersion',
			'package'				=> 'getPackageInformation',
			'php' 					=> 'getPhpVersion',
			'rootfs'				=> 'getRootFsVersion',
			'serial'				=> 'getSerial',
			'storage'				=> 'getStorage',
			'system_uptime' => 'getUptime',
			's2s_licenses'	=> 'getSip2SipLicences',
			'vpn-client'		=> 'getVpnClient',
		);

		if (is_null($bc)) {
			require_once('/usr/fallback/beroConf.php');
			$bc = new beroConf('root');
		}

		if (is_null($ba) && file_exists('/usr/local/www/berogui/misc/database.php')) {
			require_once('/usr/local/www/berogui/misc/database.php');
			$ba = new beroAri();
		}

		// login to isgw
		if (is_null($isgw) && file_exists('/usr/local/www/berogui/includes/isgwtelnet.php')) {
			require_once('/usr/local/www/berogui/includes/isgwtelnet.php');
			$isgw = new isgwtelnet();
			$isgw->isgw_login();
		}

		// get the info
		foreach ($infos as $key => $function) {
			$value = self::$function($bc->get('root', 'is-sbc-vm') == 1, $bc, $ba, $isgw);
			if (!is_null($value)) {
				$info[$key] = $value;
			}
		}

		return $info;
	}

	public static function getIsgwUptime($is_sbc_vm = 0, $bc = null, $ba = null, $isgw = null) {
		if (is_null($isgw)) {
			return(null);
		}
		$isgw_uptime = $isgw->isgw_uptime();
		$isgw_uptime = preg_split("/: /", $isgw_uptime);
		$isgw_uptime = explode(':', $isgw_uptime[1]);
		$isgw_uptime = 3600*$isgw_uptime[0] + 60*$isgw_uptime[1] + $isgw_uptime[2];
		$isgw_uptime = self::convertSecondsToDaily($isgw_uptime);
		return("{$isgw_uptime['d']}d:{$isgw_uptime['h']}h:{$isgw_uptime['m']}m:{$isgw_uptime['s']}s");
	}

	public static function getLifInfo($is_sbc_vm = 0, $bc = null, $ba = null, $isgw = null) {
		// cloud sbc + std sbc in recovery mode
		if ($is_sbc_vm || is_null($ba)) {
			return(null);
		}
		$info = array();
		for ($i = 0; $i < self::getLifCount(); $i++) {
			$query = $ba->select('SELECT type FROM isdn WHERE lif="' . $i . '" union ' .
				'SELECT type FROM analog WHERE lif="' . $i . '" union ' .
				'SELECT type FROM gsm WHERE lif="' . $i . '" union ' .
				'SELECT type FROM lte WHERE lif="' . $i . '" union ' .
				'SELECT type FROM cas WHERE lif="' . $i . '"');
			$type = sqlite_fetch_single($query);
			if (!empty($type)) {
				$info[$i] = 'li' . $i . ':  ' . $type;
			}
		}
		return($info);
	}

	public static function getMspFirmwareVersion($is_sbc_vm = 0, $bc = null, $ba = null, $isgw = null) {
		// cloud sbc
		if ($is_sbc_vm || is_null($isgw)) {
			return(null);
		}
		// std sbc
		$msp = explode(':', $isgw->Query('fw'));
		return($msp[1]);
	}
	
	public static function getFirmwareVersion() {
		if (file_exists ('/usr/local/FILENAME')) {
			foreach (file('/usr/local/FILENAME') as $line) {
				$firmware_version = str_replace("\n", "", $line);
				$firmware_version = preg_replace("/^appfs-/", "", $firmware_version);
				$firmware_version = preg_replace("/.tar.gz$/", "", $firmware_version);
				return $firmware_version;
			}
		}
		return("");
	}

	public static function getSip2SipLicences($is_sbc_vm = 0, $bc = null, $ba = null, $isgw = null) {
		if (is_null($isgw) || !file_exists('/usr/local/www/berogui/includes/variables.php') || !file_exists('/usr/local/www/berogui/includes/Helper/HelperSip.php')) {
			return(null);
		}
		include_once('/usr/local/www/berogui/includes/variables.php');
		require_once('/usr/local/www/berogui/includes/Helper/HelperSip.php');
		return(HelperSip::getSip2SipLicenses($isgw));	
	}

	public static function getVpnClient($is_sbc_vm = 0, $bc = null, $ba = null, $isgw = null) {
		// cloud sbc
		if ($is_sbc_vm && file_exists('/usr/local/www/berogui/modules/Vpn/vpn_helper.php')) {
			require_once('/usr/local/www/berogui/modules/Vpn/vpn_helper.php');
			return(VpnHelper::getDataClients());
		}
		// std sbc
		return(null);
	}
	/* */

	static public function getTotalCalls() {
		require_once ('/usr/local/www/berogui/includes/isgwtelnet.php');
		$isgw = new isgwtelnet();
		$result = $isgw->isgw_login();
		if ($result == false) {
			return 0;
		}
		$channelresult = $isgw->isgw_channelstate();
		if (preg_match('/TOTAL CALLS:([0-9]*)/', $channelresult, $nb_calls)) {
			return $nb_calls[1];
		}
		// old way. can be removed
		$rows = explode("\n", $channelresult);
		$i = 0;
		$dontUse = array();
		foreach ($rows as $row) {
			$row = htmlspecialchars($row);
			$values = explode("\t", $row);
			if (trim($row) != "" && strpos($row, "LISTING CALL OPERATIONS COMPACT") === false && (!in_array(intval($values[0]), $dontUse))) {
				if (strpos($values[13], "MSP_BRIDGED") !== false) {
					/**
					 * PSTN zu PSTN Einträgen
					 */
					$tmp = explode("=", $values[10]);
					array_push($dontUse, intval($tmp[1]));
					$i++;
				} else {
					$i++;
				}
			}
		}
		return $i;
	}


	static public function getConfigFromIsgw($is_sbc_vm = 0) {
		$cmd = array(
			0 => "/usr/local/bin/isgw -C -e/usr/conf",
			1 => "/usr/local/beroNet/sbin/isgw.sh -C -e/etc/beroNet/isgw",
		);
		exec($cmd[$is_sbc_vm ? 1 : 0], $lines);
		reset($lines);
		while (strpos(current($lines), "Default call configuration:") === FALSE && current($lines) !== FALSE) {
			array_shift($lines);
		}
		array_shift($lines);
		return $lines;
	}

	static public function getDefaultConfig($is_sbc_vm = 0) {

		$lines = self::getConfigFromIsgw($is_sbc_vm);
		$default = array();
		foreach ($lines as $line) {
			preg_match("/\[(?<bez>.+)\]\[(?<name>.+)\][\s]*(?<desc>.+)[\s]*\<(?<val>.*)\>[\s]*'(?<def>.*)'/", $line, $res);
			$default[$res["name"]] = $res['def'];
		}
		return $default;
	}

	static public function check(&$ba) {
		$pstn = 0;
		if (!($ba->get('is_sbc_vm') == 1)) {
			$query = $ba->select('SELECT DISTINCT gr FROM isdn WHERE gr!="NULL" union '
				. 'SELECT DISTINCT gr FROM analog WHERE gr!="NULL" union '
				. 'SELECT DISTINCT gr FROM gsm WHERE gr!="NULL" union '
				. 'SELECT DISTINCT gr FROM lte WHERE gr!="NULL" union '
				. 'SELECT DISTINCT gr FROM cas_channels WHERE gr!="NULL"');
			$pstn = sqlite_num_rows($query);
		}
		$query = $ba->select('select * from sip');
		$sip = sqlite_num_rows($query);
		$query = $ba->select('select  * from dialplan');
		$dialplan = sqlite_num_rows($query);
		if ($pstn == 0 && $sip == 0 && $dialplan == 0) {
			return 1;
		} else {
			return 0;
		}
	}

	static public function sanitizeGet($getInput, $getCheckor, &$ptr_authorize_request = null, &$invalid = array(), $options = array(), $request = 'GET') {
		// TODO: if some modification must be applied on a GET input (exemple, remplace a /), do it here
		// TODO: update the arguments to give the default value of a parameter

		if (!is_null($ptr_authorize_request) && !$ptr_authorize_request) {
			// a previous sanitize failed
			return $getInput;
		}

		$list_checkor_with_default_value = array('m', 'ent', 'opt', 'order', 'sort', 'start');

		// global GET checking coming from a submit or a popup loading
		if (is_array($getInput)) {
			foreach ($getInput as $key => $value) {
				if (isset($getCheckor[$key]) && in_array($getCheckor[$key], $list_checkor_with_default_value)) {
					$getInput[$key] = Helper::sanitizeGet($value, $getCheckor[$key], $ptr_authorize_request, $invalid, isset($options[$key]) ? $options[$key] : array());
				} else if (isset($getCheckor[$key]) && !Helper::checkInputData($getCheckor[$key], $value, count($options) > 0 ? $options[$key] : '')) {
					$invalid = array('request' => $request, 'key' => $key, 'checkor' => $getCheckor[$key]);
					$ptr_authorize_request = 0;
					break;
				}
			}	
		}
		// we check an unique input coming from a GET request
		else {
			$direction_list = array('sip', 'isdn', 'analog', 'cas', 'lte', 'gsm');
			switch ($getCheckor) {
				// Global Variables -> if sanitize fails, return a default value (expected opt which update the ptr_authorize_request pointer)
				case 'ent':
					$list_ent = array(10, 15, 20, 25, 30, 35, 40, 45, 50);
					if (!(in_array($getInput, $list_ent))) {
						return 10;
					}
					break;
				case 'm':
					if (!Helper::checkInputData($getCheckor, $getInput)) {
						return 'State';	
					}
					break;
				case 'opt':
					if ($getInput !== '') {
						$whitelist_opt = array();
						$beroAri = new beroAri();

						if (!($beroAri->get('is_sbc_vm') == 1)) {
							/*Analog*/
							if (sqlite_num_rows($beroAri->select("SELECT * from analog where port_type='FXO'")) > 0) {
								array_push($whitelist_opt, 'fxo');
							}
							if (sqlite_num_rows($beroAri->select("SELECT * from analog where port_type='FXS'")) > 0) {
								array_push($whitelist_opt, 'fxs');
							}

							/*ISDN*/
							if (sqlite_num_rows($beroAri->select("SELECT * from isdn where port_type='PRI'")) > 0) {
								array_push($whitelist_opt, 'pri');
							}
							if (sqlite_num_rows($beroAri->select("SELECT * from isdn where port_type='BRI'")) > 0) {
								array_push($whitelist_opt, 'bri');
							}
						
							/*GSM*/
							if (sqlite_num_rows($beroAri->select("SELECT * from gsm")) > 0) {
								array_push($whitelist_opt, 'gsm');
							}

							/*CAS*/
							if (sqlite_num_rows($beroAri->select("SELECT * from cas_channels")) > 0) {
								array_push($whitelist_opt, 'cas');
							}

							/*LTE*/
							if (sqlite_num_rows($beroAri->select("SELECT * from lte")) > 0) {
								array_push($whitelist_opt, 'lte');
							}
						}

						if (!(in_array(strtolower($getInput), $whitelist_opt))) {
							$invalid = array('request' => $request, 'checkor' => 'opt');
							$ptr_authorize_request = 0;
						}
					}
					break;
				case 'order':
				case 'sort':
				case 'start':
					if (!Helper::checkInputData('int>=0', $getInput)) {
						return 0;
					}
					break;
				// Specific Variables -> if sanitize fails, update ptr_authorize_request to false
				case 'direction':
					if (!Helper::checkInputData('select', $getInput, $direction_list)) {
						$invalid = array('request' => $request, 'checkor' => 'direction');
						$ptr_authorize_request = 0;
					}
					break;	
				case 'group-name':
					if (!Helper::checkInputData($getCheckor, $getInput)) {
						$invalid = array('request' => $request, 'checkor' => 'group-name');
						$ptr_authorize_request = 0;
					}
					break;
				case 'id':
					if (is_array($getInput)) {
						$list_id = array();
						foreach ($getInput as $id) {
							$list_id[] = Helper::sanitizeGet($getCheckor, $id, $ptr_authorize_request);
						}
						$getInput = $list_id;
					} else if (!Helper::checkInputData($getCheckor, $getInput)) {
						$invalid = array('request' => $request, 'checkor' => 'id');
						$ptr_authorize_request = 0;
					}
					break;
				default:
					if (!Helper::checkInputData($getCheckor, $getInput, $options)) {
						$invalid = array('request' => $request, 'checkor' => $getCheckor);
						$ptr_authorize_request = 0;
					}
					break;
				}
			}

		return $getInput;
	}

	static public function sanitizePost($postInput, $postCheckor, &$ptr_authorize_request = null, &$invalid = array(), $list_options = array(), $request = 'POST') {
		// TODO: if some modification must be applied on a POST input (exemple, remplace a /), do it here
		
		if (!is_null($ptr_authorize_request) && !$ptr_authorize_request) {
			// a previous sanitize failed
			return $postInput;
		}

		// global POST checking coming from a submit
		if (is_array($postInput)) {
			foreach ($postInput as $key => $value) {
				if (!isset($postCheckor[$key]) || !(Helper::checkInputData($postCheckor[$key], $value, count($list_options) > 0 ? $list_options[$key] : ''))) {
					$invalid = array('request' => $request, 'key' => $key, 'checkor' => $postCheckor[$key]);
					$ptr_authorize_request = 0;
					break;
				}
			}
		} 
		else {
			switch ($postCheckor) {
				case 'gui-mode':
					// if gui-mode unknown, we set to 'simple'
					$whitelist_gui_mode = array('simple', 'advanced');
					if (!(in_array(strtolower($postInput), $whitelist_gui_mode))) {
						return 'simple';
					}
					return $postInput;
				case 'lang':
					// if lang unknown, we set to 'en'
					$whitelist_lang = array('en', 'de');
					if (!(in_array($postInput, $whitelist_lang))) {
						return 'en';
					}
					return $postInput;
				default:
					if (!Helper::checkInputData($postCheckor, $postInput, $list_options)) {
						$invalid = array('request' => $request, 'checkor' => $postCheck[$key]);
						$ptr_authorize_request = 0;
					}
					break;
			}
		}

		return $postInput;
	}

	static public function sanitizeSession($sessionInput, $sessionCheckor, $ptr_authorize_session = null, &$invalid = array(), $list_options = array()) {

		if (!Helper::checkInputData($sessionCheckor, $sessionInput)) {
			$invalid = array('request' => $request, 'checkor' => $sessionCheckor);
			$ptr_authorize_session = 0;
		}

		return $sessionInput;
	}

	static public function checkArrayInputs($checkor, $array, $options = array()) {
		foreach ($array as $input) {
			if (!Helper::checkInputData($checkor, $input, $options)) {
				return 0;
			}
		}
		return 1;
	}

	static public function checkInputData($checkor, $data, $options = '') {
		// in case where the variable is declared but not defined
		if ($data === '') {
			return 1;
		}
		// in case where the input data is an array
		else if (is_array($data)) {
			return Helper::checkArrayInputs($checkor, $data, $options);
		}

		// multiple condition/type required
		if (is_array($checkor)) {
			// min length = 3 -> (operator + 2 conditions)
			if (count($checkor) < 3) {
				return 0;
			}

			// getting operator type
			$operator = $checkor[0];
			unset($checkor[0]);
			// getting total condition
			$data_trusted = ($operator == '||') ? 0 : 1;
			foreach ($checkor as $condition) {
				if ($operator == '||') {
					$data_trusted = $data_trusted || Helper::checkInputData($condition, $data, $options);
				} else {
					$data_trusted = $data_trusted && Helper::checkInputData($condition, $data, $options);
				}
			}
			return $data_trusted;
		}
		// an unique type required
		else {
			// checking all inputs
			switch ($checkor) {
				case 'accept':
					// the check is not necessary: the data is not stored (SQL) or displayed to the GUI (XSS)
					return 1;
				case 'alphanumeric':
					return preg_match('/^[0-9a-zA-Z]+$/', $data);
				case 'bool':
					return (is_bool($data) || (string)$data === '1' || (string)$data === '0' || $data === 'yes' || $data === 'no' || $data === 'on' || $data === 'off' || $data === 'true' || $data === 'false');
				case 'comment':
					return !preg_match('/[äÄöÖüÜß!@#$%^&*()+=[\]\';,\/{}|\"<>?]+/', $data);
				case 'config-option':
					// avoid XSS injection ... but how avoid SQL injection ?? TODO
					return !preg_match('/<script>|<\/script>|<javascript>|<\/javascript>/', $data);
				case 'dir-exists':
					if (is_array($options)) {
						$exist = 0;
						foreach ($options as $option) {
							if ($data === $option) {
								$exist = 1;
								break;
							}
						}
						return $exist;
					}
					return ($options === '' ? file_exists($data) : file_exists($options .'/'. $data));;
				case 'direction':
					$list_directions = array('all');
					foreach ($options as $dir) {
						foreach ($options as $dir1) {
							array_push($list_directions, "$dir-$dir1");
						}
					}
					return in_array(strtolower($data), array_map('strtolower', $list_directions));
				case 'file-exists':
					if (is_array($options)) {
						$exist = 0;
						foreach ($options as $option) {
							if (file_exists($option .'/'. $data)) {
								$exist = 1;
								break;
							}
						}
						return $exist;
					}
					return ($options === '' ? file_exists($data) : file_exists($options .'/'. $data));
				case 'from-to-id':
					return preg_match('/^[a-zA-Z0-9\_\-\:]+$/', $data);
				case 'gmt':
					return preg_match('/^GMT0|GMT(-|\+)[:\d]{1,5}$/', $data);
				case 'group-name':
					return preg_match('/^[a-zA-Z0-9\_\-]+$/', $data);
				case 'group-name-space':
					return preg_match('/^[ a-zA-Z0-9\_\-]+$/', $data);
				case 'hostname':
					return preg_match('/^((?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*(?::(?:[0-9]){1,5})?)*$/i', $data);
				case 'id':
					if (preg_match('/[,]+/', $data)) {
						return Helper::checkInputData('id', explode(',', $data));
					}
					return Helper::checkInputData('int>=0', $data);
				case 'int':
					$toInt = (is_string($data) && is_numeric($data)) ? (int)$data : $data;
					return is_int($toInt);
				case 'int>0':
					return (Helper::checkInputData('int', $data) && $data > 0);
				case 'int>=0':
					return preg_match('/^[\d]+$/', $data);
				case 'int-length':
					$bool_int = 0;
					switch ($options['operator']) {
						case '=':
							$bool_int = Helper::checkInputData('int', $data);
							break;
						case '>':
							$bool_int = Helper::checkInputData('int>0', $data);
							break;
						case '>=':
							$bool_int = Helper::checkInputData('int>=0', $data);
							break;
						default:
							break;
					}
					return ($bool_int && strlen((string)$data) === $options['length']);
				case 'int-piped':
					return preg_match('/^[\d\|]+$/', $data);
				case 'int-range':
					return (Helper::checkInputData('int', $data) && (isset($options['min']) && isset($options['max']) && ($data >= $options['min'] && $data <= $options['max'])));
				case 'int-ranged':
					return preg_match('/^[-0-9]+$/', $data);
				case 'international-code':
					return preg_match('/^\+?[0-9]{1,70}?$/', $data);
				case 'ip4':
					return preg_match('/^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/', $data);
				case 'ip6':
					// TODO
					return 1;
				case 'm':
					// general whitelist
					// TODO: list directories under /usr/local/www/berogui/modules
					$whitelist_class = array(
						'Acl', 'BackupRestore', 'Dialplan', 'DialplanDebug', 
						'Dos', 'FulltraceGui', 'Info',  'IsgwCauses', 'Logging', 'Miscellaneous',
						'NetConf', 'RebootReset', 'Security', 
						'Sip', 'SipStack', 'SipLicense', 'State', 'StateCalls', 'StateStatistic', 'Telnet', 'UpdateTool',
					);
	
					$beroAri = new beroAri();	

					if ($beroAri->get('is_sbc_vm') == 1) {
						$whitelist_class[] = 'Vpn';
					}
					else {	
						$whitelist_class = array_merge($whitelist_class, array('Market', 'CallProgress', 'RemoteManagement', 'TimeConf', 'Wizard', 'Provisioning', 'BeroCloud', 'Berofos', 'Cdr', 'PstnHardware'));

						// append Analog to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from analog")) > 0) {
							$whitelist_class[] = 'Analog';
						}
						// append Isdn to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from isdn")) > 0) {
							$whitelist_class[] = 'Isdn';
						}
						// append Gsm to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from gsm")) > 0) {
							$whitelist_class = array_merge($whitelist_class, array('Gsm', 'Sms'));
						}
						// append Lte to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from lte")) > 0) {
							$whitelist_class = array_merge($whitelist_class, array('Lte', 'Sms'));
						}
						// append Cas to whitelist
						if (sqlite_num_rows($beroAri->select("SELECT * from cas_channels")) > 0) {
							$whitelist_class[] = 'Cas';
						}
					}
					// check the class to load
					$class = $data;
					$path_to_class = "/usr/local/www/berogui/modules/$class/$class.php";
					// unset
					unset($beroAri);
					return (in_array($class, $whitelist_class) && is_file($path_to_class));
				case 'mac':
					return preg_match('/^([0-9A-Fa-f]{2}([:-]|$)){6}$|([0-9A-Fa-f]{4}([.]|$)){3}$/i', $data);
				case 'match':
					return preg_match('/'. $options .'/', $data);
				case 'netmask':
					return (Helper::checkInputData('ip4', $data) || (Helper::checkInputData('int', $data) && ($data >= 0 && $data <= 32)));
				case 'password':
					// not necessary to check the password since they must be hashed
					return 1;
				case 'phone-char':
					return preg_match('/^[0-9#_+]+$/', $data);
				case 'select':
					return is_array($options) ? in_array(strtolower($data), array_map('strtolower', $options)) : $data === $options;
				case 'snmp':
					return preg_match('/^[a-zA-Z0-9\@\#\$\%\^\*\(\)\_\-\+\/\?\{\}\[\]\.\,]*$/', $data);
				case 'special-char':
					return !preg_match('/[äÄöÖüÜß#$%^()[\]\'\/{}|\"<>]+/', $data);
				case 'str-length':
					$lgth = strlen($data);
					return (Helper::checkInputData('config-option', $data) && isset($options['min']) && isset($options['max']) && ($lgth >= $options['min'] && $lgth <= $options['max']));
				case 'tones':
					return preg_match('/^\[[-a-z0-9]+\]$/', $data);
				case 'uri':
					return Helper::checkInputData('config-option', urldecode($data));
				case 'url':
					$is_with_ip = preg_match("/^((https?|t?ftp):\/\/)?((25[0-5]|(2[0-4]|1[0-9]|[1-9]|)[0-9])(\.(?!$)|)){4}([0-9a-zA-Z!*'();:@&=+$,\/?#\[\]\{\}_.~-]+)?$/", $data);
					$is_without_ip = preg_match("/^((https?|t?ftp):\/\/)?(www.)?[a-zA-Z0-9-_]+(\.[a-zA-Z]+)+((\/)[\w#.-?&]+)*(\/\w+\?[a-zA-Z0-9_]+=\w+(&[a-zA-Z0-9_]+=\w+)*)?([0-9a-zA-Z!*'();:@&=+$,\/?#\[\]\{\}_.~-]+)?$/", $data);
					return ($is_with_ip || $is_without_ip);
				default:
					// unknown type -> the check is incorrect
					// TODO -> TOREMOVE: echo "unknown checkor = $checkor; <br/>data<pre>"; print_r($data); echo "<pre>options:<pre>"; print_r($options); echo "</pre>";
					return 0;
			}	
		}
	}

	static public function displayErrorMessage($request, $checkor = null, $key = null) {
		// TODO: update this table => make a huge table 
		//
		//		$list_checkor = array(
		//					checkor1 => array('function' => 'functionNameRelatedToCheckor1', 'error' => PHP_VALIDATOR_CHECKOR1_REQUIREMENT),
		//					checkor2 => array('function' => 'functionNameRelatedToCheckor2', 'error' => PHP_VALIDATOR_CHECKOR2_REQUIREMENT),
		//				     );
		//			-> this way, the checkInputData can be highly simplified without the swicth condition
		//

		$error_table = array(
					'alphanumeric'		=> array('define' => 'PHP_VALIDATOR_ALPHANUMERIC', 'chars' => ''),
					'bool'			=> array('define' => 'PHP_VALIDATOR_BOOLEAN', 'chars' => ''),
					'comment'		=> array('define' => 'PHP_VALIDATOR_COMMENT', 'chars' => 'äÄöÖüÜß!@#$%^&*()+=[\]\';,\/{}|\"<>?'),
					'config-option'		=> array('define' => 'PHP_VALIDATOR_CONFIG_OPTION', 'chars' => ''),
					'dir-exists'		=> array('define' => 'PHP_VALIDATOR_DIR_EXISTS', 'chars' => ''),
					'direction'		=> array('define' => 'PHP_VALIDATOR_DIRECTION', 'chars' => ''),
					'file-exists'		=> array('define' => 'PHP_VALIDATOR_FILE_EXISTS', 'chars' => ''),
					'from-to-id'		=> array('define' => 'PHP_VALIDATOR_FROMTO_ID', 'chars' => ''),
					'gmt'			=> array('define' => 'PHP_VALIDATOR_GMT', 'chars' => ''),
					'group-name'		=> array('define' => 'PHP_VALIDATOR_GROUP_NAME', 'chars' => 'a-z, A-Z, 0-9, _ and -.'),
					'group-name-space'	=> array('define' => 'PHP_VALIDATOR_GROUP_NAME_SPACE', 'chars' => 'a-z, A-Z, 0-9, _ and -.'),
					'hostname'		=> array('define' => 'PHP_VALIDATOR_HOSTNAME', 'chars' => ''),
					'id'			=> array('define' => 'PHP_VALIDATOR_ID', 'chars' => ''),
					'int'			=> array('define' => 'PHP_VALIDATOR_INT', 'chars' => ''),
					'int>0'			=> array('define' => 'PHP_VALIDATOR_INT_STRICT_POSTI', 'chars' => ''), 
					'int>=0'		=> array('define' => 'PHP_VALIDATOR_INT_POSITNULL', 'chars' => ''),
					'int-length' 		=> array('define' => 'PHP_VALIDATOR_INT_LENGHT', 'chars' => ''),
					'int-piped'		=> array('define' => 'PHP_VALIDATOR_INT_PIPED', 'chars' => ''),
					'int-range' 		=> array('define' => 'PHP_VALIDATOR_INT_RANGE', 'chars' => ''),
					'int-ranged'		=> array('define' => 'PHP_VALIDATOR_INT_RANGED', 'chars' => ''),
					'international-code'	=> array('define' => 'PHP_VALIDATOR_INTERNATIONAL_CODE', 'chars' => ''),
					'ip4'			=> array('define' => 'PHP_VALIDATOR_IP4', 'chars' => ''),
					'ip6'			=> array('define' => 'PHP_VALIDATOR_IP6', 'chars' => ''),
					'mac'			=> array('define' => 'PHP_VALIDATOR_MAC', 'chars' => ''),
					'match'			=> array('define' => 'PHP_VALIDATOR_MATCH', 'chars' => ''),
					'netmask'		=> array('define' => 'PHP_VALIDATOR_NETMASK', 'chars' => ''),
					'phone-char' 		=> array('define' => 'PHP_VALIDATOR_PHONE_CHAR', 'chars' => ''),
					'select'		=> array('define' => 'PHP_VALIDATOR_SELECT', 'chars' => ''),
					'snmp'			=> array('define' => 'PHP_VALIDATOR_SNMP', 'chars' => ''),
					'special-char'		=> array('define' => 'PHP_VALIDATOR_SPECIAL_CHAR', 'chars' => 'äÄöÖüÜß#$%^&*()[\]\'\/{}|\" <>'),
					'str-length'		=> array('define' => 'PHP_VALIDATOR_STRING_LENGTH', 'chars' => ''),
					'tones' 		=> array('define' => 'PHP_VALIDATOR_TONES', 'chars' => ''),
					'url' 			=> array('define' => 'PHP_VALIDATOR_URL', 'chars' => ''),
				    );

		if (is_null($checkor)) {
			$message = $request;
		}
		else {
			$message = "$request". PHP_VALIDATOR_REQUEST .(isset($key) ? " (". PHP_VALIDATOR_PARAMETER ." = $key)" : '') .". "; 
			if (!is_array($checkor) && isset($error_table[$checkor])) {
				$message .= defined($error_table[$checkor]['define']) ? constant($error_table[$checkor]['define']) : $error_table[$checkor]['define'];
				$message .= $error_table[$checkor]['chars'];
			}
			else {
				$message .= PHP_VALIDATOR_UNKNOWN_CHECKOR;
			}
		}

		return 	  "\t<div id='error-validator' class='text-center' style='margin-top: 20px; color: red;'>\n"
			. "\t\t$message"
			. "\t</div>\n";
	}

	static public function displayErrorUpload($code) {
		$msg = '';
		switch ($code) {
		case 1: // exceeds MAX_FILE_SIZE configured in php.ini
		case 2: // exceeds MAX_FILE_SIZE configured in the form
			$msg = FILEUPLOAD_ERROR_MAXFILESIZE;
			break;
		case 3:
			$msg = FILEUPLOAD_ERROR_PARTIALLYUPLOADED;
			break;
		case 4:
			$msg = FILEUPLOAD_ERROR_NOTUPLOADED;
			break;
		case 6: // should not happen
			$msg = FILEUPLOAD_ERROR_TMPMISSING;
			break;
		case 7:
			$msg = FILEUPLOAD_ERROR_WRITE;
			break;
		case 8:
			$msg = FILEUPLAOD_ERROR_EXTENSION;
			break;
		case 999:
		default:
		  $msg = FILEUPLOAD_ERROR_UNKNOWN;
		}
		return("<div id='error-upload' class='text-center' style='margin-top:20px;color:red;'>$msg</div>\n");
	}

	static public function addGracefulToCrontab($action, $overwrite = null, $cron_path = '/usr/conf/cron/root') {
		$crontab = file_get_contents($cron_path);
		$graceful_sh = '/usr/local/sbin/graceful-action.sh';
		$line = "*/1 * * * * $graceful_sh $action";
		if (preg_match("/". str_replace('/', '\/', $graceful_sh) ."/", $crontab) && is_array($overwrite)) {
			// overwrite reboot by activate
			$crontab = preg_replace("/graceful-action.sh {$overwrite['old']}/", "graceful-action {$overwrite['new']}", $crontab);
			file_put_contents($cron_path, $crontab);
		}
		else {
			file_put_contents($cron_path, $line, FILE_APPEND);
		}
		// restart crond
		self::exec(0, '/etc/init.d/S36cron restart');
	}

	static public function removeGracefulToCrontab() {
		$apply = false;
		$cron_str = '';
		$cron_path = '/usr/conf/cron/root';
		$cron_tasks = file_get_contents($cron_path);
		// activate
		foreach (explode("\n", $cron_tasks) as $cron_task) {
			if (strlen($cron_task) > 0) {
				if (preg_match('/graceful-action.sh/', $cron_task)) {
					$apply = true;
				}
				else {
					$cron_str .= "$cron_task\n";
				}
			}
		}
		// restart cron
		file_put_contents($cron_path, $cron_str);
		self::exec(0, '/etc/init.d/S36cron restart');
		return $apply;
	}

	static public function cleanCronDirectories($script, $directory_list) {
		foreach ($directory_list as $directory) {
 			if (file_exists("/etc/cron.$directory/$script")) {
				if (!self::system(true, "rm -f /etc/cron.$directory/$script")) {
					return false;
    		}
			}
		}
		return true;
	}

	static public function isRebootRequired() {
		return file_exists('/var/run/reboot-required');
	}

	static public function manageUpdateNotification($bc, $is_sbc_vm, $show_notif, $has_update_cmd, $update_message) {
		$major_issue 	= $bc->get('root', 'has-major-issue');
		$force_update = $bc->get('root', 'sbcvmupdate-notif');

		if (strlen($major_issue) > 0) {
			return 	"\n"
						. self::forceUpdateJavascript($is_sbc_vm)
						. "<div id='force-update' class='text-center' style='margin-top:5px; color:red;'>". constant($major_issue) ."</div>";
		}
		else if ($is_sbc_vm && strlen($force_update) > 0) {
			return	"\n"
						. self::forceUpdateJavascript($is_sbc_vm)
						. "<div id='force-update' class='text-center' style='margin-top:5px;color:red;'>". constant($force_update) ."</div>";
		}
		else if ($show_notif && $bc->get('root', $has_update_cmd)) {
			return	"\n"
						. "<div id='newer_firmware_available' class='text-center' style='margin-top:5px; color:red;'>". constant($update_message) ."</div>";
		}
		return '';
	}

	static public function forceUpdateJavascript($is_sbc_vm) {
		if (!$is_sbc_vm) {
			return '';
		}
		ob_start();
		?>
 		<script type='text/javascript' language='javascript'>
			function forceCheckUpdata() {
				$.ajax({
					cache: false,
					data: { check_update:1 },
					error: function(request, stat, error) {
						forceCheckUpdate();
					},
					success: function(data) {
						if (typeof data.success !== 'undefined') {
							$('#newer_firmware_available').hide();
							$('#newer_firmware_available').html('');
							$('#id_sbcvm-current-package').val(data.current_package);
							$('.form-group.sbcvm-available-package').hide();
							$('#ajax-response').css('color', 'green');
							$('#force-update').html('<?php echo constant($message['successful']); ?>');
							document.getElementById("wait_div").style.display = "none";
						}
						else if (typeof data.rebooting !== 'undefined') {
							window.setInterval(session, 1000);
							$("#wait_div").html("<p>"+ data.rebooting +"<img src='./includes/images/waitlogo1.gif'/></p>");
						}
						else {
							forceCheckUpdate();
						}
					},
					timeout: 3000,
					type: 'POST',
					url: './modules/UpdateTool/updatetool_ajax.php',
				});
			}
 			function forceUpdate() {
	 			document.getElementById('wait_div').style.display = 'block';
 				$.ajax({
 					cache: false,
 					data: { 'force-update' : true },
 					error: function(request, stat, error) {
						forceCheckUpdate();
 					},
 					success: function(data) {
						// should not happen. the update overwrite the update_ajax.php leading to a failure
 						if (typeof data.error === 'undefined') {
							$('#force-update').css('color', 'green');
							$('#force-update').html(data.success);
 						}
 						else {
 							$('#force-update').css('color', 'red');
 							$('#force-update').html(data.error);
						}
						document.getElementById('wait_div').style.display = 'none';
					},\n"
					timeout: 60000,
					type: 'POST',
					url: './modules/UpdateTool/updatetool_ajax.php',
				});
			}
		</script>
		<?php
		return ob_get_clean() ."\n";
	}

	public static function getGuiMode($ba = null) {
		$ba = is_null($ba) ? new beroAri() : $ba;
		return $ba->get('gui_mode');
	}

	public static function headerMessage($which, $bc) {
		$color = 'red';
		$message = '';
		switch ($which) {
			case 'fw-opened':
				$ports = array();
				$ports2value = array(
					'-1'	=> 'SIP',
					'-2'	=> 'SIP/TLS',
					'22' 	=> 'SSH',
					'80' 	=> 'HTTP',
					'161'	=> 'SNMP',
					'162'	=> 'SNMP/Trap',
					'443'	=> 'HTTPS',
					'all' => 'All Ports',
				);
				$value = $bc->get('root', $which);
				$message = defined($value) ? constant($value) : '';
				foreach (explode(':', $bc->get('root', "$which-ports")) as $port) {
					$ports[] = isset($ports2value[$port]) ? $ports2value[$port] : $port;
				}
				$message .= implode(', ', $ports);
				break;
			case 'new-gui-password':
				$email = $bc->get('root', 'factory-reset-email');
				if ($email == '-1') {
					$message .= FACTORY_RESET_SBCVM_ISSUE_NEW_BEROGUI_PASSWORD;
					$bc->delete('root', 'factory-reset-email');
				}
				else if (strlen($email) > 0) {
					$message .= FACTORY_RESET_SBCVM_NEW_BEROGUI_PASSWORD . $email;
					$bc->delete('root', 'factory-reset-email');
				}
				break;
			case 'sbcvm-invalid-subscription':
				$invalid = $bc->get('root', $which);
				if (preg_match('/^([_A-Z]+):([0-9]+):([_A-Z]+)$/', $invalid, $matched)) {
					// differentiation always > 0 since once = 0 the cloud sbc is shut down
					$timer = self::convertSecondsToDaily((int)($matched[2]+86400-time()));
					$message .= constant($matched[1]) ."<div id='timer_shutdown'>{$timer['h']}h:{$timer['m']}m:{$timer['s']}s</div>\n". constant($matched[3]);
					ob_start();
					?>
					<script>
						window.setInterval(timerShutdown, 1000);
						function checkSubscription() {
							$.ajax({
								cache: false,
								error: function() {
									$('#checking_failed').html('<?php echo SBCVM_CHECKINGSUBSCRIPTION_ERROR; ?>');
								},
								success: function(data) {
									if (data == '1') {
										$('#alert_shutdown').html('<?php echo SBCVM_SUBSCRIPTION_CONFIRMED; ?>');
										$('#alert_shutdown').css('color', 'green');
									}
									else {
										$('#checking_failed').html('<?php echo SBCVM_CHECKINGSUBSCRIPTION_FAILED; ?>');
									}
								},
								timeout: 1000,
								url: 'misc/checkSubscription.php',
							});
						}
						function timerShutdown() {
							let final_time = parseInt(<?php echo $matched[2]; ?>) + 86400;
							const current_time = new Date().getTime();
							let timer = ~~(final_time - current_time / 1000); // convert timestamp from milliseconds to seconds
							var hours = ~~(timer / 3600);
							var minutes = "0" + ~~((timer % 3600) / 60);
							var seconds = "0" + ~~(timer % 60);
							$('#timer_shutdown').html(hours +'h:'+ minutes.substr(-2) +'m:'+ seconds.substr(-2) +'s');
						}
					</script>
					<?php
					return 	"\n\t<div class='text-center' style='margin-top:5px;color:$color;' id='alert_shutdown'>\n\t\t$message\n\t</div>\n"
								.	"\t<div class='text-center' style='margin-top:5px;color:$color;' id='checking_failed'></div>\n"
								. ob_get_clean();
				}
				break;
			case 'reproduce-succeeded':
				$color = 'green';
			case 'reproduce-failed':
				$value = $bc->get('root', $which);
			case 'rootfs-phpcgi-failed':
				$value = strlen($value) ? $value : $bc->get('root', $which);
				if (strlen($value) == 0) {
					return('');
				}
				else if (preg_match('/^(.*):(.*):([0-9]+)$/', $value, $matched)) {
					$message .= constant($matched[1]).'<br/>'.constant($matched[2]).'<br/>('.round($matched[3] * 0.001, 1).'MB required)';
				}
				else if (preg_match('/^(.*):([0-9]+)$/', $value, $matched)) {
					$message .= constant($matched[1]).'<br/>('.round($matched[2] * 0.001, 1).'MB required)';
				}
				else if (preg_match('/(.*):(.*)$/', $value, $matched)) {
					$message .= constant($matched[2]).'<br/>'.constant($matched[2]);
				}
				else if (preg_match('/^(.*)$/', $value, $matched)) {
					$message .= constant($matched[1]);
				}
				else {
					$message .= constant($value);
				}
				$bc->delete('root', $which);
				break;
			case 'rootfs-phpcgi-success':
				$value = $bc->get('root', $which);
				if (strlen($value) == 0) {
					return('');
				}
				$color = 'green';
				$message .= constant($value);
				$bc->delete('root', $which);
				break;
			default:
				$value = $bc->get('root', $which);
				if (strlen($value) == 0) {
					return('');
				}
				$message .= constant($value);
				break;
		}
		if (strlen($message) > 0) {
			$message = 	"\n\t<div class='text-center' style='margin-top:25px;color:$color;'>\n"
								. "\t\t$message\n"
								. "\t</div>\n";
		}
		return($message);
	}

	static public function checkRootfsPackages() {
		foreach (array('rootfs', 'recoverygui', 'lighttpd') as $pkg) {
			$showWarning = true;
			if (file_exists("/pkginfo/VERSION.$pkg")) {
				extract(@parse_ini_file("/pkginfo/VERSION.$pkg"));
				$showWarning = !($PKG_VERSION != 1 && $PKG_VERSION != 999);
				unset($PKG_VERSION);
			}
			if ($showWarning) {
				return("\n\t<div class='text-center' style='margin-top:25px;color:red;'>". ROOTFS_INSTALLATION_WARNING ."</div>\n");
			}
		}
		return('');
	}

	static public function setDataValidator($parameters, &$list_data = array(), &$options_data = array()) {
		foreach ($parameters as $key => $param) {
			$list_data[$key] = $param['validator'];
			if (isset($param['options'][$param['validator']])) {
				switch ($param['validator']) {
				case 'select':
					$options_data[$key] = array_keys($param['options'][$param['validator']]);
					break;
				default:
					$options_data[$key] = $param['options'][$param['validator']];
					break;
				}
			}
		}
	}

	## // STRING FUNCTIONS \\ ##
	static public function concatenateString($string, $what_concatenate) {
		return "{$what_concatenate}{$string}";
	}

	static public function truncateString($string, $what_truncate) {
		return str_replace($what_truncate, '', $string);
	}

	## // REDIRECT FUNCTIONS \\ ##
	static public function redirectAfterSubmit($db, $m, $uri = '') {
		//if ($db->is_error()) {
		//	echo "<script>alert('{$db->error()}');</script>";
		//	exit(0);
		//}
		echo "<script>window.location='../../index.php?m=$m$uri'</script>";
		exit(0);
	}

	static public function redirectOnError($m, $code, $msg, $path = '../../index.php') {
		echo "<script>window.location='$path?m=$m&error=$code&reason=". htmlentities(str_replace("'", "\'", $msg)) ."'</script>";
		exit(1);
	}

	static public function redirectOnBeronodeError($m, $error) {
		echo "<script>window.location='../../index.php?m=$m&error=2&reason=". htmlentities(str_replace("'", "\'", trim($error['msg']))) ."'</script>";
		exit(1);
	}

	static public function redirectOnInvalidData($m, $invalid) {
		echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
		exit(1);
	}
	#####
}
?>
