<?php
/*
 * HelperSip: A class that provides some functions to generate the GUI for the SIP configuration.
 *
 * Copyright (C) 2017 beroNet GmbH
 *
 * Author: Miguel Palmer <mp@beronet.com>
 */
require_once "/usr/local/www/berogui/includes/isgwtelnet.php";
require_once "/usr/local/www/berogui/includes/profileParser.php";

class HelperSip {

	public static $fields = array("name", "sip_proxy", "sip_registrar", "sip_domain", "user", "auth_user", "displayname", "secret",
		"sip_transport", "stunserver", "externip", "register", "validation", "regrefresh", "regrefresh_failed", "register_option", "sip_custom_port",
		"config", "matchtype", "enum_support", "enum_search_domain", "keepalive_interval", "call_transfer_method", "sip_stack",
		"dns_change_registration_behaviour", "dns_change_minimum_registration_time",
		"t38", "ie_on_sip", "wait_for_cancel", "dtmfmode", "s2i_cpt",
		"i2s_cpt", "failover_proxy", "failover_timeout", "sip_national_code", "sip_international_code",
		"isdn2sip_destination_numformat", "isdn2sip_source_numformat", "dialplan_international_prefix", "sip2dialplan_dad_prefix_setting",
		"sip2dialplan_oad_prefix_setting", "srtp_mode",
		"from_sip_src_setting", "from_sip_dest_setting", "sip_to_user_setting", "sip_from_user_setting", "sip_from_display_setting",
		"codecs", "s2s_nat_opener", "use_privacy_header", "sip_pai_user_setting", "sip_ppi_user_setting", "sip_contact_user_setting", "qvalue", "dnssrv", "addit_options", "callgroup_name", "callgroup_priority", "max_simultaneous_calls", "s2s_rtp_handling_method");
		
	public static $config_values = array("t38", "dtmfmode", "codecs", "ie_on_sip", "from_sip_src_setting", "from_sip_dest_setting",
		"wait_for_cancel", "sip_to_user_setting", "sip_from_user_setting",
		"sip_from_display_setting", "failover_proxy", "failover_timeout", "s2i_cpt", "i2s_cpt",
		"sip_national_code", "sip_international_code", "isdn2sip_destination_numformat", "isdn2sip_source_numformat",
		"dialplan_international_prefix", "sip2dialplan_dad_prefix_setting",
		"sip2dialplan_oad_prefix_setting", "srtp_mode", "s2s_nat_opener", "use_privacy_header", "sip_pai_user_setting", "sip_ppi_user_setting", "sip_contact_user_setting", "qvalue", "dnssrv", "srtp_crypto_suites", "tr_notruf", "s2s_rtp_handling_method", "sips_on_tls", "1tr119");
		
	public static $configSave = array('t38', 'ie_on_sip', 'wait_for_cancel', 'dtmfmode', 's2i_cpt',
		'i2s_cpt', 'failover_proxy', 'failover_timeout', 'sip_national_code', 'sip_international_code',
		'isdn2sip_destination_numformat', 'isdn2sip_source_numformat', 'dialplan_international_prefix', 'sip2dialplan_dad_prefix_setting',
		'sip2dialplan_oad_prefix_setting', 'srtp_mode', 's2s_nat_opener', 'use_privacy_header', 'qvalue', 'dnssrv', 'tr_notruf', 's2s_rtp_handling_method', 'sips_on_tls', '1tr119');

	public static function getValue(&$ba, $id, $option, $fixedSettings) {
		if ($id === null)
			return $fixedSettings[$option];

		$query = $ba->select("select $option from sip where id=\"" . sqlite_escape_string($id) . "\"");
		return stripslashes(sqlite_fetch_single($query));
	}

	public static function getPostParameters($options_pre_loaded) {
		// TODO: combine with $field, $config_values and $configSave
		$post = array(	// GENERAL
                  		'id_upd' => 'id', 'dummy' => 'password',
                        	// SETTINGS
                       		'name'       => 'group-name'  , 'alt_name'      => 'group-name'  , 'sip_proxy'       => 'hostname' , 'sip_registrar'    => 'hostname'     , 'sip_domain' => 'hostname', 'user'         => 'special-char' ,
                        	'auth_user'  => 'special-char', 'displayname'   => 'config-option', 'matchtype'       => 'select'   , 'matchtype_manual' => 'config-option', 'profile'    => 'select'  , 'secret'       => 'config-option',
                        	'sip_stack'  => 'select'      , 'sip_transport' => 'select'      , 'sip_custom_port' => 'int-range', 'register'         => 'bool'         , 'validation' => 'bool'    , 'regrefresh_on_validation_fail' => 'bool'    , 'enum_support' => 'bool'         ,
                        	'dns_change_registration_behaviour'  => 'select',
                        	'dns_change_minimum_registration_time'  => 'int-range',
                        	'enum_search_domain' => 'hostname', 'call_transfer_method' => 'select', 'option' => 'select', 'stunserver' => 'hostname', 'regrefresh' => 'int-range', 'regrefresh_failed' => 'int-range', 'keepalive_interval' => 'int-range', 'externip' => 'hostname',
                        	// MEDIA
                        	't38' => 'bool', 'dtmfmode' => 'select', 'srtp_mode' => 'select', 'srtp_crypto_suites' => 'select', 'codecs' => 'select',
                        	// CALLPROGRESS
                        	'wait_for_cancel' => 'bool', 's2i_cpt' => 'group-name', 'i2s_cpt' => 'group-name',
                        	// HEADERS
                        	'ie_on_sip'                => 'bool'  ,
                        	'sip_to_user_setting'      => 'select', 'sip_to_user_setting_manual'      => 'config-option', 'sip_from_user_setting'    => 'select', 'sip_from_user_setting_manual'    => 'config-option' ,
                        	'sip_from_display_setting' => 'select', 'sip_from_display_setting_manual' => 'config-option' , 'sip_pai_user_setting'     => 'select', 'sip_pai_user_setting_manual'     => 'config-option' ,
                        	'sip_ppi_user_setting'     => 'select', 'sip_ppi_user_setting_manual'     => 'config-option' , 'sip_contact_user_setting' => 'select', 'sip_contact_user_setting_manual' => 'config-option',
                        	// NUMBER-FORMATTING
                        	'sip_national_code'              => 'int>=0'       , 'sip_international_code'          => 'international-code',
                        	'isdn2sip_destination_numformat' => 'select'       , 'isdn2sip_source_numformat'       => 'select'            , 'use_privacy_header'              => 'select',
                        	'dialplan_international_prefix'  => 'config-option', 'sip2dialplan_dad_prefix_setting' => 'select'            , 'sip2dialplan_oad_prefix_setting' => 'select',
	
	                        'from_sip_src_setting' => 'select', 'from_sip_src_setting_manual' => 'config-option', 'from_sip_dest_setting' => 'select', 'from_sip_dest_setting_manual' => 'config-option',
               	   			// MORE
							'failover_proxy'=> 'group-name'	, 'failover_timeout' => 'int-range'	, 's2s_nat_opener' 	=> 'select'		, "qvalue" => 'select', 
							'dnssrv' 	=> 'bool'	, 'tr_notruf' => 'bool'			, 'addit_options' 	=> 'config-option'	, 'callgroup_name' => 'alphanumeric', 'callgroup_priority' => 'int-range', 'max_simultaneous_calls' => 'int-range', "s2s_rtp_handling_method" => 'select', 'sips_on_tls' => 'bool', '1tr119' => 'bool'
                  	   );

		$options = array(
                				'call_transfer_method'                  => array('refer', 'reinvite'),
                        		'codecs'                                => $options_pre_loaded['codecs'],
                        		'dtmfmode'                              => array('info', 'inband', 'rfc2833'),
                        		'failover_timeout'                      => array('min' => 0, 'max' => 60),
                        		'from_sip_dest_setting'                 => $options_pre_loaded['from_sip_dest_setting'],
                        		'from_sip_src_setting'                  => $options_pre_loaded['from_sip_src_setting'],
                        		'isdn2sip_destination_numformat'        => $options_pre_loaded['number_format'],
                        		'isdn2sip_source_numformat'             => $options_pre_loaded['number_format'],
                        		'keepalive_interval'                    => array('min' => 0, 'max' => 86400),
								'matchtype'								=> array('address', 'fromuser', 'touser', 'contactuser', 'requesturluser', 'manual'),
                        		'option'                                => array('nonat', 'stun', 'externip'),
                        		'profile'                               => array('manual'), // only manual allowed
                        		'qvalue'                                => $options_pre_loaded['qvalue'],
                        		's2s_rtp_handling_method'               => $options_pre_loaded['s2s_rtp_handling_method'],
                        		'regrefresh'                            => array('min' => 30, 'max' => 86400),
                        		'regrefresh_failed'                     => array('min' => 10, 'max' => 3600),
                        		's2s_nat_opener'                        => $options_pre_loaded['s2s_nat_opener'],
                        		'sip_contact_user_setting'              => $options_pre_loaded['sip_from_setting'],
                        		'sip_custom_port'                       => array('min' => 1025, 'max' => 65535),
                        		'sip_from_user_setting'                 => $options_pre_loaded['sip_from_setting'],
                        		'sip_from_display_setting'              => $options_pre_loaded['sip_from_setting'],
                        		'sip_pai_user_setting'                  => $options_pre_loaded['sip_from_setting'],
                        		'sip_ppi_user_setting'                  => $options_pre_loaded['sip_from_setting'],
                        		'sip_stack'                             => array('lan', 'localhost', 'wan', 'vpn'),
                        		'sip_to_user_setting'                   => array('${new_destination}', '${dad}', '${account_username}', 'manual'), // TODO: combine with config_parameter 
                        		'sip_transport'                         => array('udp', 'tcp', 'tls'),
                        		'sip2dialplan_dad_prefix_setting'       => $options_pre_loaded['prefix_setting'],
                        		'sip2dialplan_oad_prefix_setting'       => $options_pre_loaded['prefix_setting'],
                        		'srtp_crypto_suites'                    => array_keys($options_pre_loaded['srtp_crypto_suites']),
                        		'srtp_mode'                             => array('off', 'optional', 'mandatory', 'off:optional', 'off:mandatory', 'optional:off', 'optional:mandatory', 'mandatory:off', 'mandatory:optional'),
                        		'use_privacy_header'                    => $options_pre_loaded['privacy_header'],
                        		'callgroup_priority'                    => array('min' => 0, 'max' => 100),
                        		'max_simultaneous_calls'                => array('min' => 0, 'max' => 255),
                        		'dns_change_registration_behaviour'     => array('change_when_no_calls', 'change_immediately', 'stay_on_lower_priority'),
                        		'dns_change_minimum_registration_time'  => array('min' => 0, 'max' => 3600)
                    		);

		return array('post' => $post, 'options' => $options);
	}

	//Return Sip2Sip Licenses
	public static function getSip2SipLicenses($isgw = null) {
		if (file_exists('/usr/conf/isgw_'. SERIAL .'.license')) {
			if (is_null($isgw)) {
				$isgw = new isgwtelnet();
				$isgw->isgw_login();
			}
			if ($isgw->hasError()) {
				return array(
					'sip2sip_license_status' => 'LICENSE_ISGWNOTRUNNING',
					'sip2sip_number_of_licenses' => '0:0',
				);
			}
			return array(
				'sip2sip_license_status' => $isgw->isgw_siplicensestate(),
				'sip2sip_number_of_licenses' => $isgw->isgw_siplicensecount(), 
			);
		}
		return null;
	}

	// reload Sip License
	public static function reloadSipLicense($isgw = null) {
		if (is_null($isgw)) {
			$isgw = new isgwtelnet();
			$isgw->isgw_login();
		}
		if ($isgw->hasError()) {
			return;
		}
		$isgw->isgw_siplicenserefresh();
	}

	//Return text field
	public static function textField(&$ba, $id, $col, $fixedSettings, $default = "") {
		$value = self::getValue($ba, $id, $col, $fixedSettings);
		if ($default !== "" && $value == "") {
			$value = $default;
		}
		$ret = "<input class='form-control input-sm' name='" . $col . "' id='" . $col . "' value='" . $value . "'>";
		return $ret;
	}

	//Return password field
	public static function passwordField(&$ba, $id, $col, $fixedSettings, $javascript = '') {
		$value = strlen(self::getValue($ba, $id, $col, $fixedSettings)) > 0 ? '*****' : '';
		$ret = "<input class='form-control input-sm' name='" . $col . "' id='" . $col . "' type='password' autocomplete='new-password' $javascript value='$value'/>";
		return $ret;
	}

	//Return a dropdown field
	public static function dropdown(&$ba, $id, $col, $fixedSettings, $options, $default = "") {
		$value = self::getValue($ba, $id, $col, $fixedSettings);
		$sel = "<select class='form-control input-sm' id='" . $col . "' name='" . $col . "'>";
		if ($value !== "") {
			$default = $value;
		}
		foreach ($options as $name => $value) {
			$sel .= ($name == $default) ? "<option value='" . $name . "' selected>" . $value . "</option>" : "<option value='" . $name . "'>" . $value . "</option>";
		}
		$sel .= "</select>";
		return $sel;
	}

	//Return a checkbox
	public static function checkbox(&$ba, $id, $col, $fixedSettings, $htmlOptions = "", $default = "") {
	
		$value = self::getValue($ba, $id, $col, $fixedSettings);
		
		if (intval($value) === 1) {
			$default = "checked";
		}
		elseif (intval($value) === 0) {
			$default = "";
		}
		$ret = "<input type='hidden' name='$col' value='0'>"
			. "<input type='checkbox' name='$col' id='$col'  value='1' $default $htmlOptions>";
		return $ret;
	}

	public static function checkboxConfig($ba, $id, $param, $config = '', $checked_as_default = false) {
		// TODO: can be optimized: create an associative array from config when the page is loaded and give it as argument of this function
		// TODO: or a preg_match will be faster ... this function can easily be simplified and optimized
		$checked = '';
		if (isset($id)) {
			$query = $ba->select("SELECT config FROM sip WHERE id='". sqlite_escape_string($id) ."'");
			while ($entry = $ba->fetch_array($query)) {
				$config = $entry['config'];
			}
		}
		if ($checked_as_default) {
				// checked_as_default => param=1 and does not belong to config string
				if (!preg_match("/$param=0/", $config)) {
					$checked = 'checked';
				}
		}
		else {
			if ($config != '') {
				$configs = explode(',', $config);
				foreach ($configs as $value) {
					$key = explode("=", $value, 2);
					if ($key[0] == $param && $key[1] == 1) {
						$checked = 'checked';
						break;
					}	
				}
			}
		}
    		return    "<input type='hidden' name='$param'  value='0'>"
			. "<input type='checkbox' name='$param' id='$param' value='1' $checked>\n";
	}

	/**
	 * Additional config string bei einem Update
	 */
	public static function showdefmc($fixedSettings, $is_sbc_vm = 0) {
		require_once '/usr/local/www/berogui/includes/Helper/Helper.php';
		$zeilen = Helper::getConfigFromIsgw($is_sbc_vm);
		foreach ($zeilen as $zeile) {
			if (stripos($zeile, '[') === 0) {
				preg_match("/\[(?<bez>.+)\]\[(?<name>.+)\][\s]*(?<desc>.+)[\s]*\<(?<val>.*)\>[\s]*'(?<def>.*)'/", $zeile, $res);
				if (!in_array($res['name'], self::$config_values) && ($res['bez'] == "s" || $res['bez'] == "*")) {
					?>
					<script>
						var extra_tooltip = document.getElementById('extra_tooltip');
						extra_tooltip.innerHTML = extra_tooltip.innerHTML + '<p><?php echo DIALPLAN_OPTION_DIS; ?><b>&nbsp;' +
								'<?php echo $res['name']; ?></b><br><?php echo DIALPLAN_VALUES_DIS; ?><b>&nbsp;&lt;' +
								'<?php echo $res['val']; ?>&gt;</b><br>Default:<b>&nbsp;<?php echo $res['def']; ?></b><br><i>' +
								'<?php echo htmlspecialchars($res['desc'], ENT_QUOTES); ?></i></p><br>';
					</script>
					<?php
				}
			}
		}
		if (!isset($_GET['id'])) {
			$config = $fixedSettings['config'];
		} else {
			$ba = new beroAri();
			$query = $ba->select("select config from sip where id='" . sqlite_escape_string($_GET['id']) . "'");
			while ($entry = $ba->fetch_array($query)) {
				$config = $entry['config'];
			}
		}
		$hide_config = array('tr_notruf', 'sips_on_tls', '1tr119');
		if ($config != "") {
			$configs = explode(',', $config);
			foreach ($configs as $value) {
				$key = explode('=', $value, 2);
				if (in_array($key[0], $hide_config)) {
					continue;
				}
				else if ($key[0] != "" && $key[1] != "" && !in_array($key[0], self::$config_values)) {
					?>
					<script>
						$('#addit_options').append('<?php echo $key[0]; ?>=<?php echo $key[1]; ?>\n');
					</script>
					<?php
				} elseif ($key[0] != "" && $key[1] == "" && !in_array($key[0], self::$config_values)) {
					?>
					<script>
						$('#addit_options').append('<?php echo $key[0]; ?>=\n');
					</script>
					<?php
				}
			}
		}
	}

	/**
	 * Additional config string beim Hinzufügen einer Portgruppe
	 */
	public static function showConfAdd($is_sbc_vm = 0) {
		require_once '/usr/local/www/berogui/includes/Helper/Helper.php';
		$zeilen = Helper::getConfigFromIsgw($is_sbc_vm);
		foreach ($zeilen as $zeile) {
			if (stripos($zeile, '[') === 0) {
				preg_match("/\[(?<bez>.+)\]\[(?<name>.+)\][\s]*(?<desc>.+)[\s]*\<(?<val>.*)\>[\s]*'(?<def>.*)'/", $zeile, $res);
				if (!in_array($res['name'], self::$config_values) && ($res['bez'] == "s" || $res['bez'] == "*")) {
					?>
					<script>
						$('#extra_tooltip').html($('#extra_tooltip').prop("innerHTML") +
								'<p><?php echo DIALPLAN_OPTION_DIS; ?><b>&nbsp;<?php echo $res['name']; ?></b><br><?php echo DIALPLAN_VALUES_DIS; ?>' +
								'<b>&nbsp;&lt;<?php echo $res['val']; ?>&gt;</b><br>Default:<b>&nbsp;<?php echo $res['def']; ?></b><br><i>' +
								'<?php echo htmlspecialchars($res['desc'], ENT_QUOTES); ?></i></p><br>');
					</script>
					<?php
				}
			}
		}
	}

	public static function profiles($manual = TRUE) {
		$categories = array();
		$type = "<script type='text/javascript'>"
			. "function getProfile() {
            selectedOpt = $('#type').val();
            $('#type option').each(function ()
            {
                if (selectedOpt == 'manual')
                    $('[id=\"' + $(this).val() + '\"]').hide();
                else if (selectedOpt == $(this).val())
                    $('[id=\"' + $(this).val() + '\"]').show();
                else
                    $('[id=\"' + $(this).val() + '\"]').hide();
            });
        }"
			. "</script>";
		$type .= "<select name='type' id='type' class='form-control input-sm' onChange='getProfile();'>";
		$type .= ($manual === TRUE) ? "<option value='manual'>Manual</option>" : "<option value='manual'>- Category -</option>";
		$dh = @opendir("/usr/conf/profile");
		if (false !== $dh) {
			while ($file = readdir($dh)) {
				if ("." == $file || ".." == $file)
					continue;
				array_push($categories, $file);
				$type .= '<option value=\'' . $file . '\'>' . $file . '</option>';
			}
		}
		$type .= "</select>";
		if (false !== $dh) {
			foreach ($categories as $category) {
				$profile .= "<select name='$category' id='$category' class='form-control input-sm profile' style='display:none;'>";
				if (!$manual) {
					$profile .= "<option value='manual'>- Profile -</option>";
				}
				$dh = @opendir("/usr/conf/profile/" . $category);
				if (false === $dh) {
					return false;
				}
				while ($file = readdir($dh)) {
					if ("." == $file || ".." == $file)
						continue;
					$profile .= '<option value=\'' . $file . '\'>' . $file . '</option>';
				}
				$profile .= "</select>";
			}
		}
		return $type . $profile;
	}


	public static function matchtype(&$ba, $id, $fixedSettings) {
		$defaultArray = array('address' => 'IP Address', 'fromuser' => 'From User', 'touser' => 'To User', 'contactuser' => 'Contact User', 'requesturluser' => 'Request URI User', 'manual' => 'Manual', );
		$options = self::getValue($ba, $id, "matchtype", $fixedSettings);
		$options = explode("|", $options);
		
		if ($options[0] == "") { $options[0] = 'address'; } //set default matchtype (ip adress)

		$sel = "<select name='matchtype[]' class='form-control input-sm' id='matchtype' multiple='true' style='height:102px;'>";
		foreach ($defaultArray as $value => $name) {
			in_array($value, $options) ? $sel.= "<option value='" . $value . "' selected>" . $name . "</option>" : $sel.= "<option value='" . $value . "'>" . $name . "</option>";
		}
		$sel.="</select>";

		return $sel;
	}
	
	public static function udpports(&$ba) {
		return $ba->get("udpports");
	}

}
