<?php

// TODO: use for loop in the functions: faster, simpler, lighter ... instead of copy / paste the parameters ....

/**
 * Implementiert die Funktionen um die Konfigurationsdateien, anhand der gespeicherte Information in der Datenbank, zu generieren
 *
 * @author Miguel Palmer <mp@beronet.com>
 */

require_once('/usr/fallback/beroConf.php');
require_once("/usr/www/include/SQLite2ToSQLite3.php");

class fileManagement {

	private $_is_sbc_vm = false;

	/**
	 * @var beroConf 
	 */
	protected $bc;

	/**
	 * @var beroAri 
	 */
	protected $ba;
	
	private $conf_folder;

	public function __construct() {
		if (!file_exists("/usr/local/www/berogui/includes/variables.php")
			|| !file_exists("/usr/local/www/berogui/misc/database.php")
			|| !file_exists('/usr/local/www/berogui/includes/Helper/Helper.php')) {
				throw new Exception('missing scripts');
		}

		include("/usr/local/www/berogui/includes/variables.php");
		include("/usr/local/www/berogui/misc/database.php");
		require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
		$this->bc = new beroConf('root');
		$this->ba = new beroAri();

		$this->_is_sbc_vm = $this->ba->get('is_sbc_vm');
		
		if ($this->_is_sbc_vm) {
			$this->conf_folder = "/etc/beroNet/isgw/";
		}
		else {
			$this->conf_folder = "/usr/conf/";
		}
		
	}

	protected function pstnValue($field, $group, $table) {
		$query = $this->ba->select('select ' . $field . ' from ' . $table . ' where gr=\'' . $group . '\' group by gr');
		return sqlite_fetch_single($query);
	}

	protected function getValue($config_option, $db_field, $default) {
		$ret = $config_option . '=';
		$ret .= ($this->ba->get($db_field) != "") ? $this->ba->get($db_field) : $default;
		$ret .= "\n";
		return $ret;
	}

	protected function addComma($var, $value, $force = false) {
		($var == "" && $force == false) ? $var = $value : $var .= "," . $value;
		return $var;
	}

	/**
	 * @param integer id Line interface Nummer
	 * @param integer lif1 Name des Li im lif1
	 * @access protected
	 * @return string
	 */
	protected function lifX($id, $lif1, &$list_type = array()) {
		$gwType = Helper::getType();

		$hw_cont = "[lif" . $id . "]\n";
		$i = 0;
		$type = sqlite_fetch_single($this->ba->select('SELECT type FROM isdn WHERE lif=\'' . $id . '\' and type!="bf2t1e1" and type!="bf1t1e1" and type!="bf4t1e1" union '
				. 'SELECT type FROM analog WHERE lif=\'' . $id . '\' union '
				. 'SELECT type FROM gsm WHERE lif=\'' . $id . '\' union '
				. 'SELECT type FROM lte WHERE lif=\'' . $id . '\' union '
				. 'SELECT type FROM cas WHERE lif=\'' . $id . '\''));
		if ($type != "") {

			$list_type[] = $type;

			$hw_cont .= "type=" . $type . "\n";


			$query = $this->ba->select('SELECT port, port_type FROM isdn WHERE lif=\'' . $id . '\' and type!="bf2t1e1" and type!="bf1t1e1" and type!="bf4t1e1" union '
				. 'SELECT port, port_type FROM analog WHERE lif=\'' . $id . '\' union '
				. 'SELECT port, port_type FROM gsm WHERE lif=\'' . $id . '\'  union '
				. 'SELECT port, port_type FROM lte WHERE lif=\'' . $id . '\'  union '
				. 'SELECT port, port_type FROM cas WHERE lif=\'' . $id . '\' order by port');
			while ($entry = $this->ba->fetch_array($query)) {
				$masterdb = $this->ba->get('master');
				
				
				($masterdb == strval ($id) || $masterdb == 'all') ? $master = '1' : $master = '0';
				//Bei analog oder gsm ports Durchlauf abbrechen
				if ($entry['port_type'] == "FXS" || $entry['port_type'] == "FXO" || $entry['port_type'] == "GSM")
					continue;
				//T1E1 Modul
				elseif ($entry['port_type'] == "cas" || $entry['port_type'] == "hdlc") {
					$q_cas = $this->ba->select('SELECT * FROM cas WHERE port=\'' . $entry['port'] . '\'');
					while ($entry_cas = $this->ba->fetch_array($q_cas)) {
						$protocol = $this->addComma($protocol, $entry_cas['protocol']);
						$termination = $this->addComma($termination, $entry_cas['termination']);
						$interface_type = $this->addComma($interface_type, $entry_cas['port_type']);
						$country = $this->addComma($country, $entry_cas['country']);
						$sigchan = $this->addComma($sigchan, $entry_cas['sigchan']);
						if ($entry_cas['port_type'] == "hdlc")
							$entry_cas['coding'] = "";
						($i == 0) ? $coding = $this->addComma($coding, $entry_cas['coding']) : $coding = $this->addComma($coding, $entry_cas['coding'], true);
						$i++;
						//T1E1 clock for lif 0
						if ($entry_cas['clock'] == "1" && $id == 0)
							$clock = $entry_cas['port'];
						//T1E1 clock for lif 1
						elseif ($entry_cas['clock'] == "1" && $id == 1) {
							$q = $this->ba->select('SELECT * FROM cas WHERE lif=0 order by port');
							$clock = $entry_cas['port'] - sqlite_num_rows($q);
						}
					}
					//ISDN Module
				} else {
					$q_isdn = $this->ba->select('SELECT * FROM isdn WHERE port=\'' . $entry['port'] . '\' and type!="bf2t1e1" and type!="bf1t1e1" and type!="bf4t1e1"');
					while ($entry_isdn = $this->ba->fetch_array($q_isdn)) {
						$ntteSW = $this->addComma($ntteSW, $entry_isdn['ntteSW']);
						$ntteHW = $this->addComma($ntteHW, $entry_isdn['ntteHW']);
						$crystal_clock = $this->addComma($crystal_clock, $entry_isdn['crystal_clock']);
						$permanentl1 = $this->addComma($permanentl1, $entry_isdn['permanentl1']);
						$termination = $this->addComma($termination, $entry_isdn['lt']);
						$crc = $this->addComma($crc, $entry_isdn['crc']);
						$ptp = $this->addComma($ptp, $entry_isdn['ptp']);
						$crlen = $this->addComma($crlen, $entry_isdn['crlen']);
						$cidlen = $this->addComma($cidlen, $entry_isdn['cidlen']);
						//ISDN clock for lif 0
						if ($entry_isdn['clock'] == "1" && $id == 0)
							$clock = $entry_isdn['port'];
						//ISDN clock for lif 1
						elseif ($entry_isdn['clock'] == "1" && $id == 1) {
							$q = $this->ba->select('SELECT * FROM isdn WHERE lif=0 and type!="bf2t1e1" and type!="bf1t1e1" and type!="bf4t1e1" order by port');
							$clock = $entry_isdn['port'] - sqlite_num_rows($q);
						}
					}
				}
			}
			$hw_cont .= "master=" . $master . "\n";
			//ISDN Module
			if ($type == "bf1S0" || $type == "bf2S0" || $type == "bf4S0" || $type == "bf1E1" || $type == "bf2E1" || $type == "bf2S02FXS") {
				//Crystal clock BRI Ports
				if ($this->ba->get('sync_port_li' . $id) == 1)
					$clock = 5;
				if ($this->ba->get('sync_port_auto' . $id) == 1)
					$clock = 0;
				//Default Werte speichern wenn kein Clock
				if ($clock == "" && $master == 0)
					$clock = 1;
				else if ($clock == "" && $master == 1)
					$clock = 0;

				$hw_cont .= "clock=" . $clock . "\n";
				$hw_cont .= "ntteSW=" . $ntteSW . "\n";
				$hw_cont .= "ntteHW=" . $ntteHW . "\n";
				$hw_cont .= "permanentl1=" . $permanentl1 . "\n";
				$hw_cont .= "crlen=" . $crlen . "\n";
				$hw_cont .= "cidlen=" . $cidlen . "\n";
				//Portswitch Lif1
				if ($type == "bf4S0" && $id == 1) {
					$hw_cont .= "portswitch=0\n";
				}
				if ($type != "bf2E1" && $type != "bf1E1")
					$hw_cont .= "termination=" . $termination . "\n";
				if ($type == "bf2E1" || $type == "bf1E1")
					$hw_cont .= "crc=" . $crc . "\n";
				if ($type == "bf2E1" || $type == "bf1E1")
					$hw_cont .= "crystal_clock=" . $crystal_clock . "\n";
				$revision = Helper::getRevision();
				//Set portswitch for lif 0 if lif 1 is gsm
				if (($lif1 == "bf2GSM" || $lif1 == "bf1GSM") && $id == 0 && ($gwType < 30))
					$hw_cont .= "portswitch=1\n";
				//Portswitch option for HW revision 1.80 (just for lif0)
				if ($lif1 == "none" && $id == 0 && ($type == "bf4S0" || $type == "bf2S02FXS") && $revision != "1.80" && $revision != "1.8" && ($gwType < 30)) {
					$portswitch = $this->ba->get('portswitch');
					if ($portswitch == "") {
						$portswitch = "1";
						$portswitch = $this->ba->set('portswitch', $portswitch);
					}
					$hw_cont .= "portswitch=" . $portswitch . "\n";
				}
				elseif (($type == "bf4S0" || $type == "bf2S02FXS") && $lif1 != "bf2GSM" && $lif1 != "bf1GSM" && $id == 0 && ($gwType < 30)) {
					$hw_cont .= "portswitch=0\n";
				}
				elseif ($type == "bf2S0" || $type == "bf1S0" && $id == 0 && ($gwType < 30)) {
					$hw_cont .= "portswitch=0\n";
				}

				if ($type == "bf2S02FXS") {
					$hw_cont .= "country=" . $this->ba->get('country') . "\n";
					$hw_cont .= ($this->ba->get('boostringer') == "") ? "boostringer=0\n" : "boostringer=" . $this->ba->get('boostringer') . "\n";
					$hw_cont .= "ring_oscillator_on=" . $this->ba->get('ring_oscillator_on') . "\n";
					$hw_cont .= "ring_oscillator_off=" . $this->ba->get('ring_oscillator_off') . "\n";
				}
				$hw_cont .= "ptp=" . $ptp . "\n\n";
				//GSM Module
			} elseif ($type == "bf2GSM" || $type == "bf1GSM") {
				//CAS Module
			} elseif ($type == "bf1t1e1" || $type == "bf2t1e1" || $type == "bf4t1e1") {
				//Crystal clock and auto Ports Li0
				if ($this->ba->get('sync_port_li' . $id) == 1)
					$clock = 255;
				if ($this->ba->get('sync_port_auto' . $id) == 1)
					$clock = 0;
				if ($clock === null)
					$clock = 255;

				$hw_cont .= "clock=$clock\n";
				$hw_cont .= "interface_type=$interface_type\n";
				$hw_cont .= "termination=$termination\n";
				$hw_cont .= "protocol=$protocol\n";
				$hw_cont .= "sigchan=$sigchan\n";
				$hw_cont .= "country=$country\n";
				$hw_cont .= "coding=$coding\n";
				$hw_cont .= "\n";
			} else {
				if (Helper::getType() < 30) {
					if (!in_array($revision, array('1.80', '1.8')) && ($lif1 == 'none') && ($id == 0)) {
						
						$portswitch = $this->ba->get('portswitch');
						if ($portswitch == "") {
							$portswitch = "1";
							$portswitch = $this->ba->set('portswitch', $portswitch);
						}
						$hw_cont .= "portswitch=" . $portswitch . "\n";
					}
					else if (in_array($lif1, array('bf1GSM', 'bf2GSM')) && ($id == 0)) {
						$hw_cont .= "portswitch=1\n";
					}
					else {
						$hw_cont .= "portswitch=0\n";
					}
				}
				
				if ($type == "bf4FXO" || $type == "bf2FXO") {
					$hw_cont .= "country=" . $this->ba->get('country') . "\n";
					$hw_cont .= "ohs=" . $this->ba->get('ohs') . "\n";
					$hw_cont .= "ohs2=" . $this->ba->get('ohs2') . "\n";
					$hw_cont .= "rz=" . $this->ba->get('rz') . "\n";
					$hw_cont .= "rt=" . $this->ba->get('rt') . "\n";
					$hw_cont .= "rt2=" . $this->ba->get('rt2') . "\n";
					$hw_cont .= "dcv=" . $this->ba->get('dcv') . "\n";
					$hw_cont .= "mini=" . $this->ba->get('mini') . "\n";
					$hw_cont .= "ilim=" . $this->ba->get('ilim') . "\n";
					$hw_cont .= "acim=" . $this->ba->get('acim') . "\n";
					$hw_cont .= "wait4idle=" . $this->ba->get('wait4idle') . "\n";
				}

				if (preg_match('/bf[0-9]*FXS/', $type)) {
					$hw_cont .= ($this->ba->get('boostringer') == "") ? "boostringer=0\n" : "boostringer=" . $this->ba->get('boostringer') . "\n";
					$hw_cont .= "ring_oscillator_on=" . $this->ba->get('ring_oscillator_on') . "\n";
					$hw_cont .= "ring_oscillator_off=" . $this->ba->get('ring_oscillator_off') . "\n";
				}
				$hw_cont .= "\n";
			}
		}else {
			$hw_cont .= "type=none\n";
			//Wenn PCM master=1 und kein lif1 gesteckt ist master=0
			if ($this->ba->get('master') == 'pcm') {
				$hw_cont .= "master=0\n\n";
			}
			$hw_cont .= "\n";
		}
		return $hw_cont;
	}

	protected function saveFile($filename, $content) {
		// ?? What is the difference between the two conditions ?? same action -> TODO
		if (!file_exists($filename)) {
			$fp = fopen($filename, "w+");
			$write = fputs($fp, html_entity_decode($content));
			fclose($fp);
		} else if (file_exists($filename)) {
			$fp = fopen($filename, "w+");
			$write = fputs($fp, html_entity_decode($content));
			fclose($fp);
		}
	}

	public function isgwConf() {
		// TODO: for loop: faster, simpler, lighter
		$isgw_cont = "[general]\n";

		$isgw_cont .= "statusport=54322\n";
		$isgw_cont .= $this->getValue('logserver', 'logserver', "127.0.0.1:514");
			
		$isgw_cont .= $this->getValue('logging_message', 'logging_message', "0");
		$isgw_cont .= $this->getValue('logging_debug', 'logging_debug', "0");
		$isgw_cont .= $this->getValue('logging_nmessage', 'logging_nmessage', '0');
		
		$isgw_cont .= $this->getValue('loglevel_message', 'loglevel_message', '2');
		$isgw_cont .= $this->getValue('loglevel_debug', 'loglevel_debug', "0");

		$isgw_cont .= $this->getValue("syslog_facility", "syslog_facility", "16");
		$isgw_cont .= $this->getValue("reject_calls_under_load", "reject_calls_under_load", "0");
		$isgw_cont .= $this->getValue("pcm_server", "pcm_server", "0");
		$isgw_cont .= $this->getValue("pcm_server_port", "pcm_server_port", "54329");
		$isgw_cont .= $this->getValue("logcdr", "logcdr", "0");
		
		$isgw_cont .= $this->getValue("logsizelimit", "logsizelimit", "1000000");
		$isgw_cont .= $this->getValue("nlogsizelimit", "nlogsizelimit", "500000");
		$isgw_cont .= $this->getValue("sofialogsizelimit", "sofialogsizelimit", "50000");
		$isgw_cont .= $this->getValue("cdrsizelimit", "cdrsizelimit", "200000");
		

		$isgw_cont .= "msp_bridging=YES\n";

		$ini_array = array();
		foreach(array(
			'experimental_options', 'emergency_numbers', 'device_name',
			'blacklist_max_options_packets_lan', 'blacklist_options_timeframe_lan', 'blacklist_max_invite_packets_lan', 'blacklist_invite_timeframe_lan', 'blacklist_max_register_packets_lan', 'blacklist_register_timeframe_lan',
			'blacklist_max_other_packets_lan', 'blacklist_other_timeframe_lan', 'blacklist_blockduration_lan',
			'blacklist_max_options_packets_wan', 'blacklist_options_timeframe_wan', 'blacklist_max_invite_packets_wan', 'blacklist_invite_timeframe_wan', 'blacklist_max_register_packets_wan', 'blacklist_register_timeframe_wan',
			'blacklist_max_other_packets_wan', 'blacklist_other_timeframe_wan', 'blacklist_blockduration_wan',
		) as $key) {
			$ini_array[$key] = $this->ba->get($key);
		}
		$isgw_cont .= Helper::buildIniString($ini_array);

		if ($this->bc->get("root", "vlan-enable") == "1") {
			$isgw_cont .= "interface_host=eth0." . $this->bc->get("root", "vlan-id") . "\n";
		}

		$isgw_cont .= "\n#include " . $this->conf_folder . "isgw.conf.custom\n";
		$this->saveFile($this->conf_folder . "/isgw.conf", $isgw_cont);
	}

	private function stackSettings($iface, $iface_name = null) {
		$list_params = array(
			// key => default_value
			'stack_active' 		=> '',
			'sip_bindport'		=> '',
			'rtpports'		=> '',
			'sip_transport'		=> '',
			'ssl_version'		=> '',
			'tos_rtp'		=> '160',
			'tos_sip'		=> '160',
			'rtp_port_selection'	=> '',
			'tls_verification_selection'	=> '',
			'sip_useragent' => $iface == 'wan' ? SIP_USERAGENT_WAN_DEFAULT : SIP_USERAGENT_LAN_DEFAULT,
			'registration_balancing'	=> '0',
		);
		$params = array(
			"interface_name_$iface" => (is_null($iface_name) ? Helper::getNetworkIfaceByName($iface) : $iface_name),
		);
		foreach ($list_params as $key => $default) {
			$value = $this->ba->get("{$key}_{$iface}");
			$params["{$key}_{$iface}"] = (strlen($value) != 0 ? $value : $default);
		}
		$params["sip_useragent_$iface"] = str_replace(
			array('{MAC}', '{SERIAL}', '{MODULES}'),
			array(Helper::getNetworkMacAddr(Helper::getNetworkIfaceByName($iface, $this->bc)), Helper::getSerial(), implode('_', Helper::getLif())),
			$params["sip_useragent_$iface"]
		);
		return(Helper::buildIniString($params));
	}

	public function isgwSip() {
		$sip_cont = "[general]\n";
		
		if ($this->_is_sbc_vm) {
			$sip_cont .= $this->stackSettings('wan', 'ens4');
			if ($this->bc->get('root', 'is-vpn-running')) {
				$sip_cont .= $this->stackSettings('lan', 'tun0');
			}
		}
		else {
			$sip_cont .= $this->stackSettings('lan');
			if ($this->bc->get('root', 'lan-mode') == 'lan-wan') {
				$sip_cont .= $this->stackSettings('wan');
			}
			if (is_dir('/home/admin/apps/openvpn/')) {
				$sip_cont .= $this->stackSettings('vpn');
			}
		}

		$query_sip = $this->ba->select("select * from sip");

		while ($entry = $this->ba->fetch_array($query_sip)) {
			$sip_cont .= "[" . $entry['name'] . "]\n";
			$sip_cont .= "sip_registrar = " . $entry['sip_registrar'] . "\n";
			$sip_cont .= "sip_domain = " . $entry['sip_domain'] . "\n";
			$sip_cont .= "sip_proxy = " . $entry['sip_proxy'] . "\n";
			$sip_cont .= "register = " . $entry['register'] . "\n";
			$sip_cont .= "user = " . $entry['user'] . "\n";
			$sip_cont .= "auth_user = " . $entry['auth_user'] . "\n";
			$sip_cont .= "displayname = " . $entry['displayname'] . "\n";
			$sip_cont .= "transport = " . $entry['sip_transport'] . "\n";
			$sip_cont .= "sip_custom_port = " . $entry['sip_custom_port'] . "\n";
			$sip_cont .= "secret = " . $entry['secret'] . "\n";
			if ($entry['register'] == '1') {
				$sip_cont .= "regrefresh = " . $entry['regrefresh'] . "\n";
				$sip_cont .= "regrefresh_failed = " . $entry['regrefresh_failed'] . "\n";
				$sip_cont .= "register_options = " . $entry['register_option'] . "\n";
			}
			$sip_cont .= "validation = " . $entry['validation'] . "\n";
			if ($entry['validation'] == '1') {
				$sip_cont .= "keepalive-interval = " . $entry['keepalive_interval'] . "\n";
				$sip_cont .= "regrefresh_on_validation_fail = " . $entry['regrefresh_on_validation_fail'] . "\n";
			}
			
			$sip_cont .= "externip = " . $entry['externip'] . "\n";
			$sip_cont .= "stunserver = " . $entry['stunserver'] . "\n";
			$sip_cont .= "config = " . str_replace(';', '\;', html_entity_decode($entry['config'])) ."\n";
			$sip_cont .= "profile = " . $entry['profile'] . "\n";
			$sip_cont .= "matchtype = " . $entry['matchtype'] . "\n";
			$sip_cont .= "matchtype_manual = " . $entry['matchtype_manual'] . "\n";
			$sip_cont .= "enum_support = " . $entry['enum_support'] . "\n";
			$sip_cont .= "enum_search_domains = " . $entry['enum_search_domain'] . "\n";
			$sip_cont .= "call_transfer_method = " . $entry['call_transfer_method'] . "\n";
			$sip_cont .= "sip_stack = " . $entry['sip_stack'] . "\n";
			$sip_cont .= "callgroup_name = " . $entry['callgroup_name'] . "\n";
			$sip_cont .= "callgroup_priority = " . $entry['callgroup_priority'] . "\n";
			$sip_cont .= "max_simultaneous_calls = " . $entry['max_simultaneous_calls'] . "\n";
			
			$sip_cont .= "dns_change_registration_behaviour = " . $entry['dns_change_registration_behaviour'] . "\n";
			$sip_cont .= "dns_change_minimum_registration_time = " . $entry['dns_change_minimum_registration_time'] . "\n";
			$sip_cont .= "\n";
		}

		$sip_cont .= "\n#include " . $this->conf_folder . "isgw.sip.custom\n";
		$this->saveFile($this->conf_folder ."isgw.sip", $sip_cont);
	}

	public function isgwIsdn() {
		$file_isdn = "/usr/conf/isgw.isdn";
		$isdn_cont .= "[general]\n";
		$isdn_cont .= "time_from_isdn=" . $this->bc->get("root", "time_from_isdn") . "\n\n";
		$query = $this->ba->select('SELECT DISTINCT gr FROM isdn WHERE gr!="NULL"');
		while ($entry = $this->ba->fetch_array($query)) {
			$query_port = $this->ba->select('SELECT port FROM isdn WHERE gr=\'' . $entry['gr'] . '\' ORDER BY port asc');
			$ports = "";
			while ($entryp = $this->ba->fetch_array($query_port)) {
				$ports = $this->addComma($ports, $entryp['port']);
			}
			$group = $entry['gr'];
			$isdn_cont .= "[" . $group . "]\n";
			$isdn_cont .= "ports = " . $ports . "\n";
			$isdn_cont .= "config = " . $this->pstnValue('config', $group, 'isdn') . "\n";
			$isdn_cont .= "chansel = " . $this->pstnValue("chansel", $group, 'isdn') . "\n";
			$isdn_cont .= "chansel_direction = " . $this->pstnValue("chansel_dir", $group, 'isdn') . "\n";
			$isdn_cont .= "tones = " . $this->pstnValue("tones", $group, 'isdn') . "\n";
			$isdn_cont .= "interdigit_timeout = " . $this->pstnValue("odt", $group, 'isdn') . "\n";
			$isdn_cont .= "interdigit_timeout_initial = " . $this->pstnValue("odt_empty_dad", $group, 'isdn') . "\n";
			$isdn_cont .= "overlap_dialing = " . $this->pstnValue("overlap_dialing", $group, 'isdn') . "\n";
			$isdn_cont .= "qsig = " . $this->pstnValue("qsig", $group, 'isdn') . "\n";
			$isdn_cont .= "portpullup = " . $this->pstnValue("portpullup", $group, 'isdn') . "\n";
			$isdn_cont .= "pcmlaw = " . $this->pstnValue('pcmlaw', $group, 'isdn') . "\n";
			$isdn_cont .= "country_code = " . $this->pstnValue('country_code', $group, 'isdn') . "\n";
			$isdn_cont .= "city_code = " . $this->pstnValue('city_code', $group, 'isdn') . "\n";
			$isdn_cont .= "local_area_code = " . $this->pstnValue('local_area_code', $group, 'isdn') . "\n";
			$isdn_cont .= "dialtone_digits = " . $this->pstnValue('dialtone_digits', $group, 'isdn') . "\n";
			$isdn_cont .= "restart_after_link_loss = " . $this->pstnValue('restart_after_link_loss', $group, 'isdn') . "\n";
			$isdn_cont .= "monitored_sip_peer = " . $this->pstnValue('monitored_sip_peer', $group, 'isdn') . "\n";
			$isdn_cont .= "monitored_sip_peer_offtime = " . $this->pstnValue('monitored_sip_peer_offtime', $group, 'isdn') . "\n";
			$isdn_cont .= "\n";
		}

		$isdn_cont .= "\n#include /usr/conf/isgw.isdn.custom\n";
		$this->saveFile("/usr/conf/isgw.isdn", $isdn_cont);
	}

	public function hardwareConf(&$list_type = array()) {
		//hardware.conf
		$query = $this->ba->select('SELECT type  FROM isdn WHERE lif="1" and type!="bf2t1e1" and type!="bf1t1e1" and type!="bf4t1e1" union '
			. 'SELECT type  FROM analog WHERE lif="1" union '
			. 'SELECT type  FROM gsm WHERE lif="1" union '
			. 'SELECT type  FROM lte WHERE lif="1" union '
			. 'SELECT type FROM cas WHERE lif="1"');
		$tmp = sqlite_fetch_single($query);
		$lif1 = ($tmp == "") ? $lif1 = "none" : $lif1 = $tmp;

		for ($i = 0; $i < Helper::getLifCount(); $i++) {
			$hw_cont .= $this->lifX($i, $lif1, $list_type);
		}

		$hw_cont .= "[pcm]\ntype=pcm\n";
		$masterdb = $this->ba->get('master');
		if ($masterdb == 'pcm')
			$hw_cont .= "master=1\n";
		else
			$hw_cont .= "master=0\n";

		$this->saveFile("/usr/conf/hardware.conf", $hw_cont);
	}

	public function isgwCpt() {
		$cpt_cont = "";
		$query = $this->ba->select('SELECT * FROM callprogress');
		while ($entry = $this->ba->fetch_array($query)) {
			switch ($entry['direction']) {
				case "SIP-ISDN":
					$direction = "s2i";
					break;
				case "ISDN-SIP":
					$direction = "i2s";
					break;
				case "SIP-FXO":
					$direction = "s2fxo";
					break;
			}
			$cpt_cont .= "[" . $direction . ":" . $entry['name'] . "]\n";
			if ($entry['direction'] == "SIP-FXO") {
				$cpt_cont .= "TIMER_DIAL=" . $entry['timer_dial'] . "\n";
				$cpt_cont .= "TIMER_POLREV=" . $entry['timer_polrev'] . "\n";
				$cpt_cont .= "TIMER_ALERTING_STOP=" . $entry['timer_alerting_stop'] . "\n";
			}
			$q_ent = $this->ba->select('SELECT * FROM callprogress_entries WHERE id_name=\'' . $entry['id'] . '\'');
			while ($entry_ = $this->ba->fetch_array($q_ent)) {
				switch ($entry['direction']) {
					case "SIP-ISDN":
						$cpt_cont .= $entry_['type'] . "\t" . $entry_['chann_det'] . "\t" . $entry_['isdn_event'] . "\t" . $entry_['sip_resp'] . "\t" . $entry_['resp_text'] . "\n";
						break;
					case "ISDN-SIP":
						$cpt_cont .= $entry_['type'] . "\t" . $entry_['isdn_event'] . "\t" . $entry_['resp_text'] . "\t" . $entry_['sip_resp'] . "\n";
						break;
					case "SIP-FXO":
						$cpt_cont .= $entry_['isdn_event'] . "\t" . $entry_['sip_resp'] . "\t" . $entry_['resp_text'] . "\n";
						break;
				}
			}
		}

		$this->saveFile("/usr/conf/isgw.cpt", $cpt_cont);
	}

	public function isgwAnalog() {
		//isgw.analog
		$analog_cont = "[general]\n";
		$query = $this->ba->select('SELECT DISTINCT gr FROM analog WHERE gr!="NULL"');
		while ($entry = $this->ba->fetch_array($query)) {
			$query_port = $this->ba->select('SELECT port FROM analog WHERE gr=\'' . $entry['gr'] . '\' ORDER BY port asc');
			$ports = "";
			while ($entryp = $this->ba->fetch_array($query_port)) {
				$ports = $this->addComma($ports, $entryp['port']);
			}

			$group = $entry['gr'];
			$port_type = $this->pstnValue('port_type', $group, 'analog');
			$analog_cont .= "[" . $entry['gr'] . "]\n";
			$analog_cont .= "ports = " . $ports . "\n";
			$analog_cont .= "interdigit_timeout = " . $this->pstnValue('overlap_dial_timeout', $group, 'analog') . "\n";
			$analog_cont .= "interdigit_timeout_initial = " . $this->pstnValue('overlap_dial_timeout_empty_dad', $group, 'analog') . "\n";
			$analog_cont .= "overlap_dialing = " . $this->pstnValue('overlap_dialing', $group, 'analog') . "\n";
			$analog_cont .= "tones = " . $this->pstnValue('tones', $group, 'analog') . "\n";
			$analog_cont .= "clip = " . $this->pstnValue('clip', $group, 'analog') . "\n";
			$analog_cont .= "cnip = " . $this->pstnValue('cnip', $group, 'analog') . "\n";
			$analog_cont .= "chansel = " . $this->pstnValue('chansel', $group, 'analog') . "\n";
			$analog_cont .= "chansel_direction = " . $this->pstnValue('chansel_dir', $group, 'analog') . "\n";
			$analog_cont .= "dialtone_digits = " . $this->pstnValue('dialtone_digits', $group, 'analog') . "\n";
			if ($port_type == "FXO") {
				$analog_cont .= "fxo_connect = " . $this->pstnValue('fxo_connect', $group, 'analog') . "\n";
				$analog_cont .= "fxo_wait_for_oad = " . $this->pstnValue('fxo_wait_for_oad', $group, 'analog') . "\n";
				$analog_cont .= "fxo_dialtone_passthrough = " . $this->pstnValue('fxo_dialtone_passthrough', $group, 'analog') . "\n";
				$analog_cont .= "fxo_call_ending_signal = " . $this->pstnValue('fxo_call_ending_signal', $group, 'analog') . "\n";
				$analog_cont .= "fxo_cid_detection_mode = " . $this->pstnValue('fxo_cid_detection_mode', $group, 'analog') . "\n";
			}
			if ($port_type == "FXS") {
				$analog_cont .= "message_waiting_method = " . $this->pstnValue('message_waiting_method', $group, 'analog') . "\n";
			}
			$analog_cont .= "fxo_verify_ringing = " . $this->pstnValue('fxo_verify_ringing', $group, 'analog') . "\n";
			$analog_cont .= "fxs_wink_offset = " . $this->pstnValue('fxs_wink_offset', $group, 'analog') . "\n";
			$analog_cont .= "fxs_wink_duration = " . $this->pstnValue('fxs_wink_duration', $group, 'analog') . "\n";
			$analog_cont .= "config = " . $this->pstnValue('config', $group, 'analog') . "\n";
			$analog_cont .= "\n";
		}

		$analog_cont .= "\n#include /usr/conf/isgw.analog.custom\n";
		$this->saveFile("/usr/conf/isgw.analog", $analog_cont);

		//isgw.tones.custom (for FXO analog)
		require_once('/usr/local/www/berogui/includes/Helper/HelperPstn.php');
		$custom = HelperPstn::getTonesCustom($this->ba);
		if (empty($custom)) {
			if (file_exists('/usr/conf/isgw.tones.custom')) {
				unlink('/usr/conf/isgw.tones.custom');
			}
		}
		else {
			$this->saveFile('/usr/conf/isgw.tones.custom', Helper::buildIniString($custom));
		}
	}

	public function isgwCas() {
		//isgw.cas
		$cas_cont = "[general]\n";
		$query = $this->ba->select('SELECT DISTINCT gr FROM cas_channels WHERE gr!="NULL"');
		while ($entry = $this->ba->fetch_array($query)) {

			$query_channel = $this->ba->select('SELECT channel FROM cas_channels WHERE gr=\'' . $entry['gr'] . '\' ORDER BY channel asc');
			$channels = "";
			while ($entrych = $this->ba->fetch_array($query_channel)) {
				$channels = $this->addComma($channels, $entrych['channel']);
			}
			$group = $entry['gr'];
			$cas_cont .= "[" . $entry['gr'] . "]\n";
			$cas_cont .= "ports = " . $channels . "\n";
			$cas_cont .= "t1_signalling = " . $this->pstnValue('t1sigtype', $group, 'cas_channels') . "\n";
			$cas_cont .= "e1_signalling = " . $this->pstnValue('e1sigtype', $group, 'cas_channels') . "\n";
			$cas_cont .= "interdigit_timeout = " . $this->pstnValue('interdigit_timeout', $group, 'cas_channels') . "\n";
			$cas_cont .= "interdigit_timeout_initial = " . $this->pstnValue('interdigit_timeout_initial', $group, 'cas_channels') . "\n";
			$cas_cont .= "overlap_dialing = " . $this->pstnValue('overlap_dialing', $group, 'cas_channels') . "\n";
			$cas_cont .= "tones = " . $this->pstnValue('tones', $group, 'cas_channels') . "\n";
			$cas_cont .= "clip = " . $this->pstnValue('clip', $group, 'cas_channels') . "\n";
			$cas_cont .= "cnip = " . $this->pstnValue('cnip', $group, 'cas_channels') . "\n";
			$cas_cont .= "chansel = " . $this->pstnValue('chansel', $group, 'cas_channels') . "\n";
			$cas_cont .= "chansel_direction = " . $this->pstnValue('chansel_dir', $group, 'cas_channels') . "\n";
			$cas_cont .= "dialtone_digits = " . $this->pstnValue('dialtone_digits', $group, 'cas_channels') . "\n";
			$cas_cont .= "wait_for_oad = " . $this->pstnValue('wait_for_oad', $group, 'cas_channels') . "\n";
			$cas_cont .= "pcmlaw = " . $this->pstnValue('pcmlaw', $group, 'cas_channels') . "\n";
			$cas_cont .= "fxo_wait_for_oad = " . $this->pstnValue('fxo_wait_for_oad', $group, 'cas_channels') . "\n";
			$cas_cont .= "fxo_callerid_detection_timeout = " . $this->pstnValue('fxo_callerid_detection_timeout', $group, 'cas_channels') . "\n";
			$cas_cont .= "fxo_call_ending_signal = " . $this->pstnValue('fxo_call_ending_signal', $group, 'cas_channels') . "\n";
			$cas_cont .= "fxo_cid_detection_mode = " . $this->pstnValue('fxo_cid_detection_mode', $group, 'cas_channels') . "\n";
			$cas_cont .= "config = " . $this->pstnValue('config', $group, 'cas_channels') . "\n";
			$cas_cont .= "\n";
		}

		$cas_cont .= "\n#include /usr/conf/isgw.cas.custom\n";
		$this->saveFile("/usr/conf/isgw.cas", $cas_cont);
	}

	public function isgwGsm() {
		$gsm_cont = "[general]\n";
		$query = $this->ba->select('SELECT * FROM gsm ORDER BY port ASC');
		$j = 0;
		while ($entry_gsm = $this->ba->fetch_array($query)) {
			//Wenn das Feld PIN oder SMSC leer sind trotzdem ein Komma bei dem zweiten hinzufügen
			($j == 0) ? $pin = $this->addComma($pin, $entry_gsm['pin']) : $pin = $this->addComma($pin, $entry_gsm['pin'], true);
			($j == 0) ? $smsc = $this->addComma($smsc, $entry_gsm['smsc']) : $smsc = $this->addComma($smsc, $entry_gsm['smsc'], true);
			($j == 0) ? $codec = $this->addComma($codec, $entry_gsm['codec']) : $codec = $this->addComma($codec, $entry_gsm['codec'], true);
			$j++;
		}
		$gsm_cont .= "pin=" . $pin . "\n";
		$gsm_cont .= "smsc=" . $smsc . "\n";
		$gsm_cont .= "codec=" . $codec . "\n";
		$query = $this->ba->select('SELECT DISTINCT gr FROM gsm WHERE gr!="NULL"');
		while ($entry = $this->ba->fetch_array($query)) {

			$query_port = $this->ba->select('SELECT port FROM gsm WHERE gr=\'' . $entry['gr'] . '\' ORDER BY port asc');
			$ports = "";
			while ($entryp = $this->ba->fetch_array($query_port)) {
				$ports = $this->addComma($ports, $entryp['port']);
			}

			$group = $entry['gr'];
			$gsm_cont .= "[" . $entry['gr'] . "]\n";
			$gsm_cont .= "ports = " . $ports . "\n";
			$gsm_cont .= "config = " . $this->pstnValue('config', $group, 'gsm') . "\n";
			$gsm_cont .= "sms_extensions = " . $this->pstnValue('sms_extension', $group, 'gsm') . "\n";
			$gsm_cont .= "extensions = " . $this->pstnValue('extension', $group, 'gsm') . "\n";
			$gsm_cont .= "chansel = " . $this->pstnValue('chansel', $group, 'gsm') . "\n";
			$gsm_cont .= "chansel_direction = " . $this->pstnValue('chansel_dir', $group, 'gsm') . "\n";
			$gsm_cont .= "\n";
			//$gsm_cont.="pin = ".$pin."\n";
			//$gsm_cont.="smsc = ".$smsc."\n";
		}

		$gsm_cont .= "\n#include /usr/conf/isgw.gsm.custom\n";
		$this->saveFile("/usr/conf/isgw.gsm", $gsm_cont);
	}
	
	public function isgwLte() {
		$lte_cont = "[general]\n";
		$query = $this->ba->select('SELECT * FROM lte ORDER BY port ASC');
		$j = 0;
		while ($entry_lte = $this->ba->fetch_array($query)) {
			//Wenn das Feld PIN oder SMSC leer sind trotzdem ein Komma bei dem zweiten hinzufügen
			($j == 0) ? $pin = $this->addComma($pin, $entry_lte['pin']) : $pin = $this->addComma($pin, $entry_lte['pin'], true);
			($j == 0) ? $smsc = $this->addComma($smsc, $entry_lte['smsc']) : $smsc = $this->addComma($smsc, $entry_lte['smsc'], true);
			($j == 0) ? $codec = $this->addComma($codec, $entry_lte['codec']) : $codec = $this->addComma($codec, $entry_lte['codec'], true);
			($j == 0) ? $provider = $this->addComma($provider, $entry_lte['provider']) : $provider = $this->addComma($provider, $entry_lte['provider'], true);
			$j++;
		}
		$lte_cont .= "pin=" . $pin . "\n";
		$lte_cont .= "smsc=" . $smsc . "\n";
		$lte_cont .= "codec=" . $codec . "\n";
		$lte_cont .= "provider=" . $provider . "\n";
		$query = $this->ba->select('SELECT DISTINCT gr FROM lte WHERE gr!="NULL"');
		while ($entry = $this->ba->fetch_array($query)) {

			$query_port = $this->ba->select('SELECT port FROM lte WHERE gr=\'' . $entry['gr'] . '\' ORDER BY port asc');
			$ports = "";
			while ($entryp = $this->ba->fetch_array($query_port)) {
				$ports = $this->addComma($ports, $entryp['port']);
			}

			$group = $entry['gr'];
			$lte_cont .= "[" . $entry['gr'] . "]\n";
			$lte_cont .= "ports = " . $ports . "\n";
			$lte_cont .= "config = " . $this->pstnValue('config', $group, 'lte') . "\n";
			$lte_cont .= "sms_extensions = " . $this->pstnValue('sms_extension', $group, 'lte') . "\n";
			$lte_cont .= "extensions = " . $this->pstnValue('extension', $group, 'lte') . "\n";
			$lte_cont .= "chansel = " . $this->pstnValue('chansel', $group, 'lte') . "\n";
			$lte_cont .= "chansel_direction = " . $this->pstnValue('chansel_dir', $group, 'lte') . "\n";
			$lte_cont .= "sms_webhook = " . $this->pstnValue('sms_webhook', $group, 'lte') . "\n";
			$lte_cont .= "sms_webhook_user = " . $this->pstnValue('sms_webhook_user', $group, 'lte') . "\n";
			$lte_cont .= "sms_webhook_secret = " . $this->pstnValue('sms_webhook_secret', $group, 'lte') . "\n";
			$lte_cont .= "sms_webhook_type= " . $this->pstnValue('sms_webhook_type', $group, 'lte') . "\n";
			$lte_cont .= "sms_webhook_id= " . $this->pstnValue('sms_webhook_id', $group, 'lte') . "\n";
			$lte_cont .= "wait_for_cid_timeout = " . $this->pstnValue('wait_for_cid_timeout', $group, 'lte') . "\n";
			$lte_cont .= "lte_init_hook = " . $this->pstnValue('lte_init_hook', $group, 'lte') . "\n";
			$lte_cont .= "\n";
		}

		$lte_cont .= "\n#include /usr/conf/isgw.lte.custom\n";
		$this->saveFile("/usr/conf/isgw.lte", $lte_cont);
	}

	public function miscConf($file_misc = "/usr/conf/misc.conf") {
		$conf = array(
			'general' => array(),
		);
		$params = array();
		// load Network Configuration parameters
		$nw_params = require('/usr/local/www/berogui/modules/NetConf/netconf_parameters.php');
		if ($this->bc->get('root', 'lan-ports') != 2) {
			unset($nw_params['wanDhcp'], $nw_params['wanNetmask'], $nw_params['wanGateway']);
			unset($nw_params['bondingMode'], $nw_params['bondingMiimon'], $nw_params['bondingUpdelay'], $nw_params['bondingDowndelay']);
		}
		foreach ($nw_params as $param) {
			if (!is_null($param['miscConf'])) {
				$params[$param['db-key']] = $this->bc->get("root", $param['db-key']);
			}
		}
		$conf['general'] = $params;

		## cloud
		foreach (array('_enable', '_show_status', '_key', 'Address') as $key) {
			$conf["cloud{$key}"] = $this->bc->get('root', "cloud{$key}");
		}
		foreach (array('Enabled', 'Address', 'Port', 'Type', 'User', 'Secret') as $key) {
			$conf["proxy{$key}"] = $this->bc->get('root', "proxy{$key}");
		}
		foreach (array('debug', 'verifyhost', 'verifypeer') as $key) {
			$conf["openssl_$key"] = $this->bc->get('root', "openssl_$key");
		}
		foreach (array(
			'gui-ntphost', 'ntphost', 'timezone', 'timezone_mode', 'time_mode','root-version', 'msp-iface', 'msp-ipaddr', 'app-image', 'app-status', 'use-boot-prov', 'tftp-host', 'tftp-url',
			'provisioning_manual', 'provisioning_mode', 'provisioning_useragent', 'provisioning_url', 'polling_interval',
		) as $key) {
			$conf[$key] = $this->bc->get('root', $key);
		}
		
		
		//update /etc/TZ file if necessary
		if (1) {
			$timezone_mode = $this->bc->get('root', "timezone_mode");
			$timezone_db = $this->bc->get('root', "timezone");
			$timezone_list = Helper::getTimezoneList();
			$timezone = $timezone_list[sqlite_escape_string($timezone_db)];
			switch ($timezone_mode) {
					case 'auto':
						$update_TZ = "{$timezone['std-abbr']}{$timezone['std-offset']}{$timezone['dst-abbr']},{$timezone['rules']}";
						break;
					case 'summer':
						if (preg_match('/^(-|\+)(\d+)$/', $timezone['std-offset'], $gmt_matched)) {
							$gmt_modified = $gmt_matched[1]. (string)($gmt_matched[1] === '-' ? (int)$gmt_matched[2] + 1 : abs((int)$gmt_matched[2] - 1));
							$update_TZ = "GMT$gmt_modified";
						}
						else if (preg_match('/(-|\+)(\d+):(\d+)$/', $timezone['std-offset'], $gmt_matched)) {
							$gmt_modified = $gmt_matched[1]. (string)($gmt_matched[1] === '-' ? (int)$gmt_matched[2] + 1 : abs((int)$gmt_matched[2] - 1));
							$update_TZ = "GMT$gmt_modified:{$gmt_matched[3]}";
						}
						break;
					case 'winter':
						$update_TZ = "{$timezone['std-abbr']}{$timezone['std-offset']}";
					break;
			}
			
			$tzfile = explode ("\n", file_get_contents("/etc/TZ"));
			if ($tzfile[0] != $update_TZ) {
				system("/bin/mount -o remount,rw /");
				file_put_contents ("/etc/TZ", $update_TZ . "\n");
			}
		}

		$m_cont = Helper::buildIniString($conf);
		

		/* OLDWAY. MUST BE UPDATED */
		$m_cont .= "snmp-enabled=" . $this->bc->get("root", "snmp-enabled") . "\n";
		$m_cont .= "snmpserver_enabled=" . $this->bc->get("root", "snmpserver_enabled") . "\n";
		
		$m_cont .= "snmp-syslocation=" . $this->bc->get("root", "snmp-syslocation") . "\n";
		$m_cont .= "snmp-version=" . $this->bc->get("root", "snmp-version") . "\n";

		$m_cont .= "snmp-community-ro=" . $this->bc->get("root", "snmp-community-ro") . "\n";
		$m_cont .= "snmp-community-rw=" . $this->bc->get("root", "snmp-community-rw") . "\n";
		
		$m_cont .= "snmp-ro-user=" . $this->bc->get("root", "snmp-ro-user") . "\n";
		$m_cont .= "snmp-security-level=" . $this->bc->get("root", "snmp-security-level") . "\n";
		$m_cont .= "snmp-auth-method=" . $this->bc->get("root", "snmp-auth-method") . "\n";
		$m_cont .= "snmp-encrypt-method=" . $this->bc->get("root", "snmp-encrypt-method") . "\n";
		$m_cont .= "snmp-ro-auth-password=" . $this->bc->get("root", "snmp-ro-auth-password") . "\n";
		$m_cont .= "snmp-ro-encrypt-password=" . $this->bc->get("root", "snmp-ro-encrypt-password") . "\n";
		
		$m_cont .= "snmptraps_enabled=" . $this->bc->get("root", "snmptraps_enabled") . "\n";
		$m_cont .= "snmptraps_server=" . $this->bc->get("root", "snmptraps_server") . "\n";
		$m_cont .= "snmptraps_interval=" . $this->bc->get("root", "snmptraps_interval") . "\n";
		
		$m_cont .= "snmptraps_community=" . $this->bc->get("root", "snmptraps_community") . "\n";
		
		$m_cont .= "snmptraps_security_level=" . $this->bc->get("root", "snmptraps_security_level") . "\n";
		$m_cont .= "snmptraps_auth_method=" . $this->bc->get("root", "snmptraps_auth_method") . "\n";
		$m_cont .= "snmptraps_encrypt_method=" . $this->bc->get("root", "snmptraps_encrypt_method") . "\n";
		$m_cont .= "snmptraps_auth_password=" . $this->bc->get("root", "snmptraps_auth_password") . "\n";
		$m_cont .= "snmptraps_encrypt_password=" . $this->bc->get("root", "snmptraps_encrypt_password") . "\n";
		$m_cont .= "snmptraps_user=" . $this->bc->get("root", "snmptraps_user") . "\n";
		
		
		$m_cont .= "snmptraps_traplist=" . $this->bc->get("root", "snmptraps_traplist") . "\n";
		$m_cont .= "snmptraps_isdn_crc=" . $this->bc->get("root", "snmptraps_isdn_crc") . "\n";
		$m_cont .= "snmptraps_memory_threshold=" . $this->bc->get("root", "snmptraps_memory_threshold") . "\n";
		$m_cont .= "snmptraps_cpu_load=" . $this->bc->get("root", "snmptraps_cpu_load") . "\n";
		
		
		
		$m_cont .= "gui_mode=" . $this->ba->get("gui_mode") . "\n";
		$m_cont .= "lang=" . $this->ba->get("lang") . "\n";

		$m_cont .= "redirect_cfg=" . $this->bc->get("root", "redirect_cfg") . "\n";
		$m_cont .= "userapp-enabled=" . $this->bc->get("root", "userapp-enabled") . "\n";
		$m_cont .= "userapp-user-enabled=" . $this->bc->get("root", "userapp-enabled") . "\n";
		$m_cont .= "system-check-enabled=" . $this->bc->get("root", "system-check-enabled") . "\n";
		$m_cont .= "safeguard=" . $this->bc->get("root", "safeguard") . "\n";

		$m_cont .= "summer_winter_time=" . $this->ba->get("summer_winter_time") . "\n";
		$m_cont .= "set_hw=" . $this->ba->get("set_hw") . "\n";
		$m_cont .= "bnfos-ipaddr=" . $this->ba->get("ip_berofos") . "\n";
		$m_cont .= "bnfos-mac=" . $this->ba->get("mac_berofos") . "\n";
		$m_cont .= "bnfos-intv=" . $this->ba->get("interval_berofos") . "\n";
		$m_cont .= "bnfos-hb-on-boot=" . $this->bc->get("root", "use_boot_bnfoswdog") . "\n";
		$query = $this->ba->select('SELECT * FROM users where user!="beroAdmin"');
		while ($entry = $this->ba->fetch_array($query)) {
			$admin_user = $entry['user'];
			$admin_pass = $entry['password'];
		}
		$query = $this->ba->select('SELECT show_app FROM set_app');
		while ($entry = $this->ba->fetch_array($query))
			$sessions_disable = $entry['show_app'];
		$m_cont .= "admin-pass=" . $admin_pass . "\n";
		$m_cont .= "admin-user=" . $admin_user . "\n";
		$m_cont .= "sessions-disable=" . $sessions_disable . "\n";

		$m_cont .= "national_code=" . $this->ba->get("national_code") . "\n";
		$m_cont .= "international_code=" . $this->ba->get("international_code") . "\n";

		$m_cont .= "excludelan=" . $this->bc->get("root", "excludelan") . "\n";

		$this->saveFile($this->conf_folder . "misc.conf", $m_cont);
	}

	public function hostname() {
		//hostname
		$file_hostname = $this->conf_folder . "hostname";
		$hostname = $this->bc->get("root", "hostname");
		if ($hostname == "") {
			@unlink($file_hostname);
		} else {
			$this->saveFile($file_hostname, $hostname);
		}
	}

	public function isgwCauses() {
		$c_cont = ";FROM\tTO\tINCAUSE\tOUTCAUSE\tOUTTEXT\n";
		$query_d = $this->ba->select("select * from isgw_causes");
		while ($entry = $this->ba->fetch_array($query_d)) {
			$dir = explode("-", $entry['direction']);
			$c_cont .= $dir[0] . "\t" . $dir[1] . "\t";
			$c_cont .= $entry['to_cause'] . "\t" . $entry['from_cause'] . "\t";
			$c_cont .= $entry['sip_response_message'] . "\n";
		}
		$this->saveFile($this->conf_folder . "isgw.causes", $c_cont);
	}

	public function networkAcl() {
		$bindport = $this->ba->get('bindport');

		$query = $this->ba->select("select * from acl");
		$array = array("sip_bindport_lan","sip_bindport_wan","sip_bindport_vpn");
		
		$content = '';
		while ($entry = $this->ba->fetch_array($query)) {
			$dest_port = $entry['dest_port'];
			$action = "ACCEPT";
			if ($entry['action'] == "DROP") {
				$action = "DROP";
			}
			$content .= "INPUT;" . $entry['protocol'] . ";" . $dest_port . ";" . $entry['address'] . "/" . $entry['netmask'] . ";" . $action . ";" . $entry['stack']. "\n";
		}
		$this->saveFile($this->conf_folder . "network.acl", $content);

		## check the ACL rules: if a port is open from anywhere, we update beroconf
		## to display a warning message
		$ports_opened = array();
		foreach (explode("\n", file_get_contents("{$this->conf_folder}/network.acl")) as $acl) {
			if (preg_match('/INPUT;(tcp|udp|)?;(.*);.*\/0;ACCEPT;/', $acl, $matched)) {
				$ports_opened[] = $matched[2];
				unset($matched);
			}
		}
		if (($key = array_search('65001', $ports_opened)) !== false) {
			unset($ports_opened[$key]);
		}
		if (empty($ports_opened)) {
			foreach(array('fw-opened', 'fw-opened-ports') as $key) {
				$this->bc->delete('root', $key);
			}
		}
		else {
			$this->bc->set('root', 'fw-opened', 'WARNING_MESSAGE_FW_RULES_OPENED');
			$this->bc->set('root', 'fw-opened-ports', implode(':', $ports_opened));
		}
	}

	public function isgwDialplan() {
		$pstn_dir = array('isdn', 'analog', 'cas', 'lte', 'gsm');
		$d_cont = ";From\tTo\tFromID\tToID\tDestination\tNewDestination\tSource\tNewSource\tConfig\n";
		$query_d = $this->ba->select("select * from dialplan order by posId, id asc");
		while ($entry = $this->ba->fetch_array($query_d)) {
			if ( in_array( $entry['fromDirection'] , $pstn_dir ) && in_array( $entry['toDirection'] , $pstn_dir ) ) {	
				($entry['activ'] == "1") ? $d_cont .= $entry['fromDirection'] . "\t" : $d_cont .= ";#" . $entry['fromDirection'] . "\t";
				//$d_cont.="isdn\t";
				$d_cont .= "sip\t";
				$d_cont .= $entry['fromId'] . "\t";
				$d_cont .= "127.0.0.1\t";
				$d_cont .= $entry['dest'] . "\t";
				if (strpos($entry['newDest'], "ISDNZUISDN") === false) {
					$d_cont .= $entry['isdnid'] . $entry['newDest'] . "\t";
				} else {
					$d_cont .= $entry['newDest'] . "\t";
				}
				$d_cont .= $entry['src'] . "\t";
				$d_cont .= $entry['newSrc'] . "\t";
				$d_cont .= $entry['config'] . "\n";

				$d_cont .= ($entry['activ'] == "1") ? "sip\t" : ";#sip\t";
				$d_cont .= $entry['toDirection'] . "\t";
				$d_cont .= "127.0.0.1\t";
				$d_cont .= $entry['toId'] . "\t";
				$d_cont .= $entry['isdnid'] . "(.*)" . "\t";
				$d_cont .= stripslashes("\\\\1") . "\t"; // WHY ??? stripslashes and \\\\ inside ?
				$d_cont .= stripslashes("(.*)") . "\t";
				$d_cont .= stripslashes("\\\\1") . "\t";
				$d_cont .= $entry['config'] . "\n";
				
			} else {

				($entry['activ'] == "1") ? $d_cont .= $entry['fromDirection'] . "\t" : $d_cont .= ";#" . $entry['fromDirection'] . "\t";
				$d_cont .= $entry['toDirection'] . "\t";
				$d_cont .= $entry['fromId'] . "\t";
				$d_cont .= $entry['toId'] . "\t";
				$d_cont .= $entry['dest'] . "\t";
				$d_cont .= $entry['newDest'] . "\t";
				$d_cont .= $entry['src'] . "\t";
				$d_cont .= $entry['newSrc'] . "\t";
				$d_cont .= $entry['config'] . "\n";
			}
		}
		$this->saveFile($this->conf_folder ."isgw.dialplan", $d_cont);
	}

	public function isgwWhitelist() {
		$query_d = $this->ba->select("select * from whitelist");
		
		$d_cont = '';
		while ($entry = $this->ba->fetch_array($query_d)) {
			$d_cont .= $entry['address'] . "/" . $entry['netmask'] . "/" . $entry['sipstack'] . "\n";
		}
		$this->saveFile($this->conf_folder ."/isgw.whitelist", $d_cont);
	}

	public function isModulesLoaded($modules) {
		exec("/sbin/lsmod | /bin/grep $modules", $output);
		return isset($output[0]);
	}

	public function loadModules($list_type) {
		foreach ($list_type as $type) {
			if (preg_match('/^bf[0-9]{1,2}([A-Z0-9a-z]+)$/', $type, $type_matched)) {
				$is_loaded = true;
				switch ($type_matched[1]) {
					case 'E1':
						$is_loaded = $this->isModulesLoaded('hfcmulti') && $this->isModulesLoaded('mISDN_core');
						break;
					case 'S0':
						$is_loaded = $this->isModulesLoaded('xhfc') && $this->isModulesLoaded('mISDN_core');
						break;
					case 'S02FXS':
						$is_loaded = $this->isModulesLoaded('xhfc') && $this->isModulesLoaded('mISDN_core') && $this->isModulesLoaded('bfxanalog.ko');
						break;
					case 'FXS':
					case 'FXO':
						$is_loaded = $this->isModulesLoaded('bfxanalog.ko');
						break;
					case 'GSM':
					case 'LTE':
						$is_loaded = $this->isModulesLoaded('bfxgsm.ko');
						break;
					case 't1e1':
						$is_loaded = $this->isModulesLoaded('bfxt1e1.ko');
						break;
					default:
						break;
				}
				// load modules
				if (!$is_loaded) {
					exec('/usr/local/init/S02driver-setup start');
					return;
				}
			}
		}
	}

	private function _redirectToReboot() {
		return	"<html>\n"
					. "\t<body>\n"
					.	"\t\t<form class='beroari_form' action='../reboot.php' method='POST' name='reboot'>\n"
					. "\t\t\t<input type='hidden' name='action' value='reboot'>\n"
					. "\t\t\t<input type='hidden' name='v' value='Yes'>\n"
					. "\t\t</form>\n"
					. "\t\t<script>document.reboot.submit();</script>\n"
					. "\t</body>\n"
					. "</html>\n";
	}

	public function activate($redirection = true, $list_type = array(), $skipReboot = false, $rebootUpdateMode = false) {
		// sip
		$this->isgwSip();

		// general conf
		$this->hostname();
		$this->miscConf();
		$this->networkAcl();
		$this->isgwConf();
		$this->isgwCauses();
		$this->isgwDialplan();
		$this->isgwWhitelist();

		// activate sbc-vm
		if ($this->_is_sbc_vm) {
			require_once('/usr/local/www/berogui/includes/isgwtelnet.php');
			$isgw = new isgwtelnet();
			if ($isgw->isgw_login() && $isgw->reload()) {
				$this->ba->set('activate', '0');
				Helper::system(1, 'systemctl reload beroNet-isgw');
				if ($this->bc->get('root', 'is-factory-reset') == 1) {
					$bc->bc->delete('root', 'is-factory-reset');
					echo $this->_redirectToReboot();
				}
			}
		}
		// activate sbc
		else {
			// hardware / module conf
			$this->isgwIsdn();
			$this->isgwCpt();
			$this->isgwAnalog();
			$this->isgwCas();
			$this->isgwGsm();
			$this->isgwLte();
			$this->hardwareConf($list_type);

			## reboot without reloading modules and init scripts
			if ($rebootUpdateMode) {
				$this->ba->set('activate', 0);
				return;
			}

			// activate
			$option = $this->ba->get("activate");
			if ($option == 3) {
				$this->ba->set('activate', '0');
				if ($skipReboot) {
					// reboot managed by another features.
					// do nothing
				}
				else if ($redirection) {
					echo $this->_redirectToReboot();
					//API Aufruf
				}
				else {
					require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
					Helper::reboot("",true);
				}
			}
			else if ($option == 2) {
				$this->loadModules($list_type);
				Helper::exec(0, '/usr/local/init/S90systemlog stop');
				Helper::exec(0, '/usr/local/init/S81snmptraps stop');
				Helper::exec(0, '/usr/local/init/S80snmpd stop');
				Helper::exec(0, '/usr/local/init/S50isgw stop', $ausgabe);
				Helper::exec(0, '/usr/local/init/S03acl stop');
				
				Helper::exec(0, '/usr/local/init/S03acl start');
				Helper::exec(0, '/usr/local/init/S50isgw start', $ausgabe);
				Helper::exec(0, '/usr/local/init/S80snmpd start');
				Helper::exec(0, '/usr/local/init/S81snmptraps start');
				Helper::exec(0, '/usr/local/init/S90systemlog start');
				
				Helper::exec(0, '/etc/init.d/S45provisioning cron_setup');
				Helper::exec(0, '/etc/init.d/S65cloud restart'); 
			}
			else if ($option == 1) {
				require_once "/usr/local/www/berogui/includes/isgwtelnet.php";
				$isgw = new isgwtelnet();
				$result = $isgw->isgw_login();
				$isgw->reload();
	
				if ($this->ba->get('acl_reload') == 1) {
					Helper::exec(0, '/usr/local/init/S03acl restart');
					$this->ba->set('acl_reload', 0);
				}
				Helper::exec(0, '/etc/init.d/S45provisioning cron_setup');
				Helper::exec(0, '/etc/init.d/S65cloud restart'); 
				Helper::exec(0, '/etc/init.d/S91userapp apply');
			}
		}

		if (!$this->ba->is_error()) {
			$this->ba->set('activate', '0');
		}
		if ($this->ba->is_error() && $redirection == true) {
			echo "<script>alert('" . $this->ba->error() . "');</script>";
		}
		if ($redirection == true) {
			$m = isset($_GET['m']) ? Helper::sanitizeGet($_GET['m'], 'm') : 'State';
			$opt = isset($_GET['opt']) ? '&opt='.Helper::sanitizeGet($_GET['opt'], 'opt') : '';

			echo "<script>window.location='../index.php?m=". $m . $opt ."'</script>";
		}
	}
}
