<?php

if (!defined('_ISGWTELNET_CLASS')) {
	define('_ISGWTELNET_CLASS', true);
	/**
	 * Implementiert die Verbindung mit der ISGW Telnet-Schnittstelle
	 * @author Miguel Palmer <mp@beronet.com>
	 * @author Florian Kraatz <fk@beronet.com>
	 */
	class isgwtelnet {
		var $mysocket;
		var $myerror;
		var $haserror;

		/* [NEW WAY] */
		// replace isgw_login by __constructor
		// mix all commands to an unique command

		public function command($cmd, $options = array()) {
			// default	
			$default = array(
				'timeout' => 5,
			);
			// set
			$options = array_merge($default, $options);
			// send and return
			return $this->Query($cmd, $options['timeout']);	
		}

		public function hasError() {
			return $this->haserror;
		}

		/*
		 * Reload gradually the different ISGW features. An empty input leads to reload everything
		 */ 
		public function reload($reload = array()) {
			$list_reload = array(
				'dialplan' 	=> 'isgw_dialplanreload',
				'sip'		=> 'isgw_sipreload',
				'dos'		=> 'isgw_dossettingsreload',
			);
			if (empty($reload)) {
				$reload = array_keys($list_reload);
			}
			foreach ($reload as $key) {
				$function = $list_reload[$key];
				$this->$function();
			}
			$this->isgw_rcpt();
			$this->isgw_rgc();
		}

		public function retrieveData($list_to_retrieve) {
			// TODO: must be update -> remove isgw_ from the method names
			$retrieved = '';
			foreach ($list_to_retrieve as $to_retrieve) {
				$method = "isgw_$to_retrieve";
				$retrieved .= $this->$method(1);
			}
			return $retrieved;
		}

		/* [OLD WAY] */
		function isgwtelnet() {

			$this->mysocket = FALSE;
			$this->myerror = "";
		}

		function isgw_login($host="localhost",$port="54322"){
			try{
				$this->mysocket = @fsockopen($host,$port,$errno, $errstr, 1);
			}catch(Exception $e){
				$this->haserror = true;
				return FALSE;
			}

			if (!$this->mysocket) {
				$this->error =  "Could not connect - $errstr ($errno)";
				$this->haserror = true;
				return false;
			}else{
				stream_set_timeout($this->mysocket, 1);
				$query="";
				$wrets = $this->Query($query);
				return "wrets" . $wrets;
			}
		}

		function isgw_transparent($command){
			$query=$command;
			$wrets=$this->Query($query);
			return $wrets;
		}

		function isgw_isdnstate($fulltrace = 0){
			$query="i";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_gsmstate($fulltrace = 0){
			$query="g";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_gsmoperators($fulltrace = 0){
			$query="golist";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}
		
		function isgw_fetch_gsmoperators($port, $fulltrace = 0){
			$query="goret" . $port;
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_show_gsmoperators($port, $fulltrace = 0) {
			$query="goshow" . $port;
			$wrets .= $this->Query($query);
			return $wrets;
		}
		
		function isgw_version ($fulltrace = 0) {
			$query = "version";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query ($query);
			return $wrets;
		}
		
		function isgw_dmalloc_write ($fulltrace = 0) {
			$query = "dmw";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query ($query);
			return $wrets;
		}
		
		function isgw_dnscache($fulltrace = 0) {
			$query = "dnsl";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query ($query);
			return $wrets;
		}
		
		function isgw_sipgroups($fulltrace = 0) {
			$query = "lpgs";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query ($query);
			return $wrets;
		}
		
		function isgw_analog_offhook($enable, $port){
			if ($enable) {
				$query="analog_offhook" . $port . ":1";
			}
			else {
				$query="analog_offhook" . $port . ":0";
			}
			$wrets=$this->Query($query);
			return $wrets;
		}
		
		function isgw_adv_gsmstate($fulltrace = 0){
			$query="gi";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_berocapistate($fulltrace = 0){
			$query="R";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_actualcalls($fulltrace = 0){
			$query="ss";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_siplicensestate($fulltrace = 0){
			$query="p_license_state_s2s";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}
                
		function isgw_siplicensecount($fulltrace = 0){
			$query="p_license_count_s2s";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}
		
		function isgw_siplicenserefresh(){
			$query="p_license_refresh";
			$wrets=$this->Query($query);
			return $wrets;
		}
                
		function isgw_bchannels($fulltrace = 0){
			$query="bc";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_callcompact($fulltrace = 0){
			$query="k";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_rtpstate($fulltrace = 0){
			$query="lrtp";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets.= $this->Query($query);
			return $wrets;
		}

		function isgw_listallcallshidden($fulltrace = 0){
			$query="LH";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_analogstate($fulltrace = 0){
			$query="a";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_casstate($fulltrace = 0){
			$query="p_casstatus";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_uptime($fulltrace = 0){
			$query="u";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_sipstate($fulltrace = 0){
			$query="r";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_sipstateInbound($fulltrace = 0, $query = 'R') {
			return(($fulltrace ? "########################: $query\n" : '') . $this->Query($query)); 
		}

		function isgw_blacklist($fulltrace = 0) {
			
			$query = "acllb";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query ($query);
			
			return $wrets;
		}
		
		function isgw_blacklist_delete_entry_by_id ($id, $stack) {

			if (strcasecmp ($stack, "wan") == 0) {
				$query = "aclcbw" . $id;
			}
			else {
				$query = "aclcbl" . $id;
			}
			
			$wrets = $this->Query ($query);
			return $wrets;
		}
		
		function isgw_blacklist_delete_all_entries () {
		
			$query = "aclcb";
			$wrets = $this->Query ($query);
			return $wrets;
		}
		
		function isgw_channelstate($fulltrace = 0)
		{
			$query="kt";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_pcmstate($fulltrace = 0)
		{
			$query="pcm";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_portstatistic($fulltrace = 0)
		{
			$query="ssp";
			$fulltrace ? $wrets = "########################: " . $query . "\n" : $wrets = "";
			$wrets .= $this->Query($query);
			return $wrets;
		}

		function isgw_resetstatistic()
		{
			$query="sr";
			$wrets=$this->Query($query);
			return $wrets;
		}

		function isgw_dialplanreload()
		{
			$query="rd";
			$wrets=$this->Query($query);
			return $wrets;
		}

		function isgw_rcpt()
		{
			$query="rcpt";
			$wrets=$this->Query($query);
			return $wrets;
		}

		function isgw_rgc()
		{
			$query="rgc";
			$wrets=$this->Query($query);
			return $wrets;
		}
                
		function itpX($port)
		{
			$query="itp".$port;
			$wrets=$this->Query($query);
			return $wrets;
		}

		function l2upX($port)
		{
			$query="l2up".$port;
			$wrets=$this->Query($query);
			return $wrets;
		}

		function lla()
		{
			$query="lla";
			$wrets=$this->Query($query);
			return $wrets;
		}

		function lld() {
			$query="lld";
			$wrets=$this->Query($query);
			return $wrets;
		}


		function isgw_sipreload() {
			$query="rs";
			$wrets=$this->Query($query);
			return $wrets;
		}

		function isgw_dossettingsreload() {
			$query="aclrs";
			$wrets=$this->Query($query);
			return $wrets;
		}
		
		function isgw_causesmapreload() {
			
			$query="rcm";
			$wrets=$this->Query($query);
			return $wrets;
		}
		
		function rotate_cdr() {
			$query="cdrrotate";
			$wrets=$this->Query($query);
			return $wrets;
		}

		function bert($id) {
			$query="bert".$id;
			$wrets=$this->Query($query);
			return $wrets;
		}

		function bert_list($id) {
			$query="sbert".$id;
			$this->Query($query);
			$query="lbert".$id;
			$wrets=$this->Query($query);
			return $wrets;
		}

		function ssms() {
			$query="ssms";
			$wrets=$this->Query($query);
			return $wrets;
		}

		function port_restart($port) {
			$query="pr".$port;
			$wrets=$this->Query($query);
			return $wrets;
		}
		
		function caslog($opt="") {
			$query="caslog".$opt;
			$wrets=$this->Query($query);
			return $wrets;
		}

		function port_restart_gsm($port,$lif) {
			$query="poogli".$lif;
			$wrets=$this->Query($query, 30);
			if (strpos($wrets,'finished')!==false) {
				foreach ($port as $value) {
					$query="rgp".$value;
					$wrets=$this->Query($query, 180);
				}
			}
			return $wrets;
		}

		function loglevel($level=0) {
			$query = "v" . $level;
			return $this->Query($query);
		}

		function loglevel_message($level=0) {
			$query = "m" . $level;
			return $this->Query($query);
		}

		function acl($acl="") {
			$query="acl:".$acl;
			if ($this->mysocket === FALSE)
				return FALSE;

			fputs($this->mysocket, $query);
		}

		function logactive($state) {
			if ($state==1){
				return $this->Query("ld1");
			}
			elseif($state==0){
				return $this->Query("ld0");
			}
			return "";
		}
		
		function netlog($state){
		
			if ($state==1){
				return $this->Query("t1");
			}
			elseif($state==0){
				return $this->Query("t0");
			}
			return "";
		}

		function logactive_message($state) {
		
			if ($state==1){
				return $this->Query("lm1");
			}
			elseif($state==0){
				return $this->Query("lm0");
			}
			return "";
		}

		function logactive_nmessage($state) {
		
			if ($state==1){
				return $this->Query("ln1");
			}
			elseif($state==0){
				return $this->Query("ln0");
			}
			return "";
		}
		
		function logserver($ip="127.0.0.1",$port=514) {
			$query = "n:" . $ip . ":" . $port;
			return $this->Query($query);
		}

		function isgw_dialplanconfig() {
			$query="dca";
			$wrets=$this->Query($query);
			return $wrets;
		}

		function isgw_verbose($flag) {
			$query="verbose".$flag;
			$this->Query($query);
		}
		
		function isgw_tdm($flag) {
			$query="ltdm";
			$wrets=$this->Query($query);
			return $wrets;
		}
		
		
		function Query($query, $timeout = 5) {
			$wrets = "";
			
			if ($this->mysocket === FALSE) {
				return FALSE;
			}

			fputs($this->mysocket, $query);

			// set timeout
			stream_set_timeout($this->mysocket, $timeout);

			do {
				$info = stream_get_meta_data($this->mysocket);
				$line = fgets($this->mysocket, 4096);
				$wrets .= $line;
				$info = stream_get_meta_data($this->mysocket);

			} while ($line != "\r\n" && !$info['timed_out'] && !$info['eof']);

			return $wrets;
		}
	}
} // END ifdef _ISGWTELNET_CLASS
