<?php

# check if session is valid
require_once('/usr/local/www/berogui/includes/session.php');

chdir('..');
require_once('/usr/local/www/berogui/includes/variables.php');
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

$execute = 1;
$invalid = array();
$m = Helper::sanitizeGet($_GET['m'], 'm', $execute, $invalid);
if (!$execute) {
	echo "<script>window.location='../../index.php?m=State&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

require_once('/usr/fallback/beroConf.php');
$bc = new beroConf('root');
$is_sbc_vm = $bc->get('root', 'is-sbc-vm');

// Löscht Dateien aus dem Dateisystem
switch ($_GET['option']) {
	case "debug":
		$bc->delete('root', 'trace-state');
		Helper::unlink($is_sbc_vm, "/var/log/DebugFiles.tar.gz");
		echo "<script>window.location='../index.php?m=".$m."';</script>";
		break;
	case "cdr":
		Helper::unlink($is_sbc_vm, "/var/log/isgw.cdr.gz");
		echo "<script>window.location='../index.php?m=".$m."';</script>";
		break;
	case "certificate":
		if ($_GET['file']=='cafile'){
			Helper::unlink($is_sbc_vm, "/usr/conf/cafile.pem");
			echo "<script>window.location='../index.php?m=".$m."';</script>";
		}
		else if ($_GET['file']=='agent'){
			Helper::activate(2);
			Helper::unlink($is_sbc_vm, "/usr/conf/agent.pem");
			echo "<script>window.location='../index.php?m=".$m."';</script>";
		}
		else if ($_GET['file']=='cafile_lan'){
			Helper::activate(2);
			Helper::unlink($is_sbc_vm, "/usr/conf/cafile_lan.pem");
			Helper::unlink($is_sbc_vm, "/usr/conf/certs/lan/cafile.pem");
			echo "<script>window.location='../index.php?m=".$m."';</script>";
		}
		else if ($_GET['file']=='agent_lan'){
			Helper::activate(2);
			Helper::unlink($is_sbc_vm, "/usr/conf/agent_lan.pem");
			Helper::unlink($is_sbc_vm, "/usr/conf/certs/lan/agent.pem");
			echo "<script>window.location='../index.php?m=".$m."';</script>";
		}
		else if ($_GET['file']=='cafile_wan'){
			Helper::activate(2);
			Helper::unlink($is_sbc_vm, "/usr/conf/cafile_wan.pem");
			Helper::unlink($is_sbc_vm, "/usr/conf/certs/wan/cafile.pem");
			echo "<script>window.location='../index.php?m=".$m."';</script>";
		}
		else if ($_GET['file']=='agent_wan'){
			Helper::activate(2);
			Helper::unlink($is_sbc_vm, "/usr/conf/agent_wan.pem");
			Helper::unlink($is_sbc_vm, "/usr/conf/certs/wan/agent_wan.pem");
			echo "<script>window.location='../index.php?m=".$m."';</script>";
		}
		else if ($_GET['file']=='snmpd_agent_cert'){
			Helper::unlink($is_sbc_vm, "/usr/conf/tls/certs/snmpd_agent.crt");
			echo "<script>window.location='../index.php?m=".$m."';</script>";
		}
		else if ($_GET['file']=='snmpd_agent_key'){
			Helper::unlink($is_sbc_vm, "/usr/conf/tls/private/snmpd_agent.key");
			echo "<script>window.location='../index.php?m=".$m."';</script>";
		}
		else if ($_GET['file']=='snmpd_manager_cert'){
			Helper::unlink($is_sbc_vm, "/usr/conf/tls/certs/snmpd_manager.crt");
			echo "<script>window.location='../index.php?m=".$m."';</script>";
		}
		break;
		
	case "certificate_https":
		Helper::activate(3);
		Helper::unlink($is_sbc_vm, "/usr/conf/berofix.pem");
		Helper::exec($is_sbc_vm, "ln -s /etc/lighttpd.pem /usr/conf/berofix.pem");
		echo "<script>window.location='../index.php?m=".$m."';</script>";
		break;
	case "sip_license":
		Helper::unlink($is_sbc_vm, "/usr/conf/isgw_".SERIAL.".license");
		echo "<script>window.location='../index.php?m=SipLicense&reload=true';</script>";
		break;
	case "sms":
		$filename = basename($_GET['filename']);
		if (Helper::checkInputData('file-exists', $filename, array('/tmp/sms/in'))) {
			Helper::unlink($is_sbc_vm, "/tmp/sms/in/".$filename);
		}
		echo "<script>window.location='../index.php?m=".$m."';</script>";
		break;
	case "smsFail":
		$filename = basename($_GET['filename']);
		if (Helper::checkInputData('file-exists', $filename, array("/tmp/sms/failout"))) { 
			Helper::exec($is_sbc_vm, "/bin/rm -r /tmp/sms/failout/". $filename);
		}
		echo "<script>window.location='../index.php?m=".$m."';</script>";
		break;
	case "profile":
		$filename = basename($_GET['file']);
		$dir = dirname("/usr/conf/profile/" .$_GET['category']. "/$filename");
		if (Helper::checkInputData('dir-exists', $dir) && Helper::checkInputData('file-exists', $filename, array($dir))) {
			Helper::unlink($is_sbc_vm, $dir."/".$filename);
			if (count(scandir($dir)) == 2){
				Helper::rmdir($is_sbc_vm, $dir);
			}
		}
		echo "<script>window.location='../index.php?m=".$m."';</script>";
		break;
	case 'info':
		Helper::unlink($is_sbc_vm, "/var/log/debug-info.tar.gz");
		Helper::unlink($is_sbc_vm, "/var/log/core");
		Helper::unlink($is_sbc_vm, "/var/log/corelink");
		echo "<script>window.location='../index.php?m=".$m."';</script>";
		break;
	default:
		echo "<script>window.location='../index.php?m=State&error=1&request=POST&checkor=unknown&key=action'</script>";
		break;	
}

?>
