<?php

/**
 * Implementiert die beroCloud Einstellungen
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class BeroCloud {

	private		$m_attr;

	private		$post_attr,
			$post_checked = 0;

	private 	$isRequestRejected = 0,
			$reasonRejected = array();

	private $_hasGateway 		= false,
					$_hasNameserver = false;

	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->m_attr = $m;

		// TODO: maybe set a checkor for an user input instead the 'config-option' checkor
		if (isset($post['submit']) || isset($post['disconnect_submit'])) {
			unset($post['m'], $post['fixChrome'], $post['dummy']);

			$list_post = array(	// GENERAL
				'submit' => 'select',
				// CLOUD
				'cloud_username' => 'config-option', 'cloud_password' => 'password', 'deregister' => 'bool', 'cloud_enable' => 'bool', 'cloudAddress' => 'hostname',
				'cloud_show_status' => 'bool','redirect_cfg' => 'bool',
				// KEY
				'supportKey' => 'str-length', 'supportPermanent' => 'bool', 'disconnect_submit' => 'select',
				// PROXY
				'proxyEnabled' => 'bool', 'proxyAddress' => 'hostname', 'proxyPort' => 'int-range', 'proxyType' => 'select', 'proxyUser' => 'config-option', 'proxySecret' => 'password',
			);
		
			$list_post_options = array(	
				'submit'    => array('Register', 'Registrieren', 'Save', 'Speichern', 'Connect', 'Verbinden','Deregister','Deregistrieren')	, // impossible to generalize with BUTTON_***** without reworking the class
				'disconnect_submit' => array('Disconnect', 'Trennen')		, // impossible to generalize with CLOUD_SUPPORT_DISCONNECT_BUTTON_DIS without reworking the class (and all classes)
				'proxyPort' => array('min' => 1, 'max' => 65535)		,
				'proxyType' => array('CURLPROXY_HTTP', 'CURLPROXY_SOCKS5')	,
				'supportKey'=> array('min' => 8, 'max' => 8)
		  );

			$this->post_checked = 1;
			$this->post_attr = Helper::sanitizePost($post, $list_post, $this->post_checked, $this->reasonRejected, $list_post_options);

			$this->isRequestRejected = !$this->post_checked;
		}
	}

	/*
	 * @return string HTML code
	 */
	function _display_tabs($bc, $simple_class) {
		$tabs = '';
		$display_tabs = '';
		if (strlen($simple_class) == 0) {
			$tabs =	"\t\t".'<li><a href="#tabs-3">'. CLOUD_PROXY_SETTINGS .'</a></li>' . "\n";
			$display_tabs =	$this -> _display_tab3($bc) . "\n";
		}

		$html_str = '<br/>' . "\n" . '<br/>' . "\n" .
								'<script>' . "\n" .
								"\t" . '$(function() {' . "\n" .
								"\t\t" . '$( "#tabs" ).tabs({active:0})' . "\n" .
								"\t" . '});' . "\n" . 
								'</script>' . "\n" .
								"\n\n" . '<!-- BEGIN TABS //-->' . "\n\n" .
								'<div id="tabs" class="">' . "\n" .
								"\t".'<ul>' . "\n" .
								"\t\t".'<li><a href="#tabs-1">'. CLOUD_TABLE_HEADER_DIS .'</a></li>' . "\n".
								"\t\t".'<li><a href="#tabs-2">'. CLOUD_KEY_HEADER_DIS .'</a></li>' . "\n".
								$tabs .
								"\t".'</ul>' . "\n\n" .

								$this -> _display_tab1($bc) . "\n" .
								$this -> _display_tab2($bc) . "\n" .
								$display_tabs . 

								"\n\n" . '<!-- END TABS //-->' . "\n" .
								'</div>' . "\n\n";

		return $html_str;
	}

	/*
	 * @return string HTML code
	 */
	function _display_tab1($bc)
	{
		$html_str = "\n\n" . '<!-- BEGIN TAB1 //-->' . "\n\n" .
								'<div id="tabs-1" style="margin-top: 20px;">' . "\n";

		$html_str .= 	$this->cloudRegisterTable($bc) . "\n";
		$html_str .= 	"<br><br>" . "\n";
		$html_str .= 	$this->cloudTable($bc) . "\n";

		$html_str .=	'</div>' . "\n";

		return $html_str;
	}

	/*
	 * @return string HTML code
	 */
	function _display_tab2($bc) 
	{
		$html_str = "\n\n" . '<!-- BEGIN TAB2 //-->' . "\n\n" .
								'<div id="tabs-2" style="margin-top: 20px;">' . "\n";

		$html_str .= $this->cloudSupportKey($bc) . "\n";

		$html_str .= '</div>' . "\n";

		return $html_str;
	}

	/*
	 * @return string HTML code
	 */
	function _display_tab3 ($bc)
	{
		$html_str = "\n\n" . '<!-- BEGIN TAB3 //-->' . "\n\n" .
								'<div id="tabs-3" style="margin-top: 20px;">' . "\n";

		$html_str .= $this->cloudProxyTable($bc) . "\n";

		$html_str .= '</div>' . "\n";

		return $html_str;
	}

	/**
	 * Generiert die HTML Seite
	 * @return string HTML code
	 */
	function display() {
		$m = $this->m_attr;
		$name = "BEROCLOUD_TITLE_DIS";
		include('./includes/header.php');

		$ba = new beroAri();
		require_once("./includes/lang.php");

		require_once('/usr/fallback/beroConf.php');
		$bc = new beroConf('root');

		// check gateway and nameserver settings
		$is_sbc_vm = $bc->get('root', 'is-sbc-vm') == 1 ? 1 : 0;
		foreach (array('lan', 'wan') as $iface) {
			$gw = Helper::getNetworkGateway(Helper::getNetworkIfaceByName($iface, $bc), $is_sbc_vm);
			if (strlen($gw) > 0 && $gw != 0) {
				$this->_hasGateway = true;
				break;
			}
		}
		$nameservers = Helper::getNetworkNameserver();
		if (!empty($nameservers)) {
			foreach ($nameservers as $nameserver) {
				if (strlen($nameserver) > 0) {
					$this->_hasNameserver = true;
					break;
				}
			}
		}

		//Save the changes
		$simple_class = '';
		if ($ba->get('gui_mode') == 'simple') {
			$simple_class = 'simple';
		}
		if ($this->post_checked) {
			$ret .= $this->save($bc, $ba);
		} else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		$ret .= $this -> _display_tabs($bc, $simple_class);
		$ret .= $this -> javascript();

		return $ret;
	}

	/**
	 * @return string Checkbox cloud show status
	 */
	function cloud_show_status($bc) {
		$cloud_show = $bc->get('root', "cloud_show_status");
		$checked = ($cloud_show == "1") ? "checked" : "";
		ob_start();
		?>
		<input type='hidden' name='cloud_show_status' value='0'>
		<input type='checkbox' name='cloud_show_status' id='cloud_show_status' value='1' <?php echo $checked ?>>
		<?php
		return ob_get_clean();
	}

	/**
	 * @return string Checkbox cloud enable
	 */
	function cloud_enable($bc) {
		$cloud_enable = $bc->get("root", "cloud_enable");
		$checked = ($cloud_enable == "1") ? "checked" : "";
		ob_start();
		?>
		<input type='hidden' name='cloud_enable' value='0'>
		<input type='checkbox' name='cloud_enable' id='cloud_enable' value='1' <?php echo $checked ?>>
		<?php
		return ob_get_clean();
	}

	/**
	 * @return string checkbox for redirect_cfg
	 */
	function redirect_cfg($bc) {
		$redirect_cfg = $bc->get("root", "redirect_cfg");
		$checked = ($redirect_cfg == "off") ? "checked" : "";
		ob_start();
		?>
		<input type='hidden' name='redirect_cfg' value='on'>
		<input type='checkbox' name='redirect_cfg' id='redirect_cfg' value='off' <?php echo $checked ?>>
		<?php
		return ob_get_clean();
	}

	/**
	 * @return string Textfeld Cloud Adresse
	 */
	function cloud_url($bc) {
		$cloudAddress = $bc->get('root', "cloudAddress");
		$cloudkey = $bc->get("root", "cloud_key");
		
		$warning = "onclick='return checkCloudAddress();'";
		
		ob_start();
		?>
		<script>
			function checkCloudAddress() {
				<?php if (strlen ($cloudkey) == 0) { ?>
					return true;
				<?php } ?>
				var c = <?php echo ('"' . $cloudAddress . '"'); ?>;
				var n = document.getElementById("cloudAddress").value;
				if (n == c) {
					return true;
				}
				else {
					return confirm(<?php echo ('"' . CLOUD_CHANGE_URL_MESSAGE_DIS .'"' );?>);
				}
			}
		</script>
		<input type='text' class='form-control input-sm' name='cloudAddress' id='cloudAddress' value='<?php echo $cloudAddress ?>'>
		<br>
		
		<input type='submit' class='btn btn-default' value='<?php echo BUTTON_SAVE ?>' name='submit' <?php echo $warning ?> >&nbsp;
		<input type='button' class='btn btn-default' value='<?php echo BUTTON_LOAD_DEF ?>' onclick='load();'>
		<?php
		return ob_get_clean();
	}

	/**
	 * @return string Checkbox cloud proxy enable
	 */
	function proxy_enable($bc) {
		$proxy_enable = $bc->get('root', "proxyEnabled");
		$checked = ($proxy_enable == "1") ? "checked" : "";
		ob_start();
		?>
		<input type='hidden' name='proxyEnabled' value='0'>
		<input type='checkbox' name='proxyEnabled' id='proxyEnabled' value='1' <?php echo $checked ?>>
		<?php
		return ob_get_clean();
	}

	/**
	 * 
	 * @return string Dropdown cloud proxy type
	 */
	function proxy_type($bc) {
		$proxyType = $bc->get('root', "proxyType");
		$selectedHttp = ($proxyType == "CURLPROXY_HTTP") ? "selected" : "";
		$selectedSocks5 = ($proxyType == "CURLPROXY_SOCKS5") ? "selected" : "";
		ob_start();
		?>
		<select class='form-control input-sm' name='proxyType'>
			<option value='CURLPROXY_HTTP' <?php echo $selectedHttp ?>>HTTP</option>
			<option value='CURLPROXY_SOCKS5' <?php echo $selectedSocks5 ?>>SOCKS5</option>
		</select>
		<?php
		return ob_get_clean();
	}

	/**
	 * Check, if a valid url is provided
	 * @param string $url
	 * @return boolean
	 */
	function isDomainAvailable($url) {
		$connected = @fsockopen($url, 443, $errno, $errstr, 3); //website and port
		if ($connected) {
			$is_conn = true; //action when connected
			fclose($connected);
		} else {
			$is_conn = false; //action in connection failure
		}
		return $is_conn;
	}

	/**
	 * Generates the javascript code
	 * @return string
	 */
	function javascript() {
		ob_start();
		?>
		<script type="text/javascript">
		    function load() {
		        $('#cloudAddress').val('berocloud.beronet.com');
		    }
		    $('#cloud').validate({
		        rules: {
		            cloudAddress: {
		                checkHostname: true,
		                required: '#cloud_enable:checked',
		            },
		        }
		    });
		    $('#support').validate({
		        rules: {
		            supportKey: {
		                required: true,
		                minlength: 8,
		                maxlength: 8,
				checkManual: true
		            },
		        }
		    });
		    $('#proxy').validate({
		        rules: {
		            proxyAddress: {
		                required: '#proxyEnabled:checked',
				checkHostname: true
		            },
		            proxyPort: {
		                required: '#proxyEnabled:checked',
		                digits: true,
		                range: [1, 65535],
		            },
			    proxySecret: {
 	    	      		forbidPassword: {
                      			depends: function () {
                      				if ($('#password-dummy').val() == '1') {
                           				return '*****' == $('#proxy-secret').val();
                           			}
                      				return false;
                      			}
                     		}
			    }
		        }
		    });

		    $('#proxyEnabled').change(function () {
		        required();
		    });
		    $('#cloud_enable').change(function () {
		        required();
		    });
		    function required() {
		        if ($('#proxyEnabled').is(':checked')) {
		            addAsterisk('proxyAddress');
		            addAsterisk('proxyPort');
		        } else {
		            deleteAsterisk('proxyAddress');
		            deleteAsterisk('proxyPort');
		        }
		        if ($('#cloud_enable').is(':checked')) {
		            addAsterisk('cloudAddress');
		        } else {
		            deleteAsterisk('cloudAddress');
		        }
		    }
		    required();
		</script>
		<?php
		return ob_get_clean();
	}

	/**
	 * Generates the form for the cloud registration
	 * @return string HTML code
	 */
	function cloudRegisterTable($bc) {
		$cloud_key = $bc->get ("root", "cloud_key");
		ob_start();
		?>

		<div class="form-group text-center"> 
    		<a href="https://berocloud.beronet.com/"> 
        		<img src='/app/berogui/includes/images/beroCloud.jpg' target='_blank' alt="click here to visit beroCloud" class="png"> 
    		</a> <br><br> 
		</div>

		<form  class='form-horizontal' action='' method='POST' autocomplete='off'>
			<input name='fixChrome' type='password' style='display:none'>
			<input type=hidden name=m value="<?php echo $this->m_attr ?>">
			<div class="form-group">
				<label for='cloud_username' class='col-sm-5 control-label'>Cloud <?php echo LOGIN_USER_DIS; ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control input-sm' name='cloud_username'>
				</div>
			</div>
			<div class="form-group">
				<label for='cloud_password' class='col-sm-5 control-label'>Cloud <?php echo LOGIN_PASSWORD_DIS; ?></label>
				<div class='col-sm-4'>
					<input type='password' class='form-control input-sm' autocomplete='new-password' name='cloud_password'>
				</div>
			</div>
			
			<?php if (!strlen ($cloud_key)) {?>
			
					<div class="text-center" data-toggle='tooltip' title='<?php echo CLOUD_NETWORK_HINT ?>'>
					<input name='submit' class='btn btn-default' type='submit' value='<?php echo BUTTON_REGISTER ?>'>
			
			<?php	} else { ?>
					<div class="text-center" data-toggle='tooltip' title='<?php echo CLOUD_NETWORK_DEREGISTER_HINT ?>'>
					<input name='submit' class='btn btn-default' type='submit' value='<?php echo BUTTON_DEREGISTER ?>' onclick='return confirm("<?php echo CLOUD_MESSAGE_DIS ?>?");'>
			<?php	} ?>
			</div>
		</form>
		<?php
		
		return ob_get_clean();
	}

	/**
	 * @return string HTML code
	 */
	function cloudSupportKey($bc)
	{
		$permanent_remote_support_active = $bc->get('root', "permanent_remote_support_active");
		$checked = ($permanent_remote_support_active == "1") ? "checked" : "";
		
		ob_start();
		?>
		<form name='support' id='support' action='' class="form-horizontal" method='POST'>
			<div class="form-group">
				<label for='supportKey' class='col-sm-5 control-label'><?php echo CLOUD_SUPPORT_KEY_DIS ?></label>
				<div class='col-sm-4'>
					<input type="text" name="supportKey" class='form-control input-sm'>
				</div>
			</div>
			<div class="form-group">
				<label for='supportPermanent' class='col-sm-5 control-label'><?php echo CLOUD_SUPPORT_PERMANENT_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<input type='checkbox' name='supportPermanent' id='supportPermanent' value='1' <?php echo $checked ?>>
				</div>
			</div>
			<div class="text-center">
				<input name='submit' class='btn btn-default' type='submit' value='<?php echo BUTTON_CONNECT ?>'>
			</div>
			<br>
		</form>

		<?php
		exec ("ps aux|grep ssh|grep StrictHostKeyChecking=no|grep -v grep", $output, $retval);
		if (sizeof($output) || $permanent_remote_support_active) {
			if (sizeof($output)) {
				$rsstate = CLOUD_SUPPORT_STATE_ACTIVE_INFO;
				$rscolor = "gruen";
			}
			else {
				$rsstate  = CLOUD_SUPPORT_STATE_FAILED_INFO;
				$rscolor = "rot";
			}
		?>
		<form name='disconnect_support' id='disconnect_support' action='' class="form-horizontal" method='POST'>
			<div class="text-center">
				<img src='./includes/images/punkt_<?php echo $rscolor ?>.gif'>
				<font color='black'><?php echo $rsstate ?><br>
				<input id='disconnect_submit' name='disconnect_submit' class='btn btn-default' type='submit' value=<?php echo CLOUD_SUPPORT_DISCONNECT_BUTTON_DIS ?>>
			</div>
			<br>
		</form>
		<?php
		}
		

		return ob_get_clean();		
	}

	/**
	 * @return string HTML form for the general cloud settings
	 */
	function cloudTable($bc) {
		ob_start();
		?>
		<form name='cloud' id='cloud' action='' class="form-horizontal" method='POST'>
			<div class="form-group">
				<label for='cloud_show_status' class='col-sm-5 control-label'><?php echo BEROCLOUD_SHOW_STATUS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->cloud_show_status($bc) ?>
				</div>
			</div>
			<div class="form-group">
				<label for='cloud_enable' class='col-sm-5 control-label'><?php echo CLOUD_ENABLE_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->cloud_enable($bc) ?>
				</div>
			</div>
			<div class="form-group" data-toggle='tooltip' title='<?php echo CLOUD_REDIRECT; ?>'>
				<label for='redirect_cfg' class='col-sm-5 control-label'><?php echo CLOUD_REDIRECT_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->redirect_cfg($bc) ?>
				</div>
			</div>
			<div class="form-group">
				<label for='cloudAddress' class='col-sm-5 control-label'><?php echo CLOUD_URL_DIS ?></label>
				<div class='col-sm-4'>
					<?php echo $this->cloud_url($bc) ?>
				</div>
			</div>
		</form>
		<?php
		return ob_get_clean();
	}

	/**
	 * @return string HTML form für the cloud proxy settings
	 */
	function cloudProxyTable($bc) {
		ob_start();
		?>
		<form name='proxy' id='proxy' action='' class="form-horizontal" method='POST'>
			<input type='hidden' name='dummy' id='password-dummy' style='display:none' value='0'>
			<div class="form-group">
				<label for='proxyEnabled' class='col-sm-5 control-label'><?php echo CLOUD_PROXY_ENABLE ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->proxy_enable($bc) ?>
				</div>
			</div>
			<div class="form-group">
				<label for='proxyAddress' class='col-sm-5 control-label'><?php echo CLOUD_PROXY_ADDRESS ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control input-sm' name='proxyAddress' value='<?php echo $bc->get('root', 'proxyAddress') ?>'>
				</div>
			</div>
			<div class="form-group">
				<label for='proxyPort' class='col-sm-5 control-label'><?php echo CLOUD_PROXY_PORT ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control input-sm' name='proxyPort' value='<?php echo $bc->get('root', 'proxyPort') ?>'>
				</div>
			</div>
			<div class="form-group">
				<label for='proxyType' class='col-sm-5 control-label'><?php echo CLOUD_PROXY_TYPE ?></label>
				<div class='col-sm-4'>
					<?php echo $this->proxy_type($bc) ?>
				</div>
			</div>
			<div class="form-group">
				<label for='proxyUser' class='col-sm-5 control-label'><?php echo CLOUD_PROXY_USER ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control input-sm' name='proxyUser' value='<?php echo $bc->get('root', 'proxyUser') ?>'>
				</div>
			</div>
			<div class="form-group">
				<label for='proxySecret' class='col-sm-5 control-label'><?php echo CLOUD_PROXY_SECRET ?></label>
				<div class='col-sm-4'>
					<input type='password' class='form-control input-sm' name='proxySecret' id='proxy-secret' onchange="$('#password-dummy').val('1');" value='<?php echo strlen($bc->get('root', 'proxySecret')) === 0 ? '' : '*****'; ?>'>
				</div>
			</div>
			<div class="text-center">
				<input name='submit' class='btn btn-default' type='submit' value='<?php echo BUTTON_SAVE ?>'>
			</div>
			<br>
		</form>
		<?php
		return ob_get_clean();
	}

	/**
	 * Saves the setting in the database
	 * @return string HTML code
	 */
	function save($bc, $ba) {
		$cloud = null;
		if (file_exists('/usr/php/include/SbcApi.php')) {
			require_once('/usr/php/include/SbcApi.php');
			$cloud = new SbcApi($bc);
		}
		else if (file_exists('/usr/local/php/include/cloudApi.Class.php')) {
			require_once('/usr/local/php/include/cloudApi.Class.php');
			$cloud = new cloudApi();
		}

		$result = "";
		//we now explicitly have to click the register button to register, only register is performed, no other post stuff will be evaluated
		if (isset($this->post_attr['submit']) && $this->post_attr['submit'] == BUTTON_REGISTER) {
		 	if (! (isset($this->post_attr['cloud_username']) && isset($this->post_attr['cloud_password']) && strlen ($this->post_attr['cloud_username']) && $this->post_attr['cloud_password'])) {
		 		return;
		 	}

			if (!$this->_hasGateway || !$this->_hasNameserver) {
				$result = CLOUD_NETWORK_HINT;
			}
			else if (!$this->isDomainAvailable($bc->get('root', "cloudAddress")))
				$result = CLOUD_NO_CONNECTION_HINT;
			else if (!is_null($cloud)) {
				$result = $cloud->send('register', $this->post_attr, array(), $info);
				if ($result == false) {
					$error = method_exists($cloud, 'getError') ? $cloud->getError() : array('msg' => '<font color="#9900FF">Please check if system time has been configured correctly.</font><br>Otherwise device might already be registered. Please contact beroNet support', 'code' => 500);
					if (strpos(trim($error['msg']), 'verify that the CA cert is OK')) {
						$result = "SSL certificate problem, verify that the CA cert is OK or the time is correctly set | HTTP Status Code = {$error['code']}";
					}
					else {
						$result = "{$error['msg']} | HTTP Status Code = {$error['code']}";
					}
				}
				else {
					preg_match("/[^a-zA-Z0-9=]*?yaqwsx(?<key>.+)yaqwsx/", $result, $key);
					$key = unserialize($key['key']);
					if (isset($key['key'])) {
						$bc->set('root', 'cloud_key', $key['key']);
						$bc->set('root', 'cloud_enable', 1);
						$bc->set('root', 'cloud_show_status', 1);
						$table .= Helper::activate(1, true, $this->m_attr, ACTIVATE);
						$result = preg_replace("/[^a-zA-Z0-9=]*?yaqwsx(?<key>.+)yaqwsx/", ". ", $result);
					}
				}
			}
			if ($result != "" && strpos($result, "Device was registered"))
				$table .= "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'><font color='black'> " . $result . "<br/></div>";
			elseif ($result != "" && !strpos($result, "Device was registered"))
				$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'> " . $result . "</font><br/></div>";
			return $table;
		}
		
		//we now explicitly have to click the deregister button to register, only deregister is performed, no other post stuff will be evaluated
		if (isset($this->post_attr['submit']) && $this->post_attr['submit'] == BUTTON_DEREGISTER) {

			$result = $cloud->send('deregister');
			$bc->set('root', 'cloud_enable', 0);
			$bc->set('root', 'cloud_key', '');
			$table .= Helper::activate(1, true, $this->m_attr, ACTIVATE);
			
			if ($result != "" && trim($result) == "Device was deregistered") {
				$table .= "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'><font color='black'> " . $result . "<br/></div>";
			}
			else {
				$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'> " . $result . "</font><br/></div>";
			}
			return $table;
		}
		
		if (isset($this->post_attr['cloud_enable'])) {
			
			$oldAddress = $bc->get('root', 'cloudAddress');
			$cloudkey = $bc->get("root", "cloud_key");
			
			//cloud address changed, try to deregister first and reset cloudKey in any case
			if (strcmp ($oldAddress, sqlite_escape_string(trim($this->post_attr['cloudAddress']))) != 0) {

				if (strlen ($cloudkey)) {
					$result = $cloud->send('deregister');
					$table .= Helper::activate(1, true, $this->m_attr, ACTIVATE);
					
					if ($result != "" && trim($result) == "Device was deregistered") {
						$table .= "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'><font color='black'>" . $result . "<br/></div>";
					}
					elseif ($result != "") {
						$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'>" . $result . "</font><br/></div>";
					}
				}
				$bc->set('root', 'cloud_key', '');
			}

			foreach (array('cloud_enable', 'redirect_cfg', 'cloudAddress', 'cloud_show_status') as $key) {
				$bc->set('root', $key, sqlite_escape_string($this->post_attr[$key]));
			}

			if (isset($this->post_attr['cloud_key'])) {
				$bc->set('root', 'cloud_key', sqlite_escape_string($this->post_attr['cloud_key']));
			}

			$table .= Helper::activate(1, true, $this->m_attr, ACTIVATE);
			return $table;
		}
		
		if ($this->post_attr['proxyEnabled'] == '1' && isset($this->post_attr['proxyAddress']) && isset($this->post_attr['proxyPort']) && isset($this->post_attr['proxyType'])) {
			foreach (array('Enabled', 'Address', 'Port', 'Type', 'User') as $key) {
				$bc->set('root', "proxy{$key}", sqlite_escape_string($this->post_attr["proxy{$key}"]));
			}
			if (isset($this->post_attr['proxySecret'])) {
				$bc->set('root', 'proxySecret', sqlite_escape_string($this->post_attr['proxySecret'])); // TODO: how to update the code to hash the password when a customer had already set a password ?
			}
			$table .= Helper::activate(1, true, $this->m_attr, ACTIVATE);
			return $table;
		}
		else if ($this->post_attr['proxyEnabled'] == '0') {
			foreach (array('Enabled' => 0, 'Address' => '', 'Port' => '', 'Type' => '', 'User' => '', 'Secret' => '') as $key => $value) {
				$bc->set('root', "proxy{$key}", $value);
			}
			$table .= Helper::activate(1, true, $this->m_attr, ACTIVATE);
			return $table;
		}
		
		//Disconnect remote access for support
		if (isset($this->post_attr['disconnect_submit'])) {
			exec ("ps aux|grep ssh|grep StrictHostKeyChecking=no|grep -v grep|awk '{print $1}'|head -1", $output, $retval);
			if (sizeof ($output)) {
				exec ("kill -9 " . $output[0]);
			}
			
			$bc->delete('root', 'permanent_remote_support_cmd');
			$bc->delete('root', 'permanent_remote_support_key');
			$bc->set('root', "permanent_remote_support_active", "0");
			if (file_exists ("/usr/conf/remotesupport.conf")) {
				unlink ("/usr/conf/remotesupport.conf");
			}
			return $table;
		}
		
		//Remote access for support
		if (isset($this->post_attr['supportKey'])) {
			if (!$this->_hasGateway || !$this->_hasNameserver) {
				$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'>" . CLOUD_NETWORK_HINT . "</font><br/></div>";
			} else if (!$this->isDomainAvailable($bc->get('root', "cloudAddress"))) {
				$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'>" . CLOUD_NO_CONNECTION_HINT . "</font><br/></div>";
			} else {
				
				$result = $cloud->send('support-access', array('key' => $this->post_attr['supportKey']));
				if ($result == false) {
					$error = $cloud->getError();
					$table.= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'>{$error['msg']}</font><br/></div>";
				}
				if ($result != "" && trim($result)== "Invalid data") {
					$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'>" . $result . "</font><br/></div>";
				}
				else {
					$result = unserialize($result);
					
					if (isset($result['sshKey']) && isset($result['sysCmd'])) {
						file_put_contents('/tmp/key', $result['sshKey']);
						chmod('/tmp/key', 0600);
						
						$bc->set('root', "permanent_remote_support_active", "0");
						$bc->set('root', "permanent_remote_support_key", $result['sshKey']);
						$bc->set('root', "permanent_remote_support_cmd", $result['sysCmd']);
						
						//kill any running instance
						exec ("ps aux|grep ssh|grep StrictHostKeyChecking=no|grep -v grep|awk '{print $1}'|head -1", $output, $retval);
						if (sizeof ($output)) {
							exec ("kill -9 " . $output[0]);
						}
						exec('/sbin/' . $result['sysCmd']);
						
						if (isset($this->post_attr['supportPermanent'])) {
							$bc->set('root', "permanent_remote_support_active", "1");
							//since we don't do an activate, write the conf file here
							file_put_contents("/usr/conf/remotesupport.conf", "SSHCMD:" . $result['sysCmd'] . "\n");
							file_put_contents("/usr/conf/remotesupport.conf", $result['sshKey'] . "\n", FILE_APPEND);
						}
						else if (file_exists ("/usr/conf/remotesupport.conf")) {
							unlink ("/usr/conf/remotesupport.conf");
						}
						
						$table .= "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'><font color='black'> " . CLOUD_SUPPORT_STARTED_MESSAGE . "<br/></div>";
					}
					else{
						$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'>Invalid request</font><br/></div>";
					}
				}
			}
			return $table;
		}

		return $table;
	}
}
?>
