<?php
/**
 * Konfiguration der berofos Parameter
 * @author Gürsel Kücük <gk@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Berofos {

	/**
	 * Attributs
	 */
	private		$m_attr;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

        function __construct($m, $get = array(), $post = array(), $session = array()) {
		// set main GET variable
		$this->m_attr = $m;

                // get error from modal or submit execution
		if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}
	}

	public function display() {
		$ba = new beroAri();
		include '/usr/fallback/beroConf.php';
		$bc = new beroConf('root');	
		$name = "BEROFOS_TITLE_DIS";
		include('./includes/header.php');

		if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		$m = $this->m_attr;
		$berofos_table .= $this->dynamic_table();
		ob_start();
		?>
		<form name='berofos' id='berofos_form' action='modules/Berofos/berofos_submit.php' class="form-horizontal" method='POST'>
			<input type=hidden name=m value="<?php echo $m; ?>">
			<br>
			<?php echo $berofos_table; ?>
			<br>
		</form>
		<script>
		    $("#berofos_form").validate({
		        rules: {
		            ip_address: {
		                required: true,
				checkHostname: true,
		            },
		            interval: {
		                required: true,
		                digits: true,
		            },
		            mac_address: {
		                required: true,
		                checkMac: true,
		            },
		        }
		    });
		</script>
		<?php
		$ret .= ob_get_clean();
		//Rückgabe: Inhalt der HTML-Seite
		return $ret;
	}

	public function start_bnfos() {
		
	}

	public function stop_bnfos() {
		
	}

	public function dynamic_table() {
		$ba = new beroAri();
		$bc = new beroConf('root');
		require_once("./includes/lang.php");

		$retps = exec("ps x|grep bnfos|grep -v 'grep\|sed'|wc -l");
		$bnfosstate = $retps;

		ob_start();
		?>

		<p class="text-center lead" ><?php echo BEROFOS_TABLE_HEADER_DIS; ?></p>
		<div class='form-group' data-toggle='tooltip' title='<?php echo BNFOSIP; ?>'>
			<label for='ip_address' class='col-sm-5 control-label'><?php echo BEROFOS_IP_ADDRESS_DIS; ?></label>
			<div class='col-sm-4'>
				<input name="ip_address" class="form-control input-sm" type="text" size="15" value="<?php echo $ba->get('ip_berofos'); ?>">
			</div>
		</div>
		<div class='form-group' data-toggle='tooltip' title='<?php echo BNFOSMAC; ?>'>
			<label for='mac_address' class='col-sm-5 control-label'><?php echo BEROFOS_MAC_ADDRESS_DIS; ?></label>
			<div class='col-sm-4'>
				<input name="mac_address" class="form-control input-sm" type="text" size="15" value="<?php echo $ba->get('mac_berofos'); ?>">
			</div>
		</div>
		<div class='form-group' data-toggle='tooltip' title='<?php echo BNFOSINTERVALL; ?>'>
			<label for='interval' class='col-sm-5 control-label'><?php echo BEROFOS_INTERVAL_DIS; ?></label>
			<div class='col-sm-4'>
				<input name="interval" class="form-control input-sm" type="text" size="15" value="<?php echo $ba->get('interval_berofos'); ?>">
			</div>
		</div>
		<div class='form-group' data-toggle='tooltip' title='<?php echo BNFOSUSEBOOTWDOG; ?>'>
			<label for='use_boot_bnfos_wdog' class='col-sm-5 control-label'><?php echo BEROFOS_HEARTBEAT_ON_BOOT_DIS; ?></label>
			<div class='col-sm-4 form-checkbox'>
				<input type='checkbox' name='use_boot_bnfos_wdog' id='use_boot_bnfos_wdog' value='1' 
				<?php
				echo ($bc->get('root', 'use_boot_bnfoswdog') == "1" || $bc->get('root', 'use_boot_bnfoswdog') == "yes") ?
					"checked" : "";
				?>>
			</div>
		</div>
		<div class="text-center" data-toggle='tooltip' title='<?php echo BNFOSSAVE; ?>'>
			<input type='submit' class='btn btn-default' name='action' Value='<?php echo BUTTON_SAVE; ?>'>
		</div>
		<hr>
		<p class="text-center lead" ><?php echo BEROFOS_HEARTBEAT_STATE_DIS; ?></p>
		<div class='form-group' data-toggle='tooltip' title='<?php echo BNFOSSTATE; ?>'>
			<div class='col-sm-6 control-label img-responsive'>
				<img src='<?php echo ($bnfosstate == 1) ? "./includes/images/punkt_gruen.gif" : "./includes/images/punkt_rot.gif"; ?>'>
			</div>
			<div class='col-sm-6'>
				<input type='submit' name='action' class='btn btn-default' value='<?php echo ($bnfosstate == 1) ? BUTTON_DEACTIVATE : BUTTON_ACTIVATE; ?>'>
			</div>
		</div>
		<div class='text-center'><i><?php echo REQUIRED_FIELDS; ?></i></div>
		<?php
		return ob_get_clean();
	}

}
?>
