<?php
/**
 * Implementiert die CRUD Operationen für Call Progress Tabellen
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class CallProgress {

	/*
	 * Attributs
	 */
	private 	$m_attr,
			$start_attr;

        private         $isRequestRejected = 0,
                        $reasonRejected = array();

	/**
	 * Constructor
	 */
        function __construct($m, $get = array(), $post = array(), $session = array()) {
		// set main GET variable
		$this->m_attr = $m;

		// check GET variable. if invalid, set a default value
		$this->start_attr = isset($get['start']) ? Helper::sanitizeGet($get['start'], 'start') : 0;

		// get error from modal or submit execution
		if (isset($get['error'])) {
                        $this->isRequestRejected = 1;
                        $this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
                	unset($get['error'], $get['request'], $get['checkor'], $get['key']);
                }
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML Seite
	 */
	function display() {

		$m = $this->m_attr;

                $name="CALL_PROGRESS_TITLE_DIS";
		include('./includes/header.php');

		if ($this->isRequestRejected) {
     			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
      		}

		// build page content

		$callprogress_table = $this->dynamic_table();
		$ret .= "<script>
					function del(table,id){
						conf = confirm('".CALL_PROGRESS_DELETE_MESSAGE_DIS."');
						if (conf==false)
							return false;
						else
							window.location='./misc/delete.php?m=".$m."&id='+id+'&table='+table;
					}
					function del_ent(table,id){
						conf = confirm('".CALL_PROGRESS_ENT_DELETE_MESSAGE_DIS."?');
						if (conf==false)
							return false;
						else
							window.location='./misc/delete.php?m=".$m."&id='+id+'&table='+table;
					}
				 </script>
				 <div class='modal fade bs-example-modal-lg' id='callprogress-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
				  <div class='modal-dialog modal-lg'>
				    <div class='modal-content'>
				      <div class='modal-header'>
					<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
					<h4 class='modal-title' id='myModalLabel'>CALL PROGRESS</h4>
				      </div>
				      <div class='modal-body'>
				      </div>
				    </div>
				  </div>
				</div>
					<br>
					" . $callprogress_table.
					"<br>"
			. "<div class='text-center'>"
			. "<a href='modules/CallProgress/callprogress_popup.php' role='button' data-remote='false' data-toggle='modal' data-target='#callprogress-popup' class='btn btn-default'>"
			. BUTTON_ADD_TABLE . "</a>"
			. "</div>		
					<script>
			$('#callprogress-popup').on('show.bs.modal', function(e) {
				var link = $(e.relatedTarget);
				$('.modal-body').load(link.attr('href'));
			});
		</script>";

		return $ret;
	}





	/**
	 * Erstellt die HTML Tabellen mit den Call Progress Tabellen und deren Einträge
	 * @return string HTML Tabelle
	 */

	function dynamic_table() {
		
		$ba = new beroAri();

		require_once("./includes/lang.php");

		$columns = $ba->column_type('callprogress');
		$i = 0;
		foreach ($columns as $column => $type) {
			if (($column != 'id') && ($column != 'direction')) {
				$cols_name[$i] = $column;
				
				if ($column == "name")
					$column = CALL_PROGRESS_NAME_DIS;
				$cols .= "<th>" . $column . "</th>";
				$i++;
			}
		}

		
		$start = $this->start_attr;
		$page = (($start / 15) + 1);
		if (!$start)
			$start = 0;
		$id = 0;
		for ($j = 1; $j <= $page; $j++) {
			$query_t = $ba->select('SELECT * FROM callprogress ORDER BY id');
			$rows = '';
			$dir=array(	"SIP-ISDN_TEXT"=>array(CALL_PROGRESS_IFACE_TYPE_DIS,CALL_PROGRESS_ISDN_EVENT_DIS,CALL_PROGRESS_ISDN_CHANN_DET_DIS,CALL_PROGRESS_SIP_RESP_DIS,CALL_PROGRESS_RESP_TEXT_DIS),
						"SIP-ISDN_KEY"=>array("type","isdn_event","chann_det","sip_resp","resp_text"),
						"ISDN-SIP_TEXT"=>array(CALL_PROGRESS_SIP_EVENT_DIS,CALL_PROGRESS_RESP_TEXT_DIS,CALL_PROGRESS_IFACE_TYPE_DIS,CALL_PROGRESS_ISDN_EVENT_DIS),
						"ISDN-SIP_KEY"=>array("isdn_event","resp_text","type","sip_resp"),
						"SIP-FXO_TEXT"=>array(CALL_PROGRESS_FXO_EVENT_DIS,CALL_PROGRESS_RESP_TEXT_DIS,CALL_PROGRESS_SIP_RESP_DIS),
						"SIP-FXO_KEY"=>array("isdn_event","resp_text","sip_resp"),);
			while ($entry_t = $ba->fetch_array($query_t)) {
				$rows = "<tr>";
				if ($entry_t['direction']=="SIP-ISDN") $colspan=5;
				if ($entry_t['direction']=="SIP-FXO") $colspan=3;
				if ($entry_t['direction']=="ISDN-SIP") $colspan=4;
				$rows.="<th colspan='".$colspan."'><font color='#595959'>" . $entry_t['name'] ."   " . $entry_t['direction'] . "</font>";
				$id = $entry_t['id'];
				$rows .= "&nbsp;&nbsp;&nbsp;"
					. "<a href='modules/CallProgress/callprogress_popup.php?id=" . $entry_t['id'] .  "&name=" . $entry_t['name'] . "' role='button' "
					. "data-remote='false' data-toggle='modal' data-target='#callprogress-popup' class='btn btn-default'>"
					. BUTTON_MODIFY_TABLE . "</a>&nbsp;
				<button type='button' class='btn btn-default' onclick=\"del('callprogress','".$id."');\">" . BUTTON_DELETE_TABLE . "</button></th>
				<th><a href='modules/CallProgress/callprogress_ent_popup.php?id_name=" . $id .  "' role='button' "
					. "data-remote='false' data-toggle='modal' data-target='#callprogress-popup' class='btn btn-default'>"
					. BUTTON_ADD_ENTRY . "</a></th></tr>";
				$rows .= "<tr>";
				foreach ($dir[$entry_t['direction']."_TEXT"] as $value){
					$rows.="<th>".$value."</th>";
				}

				$rows .= "<th></th></tr>";
				$query = $ba->select('SELECT * FROM callprogress_entries WHERE id_name="'.$id.'" ORDER BY id asc');
				while ($entry = $ba->fetch_array($query)) {
					$rows .= "<tr>";
					foreach ($dir[$entry_t['direction']."_KEY"] as $value){
						$rows .= "<td>" . $entry[$value] . "</td>";
					}

					$id_ent = $entry['id'];
					$rows .= "<td class='buttons'>
						<a href='modules/CallProgress/callprogress_ent_popup.php?id=" .$entry['id'] ."&id_name=" . $id . "' data-remote='false' data-toggle='modal' data-target='#callprogress-popup' class='popup_download'>
							<img src='./includes/images/modify.png'>
				</a>&nbsp;
				<a class='popup_download' onclick=\"del_ent('callprogress_entries','".$id_ent."');\">
            	    <img src='./includes/images/delete.png'>
				</a>

				</td></tr>";
				}
				$table .= "<table class='table table-striped table-bordered' id='table'>" . $rows . "</table><br><br>";
			}
		}

		return $table;
	}

}
?>
