<?php
/**
 * Implementiert die Funktionalität um CDR einzustellen und herunterzuladen
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Cdr {
	
	/**
	 * Attributs
	 */
	private		$m_attr;

	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->m_attr = $m;
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML Inahalt
	 */

	function display() {
		// args
		$m = $this->m_attr;

		$name = "CDR_TITLE_DIS";
		include('./includes/header.php');
		$ret .= $this->dynamic_table($m);

		return $ret;
	}

	/**
	 * Der boolesche Wert von Logcdr, der in der Datenbank gespeichert ist, wird 
	 * in Form eines Checkboxs zurückgegeben und später angezeigt.
	 * @return string
	 */

	function logcdr($ba) {
		$option = $ba->get("logcdr");
		if ($option == "1") {
			return "<input type='checkbox' name='logcdr' value='1' checked>";
		} else {
			return "<input type='checkbox' name='logcdr' value='1'>";
		}
	}

	function cdrsizelimit($ba) {
		$option = $ba->get("cdrsizelimit");
		if (!strlen ($option)) {
			$option = "200000";
		}
		return "<input type='text' class='form-control input-sm' name='cdrsizelimit' value='" . $option . "'>";
	}

	/**
	 * Erstellt die HTML Tabelle für die CDR Seite
	 * @return string HTML Tabelle
	 */

	function dynamic_table($m) {
		//Wenn man Änderugen von der Daten macht werden die in der Tabelle der Datenbank
		//aktualisiert
		$ba = new beroAri();

		require_once("./includes/lang.php");
		ob_start();
		?>
		<form class='form-horizontal' id='cdrform' name='cdr' action='modules/Cdr/cdr_submit.php' method='POST'>
			<input type=hidden name=m value='<?php echo $m ?>'>
			<input type=hidden name=a value='save'>
			<br>
			<p class="text-center lead"><?php echo CDR_TABLE_HEADER_DIS ?></p>
			<div class="form-group" data-toogle="tooltip" title="<?php echo LOGCDR ?>">
				<label for='logcdr' class='col-sm-5 control-label'><?php echo CDR_LOGCDR_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->logcdr($ba) ?>
				</div>
			</div>
	
			<div class="form-group" data-toogle="tooltip" title="<?php echo CDR_MAX_SIZE?>">
				<label for='cdrsizelimit' class='col-sm-5 control-label'><?php echo CDR_MAX_SIZE_DIS ?></label>
				<div class='col-sm-4'>
					<?php echo $this->cdrsizelimit($ba) ?>
				</div>
			</div>
			
			<div class="text-center">
				<button type='submit' class='btn btn-default'><?php echo BUTTON_SAVE ?></button>
			</div>
			<br>

			<?php if ($ba->get("logcdr") == "1"): ?>
				<script type="text/javascript">
					function reload_cdr() {
						window.location.href = './index.php?m=Cdr';
					}
				</script>
				<p class="text-center lead"><?php echo CDR_DOWNLOAD_DIS ?></p>
				<div class="form-group">
					<label for='logcdr' class='col-sm-5 control-label'><?php echo CDR_LOGFILE_DIS ?></label>
					<div class='col-sm-4'>
						<input type='button' class='btn btn-default' value='<?php echo CDR_BUTTON_DOWNLOAD_DIS ?>' 
							   onclick="window.location.href = 'modules/Cdr/cdr_download.php';
			                                       window.setTimeout('reload_cdr()', 5000);" data-toogle="tooltip" 
							   title="<?php echo CDR_DOWNLOAD ?>">&nbsp;&nbsp;
							   <?php if (file_exists("/tmp/isgw.cdr.gz")) : ?>
							<input type='button' class='btn btn-default' value='<?php echo CDR_BUTTON_DELETE_FILE_DIS ?>' 
								   onclick="javascript:if (confirm('Do you want to delete the logfile?') == true)
				                                               window.location.href = 'misc/deletefile.php?m=<?php echo $m ?>&option=cdr';" 
								   data-toogle="tooltip" title="<?php echo CDR_DELETE ?>" >
							   <?php endif; ?>
					</div>
				</div>

			</form>
			<script type='text/javascript'>
				$("#cdrform").validate({
					rules: {
						cdrsizelimit: {
							range: [10000, 1000000],
						},
               				}
                        	});
			</script>

			<?php
		endif;
		$table .= ob_get_clean();
		//Rückgabe: Erzeugte Tabelle mit den änderbaren Feldern von den Einstellungen von isgw.conf
		return $table;
	}

}
?>

