<?php

/**
 * Implementiert die CRUD Operationen für Wählplaneinträge
 * 
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Dialplan {

	/**
	 * Attributs
	 */
	private		$m_attr,
			$q_attr,
			$start_attr,
			$ent_attr,
			$dir_attr,
			$search_attr,
			$number_attr;

        private         $isRequestRejected = 0,
                        $reasonRejected = array();

	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		// set main GET variable
		$this->m_attr = $m;

		// check GET variable (default values are set from the Helper function)
		$this->q_attr 	  = Helper::sanitizeGet($get['q'] 	, 'int>=0'	);
		$this->start_attr = Helper::sanitizeGet($get['start']	, 'int>=0'	);
		$this->ent_attr   = Helper::sanitizeGet($get['ent']	, 'ent'		);
		$this->dir_attr   = Helper::sanitizeGet($get['dir']	, 'direction'	);
		$this->search_attr = Helper::sanitizeGet($get['search']	, 'int>=0'	);
		$this->number_attr = Helper::sanitizeGet($get['number']	, 'int>=0'	);

                // get error from modal or submit execution
                if (isset($get['error'])) {
                        $this->isRequestRejected = 1;
                        $this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
                	unset($get['error'], $get['request'], $get['checkor'], $get['key']);
                }
	}

	/**
	 * Search for the dialplan entries, that match the "search" criteria.
	 * @param beroAri $ba
	 * @param int $span
	 * @param int $start
	 * @param bool $navi
	 * @return Object Query result 
	 */
	function filter($ba, $span, $start, $navi = false) {
		$where = "";
		if ((!isset($this->dir_attr) || $this->dir_attr == 'all' || $this->dir_attr == "") && $this->search_attr == "") {
			$where = "";
		} else if ((!isset($this->dir_attr) || $this->dir_attr == 'all' || $this->dir_attr == "") && $this->search_attr != "") {
			$where = ' 	WHERE fromId like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or toId like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or dest like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or newDest like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or src like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or comment like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or newSrc like ("%' . sqlite_escape_string($this->search_attr) . '%")';
		} else if (isset($this->dir_attr) && $this->dir_attr != 'all' && $this->dir_attr != "" && $this->search_attr != "") {
			$dir = explode("-", $this->dir_attr);
			$where = ' 	WHERE (fromId like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or toId like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or dest like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or newDest like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or src like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or comment like ("%' . sqlite_escape_string($this->search_attr) . '%")
								or newSrc like ("%' . sqlite_escape_string($this->search_attr) . '%"))
								and (toDirection="' . sqlite_escape_string($dir[1]) . '" and fromDirection="' . sqlite_escape_string($dir[0]) . '")';
		} else {
			$dir = explode("-", $this->dir_attr);
			$where = ' WHERE toDirection="' . sqlite_escape_string($dir[1]) . '" and fromDirection="' . sqlite_escape_string($dir[0]) . '" ';
		}
		//Select all entries for navigation bar whithout limit
		if (!$navi)
			$limit = 'limit ' . sqlite_escape_string($span) . ' offset ' . sqlite_escape_string($start);

		$query = $ba->select(' SELECT * from dialplan ' . $where . ' ORDER BY posId, id asc ' . $limit);

		return $query;
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML Inahalt
	 */
	function display() {

		include "./includes/functions.php";
		//Function for the pagination bar
		$functions = new functions();

		// args
		$m = $this->m_attr;
		$q = $this->q_attr;
		$start = $this->start_attr;

		$next_del = 0;
		$next_add = 0;
		//ein neues Datenbankobjekt wird erzeugt.
		$ba = new beroAri();

		$query = $ba->select('SELECT * FROM dialplan');
		$record_count = sqlite_num_rows($query);
		$start = $start == '' ? 0 : $start;
		if (!is_null($this->ent_attr))
			$ba->set('span', $this->ent_attr);
		if (!$ba->get('span'))
			$ba->set('span', '15');
		$span = $ba->get('span');

		$next_del = $start;
		$test = $record_count / $span;
		$test = (int) $test;
		if ($record_count == 0) {
			$next_add = 0;
		} else {
			$next_add = ($test * $span);
		}

		if ($start + $span < $record_count) {
			$next_del = $start;
		} else {
			$rest = $record_count % $span;
			if ($record_count % $span == 1) {
				$next_del = $start - $span;
				if ($next_del < 0)
					$next_del = 0;
			}else {
				$next_del = $start;
			}
		}

		$name = "DIALPLAN_TITLE_DIS";
		include('./includes/header.php');
		
		if ($this->isRequestRejected) {
              		$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
             	}

		$dialplan_table = $this->dynamic_table($ba, $next_del, $span, $next_add);
		// build page content
		$ret .= "<script type='text/javascript'>
				
				function del(table,option, from, to,op,pos){


					conf = confirm('" . DIALPLAN_DELETE_MESSAGE_DIS . " " . DIALPLAN_FROM_ID_DIS . " '+from+', " . DIALPLAN_TO_ID_DIS . " '+to+'?');
					if (conf==false)
						return false;
					else
						window.location='./misc/delete.php?m=" . $m . "&id='+option+'&table='+table+'&start='+pos;
				}
			</script>
			<div class='modal fade bs-example-modal-lg' id='dialplan-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
				  <div class='modal-dialog modal-lg'>
				    <div class='modal-content'>
				      <div class='modal-header'>
					<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
					<h4 class='modal-title' id='myModalLabel'>" . DIALPLAN_TITLE_DIS . "</h4>
				      </div>
				      <div class='modal-body'>
				      </div>
				    </div>
				  </div>
				</div>
			<div id='dialog' title='" . DIALPLAN_TITLE_DIS . "'></div>
			<br>
			<div id='content'>
			" . $dialplan_table . "
			<br>

			<form name='dialplan' action='' method='GET'>
			<input type=hidden name=m value='" . $m . "'>
			<input type=hidden name=f value='action'>
			<input type=hidden name=a value='add'>
			<input type=hidden name=start value='" . $next_add . "'>
				<div class='text-center'>
			<a href='modules/Dialplan/dialplan_popup.php' role='button' data-remote='false' data-toggle='modal' data-target='#dialplan-popup' class='btn btn-default'>
				" . BUTTON_ADD . "
			</a>
		</div>
		<script>
			$('#dialplan-popup').on('show.bs.modal', function(e) {
				var link = $(e.relatedTarget);
				$('.modal-body').load(link.attr('href'));
			});
			$('#dialplan-popup').on('hidden.bs.modal', function(e) {
				$('.modal-body').empty();
			});
		</script>
		<br>";

		//Create the pagination bar

		$url_opts = array();
		$url_opts['number'] = $this->number_attr;
		$url_opts['search'] = $this->search_attr;
		$url_opts['dir'] = $this->dir_attr;
		$url_opts['ent'] = $this->ent_attr;
		$query = $this->filter($ba, $span, $start, true);
		$record_count = sqlite_num_rows($query);
		$ret .= "<div class='text-center'>" .
			$functions->displayNavigationBlock($m, $q, $url_opts, $start, $span, $record_count) .
			"</div>"
			. "</div>"
			. "</form>";

		//Rückgabe: Inhalt der HTML-Seite
		return $ret;
	}

	/**
	 * Direction filter
	 * @return string
	 */
	function getDirFilter() {
		$directions = array("sip", "isdn", "analog", "gsm", "cas", "lte");
		$filter = "<select name='dir' class='form-control' id='dir' onchange=\"window.location='index.php?m=" . $this->m_attr . "&search=" . $this->search_attr . "&dir='+getElementById('dir').options[getElementById('dir').selectedIndex].value;\">";
		if ($this->dir_attr == 'all')
			$selected = "selected";
		$filter .= "<option value='all' $selected>" . DIALPLAN_DIRECTION_ALL_DIS . "</option>";
		foreach ($directions as $dir) {
			foreach ($directions as $dir1) {
				($this->dir_attr == $dir . '-' . $dir1) ? $selected = "selected" : $selected = "";
				$filter .= "<option value='" . $dir . "-" . $dir1 . "' $selected>" . $dir . "-" . $dir1 . "</option>";
			}
		}
		$filter .= "</select>";
		return $filter;
	}

	/**
	 * Count filter
	 * @param beroAri $ba
	 * @return type
	 */
	function getCountFilter($ba) {
		$spancount = array(10, 15, 20, 25, 30, 35, 40, 45, 50);
		$filter = "<select name='ent' id='ent' class='form-control' onchange=\"window.location='index.php?m=" . $this->m_attr . "&ent='+getElementById('ent').options[getElementById('ent').selectedIndex].value;\">";
		foreach ($spancount as $span) {
			($ba->get('span') == $span) ? $selected = "selected" : $selected = "";
			$filter .= "<option value='$span' $selected>$span</option>";
		}
		return $filter;
	}

	/**
	 * Erstellt die HTML Tabelle für die Wählplaneinträge
	 * @return string HTML Tabelle
	 */
	function dynamic_table($ba, $next_del, $span, $next_add) {
		require_once("./includes/lang.php");
		if ($ba->get('gui_mode') == 'simple')
			$simple_class = 'simple';
		$filter = "<th colspan='12'>
		<form>
		<div class='row'>
		<div class='col-sm-1'>" . DIALPLAN_DIRECTION_DIS . ": </div>"
			. "<div class='col-sm-3'>" . $this->getDirFilter() . "</div>";

		$filter .= "<div class='col-sm-1'>" . DIALPLAN_SEARCH_DIS . ":</div>"
			. "<div class='col-sm-2'> "
			. "<input name='search' class='form-control' value='" . $this->search_attr . "' onkeydown=\"if (event.keyCode == 13){ window.location='index.php?m=" . $this->m_attr . "&dir=" . $this->dir_attr . "&search='+search.value; return false;}\" >"
			. "</div>";
		$filter .= "<div class='col-sm-2'>" . DIALPLAN_ENTRIES_DIS . ":</div>"
			. "<div class='col-sm-3'> " . $this->getCountFilter($ba) . "</div>"
			. "</div>"
			. "</form>"
			. "</th>";




		$query = $ba->select(' SELECT * from dialplan ORDER BY posId, id asc');
		$pi = 1;

		while ($entry = $ba->fetch_array($query)) {
			$ba->update('UPDATE dialplan set posId="' . $pi++ . '" WHERE id="' . $entry['id'] . '"');
		}


		$start = $this->start_attr;
		$columns = $ba->column_type('dialplan');
		$i = 0;

		//Table header
		$cols .= "<th class='checkall'><div data-toggle='tooltip' title='" . DIALPLAN_CHECK_ALL_DIS . "'> <input type='checkbox' id='checkall'></div></th>";
		$cols .= "<th>" . DIALPLAN_DIRECTION_DIS . "</th>";
		foreach ($columns as $column => $type) {
			// TODO: replace by !in_array(): more simple and clear
			if (($column != 'id') && ($column != 'config') && ($column != 'isdnid') && ($column != 'activ') && ($column != 'fromDirection') && ($column != 'toDirection') && ($column != 'posId') && ($column != 'comment')) {
				$cols_name[$i] = $column;
				if ($column == "fromId")
					$cols .= "<th>" . DIALPLAN_FROM_ID_DIS . "</th>";
				if ($column == "toId")
					$cols .= "<th>" . DIALPLAN_TO_ID_DIS . "</th>";
				if ($column == "dest") {
					$cols .= "<th class='" . $simple_class . "'>" . DIALPLAN_DESTINATION_DIS . "</th>";
					$class[$column] = $simple_class;
				}
				if ($column == "newDest") {
					$cols .= "<th class='" . $simple_class . "'>" . DIALPLAN_NEW_DESTINATION_DIS . "</th>";
					$class[$column] = $simple_class;
				}
				if ($column == "src") {
					$cols .= "<th class='" . $simple_class . "'>" . DIALPLAN_SOURCE_DIS . "</th>";
					$class[$column] = $simple_class;
				}
				if ($column == "newSrc") {
					$cols .= "<th class='" . $simple_class . "'>" . DIALPLAN_NEW_SOURCE_DIS . "</th>";
					$class[$column] = $simple_class;
				}
				$i++;
			}
		}
		$i = 0;
		$cols .= "<th>" . DIALPLAN_POSITION_DIS . "</th>";

		/* Table content, CRUD buttons */
		$page = (($start / $span) + 1);
		if (!$start)
			$start = 0;
		$id = 0;

		for ($j = $page; $j <= $page; $j++) {
			$query = $this->filter($ba, $span, $start);
			$rows = '';

			while ($entry = $ba->fetch_array($query)) {

				($entry['activ'] == 1) ? $rows .= "<tr>" : $rows .= "<tr style='color:grey'>";
				$rows .= "<td class='checkall'><form>
                                                    <input type='checkbox' name='entryid' class='entryid' value='" . $entry['id'] . "'/>
						</form></td>";
				$rows .= "<td>" . $entry['fromDirection'] . "-" . $entry['toDirection'] . "</td>";
				$count = sqlite_num_fields(defined('PHP_VERSION_ID') ? $entry : $query);
				for ($i = 0; $i < ($count - 8); $i++) {
					$col_name = $cols_name[$i];
					$entry['comment'] = str_replace("\r\n", "<br>", $entry['comment']);
					if ($entry['comment'] != "")
						$rows .= "<td class='" . $class[$col_name] . "' onmouseover=\"Tip('" . $entry['comment'] . "')\" onmouseout='UnTip()'>";
					else
						$rows .= "<td class='" . $class[$col_name] . "'>";
					if (strlen($entry[$col_name]) > 15)
						$value = substr($entry[$col_name], 0, 15) . "...";
					else
						$value = $entry[$col_name];
					//Don't show the matchtypes and g:
					if (strpos($value, ":") === 1)
						$rows .= substr($entry[$col_name], 2);
					else
						$rows .= $value;
					$rows .= "</td>";
				}

				if ((!isset($this->dir_attr) || $this->dir_attr == 'all' || $this->dir_attr == "") && $this->search_attr == "")
					$rows .= "<td>
								&nbsp;
								<a href='modules/Dialplan/change_pos.php?posid=" . ($entry['posId'] - 1) . "&id[]=" . $entry['id'] . "' 
								style='vertical-align: sub;'>
								<img src='./includes/images/up.png' onmouseover=\"Tip('" . DIALPLAN_UP . "')\" onmouseout='UnTip()'></a>
								&nbsp;
								<a href='modules/Dialplan/change_pos.php?posid=" . ($entry['posId'] + 1) . "&id[]=" . $entry['id'] . "'
								style='vertical-align: sub;'>
								<img src='./includes/images/down.png' onmouseover=\"Tip('" . DIALPLAN_DOWN . "')\" onmouseout='UnTip()'></a>
								&nbsp;
								<form class='position' id='pos" . $entry['id'] . "' action=\"./modules/Dialplan/change_pos.php\">
									<input type='text' class='form-control' name='posid' size='3' value='" . $entry['posId'] . "' digits='true' onmouseover=\"Tip('" . DIALPLAN_MOVE_POS_DIS . "')\" onmouseout='UnTip()' onkeydown=\"if (event.keyCode == 13){ $('#pos" . $entry['id'] . "').submit(); }\">
									<input type='hidden' name='id[]' value='" . $entry['id'] . "'>
								</form>
								<label id='posid" . $entry['posId'] . "'></label>
								<script>
									$(\"#pos" . $entry['id'] . "\").validate({
										errorLabelContainer: \"#posid" . $entry['posId'] . "\",
									});
								</script>
							</td>";
				else
					$rows .= "<td>
								<img src='./includes/images/up.png'>
								&nbsp;
								<img src='./includes/images/down.png'>
                                                                &nbsp;
								<form class='position'>
									<input disabled type='text' name='pos' size='3' value='" . $entry['posId'] . "' onmouseover=\"Tip('" . DIALPLAN_MOVE_POS_DIS . "')\" onmouseout='UnTip()'>
								</form>
							</td>";

				$id = $entry['id'];
				$rows .= "<td nowrap><font size='3'><form>
						<a href='modules/Dialplan/dialplan_popup.php?id=" .
					$entry['id'] . "&start=" . $next_add . "&dir=" . $this->dir_attr . "&search=" . $this->search_attr . "' data-remote='false' data-toggle='modal' data-target='#dialplan-popup' class='popup_download'>
					<img src='./includes/images/modify.png' onmouseover=\"Tip('" . DIALPLAN_MOD_INBOUND_MODIFY . "')\" onmouseout='UnTip()'>
					</a>" .
					"<a href='modules/Dialplan/dialplan_popup.php?copy=" .
					$entry['id'] . "&start=" . $next_add . "&dir=" . $this->dir_attr . "&search=" . $this->search_attr . "' data-remote='false' data-toggle='modal' data-target='#dialplan-popup' class='popup_download'>
					<img src='./includes/images/copy.png' onmouseover=\"Tip('" . DIALPLAN_MOD_INBOUND_COPY . "')\" onmouseout='UnTip()'>
					</a>" .
					"&nbsp;<a href='modules/Dialplan/more.php?dialplanid=" . $entry['id'] . "&start=" . $next_add .
					"&dir=" . $this->dir_attr . "&search=" . $this->search_attr . "&from=" . $entry['fromDirection'] . "&to=" . $entry['toDirection'] . "' data-remote='false' data-toggle='modal' data-target='#dialplan-popup' class='popup_download " . $simple_class . "'>
					<img src='./includes/images/more.png' onmouseover=\"Tip('" . DIALPLAN_MORE_OPTIONS . "')\" onmouseout='UnTip()'>
					</a>" .
					"&nbsp;<a class='popup_download' onclick=\"del('dialplan','" . $id . "','" . $entry['fromId'] . "','" . $entry['toId'] . "','id','" . $next_del . "');\"><img src='./includes/images/delete.png' onmouseover=\"Tip('" .
					DIALPLAN_MOD_INBOUND_DELETE . "')\" onmouseout='UnTip()'></a>" .
					"</form></font></td></tr>";
			}
		}
		//Table
		$table = "<table class='table table-striped table-bordered' id='table'><tr>" . $filter . "</tr><tr>" . $cols . "<th>" . DIALPLAN_TOOLS_DIS . "</th></tr>" . $rows . "</table>
                        <img src='./includes/images/arrow.jpg' style='margin-left:10px; margin-right:5px;'>
                        <a href='javascript:void sendForm(\"activate\");'>" . BUTTON_ACTIVATE . "</a> ,
                        <a href='javascript:void sendForm(\"deactivate\");'>" . BUTTON_DEACTIVATE . "</a> ,
                        <a href='javascript:void sendForm(\"delete\");'>" . BUTTON_DELETE . "</a>
                        <script>$(\"#checkall\").click(function(event) {
                                    if (this.checked){
                                        $('.entryid').each(function() { 
                                            this.checked = true;               
                                        });
                                    }else{
                                        $('.entryid').each(function() { 
                                            this.checked = false;               
                                        });
                                    }
                                    });
                                    
                                    function sendForm (action) {
                                        if (action=='delete'){
                                            Check = confirm('" . DIALPLAN_DELETE_BULKMESSAGE_DIS . "');
                                            if (Check == false)
                                                return false;  
                                        }
					
                                        var entryid=[];
                                        var i=0;
                                        $('.entryid').each(function () {
                                            if ($(this).prop('checked')==true) entryid[i++]=$(this).val();
                                        });
	
                                        $.post('./modules/Dialplan/dialplan_action.php', { entryid : entryid, action: action })
                                            .done (function (data) {
                                                location.reload();
                                            });
                                    }
                        </script>";
		return $table;
	}

}

?>
