<?php
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

function get_berofix_hostname () {

	$hostname = @file('/etc/hostname');
	if ($hostname == false) {
		return('unknown');
	}

	return(str_replace(array("\r", "\n", ' '), '', $hostname[0]));
}

function get_berofix_carduuid () {

	$uuid=exec ("cat /proc/cmdline |sed 's/.*carduuid=//;s/ .*//;s/-0*/-/g'");
	return(str_replace(array("\r", "\n", ' '), '', $uuid));

}

function get_berofix_fw_version () {
	$fw=exec ("cat /usr/local/FILENAME |head -1 |sed 's/.tar.gz//'");
	return($fw);
}


function get_mtime_datestring_for_file ($filename) {

	if (!file_exists($filename)) {
		return('unknown');
	}

	return(@date ('Ymd-His', filemtime($filename)));
}

function get_fulltrace_datestring_for_file ($is_sbc_vm) {
	if ($is_sbc_vm) {
		$datestring = Helper::exec(1, 'tar xzf /var/log/DebugFiles.tar.gz cloud-sbc/fulltrace-starttime.txt -O');
	}
	else {
		$datestring = Helper::exec(0, 'tar xzf /var/log/DebugFiles.tar.gz fulltrace-starttime.txt -O');
	}
	if (strlen($datestring) == 0) {
		return('unknown');
	}
	$ret = str_replace('-', '', $datestring);
	$ret = str_replace(':', '', $ret);
	$ret = str_replace(' ', '-', $ret);
	return $ret;
}

function get_lifs_for_file () {
	$lifs = '';
	if (file_exists('/usr/conf/hardware.conf')) {
		$lifs = exec ("cat /usr/conf/hardware.conf |grep type|grep -v pcm|sed 's/.*=//'|tr '\n' '-'|sed 's/_$//;s/-$//'|head -1");
	}
	return(strlen($lifs) > 0 ? $lifs : 'unknown');
}

# check if session is valid
$newTarget='/app/berogui/index.php?m=FulltraceGui';
require_once('/usr/local/www/berogui/includes/session.php');
unset($newTarget);

require_once('/usr/fallback/beroConf.php');
$bc = new beroConf('root');
$is_sbc_vm = $bc->get('root', 'is-sbc-vm') == 1;

Helper::exec($is_sbc_vm, '/bin/sync');
switch ($_GET['option']) {
case 'isgw':
	if (!file_exists('/var/log/debug-info.tar.gz')) {
		exit(0);
	}
	$fileList = '/var/log/debug-info.tar.gz' . (file_exists('/var/log/core') ? ' /var/log/core' : '');
	$mtime = get_mtime_datestring_for_file('/var/log/debug-info.tar.gz');
	$fname = array(
		0 => "debug-info-". get_berofix_hostname() ."$mtime.tar",
		1 => "debug-info-$mtime.tar",
	);
	header('Content-Type: application/force-download');
	header('Content-Disposition: attachment; filename=' . $fname[$is_sbc_vm] . "\r\n\r\n");
	passthru('tar -f - -c ' . $fileList);
	exit(0);
case 'cloud':
	if (!file_exists('/var/log/isgw.err')) {
		exit(0);
	}

	$file = file_get_contents('/var/log/cloud.log');
	header('Content-Type: application/force-download');
	header('Content-Disposition: attachment; filename=cloud.log' . "\r\n\r\n");
	header('Content-Length: ' . strlen($file) . "\n\n");
	echo $file;
	exit(0);
case 'single_logfile':
	Helper::exec($is_sbc_vm, '/bin/sync');
	$logfile = $_POST['logfile_name'];
	$path = '/var/log';
	if ($is_sbc_vm && preg_match('/tcpdump.*.pcap/', $logfile)) {
		$path = '/var/log/captures';
	}
	if (Helper::checkInputData('file-exists', $logfile, array($path))) {
		$file = file_get_contents("$path/$logfile");
		header('Content-Type: application/force-download');
		header('Content-Disposition: attachment; filename=' . $logfile . "\r\n\r\n");
		header('Content-Length: ' . strlen($file) . "\n\n");
		echo $file;
	}
	exit(0);
}

if (!file_exists('/var/log/DebugFiles.tar.gz')) {
	exit(0);
}
$bc->delete('root', 'trace-state');

$datestring = get_fulltrace_datestring_for_file($is_sbc_vm);
if ($is_sbc_vm) {
	extract(parse_ini_file('/etc/beroNet/sbc.conf'));
	$fname = "DebugFiles-CloudSBC-{$SBCVM_SERIAL}_{$datestring}.tar.gz";
}
else {
	$fname = 'DebugFiles-'. get_berofix_carduuid() ."_{$datestring}_". get_lifs_for_file() ."_". get_berofix_fw_version() .'.tar.gz';
}

$fcontents = file_get_contents('/var/log/DebugFiles.tar.gz');
header('Content-Type: application/force-download');
header('Content-Disposition: attachment; filename="' . $fname . '"');
header('Content-Length: ' . filesize('/var/log/DebugFiles.tar.gz'));
echo $fcontents;
?>
