<?PHP
$m = 'FulltraceGui';
$berogui_path = "/usr/local/www/berogui";

/* [CHECKING SESSION] */
$newTarget = "/app/berogui/index.php?m=$m";
include($berogui_path .'/includes/session.php');
unset($newTarget);

/* [INCLUDE] */
include('/usr/fallback/beroConf.php');
include_once($berogui_path ."/includes/Helper/Helper.php");
include_once('/usr/local/php/include/fulltrace.Class.php');

$exec_ajax = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
unset($_GET);

/* [CHECKING POST REQUEST] */
if (isset($_POST['data'])) {
	$list_data = array(
		'analog_ports' 				=> 'int-range',
		'analog_ports_select' => 'bool',
		'ft_advanced_options' => 'config-option',
		'fulltrace_type' 			=> 'bool',
	);

	$options_data = array(
		'analog_ports'	=> array('min' => 1, 'max' => 24),
	);

	$data = Helper::sanitizePost($_POST['data'], $list_data, $exec_ajax, $invalid, $options_data);
	unset($_POST['data']);
}

$list_post = array(
	'trace' => 'select',
);

$options_post = array(
	'trace' => array('Start', 'Stop & Download', 'Anhalten & Herunterladen', 'Cancel', 'Abbrechen'),
);

$_POST = Helper::sanitizePost($_POST, $list_post, $exec_ajax, $invalid, $options_post);

/* [EXECUTING AJAX] */
if (!$exec_ajax) {
	echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

$ft = new fulltrace();

$rsp_action = '&action=';
switch ($_POST['trace']) {
	case 'Start':
		$enable = (($data['fulltrace_type'] == '1') ? 1 : 0);
		$ft->start($enable, array(
			'advanced'=> $data['ft_advanced_options'],
			'analog'	=> array(
				'isset'	=> $data['analog_ports_select'] == 1 ? 1 : 0,
				'ports'	=> $data['analog_ports'],
			),
		));
		$rsp_action .= 'start';
		break;
	case 'Stop & Download':
	case 'Anhalten & Herunterladen':
		$ft->stop(false);
		$rsp_action .= 'stop';
		break;
	case 'Cancel':
	case 'Abbrechen':
		$ft->stop(false, 1);
		$rsp_action .= 'stop';
		break;
	default:
		$rsp_action .='default';
		break;
}

echo "<script>window.location='../../index.php?m=$m$rsp_action'</script>";
exit(1);
?>
