<?PHP
$m = 'Logging';
$berogui_path = "/usr/local/www/berogui";

/* [CHECKING SESSION] */
$newTarget = "/app/berogui/index.php?m=$m";
include($berogui_path .'/includes/session.php');
unset($newTarget);

/* [INCLUDE] */
include('/usr/fallback/beroConf.php');
include($berogui_path ."/includes/isgwtelnet.php");
include_once($berogui_path ."/misc/database.php");
include_once($berogui_path ."/includes/Helper/Helper.php");

$exec_ajax = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
unset($_GET);

/* [CHECKING POST REQUEST] */
unset($_POST['m'], $_POST['a'], $_POST['submit']);

$list_post = array(	
	'address' 	  => 'hostname'	, 'port' 	  => 'int-range', 'loglevel_debug'  => 'int-range', 'loglevel_message'     => 'int-range',
	'logging_message' => 'bool'	, 'logging_debug' => 'bool'	, 'syslog_facility' => 'int-range', 'system-check-enabled' => 'bool'	 ,
	'logsizelimit' => 'int-range', 'nlogsizelimit' => 'int-range', 'logging_nmessage' => 'bool',
);

$list_options = array( 	
	'port'			=> array('min' => 0 	, 'max' => 65535 ),
	'loglevel_debug'	=> array('min' => 0 	, 'max' => 9     ),
	'loglevel_message'	=> array('min' => 0 	, 'max' => 2     ),
	'syslog_facility'	=> array('min' => 16	, 'max' => 23    ),
	'logsizelimit'		=> array('min' => 100000, 'max' => 2000000     ),
	'nlogsizelimit'		=> array('min' => 100000, 'max' => 2000000     ),
);

$_POST = Helper::sanitizePost($_POST, $list_post, $exec_ajax, $invalid, $list_options);

/* [EXECUTING AJAX] */
if (!$exec_ajax) {
        echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
        exit(1);
}

$activate_level = 1;

$ba = new beroAri();
$bc = new beroConf('root');

$isgw = new isgwtelnet();
if (($response = $isgw->isgw_login()) == false) {
	echo "<script>window.location='../../index.php?m=$m&isgwerror=1'</script>";
	exit(1);
}

if (($_POST['address'] != "") && ($_POST['port'] != "")) {
	$isgw->logserver($_POST['address'], $_POST['port']);
	$ba->set("logserver", sqlite_escape_string($_POST['address'] . ":" . $_POST['port']));
	$isgw->netlog(1);
}
else {
	$isgw->netlog(0);
}

if ($_POST['logging_message'] == "1") {
	$isgw->logactive_message(1);
	$ba->set("logging_message", 1);
}
else {
	$isgw->logactive_message(0);
	$ba->set("logging_message", 0);
}

if ($_POST['logging_nmessage'] == "1") {
	$isgw->logactive_nmessage(1);
	$ba->set("logging_nmessage", 1);
}
else {
	$isgw->logactive_nmessage(0);
	$ba->set("logging_nmessage", 0);
}

if ($_POST['logging_debug'] == "1") {
	$isgw->logactive(1);
	$ba->set("logging_debug", 1);
}
else {
	$isgw->logactive(0);
	$ba->set("logging_debug", 0);
}

if ($_POST['loglevel_debug'] != "") {
	$isgw->loglevel($_POST['loglevel_debug']);
	$ba->set("loglevel_debug", sqlite_escape_string($_POST['loglevel_debug']));
}

if ($_POST['loglevel_message'] != "") {
	$isgw->loglevel_message($_POST['loglevel_message']);
	$ba->set("loglevel_message", sqlite_escape_string($_POST['loglevel_message']));
}


if (isset($_POST['syslog_facility']) || isset($_POST['system-check-enabled']) || isset($_POST['logsizelimit']) || isset($_POST['nlogsizelimit'])) {
	//Nur wenn syslog facility oder die logsizeilimits verändert wurden, ist ein oranges activate erforderlich
	if ($ba->get('syslog_facility') != $_POST['syslog_facility'] || $bc->get("root", 'system-check-enabled') != $_POST['system-check-enabled']  || $ba->get('logsizelimit') != $_POST['logsizelimit'] || $ba->get('nlogsizelimit') != $_POST['nlogsizelimit']) {
		$activate_level = 2;
	}
	$ba->set("syslog_facility", sqlite_escape_string($_POST['syslog_facility']));
	$bc->set("root", "system-check-enabled", sqlite_escape_string($_POST['system-check-enabled']));
	$ba->set("logsizelimit", sqlite_escape_string($_POST['logsizelimit']));
	$ba->set("nlogsizelimit", sqlite_escape_string($_POST['nlogsizelimit']));
	
}
else {
	$activate_level = 2;
	$ba->set("syslog_facility", "16");
}

Helper::activate($activate_level, true, $m, ACTIVATE);
echo "<script>window.location='../../index.php?m=$m'</script>";
exit(1);
?>
