<?php

/* [INCLUDES] */
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

/* [FUNCTIONS - INTERN] */
function selectOptions(Array &$full_options, Array $to_select) {
	$full_options = array_intersect_key($full_options, array_flip($to_select));
}

/* [FUNCTIONS - EXPORT] */
function updateParametersValues($parameters, $is_vpn_running) {
	// load conf file
	$sbcconf = parse_ini_file('/etc/beroNet/sbc.conf');
	// GENERAL
	if (!$is_vpn_running) {
		$parameters['lanMode']['title'] = 'NETWORK_WAN_MODE_DIS'; 
	}
	selectOptions($parameters['lanMode']['options']['select'], $is_vpn_running ? ['lan-wan'] : ['single']);
	// WAN PARAMETERS
	unset($parameters['wanDhcp']['options']['select']['1'], $parameters['wanIpaddr']['validator-java'], $parameters['wanNetmask']['validator-java'], $parameters['wanGateway']['validator-java']);
	$parameters['wanIpaddr']['disabled'] = $parameters['wanNetmask']['disabled'] = $parameters['wanGateway']['disabled'] = true;
	$parameters['wanDhcp']['default'] = 0;
	// LAN PARAMETERS
	if ($is_vpn_running) {
		unset($parameters['lanDhcp']['options']['select']['1']);
		unset($parameters['lanIpaddr']['validator-java'], $parameters['lanNetmask']['validator-java'], $parameters['lanGateway']['validator-java']);
		$parameters['lanIpaddr']['disabled'] = $parameters['lanNetmask']['disabled'] = $parameters['lanGateway']['disabled'] = true;
		$parameters['lanDhcp']['default'] = 0;
	}
	else {
		unset($parameters['lanDhcp'], $parameters['lanIpaddr'], $parameters['lanNetmask'], $parameters['lanGateway']);
	}
	// NAMESERVER, GATEWAY
	selectOptions($parameters['gatewayMode']['options']['select'], ['manual']);
	selectOptions($parameters['nameserverMode']['options']['select'], ['manual']);
	return $parameters;
}

/* [MAIN] */
$functions = [
	'update'  => 'updateParametersValues',
];

return $functions;
?>
