<?php
$m = 'NetConf';
$berogui = '/usr/local/www/berogui';

/* [GENERAL FUNCTIONS] */
function managePemFile($pem_file, &$info) {
	exec("/usr/local/bin/openssl x509 -in $pem_file -noout -text", $output, $return_cert);
	exec("/usr/local/bin/openssl rsa -in $pem_file -check", $output, $return_privkey);
	if ($return_cert == 1) {
		$info = 3;
		return false;
	}
	else if ($return_privkey == 1) {
		$info = 4;
		return false;
	}

	exec("openssl x509 -modulus -noout -in $pem_file | openssl md5", $output_cert, $return_cert);
	exec("openssl rsa -modulus -noout -in $pem_file | openssl md5", $output_privkey, $return_privkey);
	if ($return_cert == 0 && $return_privkey == 0 && ($output_cert[0] == $output_privkey[0])) {
		@unlink("/usr/conf/berofix.pem");
		exec("/bin/cp $pem_file /usr/conf/berofix.pem");
		$option = 3;
		$info = 4;
		return true;
	}
	$info = 5;
	return false;
}

function subnetworkMatch($ipaddr = null, $netmask = null, $gateway = null) {
	if (is_null($ipaddr) || is_null($netmask)) {
		return false;
	}

	$ip = ip2long($ipaddr);
	$mk = ip2long($netmask);
	$gw = ip2long($gateway);
 
	$gw &= $mk;
    
	return ($ip & $mk) == $gw;
}

/* [CHECKING SESSION] */
$newTarget = "/app/berogui/index.php?m=$m";
include("$berogui/includes/session.php");
unset($newTarget);

/* [CHECKING GET] */
unset($_GET);

/* [CHECKING POST] */
$exec_submit = 1;
$invalid = array();

require_once("$berogui/includes/Helper/Helper.php");
$parameters = require("$berogui/modules/NetConf/netconf_parameters.php");
Helper::setDataValidator($parameters, $list_data, $options_data);

if (isset($_POST['data'])) {
	$data = Helper::sanitizePost($_POST['data'], $list_data, $exec_submit, $invalid, $options_data);
}

$action = $_POST['action'];
$id = isset($_POST['id']) ? Helper::sanitizePost($_POST['id'], 'int>=0', $exec_submit, $invalid) : 0;
unset($_POST);

/* [EXECUTING SUBMIT] */
if (!$exec_submit) {
	echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

require_once('/usr/fallback/beroConf.php');
$bc = new beroConf('root');

$activate = 1;
switch ($action) {
	case 'saveNwAdvanced':
		// manage data
		if ($data['vlanEnable'] == 0) {
			foreach (array('vlanId', 'vlanPrio') as $vlan) {
				unset($data[$vlan]);
				$bc->delete('root', $parameters[$vlan]['db-key']);
			}
		}
		$activate = 3;
		break;
	case 'saveNwHttps':
		// manage error certificate
		$file_error = '/tmp/error_certificate.log';
		if ($data['errorCert'] && file_exists($file_error)) {
			exec("/bin/rm -f $file_error");
			unset($data['errorCert']);
		}
		// manage uploaded file
		if ($_FILES['uploadFile']['name'] != '') {
			if ($_FILES['uploadFile']['size'] > 51200) { // 50kB
				echo "<script>window.location='../../index.php?m=$m&error=2'</script>";
				exit(1);
			}
			else {
				if (file_exists($file_error)) {
					exec("/bin/rm -f $file_error");
				}
				$info = 0;
				if (managePemFile($_FILES['uploadFile']['tmp_name'], $info)) {
					$bc->set('root', 'httpsOnly', sqlite_escape_string($data['httpsOnly']));
					echo "<script>window.location='../../index.php?m=$m&success=$info'</script>";
					Helper::activate(3);
					exit(1);
				}
				echo "<script>window.location='../../index.php?m=$m&error=$info'</script>";
				exit(1);
			}
		}
		break;
	case 'saveNwRouting':
		$routing = explode(',', $bc->get('root', $parameters['routing']['db-key']));
		$routing[$id] = implode('/', array($data['routeNet'], $data['routeNetmask'], $data['routeGateway']));
		unset($data);
		$data['routing'] = implode(',', $routing);
		$activate = 3;
		break;
	case 'saveNwSettings':
		// manage data
		foreach ($data as $key => $value) {
			if (strlen($value) == 0) {
				unset($data[$key]);
			}
			else if (is_array($value)) {
				$value = array_filter($value);
				if (empty($value)) {
					unset($data[$key]);
				}
				else {
					$data[$key] = implode(';', $value);
				}
			}
		}
		// manage manual gateway
		if ($data['gatewayMode'] == 'manual') {
			if (subnetworkMatch($data['lanIpaddr'], $data['lanNetmask'], $data['gatewayManual'])) {
				$data['lanGateway'] = $data['gatewayManual'];
			}
			else if (subnetworkMatch($data['wanIpaddr'], $data['wanNetmask'], $data['gatewayManual'])) {
				$data['wanGateway'] = $data['gatewayManual'];
			}
			else {
				## gateway value does not match LAN or WAN subnet. return error
				echo "<script>window.location='../../index.php?m=$m&error=6'</script>";
				exit(1);
			}
		}
		else {
			unset($data['gatewayManual']);
		}
		// manage ifaces
		foreach (array('lan', 'wan') as $iface) {
			if ($data["{$iface}Dhcp"] == 1) {
				unset($data["{$iface}Ipaddr"], $data["{$iface}Netmask"]);
			}
		}
		// manage nameserver
		if ($data["nameserverMode"] != 'manual') {
			unset($data['nameserverManual']);
		}
		// clean on submit
		foreach ($parameters as $param) {
			if ($param['cleanOnSubmit']) {
				$bc->delete('root', $param['db-key']);
			}
		}
		// activate
		$activate = 3;
		break;
	default:
		echo "<script>window.location='../../index.php?m=$m&error=1&request=unknown&checkor=select&key=action'</script>";
		exit(1);
}

// update beroConf
foreach ($data as $key => $value) {
	$bc->set('root', $parameters[$key]['db-key'], sqlite_escape_string($value));
}

// activate and redirect
Helper::activate($activate);
echo "<script>window.location='../../index.php?m=$m&success=$activate'</script>";

exit(0);
?>
