<?php

/**
 * Implementiert das Hochladen und Löschen von SIP Profilen
 *
 * @author Florian Kraatz <fk@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');
require_once('/usr/local/php/include/sipProfileDownloader.Class.php');

class ProfileManagement {

	function __construct($m, $get = array(), $post = array(), $session = array()) {
		// TODO: when SIP-Profile will be added
	}

	function getTab($profiles, $i, $category) {
		$ret = '<div id="tabs-' . $i . '">' .
			'<table class="table table-striped table-bordered" >';

		foreach ($profiles as $profile) {
			$ret .= '<tr><td>' . $profile . '</td><td><img src="./includes/images/delete.png" onclick="del(\'' . $profile . '\',\'' . $category . '\');" /></td></tr>';
		}

		$ret .= '</table>' .
			'</div>';

		return($ret);
	}

	function _upload() {
		$filename = $_FILES['uploadfile']['name'];
		$ext = pathinfo($filename, PATHINFO_EXTENSION);
		if ($ext=="tar"){
			return $this->_uploadTar();
		}else{
			return $this->_uploadSingle();
		}
	}

	function _uploadSingle($tmp_file=null,$file_name=null, $file_size=null){
		require_once "./includes/profileParser.php";
		if ($file_name===null && $file_size===null && $tmp_file===NULL){
			$file_name = $_FILES["uploadfile"]["name"];
			$tmp_file = $_FILES["uploadfile"]["tmp_name"];
			$file_size = $_FILES["uploadfile"]["size"];
		}
		if ($file_name != "") {
			if ($file_size > 102400) { //100 kB
				$ret.="<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'>" . SIP_STACKS_FILE_SIZE_DIS . "</font></div>";
			} else {
				$profileParser = new profileParser('', $tmp_file);
				$name = $profileParser->getName();
				$category = $profileParser->getType();
				$version = $profileParser->getVersion();
				$profileParserOld = new profileParser($category . "-" . $name);
				if ($profileParserOld!==NULL)
					$versionOld = $profileParserOld->getVersion();
				else
					$versionOld=0;
				if ($version > $versionOld) {
					if (!is_dir("/usr/conf/profile/" . $category))
						mkdir("/usr/conf/profile/" . $category);
					copy($tmp_file, "/usr/conf/profile/" . $category . "/" . $name);
					$ret.="<div class='text-center'><img src='./includes/images/punkt_gruen.gif'><font color='black'>" . SIP_STACKS_UPLOAD_SUCCESS_DIS . " ($name)</font></div>";
				}else{
					$ret.="<div class='text-center'><img src='./includes/images/punkt_rot.gif'><font color='red'>Please upload a newer version ($name)</font></div>";
				}
			}
		}
		return $ret;
	}

	function _uploadTar(){
		$tmp_file = $_FILES["uploadfile"]["tmp_name"];
		@mkdir('/tmp/profile');
		exec('tar -xf '.$tmp_file.' -C /tmp/profile');
		$dh = @opendir("/tmp/profile");
		if (false === $dh) {
		    return false;
		}
		while ($file = readdir($dh)) {
		    if ("." == $file || ".." == $file)
			continue;
		    $ret.=$this->_uploadSingle('/tmp/profile/'.$file,$file, filesize('/tmp/profile/'.$file));
		    unlink('/tmp/profile/'.$file);
		}
		return $ret;
	}

	function uploadTab($i) {
		$ret = '<div id="tabs-' . $i . '">' .
			"<form name='sip_general' id='sip_general' action='' method='POST' ENCTYPE='multipart/form-data'>" .
			"<b>" . PROFILE_MANAGEMENT_UPLOAD_PROFILE . " : </b><input type='file' size='28' name='uploadfile'><br />" .
			"<input name='submit' class='btn btn-default' type='submit' value='" . BUTTON_UPLOAD . "'>" .
			'</form>' .
			'</div>';

		return($ret);
	}

	function downloadTab ($index) {

		$ProfDown = new sipProfileDownloader();
		$sipProfiles = $ProfDown->readProfileList();

		$ret =	'<div id="tabs-' . $index . '">' . "\n" .
			'<table class="table table-striped">' . "\n" .
			'<tr><th>' . SIP_PROFILE_NAME . '</th><th>' . SIP_PROFILE_VERS . '</th>' .
			'<th>' . SIP_PROFILE_DESC . '</th><th>' . SIP_PROFILE_ACTN . '</th></tr>' . "\n";
		foreach ($sipProfiles as $s) {
			$ret .= '<tr><td>' . $s['name'] . '</td><td>' . $s['version'] . '</td><td>' . $s['meta-text'] . '</td>' . "\n" .
				'<td>' . "\n" .
				'<form name="sip_download" id="sip_general" method="POST">' . "\n" .
				'<input type="hidden" name="url" value="' . $s['url'] . '" />' . "\n" .
				'<input type="submit" class="btn btn-default" name="submit_down" value="' . BUTTON_DOWNLOAD . '">' . "\n" .
				'</form>' . "\n" .
				'</td>' . "\n" .
				'</tr>' . "\n";
		}
		$ret .=	'</table>' . "\n" .
			'</div>';

		return($ret);
	}

	function display() {
		require_once './includes/Helper/HelperSipProfile.php';

		// build page content
		$name = "PROFILE_MANAGEMENT_TITLE_DIS";
		include('./includes/header.php');

		$ret .= '<br />' . "\n";
		if (isset($_POST['submit'])) {
			$ret.=$this->_upload();
		}

		if (isset($_POST['submit_down'])) {
			$ProfDown = new sipProfileDownloader();
			if ($ProfDown->downloadProfile($_POST['url']) == false) {
				$ret .= '<div class="text-center" style="color: red;">' . "\n" .
					'<img src="/app/berogui/includes/images/punkt_rot.gif" />' . "\n" .
					'Error downloading <span style="font-weight: bold;">\'' . basename($_POST['url']) . '\'</span>!' . "\n" .
					'</div>' . "\n";
			} else {
				$ret .= '<div class="text-center">' . "\n" .
					'<img src="/app/berogui/includes/images/punkt_gruen.gif" />' . "\n" .
					'<span style="font-weight: bold;">\'' . basename($_POST['url']) . '\'</span> has been downloaded and installed!' . "\n" .
					'</div>' . "\n";
			}
		}

		$ret .= "<br />
			<script>
			function del(file,category){
				conf = confirm('" . PROFILE_MANAGEMENT_DELETE_MESS_DIS . " '+file+'?');
				if (conf==false)
					return false;
				else
					window.location='./misc/deletefile.php?option=profile&file='+file+'&m=" . $_GET['m'] . "&category='+category;
			}
				$(function() {
					$( \"#tabs\" ).tabs();
				});
				</script>";
		$ret .= '<div id="tabs" class="">' . "\n" .
			'<ul>' . "\n";
		$categories = HelperSipProfile::getCategories();
		$i = 1;
		foreach ($categories as $category) {
			$ret.='<li><a href="#tabs-' . $i++ . '">' . $category . '</a></li>';
		}
		$ret .=	'<li><a href="#tabs-' . $i++ . '">' . BUTTON_UPLOAD . '</a></li>' . "\n" .
			'<li><a href="#tabs-' . $i++ . '">' . BUTTON_DOWNLOAD . '</a></li>' . "\n" .
			'</ul>';
		$i = 1;
		foreach ($categories as $category) {
			$ret .= $this->getTab(HelperSipProfile::getProfiles($category), $i++, $category);
		}
		$ret .=	$this->uploadTab($i++) .
			$this->downloadTab($i++) .
			'</div>' . "\n";

		return $ret;
	}

}
