<?php
$berogui = '/usr/local/www/berogui';
require_once("$berogui/includes/Helper/Helper.php");
require_once("$berogui/includes/Helper/HelperHtml.php");

class Provisioning {
	
	private $_bc = null;

	private	$m_attr;

	private	$post_attr,
					$post_checked = 0;

	private	$isRequestRejected = 0,
					$reasonRejected = array();

	private $_data = array();

	private $_tabs = array(
						// provisioning settings
						0 => array(
							'display' => '_displayTabSettings',
							'form'		=> array(
								'action'=> 'saveProSettings',
								'id' 		=> 'provisioning',
								'name'	=> 'provsettings',
								'style'	=> 'margin-top:15px;',
								'uri' 	=> 'Provisioning/provisioning_submit.php',
							),
							'key'			=> 'provisioning-settings',
							'title'		=> 'PROVISIONING_SETTINGS_HEADER_DIS',
						),
						// client certificate; managed by beroCloud
						//// master certificate
						/////// must be deleted to upload own certificate
						/////// but do not overwrite if own certificate uploaded
						1 => array(
							'display'	=> '_displayTabClientCertificate',
							'files'		=> array(),
							'form'		=> array(
								'action'=> 'modules/Provisioning/provisioning_submit.php',
								'id' 		=> 'provisionig-tls',
								'name'	=> 'cc-provisionong-tls',
								'style'	=> 'margin-top:15px;',
							),
							'key'			=> 'provisioning-client-cert',
							'title'		=> 'PROVISIONING_CLIENT_CERTIFICATE_HEADER_DIS',
						),
						// own certificate uploaded
					  //// slave certificate
						//// must be deleted to use certificate from beroCloud
						//// but no not overwrite if beroCloud uploaded
					  2 => array(
							'display' => '_displayTabCertificateUpload',
							'files'		=> array(),
							'form'    => array(
								'action' => 'modules/Provisioning/provisioning_submit.php',
								'id'     => 'upload-crts',
								'name'   => 'upload_crts',
								'style'  => 'margin-top:15px;',
							),
							'key'     => 'provisioning-upload-cert',
							'title'   => 'PROVISIONING_UPLOAD_CERTIFICATE_HEADER_DIS',
						),
						// troubleshooting
						//// offer mechanism to troubleshoot the provisioning server
						//// give the possibility to use different TLS configuration
						//// can preserve the configuration
						3 => array(
							'display' => '_displayTabTroubleshoot',
							'form'    => array(
                'action' => null,
								'id'     => 'tbshoot-prov',
								'name'   => 'tbshoot_prov',
								'style'  => 'margin-top:15px;',
							),
							'key'     => 'provisioning-troubleshoot',
							'title'   => 'PROVISIONING_TROUBLESHOOT_HEADER_DIS',
						),
					);

	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->m_attr = $m;

		// check submit result
		if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			$this->reasonRejected = $get;
			unset($get);
		}

		// init TLS files
		$tlsFiles = rootHelper::tlsGetCertificate();
		$this->_tabs[1]['files'] = $tlsFiles;
		$this->_tabs[2]['files'] = $tlsFiles;

		// load beroConf
		include('/usr/fallback/beroConf.php');
		$this->_bc = new beroConf('root');

		// load parameters
		$this->_parameters = require('/usr/local/www/berogui/modules/Provisioning/provisioning_parameters.php');

		// certificate exist. 
		//// same mechanism for tab1 and tab2
		foreach (array('caCrt', 'clientCrt') as $file) {
			if (file_exists($this->_tabs[1]['files'][$file])) {
				// fetch info from certificates
				foreach (array('enddate' => 'notAfter', 'issuer' => 'issuer', 'subject' => 'subject') as $key => $param) {
					$ret = Helper::exec(0, "/usr/local/bin/openssl x509 -in {$this->_tabs[1]['files'][$file]} -noout -$key");
					if (preg_match("/$param=(.*)/", $ret, $matched)) {
						if (preg_match_all('/(?<what>[a-zA-Z]+)=(?<value>[^\/]+)/', $matched[1], $mtchd)) {
							$this->_data[$file][$key] = array_combine($mtchd['what'], $mtchd['value']);
						}
						else {
							$this->_data[$file][$key] = $matched[1];
						}
						unset($mtchd, $matched);
					}
				}
			}
		}

		// manage tabs to be displayed
		//// display tab1 or tab2 depending who signed the certificate
		if (isset($this->_data['clientCrt']['enddate'])) {
			if (rootHelper::tlsIsSignedByBerocloud()) {
				unset($this->_tabs[2]);
			}
			else {
				//// gather md5 for crt and key (they must match)
				//// only displayed when uploaded
				if (file_exists($this->_tabs[2]['files']['clientCrt'])) {
					$this->_data['clientCrt']['md5'] = rootHelper::exec(0, "/usr/local/bin/openssl x509 -noout -modulus -in {$this->_tabs[2]['files']['clientCrt']} | /usr/local/bin/openssl  md5 | /usr/bin/awk '{ print $2; }'");
				}
				if (file_exists($this->_tabs[2]['files']['clientKey'])) {
					$this->_data['clientKey']['md5'] = rootHelper::exec(0, "/usr/local/bin/openssl rsa -noout -modulus -in {$this->_tabs[2]['files']['clientKey']} | /usr/local/bin/openssl md5 | /usr/bin/awk '{ print $2; }'");
				}
				unset($this->_tabs[1]);
			}
		}
		//// no crt
		else {
			unset($this->_tabs[1]);
		}

		// provisioning disable => no troubleshooting
		if (in_array($this->_bc->get('root', 'provisioning_mode'), array('off', ''))) {
			unset($this->_tabs[3]);
		}
		else {
			// troubleshooting enabled => fetching the troubleshooting configuration
			foreach ($this->_parameters[3] as $key => $params) {
				$value = $this->_bc->get('root', $params['db-key']);
				$this->_data[$key] = strlen($value) ? $value : $params['default'];
			}
		}
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML Seite
	 */
	public function display() {
		$name = "PROVISIONING_TITLE_DIS";
		include('./includes/header.php');
		include_once('./includes/lang.php');
		$ret .= "\n";

		$tabs = "";
		$tabs_menu = "";
		foreach ($this->_tabs as $id => $tab) {
			$tabs_menu .= "\t\t<li><a href='#tabs-$id'>". constant($tab['title'])  ."</a></li>\n";

			$function = $tab['display'];
			$tabs .= $this->$function($id, $tab['form'], "\t");
		}

		$msg = '';
		if ($this->isRequestRejected) {
			switch ($this->reasonRejected['error']) {
			case 1:
				$msg = Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
				break;
			case 2:
				$msg = Helper::displayErrorUpload($this->reasonRejected['code']);
				break;
			case 3:
				$msg = "<div class='text-center' style='margin-top:20px;color:red;'>". PROVISIONING_SUBMIT_ERRORTYPE_DIS .": {$this->reasonRejected['type']}</div>\n";
				break;
			case 4:
				$msg = "<div class='text-center' style='margin-top:20px;color:red;'>". PROVISIONING_SUBMIT_ERRORMD5_DIS ."</div>\n";
				break;
			case 5:
				$msg = "<div class='text-center' style='margin-top:20px;color:red;'>". PROVISIONING_SUBMIT_ERRORACTION_DIS ."</div>\n";
				break;
			}
		}

		$ret .= HelperHtml::buildTabs('tabs', $msg, $tabs_menu, $tabs);
		return($ret);
	}

	/* [PRIVATE METHODS] */
	private function _displayParameter($id, $param, $value, $tab = "", $what = null) {
		$function = $this->_parameters[$id][$param]['display'];
		if (strlen($value) > 34) {
			// when value bigger the field size, adding it to tooltip
			$this->_parameters[$id][$param]['tooltip'] = $value;
		}
		$ret = HelperHtml::$function(is_null($what) ? $param : "{$what}_{$param}", $value, $this->_parameters[$id][$param], $tab);
		$this->_parameters[$id][$param]['tooltip'] = '';
		return($ret);
	}

	private function _displayTabCertificateUpload($id, $form, $tab = "") {
		// build upload form
		$content['main-form'] = '';
		foreach (array('upload_ca', 'upload_crt', 'upload_key') as $what) {
			$content['main-form'] .= $this->_displayParameter($id, $what, $this->_data[$what], "$tab\t");
		}
		$content['main-form'] .= HelperHtml::buttons('uploadTLS', 'BUTTON_UPLOAD', array('action' => 'upload', 'style' => 'margin-top:20px;'), "$tab\t\t");

	  // CRTs have been uploaded. 1st form becomes info displayer / 2nd	becomes upload form
		if (file_exists($this->_tabs[$id]['files']['clientCrt']) || file_exists($this->_tabs[$id]['files']['caCrt'])) {
			$content['2nd-form'] = "$tab\t<hr style='width:75%;'>\n"
				                   . HelperHtml::form($content['main-form'], $form);

			$form = array();
			$content['main-form'] = '';
			foreach (array('PROVISIONING_UPLOAD_CA_DIS' => 'caCrt', 'PROVISIONING_UPLOAD_CRT_DIS' => 'clientCrt') as $header => $crt) {
				if ($crt === 'clientCrt') {
					$content['main-form'] .= "$tab\t<hr style='width:25%;'>\n";
				}
				$content['main-form'] .= "$tab\t<p class='text-center lead'>". constant($header) ."</p>\n";
				// we use the same parameter than tab1
				$content['main-form'] .= $this->_displayParameter((int)($id-1), 'enddate', strlen($this->_data[$crt]['enddate']) ? $this->_data[$crt]['enddate'] : PROVISIONING_UPLOAD_CRT_MISSING, "$tab\t", $crt);
				$content['main-form'] .= $this->_displayParameter((int)($id-1), 'CN', strlen($this->_data[$crt]['subject']['CN']) ? $this->_data[$crt]['subject']['CN'] : PROVISIONING_UPLOAD_CRT_MISSING, "$tab\t", $crt);
			}
			// display the end
			//// client md5 and key md5
			$content['main-form'] .= $this->_displayParameter($id, 'md5', strlen($this->_data['clientCrt']['md5']) ? $this->_data['clientCrt']['md5'] : PROVISIONING_UPLOAD_KEY_MISSING, "$tab\t", 'clientCrt')
				                    .  "$tab\t<hr style='width:25%;'>\n"
				                    .  "$tab\t<p class='text-center lead'>". PROVISIONING_UPLOAD_KEY_DIS ."</p>\n"
														.  $this->_displayParameter($id, 'md5', strlen($this->_data['clientKey']['md5']) ? $this->_data['clientKey']['md5'] : PROVISIONING_UPLOAD_KEY_MISSING, "$tab\t", 'clientKey');
		}
		// CRTs not uploaded. reorganize the form
		else {
			$form['uri'] = 'Provisioning/provisioning_submit.php';
			unset($form['action']);
		}
		return(HelperHtml::tab($id, $form, null, $content, null, $tab));
	}

	private function _displayTabClientCertificate($id, $form, $tab = "") {
		$content['main-form'] = $this->_displayParameter($id, 'enddate', $this->_data['clientCrt']['enddate'], "$tab\t");
		foreach (array('PROVISIONING_CC_SUBJECT_DIS' => 'subject', 'PROVISIONING_CC_ISSUER_DIS' => 'issuer') as $header => $what) {
			$content['main-form'] .= "$tab\t<hr style='width:25%;'>\n"
														.	 "$tab\t<p class='text-center lead'>". constant($header) ."</p>\n";
			foreach ($this->_data['clientCrt'][$what] as $key => $value) {
				$content['main-form'] .= $this->_displayParameter($id, $key, $value, "$tab\t", $what);
			}
		}

		$btns = array(
			// download
			0 => array(
				'form'   => array(
					'action' => 'misc/files_download.php',
					'id'     => 'id-prov-cc-btn',
					'method' => 'GET',
					'name'   => 'prov_cc_btn',
				),
				'option' => 'provisioning-cc',
				'tooltip'=> PROVISIONING_CC_DOWNLOAD_TOOLTIP_BTN,
				'value'  => PROVISIONING_CC_DOWNLOAD_BTN,
			),
			// remove
			1 => array(
				'form'   => array(
					'action' => 'modules/Provisioning/provisioning_submit.php',
					'id'     => 'id-prov-rm-btn',
					'method' => 'POST',
					'name'   => 'prov_rm_tbn',
				),
				'action' => 'delete',
				'tooltip'=> PROVISIONING_CC_REMOVE_TOOLTIP_BTN,
				'value'  => PROVISIONING_CC_REMOVE_BTN, 
			),
		);

		$content['2nd-form'] = 	"$tab\t<hr style='width:25%;'>\n"
			                   .	HelperHtml::actionButtonsInline($btns, $tab);

		return(HelperHtml::tab($id, $form, null, $content, null, $tab));
	}

	private function _displayTabSettings($id, $form, $tab = "") {
		// build javascript
		ob_start();
		?>
		<script  type="text/javascript">
			$("#provisioning").validate({
				rules: {
					provisioning_url: {
						checkUrl: true,
					},
					provisioning_useragent: {
						checkManual: true,
					},
				}
			});
		</script>
		<?php
		$javascript = ob_get_clean();
		$content['main-form'] = $this->dynamic_table();
		return(HelperHtml::tab($id, $form, $javascript, $content, null, $tab));
	}

	private function _displayTabTroubleshoot($id, $form, $tab = "") {
		$tbs = array(
			'btn'  => 'tbsBtn',
			'test' => 'tbsTest',
			'wait' => 'tbsWait',
		);
		ob_start();
		?>
    <script type="text/javascript">
			$(document).ready(function () {
				$('#<?php echo $form['id']; ?> input').bind('keyup blur click', function () {
					if ($('#<?php echo $form['id']; ?>').validate().checkForm()) {
						$('#<?php echo $tbs['test']; ?>').removeClass('button_disabled').prop('disabled', false);
					}
					else {
						$('#<?php echo $tbs['test']; ?>').addClass('button_disabled').prop('disabled', true);
					}
				});
				$("#<?php echo $tbs['test']; ?>").click(function() {
					if ($('#url').val() === '') {
						return(false);
					}
					document.getElementById("<?php echo $tbs['btn']; ?>").style.display = "none";
					document.getElementById("<?php echo $tbs['wait']; ?>").style.display = "block";
					$.ajax({
					  cache: false,
					  data: {
					    url: $('#id_url').val(),
						  verifyhost: $('#id_verifyhost').val(),
						  verifypeer: $('#id_verifypeer').val(),
						  debug: $('#id_debug').is(':checked'),
					  },
						error: function (testStatus, errorThrown) {
              document.getElementById("<?php echo $tbs['wait']; ?>").style.display = "none";
						  document.getElementById("<?php echo $tbs['btn']; ?>").style.display = "block";
						},
            success: function(res) {
							var data = JSON.parse(res);
							Object.keys(data).forEach(id => {
								$(id).show();
								try {
							  	$(id).html(atob(data[id]));
								}
								catch (e) {
									$(id).html(data[id]);
								}
						  });
              document.getElementById("<?php echo $tbs['wait']; ?>").style.display = "none";
							document.getElementById("<?php echo $tbs['btn']; ?>").style.display = "block";
						},
						timeout: 10000,
						type: 'POST',
						url: 'modules/Provisioning/provisioning_ajax.php',
					});
					return(false);
				});
			});
    </script>
		<?php
		$javascript = ob_get_clean();

		$content = array('main-form' => "$tab\t<div id='ajaxResult' class='text-center' style='display:none;margin-bottom:25px;'></div>");
		foreach (array_keys($this->_parameters[$id]) as $param) {
			$parameter = $this->_parameters[$id][$param];

			$function = $parameter['display'];
			$content['main-form'] .= HelperHtml::$function($param, $this->_data[$param], $parameter, "$tab\t\t");
		}

		$content['main-form'] .= HelperHtml::fieldButtonTest($tbs['wait'], $tbs['btn'], $tbs['test']);

		$content['2nd-form'] .= "$tab\t<div id='logTest' style='overflox:auto;padding-left:10px;background-color:#F0F0F0;border:2px dashed #CCCCCC;height:200px;width:90%;margin:auto;margin-top:25px;overflow-y:scroll;scroll-behavior:smooth;display:none;'></div>\n"
			                   .  "<hr style='width:50%;'>\n"
			                   .  HelperHtml::fieldNote(PLEASE_NOTE, PROVISIONING_PLEASENOTE_MESSAGE_DIS, array('width' => '75%'));

		return(HelperHtml::tab($id, $form, $javascript, $content, null, $tab));
	}

	/**
	 * Generiert das HTML Formular und speichert die Einstellungen
	 * @return string HTML Formular
	 */

	function dynamic_table() {
		$bc = $this->_bc;

		$table = '';
		$selmode = $bc->get('root', 'provisioning_mode');

		$useragent = $bc->get('root', 'provisioning_useragent');
		if (!strlen($useragent)) {
			$useragent = 'beroNet VoIP Gateway';
		}
		ob_start();
		?>
		<div class='form-group' id="prov_mode">
			<label for='provisioning_mode' class='col-sm-5 control-label'><?php echo PROVISIONING_MODE_DIS ?></label>
			<div class='col-sm-4'>
				<select name="provisioning_mode" class="form-control input-sm">
					<?php foreach (array('off', 'once', 'always') as $mode): ?>
						<option value="<?php echo $mode ?>" <?php echo (($mode == $selmode) ? ' selected' : '') ?>><?php echo $mode ?></option>
					<?php endforeach; ?>
				</select>
			</div>
		</div>
		<div class='form-group' id="prov_url">
			<label for='provisioning_url' class='col-sm-5 control-label'><?php echo PROVISIONING_URL_DIS ?></label>
			<div class='col-sm-4'>
				<input type="text" class="form-control input-sm" name="provisioning_url" value="<?php echo $bc->get('root', 'provisioning_url') ?>">
			</div>
		</div>
		<div class='form-group' data-toggle='tooltip' title='<?php echo PROVISIONING_USERAGENT_TOOLTIP . $useragent; ?>'>
			<label for='sip_bindport_<?php echo $network_interface; ?>' class='col-sm-5 control-label'><?php echo PROVISIONING_USERAGENT_DIS ?></label>
			<div class='col-sm-4'>
				<input type='text' class='form-control input-sm' name='provisioning_useragent' maxlength='150' value='<?php echo $useragent; ?>' required>
			</div>
		</div>
		<div class='form-group' id="poll_int">
			<label for='polling_interval' class='col-sm-5 control-label'><?php echo PROVISIONING_POLLING_INTERVAL_DIS ?></label>
			<div class='col-sm-4'>
				<input type="text" class="form-control input-sm" name="polling_interval" digits="true" value="<?php echo $bc->get('root', 'polling_interval') ?>" min="0">
			</div>
		</div>
		<div class="text-center" style='margin-top:20px;'>
			<input type="hidden" name="action" value="save">
			<input type="submit" name="submit" class="btn btn-default" value="<?php echo BUTTON_SAVE ?>">
		</div>
		<?php
		if (strlen(($provConfigMd5 = $bc->get('root', 'provisioning_config_md5'))) == 0) {
			$table .= ob_get_clean();
			return $table;
		}
		?>
		<br>
		<br>
		<p class="text-center lead"><?php echo PROVISIONINGMD5_TABLE_HEADER_DIS ?></p>
		<form name="provMd5" action="" method="POST">
			<div class="text-center">
				<p><?php echo $bc->get('root', 'provisioning_config_md5'); ?></p>
				<input type="hidden" name="action" value="deleteMd5"/>
				<input type="submit" class="btn btn-default" value="<?php echo BUTTON_DELETE; ?>">
			</div>
		</form>

		<?php
		$table .= ob_get_clean();

		return($table);
	}

}
?>
