<?php

/**
 * Implementiert die Konfiguration der Hardware-Parameter für die Line Interfaces
 * @author Miguel Palmer <mp@beronet.com>
 */

include('/usr/local/www/berogui/includes/isgwtelnet.php');
include_once('/usr/www/include/SQLite2ToSQLite3.php');

function _isMatch($type, $regex) {
	return(preg_match($regex, $type));
}

class PstnHardware {
	
	private		$m_attr,
			$ltescan_attr;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	private		$countries_list = array();

	function __construct($m = '', $get = array(), $post = array(), $session = array()) {
		$this->m_attr = $m;
		$this->ltescan_attr = isset($get['ltescan']) ? Helper::sanitizeGet($get['ltescan'], 'int>0') : 0; 
		$this->tdmreset_attr = isset($get['tdmreset']) ? Helper::sanitizeGet($get['tdmreset'], 'int>0') : 0;
		
		require_once('/usr/local/www/berogui/includes/Helper/HelperPstn.php');
		$this->countries_list = HelperPstn::getCountriesList();

                // get error from modal or submit execution
		if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}
	}

	/**
	 * Holt den Clock Parameter (Synchronization port) aus der Datenbank
	 * @param int $lo Line Interface Nummer
	 * @param string $type Line Interface Name
	 * @param beroAri $database Datenbank Instanz
	 * @return string  HTML Dropdown-Menu
	 */

	function getClock($li, $type, $database) {
		$res.="<span id='sync_port_li" . $li . "'><div class='col-sm-3'>&nbsp;&nbsp;" . HARDWARE_SYNC_PORT_DIS . ":</div><div class='col-sm-2'><select class='form-control' name='sync_li" . $li . "' onmouseover=\"Tip('" . ISDNHW_MASTER . "')\" onmouseout='UnTip()'>";

		//ISDN Auto
		if ($type != 'bf1t1e1' && $type != 'bf2t1e1' && $type != 'bf4t1e1' && $type != 'bf2E1' && $type != 'bf1E1') {
			($database->get('sync_port_auto' . $li) == 1) ? $selected = "selected" : $selected = "";
			$res.="<option value='auto' $selected>Auto</option>";
		}

		//Crystal - Gilt für alle
		if ($type != 'bf2E1' && $type != 'bf1E1') {
			($database->get('sync_port_li' . $li) == 1) ? $selected = "selected" : $selected = "";
			$res.="<option value='crystal' $selected>Crystal</option>";
		}

		//ISDN lif
		$query = $database->select("select port, clock from isdn where lif='" . $li . "' and type!='bf2t1e1' and type!='bf1t1e1' and type!='bf4t1e1' and port_type!='FXS'");
		while ($entry = $database->fetch_array($query)) {
			($entry['clock'] == 1) ? $selected = "selected" : $selected = "";
			$res.="<option value='isdn-" . $entry['port'] . "' $selected>" . $entry['port'] . "</option>";
		}

		//CAS lif
		$query = $database->select("select port, clock from cas where lif='" . $li . "'");

		while ($entry = $database->fetch_array($query)) {
			($entry['clock'] == 1) ? $selected = "selected" : $selected = "";
			$res.="<option value='cas-" . $entry['port'] . "' $selected>" . $entry['port'] . "</option>";
		}

		$res.="</select></div></span>";

		return $res;
	}

	/**
	 * Generiert die Graphische Darstellung der Line Interfaces (nicht benutzbar von Gateways mit 3 Line Interfaces)
	 */

	function graphic($database) {
		$form_elements = "<script>
			$(function() {
				\$( \"#accordion\" ).accordion({ collapsible: true, autoHeight: true, active: false });
			});
			</script>
			<div id='accordion' style='width:510px; margin-left:auto; margin-right:auto;'>
				<h3><a href='#'>" . HARDWARE_GRAPHIC_DIS . "</a></h3>
				<div><div >
					<div id='port1' style='z-index:3; position:absolute; width:95px; font-size:1.2em; margin-top:163px; margin-left:5px;'></div>
					<div id='port2' style='z-index:4; position:absolute; width:95px; font-size:1.2em; margin-top:163px; margin-left:111px;'></div>
					<div id='port3' style='z-index:5; position:absolute; width:95px; font-size:1.2em; margin-top:163px; margin-left:213px;'></div>
					<div id='port4' style='z-index:6; position:absolute; width:95px; font-size:1.2em; margin-top:163px; margin-left:315px;'></div>
					<div id='bild1' style='z-index:3; position:absolute; margin-top:93px; margin-left:5px;'></div>
					<div id='bild2' style='z-index:4; position:absolute; margin-top:93px; margin-left:110px;'></div>
					<div id='bild3' style='z-index:5; position:absolute; margin-top:93px; margin-left:211px;'></div>
					<div id='bild4' style='z-index:6; position:absolute; margin-top:93px; margin-left:312px;'></div>
					</div>
					<div style='height:205px'><img src='./includes/images/Zeichnung.png' title='Image Ports'></div>
				</div>
			</div>";

		$portswitch = $database->get("portswitch");
		$query = $database->select('SELECT type  FROM gsm WHERE lif="1"');
		$lif1 = sqlite_fetch_single($query);

		//Portswitch oder GSM
		if ($portswitch == 1 || $lif1 == "bf2GSM" || $lif1 == "bf1GSM" || $lif1 == "bf2LTE") {
			$q = $database->select("SELECT port, port_type FROM isdn WHERE lif='0' and type!='bf2t1e1' and type!='bf1t1e1' and type!='bf4t1e1' union "
				. "SELECT port, port_type FROM analog WHERE lif='0'  union SELECT port, port_type FROM gsm WHERE lif='0' union "
				. "SELECT port, port_type FROM lte WHERE lif='0' union SELECT port, port_type FROM cas WHERE lif='0'  order by port_type, port");
			$i = 1;
			while ($ent = $database->fetch_array($q)) {
				$form_elements.="<script>
					$(document).ready(function() {
						document.getElementById('bild" . $i . "').innerHTML='<img src=\"./includes/images/Zeichnung-2.png\" title=\"Image Ports\">';
						document.getElementById('port" . $i . "').innerHTML='<div class=\"text-center\">" . $ent['port_type'] . $ent['port'] . "</div>';
					});
					</script>";
				$i++;
			}

			//Besonderer Fall, wenn das LI1 GSM ist, wird Portswitch per default aktiviert, die GSM Portsvon LI1 müssen aber extra angezeigt werden.
			if ($lif1 == "bf2GSM" || $lif1 == "bf1GSM" || $lif1 == "bf2LTE") {
				$q = $database->select("SELECT port, port_type FROM gsm WHERE lif='1' union  SELECT port, port_type FROM lte WHERE lif='1' order by port_type, port");
				$i = 3;
				while ($ent = $database->fetch_array($q)) {
					if ($ent['port_type'] == 'hdlc')
						$ent['port_type'] = 'ccs';
					$form_elements.="<script>
						$(document).ready(function() {
							if ($('#port" . $i . "').html()==''){
								document.getElementById('bild" . $i . "').innerHTML='<img src=\"./includes/images/Zeichnung-2.png\" title=\"Image Ports\">';
								document.getElementById('port" . $i . "').innerHTML='<div class=\"text-center\">" . $ent['port_type'] . $ent['port'] . "</div>';
							}else{
								document.getElementById('port" . $i . "').innerHTML+='<div class=\"text-center\">" . $ent['port_type'] . $ent['port'] . "</div>';
							}
						});
						</script>";
					$i++;
				}
			}
		} else {
			//Kontrollvariable für 2S02FXS Lif
			$isdn = false;
			$analog = false;
			$q = $database->select("SELECT lif, type, port, port_type, 'isdn' as table_name FROM isdn WHERE type!='bf2t1e1' and type!='bf1t1e1' and type!='bf4t1e1' union "
				. "SELECT lif, type, port, port_type, 'analog' as table_name FROM analog union SELECT lif, type, port, port_type, 'gsm' as table_name FROM gsm union "
				. "SELECT lif, type, port, port_type, 'lte' as table_name FROM lte union SELECT lif, type, port, port_type, 'cas' as table_name FROM cas order by lif, port ;");

			$i = 1;
			$j = 1;
			$setj = false;
			while ($ent0 = $database->fetch_array($q)) {
				if ($ent0['port_type'] == 'hdlc')
					$ent0['port_type'] = 'ccs';
				if ($ent0['lif'] == 0) {
					$name['port1'] = 'port1';
					$name['port2'] = 'port2';
					$name['bild1'] = 'bild1';
					$name['bild2'] = 'bild2';
				} elseif ($ent0['lif'] == 1) {
					$name['port1'] = 'port3';
					$name['port2'] = 'port4';
					$name['bild1'] = 'bild3';
					$name['bild2'] = 'bild4';
				}
				//Beim ersten Port von Li1 soll $j zurückgesetzt werden
				if (!$setj && $ent0['lif'] == 1) {
					$setj = true;
					$j = 1;
					$i = 3;
				}

				//Line interface mit mehr als 2 ports
				if ($j > 3) {
					$form_elements.="<script>
					$(document).ready(function() {
						show_line" . $ent0['lif'] . "=false;
						document.getElementById('" . $name['bild1'] . "').innerHTML='<img src=\"./includes/images/Zeichnung-1.png\" title=\"Image Ports\">';
						document.getElementById('" . $name['bild2'] . "').innerHTML='<img src=\"./includes/images/Zeichnung-1.png\" title=\"Image Ports\">';
					});
					</script>";
				}
				//2SO-2 FXS Modul
				if ($ent0['type'] == "bf2S02FXS") {
					$form_elements.="<script>
					$(document).ready(function() {
						if (typeof(show_line" . $ent0['lif'] . ")=='undefined') document.getElementById('bild" . $i . "').innerHTML='<img src=\"./includes/images/Zeichnung-2.png\" title=\"Image Ports\">';
					});
                                        </script>";
					//Analog Ports rechts platzieren
					if ($ent0['table_name'] == "analog") {
						if ($analog == true)
							$i++;
						$form_elements.="<script>
					$(document).ready(function() {
							$('#port" . $i . "').append('<div style=\'float:right;\'>" . $ent0['port_type'] . $ent0['port'] . "</div>');
                                        });
					</script>";
						$analog = true;
						$isdn = false;
						//ISDN Ports links platzieren
					} else if ($ent0['table_name'] == "isdn") {
						//Wenn 2 ISDN Ports hintereinander in dem DB ergebnis kommen,
						//soll der 2. Port zu dem nächsten Slot zugeordnet werden
						if ($isdn == true)
							$i++;
						$form_elements.="<script>
					$(document).ready(function() {
						$('#port" . $i . "').append('<div style=\'float:left;\'>" . $ent0['port_type'] . $ent0['port'] . "</div>');
                                        });
					</script>";
						if ($isdn == true)
							$i = $i - 2;
						$analog = false;
						$isdn = true;
					}
					if ($j % 2 == 0)
						$i++;
					if ($i == 3 && $ent0['lif'] == 0)
						$i = 1;
					else if ($i == 5 && $ent0['lif'] == 1)
						$i = 3;
					$j++;
					//8FXS Modul
				}elseif ($ent0['type'] == "bf8FXS") {
					$form_elements.="<script>
					$(document).ready(function() {
						document.getElementById('" . $name['bild1'] . "').innerHTML='<img src=\"./includes/images/Zeichnung-2.png\" title=\"Image Ports\">';
                                                document.getElementById('" . $name['bild2'] . "').innerHTML='<img src=\"./includes/images/Zeichnung-2.png\" title=\"Image Ports\">';
						document.getElementById('" . $name['port1'] . "').innerHTML='<div style=\'float:left;\'>bf8FXS</div>';
                                                document.getElementById('" . $name['port2'] . "').innerHTML='<div style=\'float:left;\'>bf8FXS</div>'});
					</script>";
					//Alle übrigen Module
				} else {

					$form_elements.="<script>
					$(document).ready(function() {
						if (typeof(show_line" . $ent0['lif'] . ")=='undefined') document.getElementById('bild" . $i . "').innerHTML='<img src=\"./includes/images/Zeichnung-2.png\" title=\"Image Ports\">';
						if (document.getElementById('port" . $i . "').innerHTML!='')
							document.getElementById('port" . $i . "').innerHTML+='<div style=\'float:right;\'>" . $ent0['port_type'] . $ent0['port'] . "</div>';
						else";
					if ($database->get_count_port($ent0['lif']) <= 2)
						$form_elements.=" document.getElementById('port" . $i . "').innerHTML+='<div class=\"text-center\">" . $ent0['port_type'] . $ent0['port'] . "</div>';";
					else
						$form_elements.=" document.getElementById('port" . $i . "').innerHTML+='<div style=\'float:left;\'>" . $ent0['port_type'] . $ent0['port'] . "</div>';";
					$form_elements.="});
					</script>";
					if ($database->get_count_port($ent0['lif']) <= 2)
						$j++;
					if ($j % 2 == 0)
						$i++;
					if ($database->get_count_port($ent0['lif']) >= 2)
						$j++;
				}
			}
		}

		return $form_elements;
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML-Seite
	 */

	public function display() {

		$m = $this->m_attr;

		$name = "HARDWARE_TITLE_DIS";
		include('./includes/header.php');

		if ($this->ltescan_attr) {
			$isgw = new isgwtelnet();
			$isgw->isgw_login();
			$list = $isgw->isgw_fetch_gsmoperators($this->ltescan_attr);
			print ( '<script type="text/javascript">');
			print ('window.location = "index.php?m=PstnHardware"');
			print ( '</script>">');
		}
		else if ($this->tdmreset_attr) {
			ob_start();
			include_once('/usr/local/php/tdmConfigure.php');
			ob_end_clean();
			echo "Resetting TDM Bus\n";
			print ( '<script type="text/javascript">');
			print ('window.location = "index.php?m=PstnHardware"');
			print ( '</script>">');
		}
		else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		$pstn_hw_table = $this->dynamic_table();
		// build page content
		$ret.="<script>
                function enablepl1(port){
                    if ($('#mode'+port+' option:selected').val()=='te')
                        $('#permanentl1'+port).attr('disabled', false);
                    else
                         $('#permanentl1'+port).attr('disabled', true);
                }

                function enablepl1_checkclock(port, li, params) {
                    allnt=1;
                    for (i=0; i<params.length; i++) {
                         if ($('#mode'+params[i]+' option:selected').val()!='nt') {
                               allnt=0;
                         }
                    }

                    if (allnt) {
                        if ($(\"#sync_port_li\" + li +  \" option[value='crystal']\").length) {
                            document.getElementsByName('sync_li' + li)[0].value='crystal'
                        }
                    }

                    if ($('#mode'+port+' option:selected').val()=='te')
                        $('#permanentl1'+port).attr('disabled', false);
                    else
                         $('#permanentl1'+port).attr('disabled', true);
                }
		</script>";
		$ret .= "<form name='isdn_hw' id='pstn_hw' class='form-horizontal' action='modules/PstnHardware/pstnhardware_submit.php' method='POST'>
			<input type='hidden' name='m' value='" . $m . "'>
			<br/>
			" . $pstn_hw_table . "
			<br/>
			</form>";
		$ret.='<script>$("#pstn_hw").validate({
				rules: {
					pcm_ip: {
						checkHostname: true,
						required: {
							depends: function (element) {
								return $("#master").val() == "pcm";
							}
						},
					},
					pcm_server_port: {
						digits: true,
						range: [1, 65535],
						required: {
							depends: function (element) {
								return $("#master").val() == "pcm";
							}
						},
					},
					wait4idle: {
						digits: true,
						range: [1000, 10000],
					},
					ring_oscillator_on: {
						digits: true,
						range: [100, 8000],
					},
					ring_oscillator_off: {
						digits: true,
						range: [100, 8000],
					},
				}
			});
			</script>';

		//Rückgabe: Inhalt der HTML-Seite
		return $ret;
	}

	public function mode($ba, $act_mode, $id) {
		if ($act_mode == 'te') {
			$mode.="<option value='nt'>nt</option>";
			$mode.="<option value='te' selected>te</option>";
		} else {
			$mode.="<option value='nt' selected>nt</option>";
			$mode.="<option value='te'>te</option>";
		}
		return $mode;
	}

	public function hw_mode($ba, $act_mode) {
		if ($act_mode == 'hdlc') {
			$mode.="<option value='cas'>cas</option>";
			$mode.="<option value='hdlc' selected>ccs</option>";
		} else {
			$mode.="<option value='cas' selected>cas</option>";
			$mode.="<option value='hdlc'>ccs</option>";
		}
		return $mode;
	}

	public function coding($codingval, $port) {
		${$codingval} = 'selected'; 
		$coding = "<select class='form-control' name='coding" . $port . "'>";
		$coding.="<option value='B8ZS' " . $B8ZS . ">B8ZS</option>";
		$coding.="<option value='AMI' " . $AMI . ">AMI</option>";
		$coding.="</select>";
		return $coding;
	}
	
	public function cr_cidlen($name,$port,$value) {
		if ($value==1) $selected1='selected';
		if ($value==2) $selected2='selected';
		$crcidlen="<select name='".$name . $port . "'>";
		$crcidlen.="<option value='1' ".$selected1.">1</option>";
		$crcidlen.="<option value='2' ".$selected2.">2</option>";
		$crcidlen.="</select>";
		return $crcidlen;
	}
	
	public function crystal_clock($ba, $crystal_clock, $id) {
		if ($crystal_clock == '1') {
			$mode.="<option value='1' selected>Internal Crystal</option>";
			$mode.="<option value='0'>External</option>";
		} else {
			$mode.="<option value='1'>Internal Crystal</option>";
			$mode.="<option value='0' selected>External</option>";
		}
		return $mode;
	}
	
	function codec($option, $port, $type) {
		$options = explode("|", $option);
		$checkbox = "<fieldset class='alignleft'>";
		(in_array("1", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='1' $checked>&nbsp;full&nbsp;rate&nbsp;mode</div>";
		(in_array("2", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='2' $checked>&nbsp;enhanced&nbsp;full&nbsp;rate&nbsp;mode</div>";
		(in_array("4", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='4' $checked>&nbsp;half&nbsp;rate&nbsp;mode</div>";
		(in_array("8", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='8' $checked>&nbsp;AMR&nbsp;full&nbsp;rate&nbsp;mode</div>";
		(in_array("16", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='16' $checked>&nbsp;AMR&nbsp;half&nbsp;rate&nbsp;mode</div>";
		$checkbox.="</fieldset>";
		return $checkbox;
	}

	function ltecodec($option, $port, $type) {
		$options = explode("|", $option);
		$checkbox = "<fieldset class='alignleft'>";
		(in_array("1", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='1' $checked>&nbsp;full&nbsp;rate&nbsp;mode</div>";
		(in_array("2", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='2' $checked>&nbsp;enhanced&nbsp;full&nbsp;rate&nbsp;mode</div>";
		(in_array("4", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='4' $checked>&nbsp;half&nbsp;rate&nbsp;mode</div>";
		(in_array("8", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='8' $checked>&nbsp;AMR&nbsp;full&nbsp;rate&nbsp;mode</div>";
		(in_array("16", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='16' $checked>&nbsp;AMR&nbsp;half&nbsp;rate&nbsp;mode</div>";
		(in_array("32", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='32' $checked>&nbsp;GSM AMR&nbsp;Wide&nbsp;band&nbsp;mode</div>";
		(in_array("64", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='64' $checked>&nbsp;UMTS AMR&nbsp;Narrow&nbsp;band&nbsp;mode</div>";
		(in_array("128", $options) || $option == "") ? $checked = "checked" : $checked = "";
		$checkbox.="<div><input type='checkbox' name='codec$type" . $port . "[]'  value='128' $checked>&nbsp;UMTS AMR&nbsp;Wide&nbsp;band&nbsp;mode</div>";
		$checkbox.="</fieldset>";
		return $checkbox;
	}

	
	public function get_connector_info_for_lif ($lif) {
	
		//on 2LI gateway we return an empty string
		if (!file_exists ("/sys/class/beronet/li2")) {
			return "";
		}
		$filename = "/sys/class/beronet/li" . $lif . "/connector";
		if (file_exists ($filename)) {
			$n = file_get_contents ($filename);
		}
		else {
			$n = "unknown";
		}
		
		$ret = "&nbsp;&nbsp;" . HARDWARE_CONNECTOR_DIS . ":&nbsp;" . $n . "&nbsp;&nbsp;";
		return $ret;
	}
	
	
	public function dynamic_table() {
		$database = new beroAri();
		require_once("./includes/lang.php");

		if ($database->get('gui_mode') == 'simple')
			$simple_class = 'simple';

		$q = $database->select("SELECT distinct lif, type FROM cas order by lif");

		//Änderung des Interface Types und Protocols wenn CAS gesteckt ist und keine keine Einstellungen vorgenommen wurden
		if (Helper::check($database) == 1 && sqlite_num_rows($q) != 0 && $database->get("set_hw") == "") {
			// This part is now useless since moved before to do a factory reset. Can be removed. We keep it to avoid eventually some errors
			//CAS
			$form_elements.="<h3><div class='text-center'>" . HARDWARE_INTERFACE_TYPE_MESSAGE_DIS . ""
				. "<input type='hidden' name='set_hw' value='true' /></div></h3>";
			while ($ent = $database->fetch_array($q)) {
				$query = $database->select("select * from cas where lif='" . $ent['lif'] . "'");
				$form_elements.="<br /><br /><table class='table table-striped table-bordered' style='width:90% !important; margin:auto;'>
					<tr><th colspan='7'><div class='text-center'>" . HARDWARE_CARD_TYPE_DIS . ":&nbsp;" . $ent['type'] .
					"&nbsp;&nbsp;" . HARDWARE_LINE_INTERFACE_DIS . ":&nbsp;" . $ent['lif'] . "&nbsp;&nbsp;</div></th></tr>";
				while ($entry = $database->fetch_array($query)) {
					$form_elements.="<tr>
				<td><b>" . HARDWARE_PORT_DIS . ":</b>&nbsp;" . $entry['port'] . "&nbsp;</td>
				<td colspan='4'><div class='col-sm-5'><b>" . HARDWARE_INTERFACE_TYPE_DIS . ":</b></div><div class='col-sm-7'><select class='form-control' name='interface_type" . $entry['port'] . "'>" . $this->hw_mode($database, $entry['port_type']) .
						"</select></div><input type=hidden name=id_upd[] value=" . $entry['port'] . ">
				<input type=hidden name=type[] value='cashw'></td>";

					if ($entry['protocol'] == "t1") {
						$form_elements.="<td><div class='col-sm-3'><b>" . HARDWARE_PROTOCOL_DIS . ":</b></div><div class='col-sm-7'><select class='form-control' name='t1e1" . $entry['port'] . "' onmouseover=\"Tip('" . "T1 or E1" . "')\" onmouseout='UnTip()'>
						<option value=1 selected>T1</option>
						<option value=0>E1</option>
						</select>
						</div>
						<input type=hidden name=id_upd[] value=" . $entry['port'] . ">
						<input type=hidden name=type[] value='cas'></td>";
					} else {
						$form_elements.="<td><div class='col-sm-3'><b>" . HARDWARE_PROTOCOL_DIS . ":</b></div><div class='col-sm-7'><select class='form-control' name='t1e1" . $entry['port'] . "' onmouseover=\"Tip('" . "T1 or E1" . "')\" onmouseout='UnTip()'>
						<option value=1>T1</option>
						<option value=0 selected>E1</option>
						</select>
						</div>
						<input type=hidden name=id_upd[] value=" . $entry['port'] . ">
						<input type=hidden name=type[] value='cas'></td>";
					}
				}
				$form_elements.="</table>";
			}

			$form_elements.="<div class='text-center'><input type='submit' class='btn btn-default' value='" . BUTTON_SAVE . "' onmouseover=\"Tip('" . ISDNHW_SAVE . "')\" onmouseout='UnTip()'></div>";
		} else {
			//Grafische Darstellung der Portsbelegung in Form eines Bilds
			if (Helper::getType() < 30) {
				$form_elements.=$this->graphic($database);
			}

			//Zeigen des master-slave Drop-downs wenn die beiden Lineinterfaces belegt sind
			$type = array();
			$q = $database->select("select type, lif from isdn WHERE type!='bf2t1e1' and type!='bf1t1e1' and type!='bf4t1e1' group by type,lif union select type, lif from analog group by type,lif union select type, lif from gsm group by type,lif union select type, lif from cas group by type,lif order by lif;");
			$master = $database->get('master');
			while ($ent = $database->fetch_array($q)) {
				$li[$ent['lif']] = $ent['lif'];
				$type[$ent['lif']] = $ent['type'];
				($master == $ent['lif']) ? $selected = 'selected' : $selected = '';
				$master_options.='<option value="' . $ent['lif'] . '" ' . $selected . '>lif' . $ent['lif'] . '-' . $ent['type'] . '</option>';
			}

			//Master Setting
			($master == 'all') ? $allmaster = 'selected' : $allmaster = '';
			($master == 'pcm') ? $pcmmaster = 'selected' : $pcmmaster = '';
			$master_modules = array("bf2GSM", "bf1GSM", "bf4FXO", "bf2FXO");
			if (count(array_intersect($master_modules, $type)) != 0) {
				$disabled = 'disabled';
				$allmaster = 'selected';
			}

			$master_options.='<option value="all" ' . $allmaster . '>ALL</option>';
			$master_options.='<option value="pcm" ' . $pcmmaster . '>PCM</option>';

			$form_elements.='<br/><br/>'
			. '<table class="table table-striped table-bordered" style="width:90% !important; margin:auto;">'
			. '<tr><th>'
			. '<div onmouseover=\'Tip("' . HARDWARE_MASTER . '")\' onmouseout="UnTip()" class="col-sm-2"><b>' . HARDWARE_MASTER_DIS . ':&nbsp;</b></div>'
			. '<div onmouseover=\'Tip("' . HARDWARE_MASTER . '")\' onmouseout="UnTip()" class="col-sm-3"><select name="master" class="form-control" id="master" ' . $disabled . '>'
			. $master_options
			. '</select></div>';
			
			
			$q = $database->select("select lif from lte where type='bf2LTE';");
			if (sqlite_num_rows ($q) > 0) {
					$form_elements.= '<div class="col-sm-2" onmouseover="Tip(\'Re-initializes the TDM bus\')" onmouseout="UnTip()">';
					$form_elements.= "<button style='float: right;' type='button' onclick=\"location.href='index.php?m=PstnHardware&tdmreset=1';\">Reset TDM Bus</button>";
					$form_elements.= '</div>';
			}
				
			$form_elements.= '</th></tr>'
				. '</table>';
			//End Master setting

			$q = $database->select("select type, lif from isdn where type!='bf2t1e1' and type!='bf1t1e1' and type!='bf4t1e1' group by type,lif union select type, lif from analog group by type,lif union select type, lif from gsm group by type,lif union select type, lif from lte group by type,lif union select type, lif from cas group by type,lif order by lif;");
			while ($ent = $database->fetch_array($q)) {
				$connector_info = $this->get_connector_info_for_lif ($ent['lif']);
				if ($ent['type'] != "bf1E1" && $ent['type'] != "bf2E1") {
					$form_elements.="<br/><br/><table class='table table-striped table-bordered' style='width:90% !important; margin:auto;'>
					<tr><th colspan='8'><div class='text-center form-group'><div class='col-sm-5'><input type=hidden name='card_type" . $ent['lif'] . "' value='" . $ent['type'] . "'>" . HARDWARE_CARD_TYPE_DIS .":&nbsp;" . $ent['type'] .
						"&nbsp;&nbsp;" . HARDWARE_LINE_INTERFACE_DIS . ":&nbsp;" . $ent['lif'] . "&nbsp;&nbsp;" . $connector_info;
				} else {
					$form_elements.="<br /><br /><table class='table table-striped table-bordered' style='width:90% !important; margin:auto;'>
					<tr><th colspan='7'><div class=\"text-center form-group\"><div class='col-sm-5'>" . HARDWARE_CARD_TYPE_DIS . ":&nbsp;" . $ent['type'] .
						"&nbsp;&nbsp;" . HARDWARE_LINE_INTERFACE_DIS . ":&nbsp;" . $ent['lif'] . "&nbsp;&nbsp;" . $connector_info;
				}
				$form_elements.="</div>";
				//Clock - Synchonisation port
				if (!in_array($ent['type'], array("bf4FXS", "bf8FXS", "bf4FXO", "bf2FXO", "bf1FXS", "bf2FXS", "bf2GSM", "bf2LTE"))) {
					$form_elements.=$this->getClock($ent['lif'], $ent['type'], $database);
				}
				$form_elements.="</div></th></tr>";
				//ISDN
				$query = $database->select("select * from isdn where lif='" . $ent['lif'] . "' and type!='bf2t1e1' and type!='bf1t1e1' and type!='bf4t1e1'");
				$first_entry = 1;
				
				$li_ports_list = '[';
				while ($entry = $database->fetch_array($query)) {
					if (!$first_entry) {
						$li_ports_list .= ",";
					}
					$li_ports_list .= '"' . $entry['port'] . '"' ;
					$first_entry = 0 ;
				}
				$li_ports_list .= ']';
				
				sqlite_rewind ($query);
				
				while ($entry = $database->fetch_array($query)) {
					if ($entry['type'] != "bf1E1" && $entry['type'] != "bf2E1") {
						$form_elements.="<tr>
						<td><b>" . HARDWARE_PORT_DIS . ":</b>&nbsp;" . $entry['port'] . "&nbsp;</td>
						<td><b>" . HARDWARE_PORT_TYPE_DIS . ":</b>&nbsp;" . $entry['port_type'] . "</td>
						<td><div class='col-sm-3'><b class='table-middle'>" . HARDWARE_TYPE_DIS . ":</b></div><div class='col-sm-8'><select class='form-control' name='mode" . $entry['port'] . "' id='mode" . $entry['port'] . "' onmouseover=\"Tip('" . ISDNHW_MODE . "')\"
							onmouseout='UnTip()' onchange='enablepl1_checkclock(\"" . $entry['port'] . "\",\"" . $ent['lif'] . "\"," . $li_ports_list . ");'>" . $this->mode($database, $entry['ntteHW'], $entry['port']) . "</select></div></td>";
						if ($entry['ptp'] == 1) {
							$form_elements.="<td><div class='col-sm-5'><b class='table-middle'>" . HARDWARE_PROTOCOL_DIS . ":</b></div><div class='col-sm-7'><select class='form-control' name='ptp" . $entry['port'] . "' onmouseover=\"Tip('" . ISDNHW_PTP . "')\" onmouseout='UnTip()'>
								<option value=1 selected>PTP</option>
								<option value=0>PMP</option>
								</select>
								</div>
								<input type=hidden name=id_upd[] value=" . $entry['port'] . ">
								<input type=hidden name=type[] value='isdn'></td>";
						} else {
							$form_elements.="<td><div class='col-sm-5'><b class='table-middle'>" . HARDWARE_PROTOCOL_DIS . ":</b></div><div class='col-sm-7'><select class='form-control' name='ptp" . $entry['port'] . "' onmouseover=\"Tip('" . ISDNHW_PTP . "')\" onmouseout='UnTip()'>
								<option value=1>PTP</option>
								<option value=0 selected>PMP</option>
								</select>
								</div>
								<input type=hidden name=id_upd[] value=" . $entry['port'] . ">
								<input type=hidden name=type[] value='isdn'></td>";
						}
						if ($entry['lt'] == 1) {
							$form_elements.="<td class='$simple_class'><b>" . HARDWARE_TERMINATION_DIS . ":</b>&nbsp;<input type='checkbox' name='lt" . $entry['port'] . "' checked value='1' onmouseover=\"Tip('" . ISDNHW_LT . "')\" onmouseout='UnTip()'></td>";
						} else {
							$form_elements.="<td class='$simple_class'><b>" . HARDWARE_TERMINATION_DIS . ":</b>&nbsp;<input type='checkbox' name='lt" . $entry['port'] . "' value='1' onmouseover=\"Tip('" . ISDNHW_LT . "')\" onmouseout='UnTip()'></td>";
						}
						if ($entry['permanentl1'] == 1) {
							$form_elements.="<td class='$simple_class'><b>" . HARDWARE_PERMANENTL1_DIS . ":</b>&nbsp;<input type='checkbox' name='permanentl1" . $entry['port'] . "' id='permanentl1" . $entry['port'] . "' checked value='1'><script>enablepl1_checkclock(\"" . $entry['port'] . "\",\"" . $ent['lif'] . "\"," . $li_ports_list . ");</script></td>";
						} else {
							$form_elements.="<td class='$simple_class'><b>" . HARDWARE_PERMANENTL1_DIS . ":</b>&nbsp;<input type='checkbox' name='permanentl1" . $entry['port'] . "' id='permanentl1" . $entry['port'] . "' value='1'><script>enablepl1_checkclock(\"" . $entry['port'] . "\",\"" . $ent['lif'] . "\"," . $li_ports_list . ");</script></td>";
						}
						
						$form_elements.="<td class='$simple_class'><b>" . ISDNHW_CRLEN_NAME . ":</b>&nbsp;<input type='checkbox' name='crlen" . $entry['port'] . "' id='crlen" . $entry['port'] . "' "
						. ($entry['crlen'] == 2 ? "checked" : "") . " value='2' onmouseover=\"Tip('" . ISDNHW_CRLEN_TOOLTIP . "')\" onmouseout='UnTip()'></td>";
						$form_elements.="<td class='$simple_class'><b>" . ISDNHW_CIDLEN_NAME . ":</b>&nbsp;<input type='checkbox' name='cidlen" . $entry['port'] . "' id='cidlen" . $entry['port'] . "' "
						. ($entry['cidlen'] == 2 ? "checked" : "") . " value='2' onmouseover=\"Tip('" . ISDNHW_CIDLEN_TOOLTIP . "')\" onmouseout='UnTip()'></td>";
						
					}
					else {
						$form_elements.="<tr>
						<td><b>" . HARDWARE_PORT_DIS . ":</b>&nbsp;" . $entry['port'] . "&nbsp;</td>
						<td><b>" . HARDWARE_PORT_TYPE_DIS . ":</b>&nbsp;" . $entry['port_type'] . "</td>
						<td><div class='col-sm-3'><b class='table-middle'>" . HARDWARE_TYPE_DIS . ":</b></div><div class='col-sm-7'><select class='form-control' name='mode" . $entry['port'] . "' id='mode" . $entry['port'] . "' onmouseover=\"Tip('" . ISDNHW_MODE . "')\"
						onmouseout='UnTip()' onchange='enablepl1_checkclock(\"" . $entry['port'] . "\",\"" . $ent['lif'] . "\"," . $li_ports_list . ");'>" . $this->mode($database, $entry['ntteHW'], $entry['port']) . "</select></div></td>";
						$form_elements.="<td><div class='col-sm-5'><b class='table-middle'>" . HARDWARE_PROTOCOL_DIS . ":</b></div><div class='col-sm-7'><select class='form-control' name='ptp" . $entry['port'] . "' onmouseover=\"Tip('" . ISDNHW_PTPE1 . "')\" onmouseout='UnTip()'>
						<option value=1 selected>PTP</option>
						</select>
						</div>
						<input type=hidden name=id_upd[] value=" . $entry['port'] . ">
						<input type=hidden name=type[] value='isdn'></td>";
						if ($entry['crc'] == 1) {
							$form_elements.="<td><b>" . HARDWARE_CRC_DIS . ":</b>&nbsp;<input type='checkbox' name='crc" . $entry['port'] . "' checked value='1'></td>";
						} else {
							$form_elements.="<td><b>" . HARDWARE_CRC_DIS . ":</b>&nbsp;<input type='checkbox' name='crc" . $entry['port'] . "' value='1'></td>";
						}
						$form_elements.="<td><b>" . HARDWARE_CLOCK_MODE_DIS . ":</b>&nbsp;<input type='hidden' name='crystal_clock" . $entry['port'] . "' value='0'/><select class='form-control' name='crystal_clock" . $entry['port'] . "' class='crystal_clock" . $ent['lif'] . "'>" . $this->crystal_clock($database, $entry['crystal_clock'], $entry['port']) . "</select></td>";
						if ($entry['permanentl1'] == 1) {
							$form_elements.="<td><b>" . HARDWARE_PERMANENTL1_DIS . ":</b>&nbsp;<input type='checkbox' name='permanentl1" . $entry['port'] . "' id='permanentl1" . $entry['port'] . "' checked value='1'><script>enablepl1_checkclock(\"" . $entry['port'] . "\",\"" . $ent['lif'] . "\"," . $li_ports_list . ");</script></td>";
						} else {
							$form_elements.="<td><b>" . HARDWARE_PERMANENTL1_DIS . ":</b>&nbsp;<input type='checkbox' name='permanentl1" . $entry['port'] . "' id='permanentl1" . $entry['port'] . "' value='1'><script>enablepl1_checkclock(\"" . $entry['port'] . "\",\"" . $ent['lif'] . "\"," . $li_ports_list . ");</script></td>";
						}
					}
				}

				//ANALOG
				$query = $database->select("select * from analog where lif='" . $ent['lif'] . "'");
				while ($entry = $database->fetch_array($query)) {
					$form_elements.="<tr>"
						. "<td><b>" . HARDWARE_PORT_DIS . ":</b>&nbsp;" . $entry['port'] . "&nbsp;</td>"
						. "<td colspan='7'><b>" . HARDWARE_PORT_TYPE_DIS . ":</b>&nbsp;" . $entry['port_type'] 
						. "<input type=hidden name=id_upd[] value=" . $entry['port'] . "><input type=hidden name=type[] value='analog'></td>";
				}
				//GSM
				$query = $database->select("select * from gsm where lif='" . $ent['lif'] . "'");
				while ($entry = $database->fetch_array($query)) {
					$form_elements.="<tr>"
						. "<td><b>" . HARDWARE_PORT_DIS . ":</b>&nbsp;" . $entry['port'] . "&nbsp;</td>"
						. "<td colspan='2'><b>" . HARDWARE_PORT_TYPE_DIS . ":</b>&nbsp;" . $entry['port_type'] 
						. "<input type=hidden name=id_upd[] value=" . $entry['port'] . ">"
						. "<input type=hidden name=type[] value='gsm'></td>"
						. "<td><b>" . HARDWARE_PIN_DIS . ":</b>&nbsp;<input type='password' class='form-control input-sm' "
						. "autocomplete='off' digits='true' minlength='4' maxlength='4' name='pingsm" . $entry['port'] . "' value='" . $entry['pin'] . "'>&nbsp;</td>"
						. "<td><b>" . HARDWARE_SMSC_DIS . ":</b>&nbsp;<input type='text' class='form-control input-sm' "
						. "name='smscgsm" . $entry['port'] . "' checkPhoneKeys=true value='" . $entry['smsc'] . "'>&nbsp;</td>"
						. "<td><b>" . HARDWARE_CODEC_DIS . ":</b>&nbsp;" . $this->codec($entry['codec'], $entry['port'], 'gsm') . "&nbsp;</td>";
				}
				
				
			
				//LTE
				$query = $database->select("select * from lte where lif='" . $ent['lif'] . "'");
				while ($entry = $database->fetch_array($query)) {
					$form_elements.="<tr>"
						. "<td><b>" . HARDWARE_PORT_DIS . ":</b>&nbsp;" . $entry['port'] . "&nbsp;</td>"
						. "<td colspan='2'><b>" . HARDWARE_PORT_TYPE_DIS . ":</b>&nbsp;" . $entry['port_type'] 
						. "<input type=hidden name=id_upd[] value=" . $entry['port'] . ">"
						. "<input type=hidden name=type[] value='lte'></td>"
						. "<td><b>" . HARDWARE_PIN_DIS . ":</b>&nbsp;<input type='password' class='form-control input-sm' "
						. "autocomplete='off' digits='true' minlength='4' maxlength='4' name='pinlte" . $entry['port'] . "' value='" . $entry['pin'] . "'>&nbsp;</td>"
						. "<td><b>" . HARDWARE_SMSC_DIS . ":</b>&nbsp;<input type='text' class='form-control input-sm' "
						. "name='smsclte" . $entry['port'] . "' checkPhoneKeys=true value='" . $entry['smsc'] . "'>&nbsp;</td>"
						. "<td><b>" . HARDWARE_CODEC_DIS . ":</b>&nbsp;" . $this->ltecodec($entry['codec'], $entry['port'], 'lte') . "&nbsp;</td>"
						. "<td><b>" . $this->gsm_provider_settings($entry['port']) . "</b>&nbsp;" . "&nbsp;</td>";
				}
				
				//CAS
				$query = $database->select("select * from cas where lif='" . $ent['lif'] . "'");
				while ($entry = $database->fetch_array($query)) {
					//HDCL in CCS für die Anzeige umbenennen
					if ($entry['port_type'] == 'hdlc') {
						$entry['port_type'] = 'ccs';
						$colspan = 3;
					} else {
						$colspan = 2;
					}
					$form_elements.="<tr onmouseover=\"Tip('" . HARDWARE_HWMODE_HINT . "')\" onmouseout='UnTip()'>
				<td><b>" . HARDWARE_PORT_DIS . ":</b>&nbsp;" . $entry['port'] . "&nbsp;</td>
				<td colspan='$colspan'><b>" . HARDWARE_INTERFACE_TYPE_DIS . ":</b>&nbsp;" . $entry['port_type'] . "</td>";
					if ($entry['port_type'] == 'cas') {
						$form_elements.="<td><div class='col-sm-5'><b>" . HARDWARE_CODING_DIS . ":</b></div><div class='col-sm-7'>" . $this->coding($entry['coding'], $entry['port']) . "</div></td>";
					}
					$form_elements.="<td><b class='table-middle'>" . HARDWARE_PROTOCOL_DIS . ":</b>&nbsp;" . $entry['protocol'] . "
						</td>
                                         <td><div class='col-sm-3'><b class='table-middle'>" . HARDWARE_TYPE_DIS . ":</b></div><div class='col-sm-7'><select class='form-control' name='casmode" . $entry['port'] . "' onmouseover=\"Tip('" . ISDNHW_MODE . "')\"
							onmouseout='UnTip()' ";
					($entry['port_type'] == 'cas') ? $form_elements.="disabled" : $form_elements.="";
					$form_elements.=">" . $this->mode($database, $entry['termination'], $entry['port']) . "</select></div>"
						. "                 <input type=hidden name=id_upd[] value=" . $entry['port'] . ">
                                                <input type=hidden name=type[] value='cas'></td>";
					$form_elements.="</td>";
				}
				$form_elements.="</table>"
					. "<script>"
					. "function required() {
			if ($('#master').val() == 'pcm') {
				addAsterisk('pcm_ip');
				addAsterisk('pcm_server_port');
			} else {
				deleteAsterisk('pcm_ip');
				deleteAsterisk('pcm_server_port');
			}
		}
        function check_master(){
			for (i = 0; i < 3; i++) {
				$( \"select[name='sync_li\"+i+\"']\" ).prop('disabled',true);
				$('#sync_port_li'+i).hide();
				$('.crystal_clock'+i).prop('disabled',true);
			}
			if ($('#master').val()=='pcm'){
				$('#pcm_client').show();
				$('#pcm_server').hide();

			}else if($('#master').val()=='all' || $('#master option').length>2){
				$('#pcm_server').show();
				$('#pcm_client').hide();
			//No lifs
			}else{
				$('#pcm_server').hide();
				$('#pcm_client').show();
			}

			var index = $.inArray( $('#master').val(), [ '0', '1', '2'] );
			if (index!=-1){
				$( \"select[name='sync_li\"+index+\"']\" ).prop('disabled',false);
				$('#sync_port_li'+index).show();
                                $('.crystal_clock'+index).prop('disabled',false);
			}else if ($('#master').val()=='all'){
				for (i = 0; i < 3; i++) {
					$( \"select[name='sync_li\"+i+\"']\" ).prop('disabled',false);
					$('#sync_port_li'+i).show();
					$('.crystal_clock'+i).prop('disabled',false);
				}
			}";
				if (in_array('bf1GSM', $type) || in_array('bf2GSM', $type) || in_array('bf2LTE', $type))
					$form_elements.= "$('#pcm_server').hide();"
						. "$('#pcm_client').hide();";
				//Die funktion check_master wird erst hier geschlossen
				$form_elements.="}
		function master(){
			check_master();
			required();
		}
		$( '#master' ).change(function() {
			master();
		});
		$( document ).ready(function() {
			master();
		});
		</script>";
			}

			$revision = Helper::getRevision();

			//Country
			if (!empty($type) && count(array_filter(array_map('_isMatch', $type, array_fill(0, count($type), '/bf.*FX[SO]/')))) > 0) {
				$form_elements.="<script>function country_setting(param)
			{
                            if (param!='USER'){
				$.ajax({
					url : 'modules/PstnHardware/ajax_country.php?country='+param,
                                        dataType: 'json',
					success : function (data) {
                                                $( 'select[name=\"ohs\"]' ).val(data['ohs']);
                                                $( 'select[name=\"rt\"]' ).val(data['rt']);
                                                $( 'select[name=\"rz\"]' ).val(data['rz']);
                                                $( 'select[name=\"dcv\"]' ).val(data['dcv']);
                                                $( 'select[name=\"mini\"]' ).val(data['mini']);
                                                $( 'select[name=\"acim\"]' ).val(data['acim']);
                                                $( 'select[name=\"ilim\"]' ).val(data['ilim']);
					}
				});
                             }
			}
                        function select_user(){
                            $( 'select[name=\"country\"]' ).val('USER');
                        }</script>";
				$form_elements.="<br/>"
					. "<br/>"
					. "<table class='table table-striped table-bordered' style='width:90% !important; margin:auto'>";
				//FXO specific options
				$country_modules = array("bf4FXO", "bf2FXO");
				if (count(array_intersect($country_modules, $type)) != 0) {
					$form_elements.="<tr ><th><b>" . HARDWARE_COUNTRY_DIS . ":</b></th><th><select class='form-control' name='country' class='country' onchange=\"country_setting($(this).val());\" onmouseover=\"Tip('" . HARDWARE_COUNTRY . "')\" onmouseout='UnTip()'>";
					foreach ($this->countries_list as $value) {
						if ($value == $database->get('country'))
							$form_elements.="<option value='" . $value . "' selected>" . $value . "</option>";
						else
							$form_elements.="<option value='" . $value . "'>" . $value . "</option>";
					}
					$form_elements.="</select></th></tr>";
					$form_elements.="<tr class='$simple_class'><td>" . HARDWARE_OHS_DIS . "</td><td>"
						. "<select class='form-control' name='ohs' onchange='select_user();' class='country'>"
						. "<option value='ohs=0|ohs2=0'>less than 0.5ms</option>";
					($database->get("ohs") == 0 && $database->get("ohs2") == 1) ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='ohs=0|ohs2=1' " . $selected . ">3ms (ETSI)</option>";
					($database->get("ohs") == 1 && $database->get("ohs2") == 0) ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='ohs=1|ohs2=0' " . $selected . ">26ms</option>"
						. "</select>"
						. "</td></tr>";
					$form_elements.="<tr class='$simple_class'><td>" . HARDWARE_RZ_DIS . "</td><td>"
						. "<select class='form-control' name='rz' onchange='select_user();' class='country'>"
						. "<option value='0'>maximum ringer impedance</option>";
					($database->get("rz") == 1) ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='1' " . $selected . ">synthesized ringer impedance (poland, ZA, Slovenia)</option>"
						. "</select>"
						. "</td></tr>";
					$form_elements.="<tr class='$simple_class'><td>" . HARDWARE_RT_DIS . "</td><td>"
						. "<select class='form-control' name='rt' onchange='select_user();' class='country'>"
						. "<option value='rt=0|rt2=0'>lower level: 13.5V upper level 16.5V</option>";
					($database->get("rt") == 1 && $database->get("rt2") == 0) ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='rt=1|rt2=0' " . $selected . ">lower level: 19.35V upper level 23.65V</option>";
					($database->get("rt") == 1 && $database->get("rt2") == 1) ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='rt=1|rt2=1' " . $selected . ">lower level: 40.5V upper level 49.5V</option>"
						. "</select>"
						. "</td></tr>";
					$form_elements.="<tr class='$simple_class'><td>" . HARDWARE_DCV_DIS . "</td><td>"
						. "<select class='form-control' name='dcv' onchange='select_user();' class='country'>"
						. "<option value='0x0'>3.1V</option>";
					($database->get("dcv") == '0x1') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x1' " . $selected . ">3.2V</option>";
					($database->get("dcv") == '0x2') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x2' " . $selected . ">3.35V</option>";
					($database->get("dcv") == '0x3') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x3' " . $selected . ">3.5V</option>"
						. "</select>"
						. "</td></tr>";
					$form_elements.="<tr class='$simple_class'><td>" . HARDWARE_MINI_DIS . "</td><td>"
						. "<select class='form-control' name='mini' onchange='select_user();' class='country'>"
						. "<option value='0x0'>10 mA</option>";
					($database->get("mini") == '0x1') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x1' " . $selected . ">12 mA</option>";
					($database->get("mini") == '0x2') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x2' " . $selected . ">14 mA</option>";
					($database->get("mini") == '0x3') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x3' " . $selected . ">16 mA</option>"
						. "</select>"
						. "</td></tr>";
					$form_elements.="<tr class='$simple_class'><td>" . HARDWARE_ILIM_DIS . "</td><td>"
						. "<select class='form-control' name='ilim' onchange='select_user();' class='country'>"
						. "<option value='0'>no limit</option>";
					($database->get("ilim") == '1') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='1' " . $selected . ">limit to 60mA</option>"
						. "</select>"
						. "</td></tr>";
					$form_elements.="<tr class='$simple_class'><td>" . HARDWARE_ACIM_DIS . "</td><td>"
						. "<select class='form-control' name='acim' onchange='select_user();' class='country'>"
						. "<option value='0x0'>600 Ohm</option>";
					($database->get("acim") == '0x1') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x1' " . $selected . ">900 Ohm</option>";
					($database->get("acim") == '0x2') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x2' " . $selected . ">270 Ohm + (750 Ohm || 150nF) and 275 Ohm + (780 Ohm || 150nF)</option>";
					($database->get("acim") == '0x3') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x3' " . $selected . ">220 Ohm + (820 Ohm || 120nF) and 220 Ohm + (820 Ohm || 115 nF)</option>";
					($database->get("acim") == '0x4') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x4' " . $selected . ">370 Ohm + (620 Ohm || 310 nF)</option>";
					($database->get("acim") == '0x5') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x5' " . $selected . ">320 Ohm + (1050 Ohm || 230 nF)</option>";
					($database->get("acim") == '0x6') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x6' " . $selected . ">370 Ohm + (820 Ohm || 110 nF)</option>";
					($database->get("acim") == '0x7') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x7' " . $selected . ">275 Ohm + (780 Ohm || 115 nF)</option>";
					($database->get("acim") == '0x8') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x8' " . $selected . ">120 Ohm + (820 Ohm || 110 nF)</option>";
					($database->get("acim") == '0x9') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0x9' " . $selected . ">350 Ohm + (1000 Ohm || 210 nF)</option>";
					($database->get("acim") == '0xa') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0xa' " . $selected . ">200 Ohm + (680 Ohm || 100 nF)</option>";
					($database->get("acim") == '0xb') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0xb' " . $selected . ">600 Ohm + 2.16 μF</option>";
					($database->get("acim") == '0xc') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0xc' " . $selected . ">900 Ohm + 1 μF</option>";
					($database->get("acim") == '0xd') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0xd' " . $selected . ">900 Ohm + 2.16 μF</option>";
					($database->get("acim") == '0xe') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0xe' " . $selected . ">600 Ohm + 1 μF</option>";
					($database->get("acim") == '0xf') ? $selected = "selected" : $selected = "";
					$form_elements.= "<option value='0xf' " . $selected . ">Global impedance</option>"
						. "</select>"
						. "</td></tr>";
						
					$fxo_config_wait4idle = $database->get('wait4idle');
					if ($fxo_config_wait4idle == "" || $fxo_config_wait4idle < 1000) {
						$fxo_config_wait4idle =  1000;
					}
					else if ($fxo_config_wait4idle > 10000) {
						$fxo_config_wait4idle =  10000;
					}
					$form_elements.="<tr onmouseover='Tip(\"" . HARDWARE_WAIT4IDLE_TOOLTIP . "\")' onmouseout='UnTip()' class='$simple_class'><td>" . HARDWARE_WAIT4IDLE . "</td><td>";
					$form_elements.="<input type='text' class='form-control' name='wait4idle' value='" . $fxo_config_wait4idle . "'> </tr>\n";
				}

				if (count(array_filter(array_map('_isMatch', $type, array_fill(0, count($type), '/bf.*FXS/')))) > 0) {
					$form_elements.="<tr ><th><b style='vertical-align: middle;'>" . HARDWARE_BOOSTRINGER_DIS . ":</b></th><th><select class='form-control' name='boostringer'>";

					($database->get('boostringer') == 0) ? $form_elements.="<option value='0' selected>49V</option>" : $form_elements.="<option value='0'>49V</option>";
					($database->get('boostringer') == 1) ? $form_elements.="<option value='1' selected>89V</option>" : $form_elements.="<option value='1'>89V</option>";
					$form_elements.="</select></th></tr>";
					
					$fxs_config_ring_oscillator_on = $database->get('ring_oscillator_on');
					if ($fxs_config_ring_oscillator_on == "") {
						$fxs_config_ring_oscillator_on = 1000;
					}
					$form_elements.="<tr onmouseover='Tip(\"" . HARDWARE_RING_OSCILLATOR_ON_TOOLTIP . "\")' onmouseout='UnTip()'  ><th><b style='vertical-align: middle;'>" . HARDWARE_RING_OSCILLATOR_ON . ":</b></th>";
					$form_elements.="<td><input type='text' class='form-control' name='ring_oscillator_on' value='" . $fxs_config_ring_oscillator_on . "'> </td></tr>\n";
					
					$fxs_config_ring_oscillator_off = $database->get('ring_oscillator_off');
					if ($fxs_config_ring_oscillator_off == "") {
						$fxs_config_ring_oscillator_off = 4000;
					}
					$form_elements.="<tr onmouseover='Tip(\"" . HARDWARE_RING_OSCILLATOR_OFF_TOOLTIP . "\")' onmouseout='UnTip()'  ><th><b style='vertical-align: middle;'>" . HARDWARE_RING_OSCILLATOR_OFF . ":</b></th>";
					$form_elements.="<td><input type='text' class='form-control' name='ring_oscillator_off' value='" . $fxs_config_ring_oscillator_off . "'> </td></tr>\n";
				}
				
				$form_elements.="</table>";
				
				
			}

			//Portswitch
			if ((Helper::getType() < 30) && in_array($type[0], array('bf4S0', 'bf4FXO', 'bf4FXS', 'bf2S02FXS')) && !isset($type[1]) && !in_array($revision, array('1.80', '1.8'))) {
				$form_elements.="<br/>"
					. "<br/>"
					. "<table class='table table-striped table-bordered' style='width:90% !important; margin:auto;'>"
					. "<tr onmouseover=\"Tip('" . HARDWARE_PORT_SWITCH . "')\" onmouseout='UnTip()'>
								<th>" . HARDWARE_CARD_TYPE_DIS . ":&nbsp;none&nbsp;&nbsp;" . HARDWARE_LINE_INTERFACE_DIS . ":&nbsp;1&nbsp;&nbsp;" . HARDWARE_PORTSWITCH_DIS . ":&nbsp;";
				//$query=$database->select("select value from key_val where key='portswitch'");
				if ($database->get('portswitch') == "") {
					$form_elements.="<input type='checkbox' name='portswitch' value='1' checked>";
				} elseif ($database->get('portswitch') == "1") {
					$form_elements.="<input type='checkbox' name='portswitch' value='1' checked>";
				} elseif ($database->get('portswitch') == "0") {
					$form_elements.="<input type='checkbox' name='portswitch' value='1'>";
				}
				$form_elements.="</th>"
					. "</tr>"
					. "</table>";
			}
			$form_elements.="<br /><br />";
			//PCM
			$pcm_ip = "";
			if ($database->get('pcm_server') != 0 && $database->get('pcm_server') != 1)
				$pcm_ip = $database->get('pcm_server');
			$pcm_server_port = '54329';
			if ($database->get('pcm_server_port') != "")
				$pcm_server_port = $database->get('pcm_server_port');
			$form_elements.="<table id='pcm_client' style='width:90% !important; display:none; margin:auto;' class='table table-striped table-bordered'>
		                     <tr>
		                         <th nowrap>
						<div class='row'>
		                         	<div class='col-sm-5'><label for='pcm_ip'>" . HARDWARE_PCM_MASTER_IP_DIS . ":</label></div>
		                         	<div class='col-sm-7'><input type='text' class='form-control' name='pcm_ip' value='" . $pcm_ip . "'></div>
						</div>
		                         </th>
		                         <th nowrap>
						<div class='row'>
		                         	<div class='col-sm-5'><label for='pcm_server_port'>" . HARDWARE_PCM_MASTER_PORT_DIS . ":</label></div>

		                         	<div class='col-sm-7'><input type='text' class='form-control' name='pcm_server_port' value='" . $pcm_server_port . "'></div>
						</div>
		                         </th>
		                     </tr>
		                 </table>";

			$form_elements.="<table id='pcm_server' style='width:90% !important; margin:auto; display:none;' class='table table-striped table-bordered'>
		                     <tr>
		                         <th nowrap onmouseover=\"Tip('" . HARDWARE_PCM_BRIDGING . "')\" onmouseout='UnTip()'>
		                         	<div class='row'>
						<div class='col-sm-5'>" . HARDWARE_PCM_BRIDGING_DIS . ":</div>"
				. "<div class='col-sm-7'>";
			if ($database->get('pcm_server') == 1)
				$form_elements.="<input type='checkbox' name='pcm_server' value='1' checked>";
			else
				$form_elements.="<input type='checkbox' name='pcm_server' value='1'>";
			$form_elements.="</div>
		    </div>
		    </th>
		                         <th nowrap>
						<div class='row'>
		                         	<div class='col-sm-4'><label>" . HARDWARE_PCM_MASTER_PORT_DIS . "</label>:</div>
		                         	<div class='col-sm-8'>
						<input type='text' class='form-control' name='pcm_server_port' value='" . $pcm_server_port . "'>
						</div>
						</div>
		                         </th>
		                     </tr>
		                 </table>";

			$form_elements.="<br/>
		<div class='text-center'><input type='submit' class='btn btn-default' value='" . BUTTON_SAVE . "' onmouseover=\"Tip('" . ISDNHW_SAVE . "')\"
		onmouseout='UnTip()'></div>";
		}
		return $form_elements;
	}
	
	
	private function gsm_provider_settings($port) {
	
		$isgw = new isgwtelnet();
		$ret = $isgw->isgw_login();
		
		if ($ret == FALSE) {
			$list = "No ISGW";
		}
		else {
			$list = $isgw->isgw_show_gsmoperators($port);
		}
		
		$database = new beroAri();
		
		$options = array();
		$query = $database->select("select provider from lte where port='" . $port . "'");
		
		$current_provider_setting = "";
		$current_provider_mode = 0;

		while ($entry = $database->fetch_array($query)) {
			if (strlen ($entry["provider"]) > 2 && ($entry["provider"][0] == '1' || $entry["provider"][0] == '2') && $entry["provider"][1] == ':') {
				$current_provider_setting = substr ($entry["provider"], 2);
				$current_provider_mode = $entry["provider"][0];
				//we don't show availibility for stored value
				$current_provider_setting = preg_replace ("/].*/", "]",$current_provider_setting);
				array_push ($options, $current_provider_setting);
			}
			break;
		}
		
		switch ($current_provider_mode) {
			case 0:
				$selected0 = "selected";
				break;
			case 1:
				$selected1 = "selected";
				break;
			case 2:
				$selected2 = "selected";
				break;
		}
		
		$lines = explode("\n", $list);
		foreach ($lines as $line) {
			$line = str_replace("\r",  '', $line);
			if (!strlen ($line)) {
				continue;
			}
			
			$scanmode = 0;
			if ($line == "No Scan Results" || $line == "Scanning Now"|| $line == "No ISGW") {
				
				if ($line == "No Scan Results") {
					$scanmode = 1;
				}
				else if ($line == "Scanning Now") {
					$scanmode = 2;
				}
				else if ($line == "No ISGW") {
					$scanmode = 3;
				}
				if ($current_provider_setting == "") {
					array_push ($options, "--------");
				}
				break;
			}
			
			$xfields = explode(":", $line);
			if (!(count ($xfields) == 2 || count ($xfields) == 3)) {
				continue;
			}
			
			$fields = explode("|", $xfields[0]);
			
			$fn = 0;
			foreach ($fields as $field) {
				switch ($fn) {
					case 0:
						$accessibility = $field;
						break;
					case 1:
						$long_alphanumeric = $field;
						break;
					case 2:
						$short_alphanumeric = $field;
						break;
					case 3:
						$numeric = $field;
						break;
					case 4:
						$access_technology = $field;
						break;
				}
				$fn++;
			}
			if ($fn != 5) {
				continue;
			}
			array_push ($options, $line);
		}
		ob_start();
		
		if ($port == 1) {
		?>
		
		<script type='text/javascript'>
		function show_provider_ids(port) {
			if ($('#provider_mode'  + port + ' option:selected').val() == 0) {
				$('#provider_ids' + port).hide();
			}
			else {
				$('#provider_ids' + port).show();
			}
		}
		
		</script>
		<?php } ?>
		
		<div name='provider'>
		<select name='provider_mode<?php echo $port ?>' id='provider_mode<?php echo $port ?>' onchange='show_provider_ids(<?php echo $port ?>)'>
		<option value=0 <?php echo $selected0; ?>>Automatic</option>
		<option value=1 <?php echo $selected1; ?>>Manual</option>
		<option value=2 <?php echo $selected2; ?>>Manual/Automatic</option>
		</select>
		</div>
		
		<select name='provider_ids<?php echo $port ?>'  id='provider_ids<?php echo $port ?>' >
			<?php
			$counter = 0;
			foreach ($options as $value) {
			
				$fields = explode(":", $value);
				
				if (count($fields) == 2) {
					$value_text = $value;
					$shown_text = $fields[1];
					
				}
				else {
					$value_text = $value;
					$shown_text = $value;
				}
// 				if ($value == $current_provider_setting && $counter != 0) {
// 					continue;
// 				}
				$counter++;
				?>
				
				<option value='<?php echo $value?>' <?php echo $selected ?>><?php echo $shown_text ?></option>
			<?php } ?>
		</select>
			
		<script type='text/javascript'>
		
		if ($('#provider_mode<?php echo $port ?> option:selected').val() == 0) {
			$('#provider_ids<?php echo $port ?>').hide();
		}
		</script>
		<br><br>
		
<?php 
	if ($scanmode == 1) {
			printf ("<div onmouseover=\"Tip('No Scan Results yet<br>Click Scan Providers (scanning can take up to one minute)!')\" onmouseout='UnTip()'> " . $line . "<br><br></div>");
 	}
 	if ($scanmode == 2) {
			printf ("<div onmouseover=\"Tip('Scanning now!<br>Please wait up to one minute and reload the page!')\" onmouseout='UnTip()'> " . $line . "<br><br></div>");
 	}
	if ($scanmode == 3) {
		printf ("<div onmouseover=\"Tip('Cannot connect to isgw!<br>Cannot scan now!')\" onmouseout='UnTip()'> " . $line . "<br><br></div>");
 	}
 	if ($scanmode == 0 || $scanmode == 1) {
?>
		<a href="index.php?m=PstnHardware&ltescan=<?php echo $port ?>">Scan Providers </a>
<?php
}
?>
		<?php
		
		return ob_get_clean();
	}
}

?>


