<?php

/**
 * Implementiert das Versenden, Einsehen und Löschen von SMS.
 * @author Miguel Palmer <mp@beronet.com>
 * @author Florian Kraatz <florian.kraatz@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Sms {

	private		$m_attr;

	private		$post_attr,
			$post_checked = 0;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

        function __construct($m, $get = array(), $post = array(), $session = array()) {

		$this->m_attr = $m;
		
		if (isset($post['number']) && isset($post['port'])) {
			$list_post = array('number' => 'international-code', 'port' => 'match', 'text' => 'accept');

			$list_post_options = array('port' => '^([0-9]{1,3})-(LTE|GSM)$');

			$this->post_checked = 1;
			$this->post_attr = Helper::sanitizePost($post, $list_post, $this->post_checked, $this->reasonRejected);

			$this->isRequestRejected = !$this->post_checked;
		}
	}

	/**
	 * Get the options for the ports dropdown menu
	 * @return string
	 */
	function port() {
		$ba = new beroAri();
		$query = $ba->select("SELECT port, port_type FROM gsm union SELECT port, port_type FROM lte order by port_type, port");
		$ret = "";
		while ($entry = $ba->fetch_array($query)) {
			$ret.="<option value='" . $entry['port'] . "-" . $entry['port_type'] . "'>" . $entry['port'] . "-" . $entry['port_type'] . "</option>";
		}
		return $ret;
	}

	/**
	 * Send a SMS
	 * @param isgwtelnet $isgw
	 * @return string Result
	 */
	function sendSMS($isgw) {
		if (strlen($this->post_attr['text']) <= 670) {
			if (!is_dir("/tmp/sms/out"))
				mkdir("/tmp/sms/out", 0777, true);
			$file = '/tmp/sms/out/' . uniqid() . '.sms';
			// Open the file to get existing content
			$content = "num=" . $this->post_attr['number'] . "\n" .
				"port=" . $this->post_attr['port'] . "\n" .
				"msg=" . $this->post_attr['text'];
			// Write the contents back to the file
			file_put_contents($file, $content);
			//SMS sofort senden

			$result = $isgw->isgw_login();
			if ($result != false)
				$isgw->ssms();
		}else {
			$ret.="<br/><font color='red'>Error!</font>";
		}
		return $ret;
	}

	/**
	 * Generates the HTML page
	 * @retrun string
	 */
	function display() {

		$ba = new beroAri();
		$name = "SMS_TITLE_DIS";
		include('./includes/header.php');

		if ($this->post_checked) {
			require_once ('./includes/isgwtelnet.php');
			$isgw = new isgwtelnet();
			$ret.=$this->sendSMS($isgw);
		} else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']); 
		}

		$dir = "/tmp/sms/in/";
		$dirFail = "/tmp/sms/failout/";
		ob_start();
		?>

		<script type='text/javascript'>
			function contentDisp(filename)
			{
				$.ajax({
					url: 'misc/fileContent.php?filename=' + filename,
					success: function (data) {
						$('#dialog').html(data);
						$('#dialog').dialog();
					}
				});
			}
		</script>
		<div id='dialog' title='SMS'></div>
		<script type='text/javascript'>
			function del(filename, opt) {
				conf = confirm('<?php echo SMS_DELETE_MESSAGE_DIS ?>?');
				if (conf == false)
					return false;
				else {
					window.location = './misc/deletefile.php?m=<?php echo $this->m_attr; ?>&option=' + opt + '&filename=' + filename;
				}
			}
		</script>
		<br/>
		<form name='sendSMS' id='sendSMS' method='POST' class="form-horizontal">
			<div class="form-group" >
				<label for='port' class='col-sm-5 control-label'><?php echo SMS_PORT_DIS ?></label>
				<div class='col-sm-4'>
					<select name='port' class='form-control input-sm'>
						<?php echo $this->port() ?>
					</select>
				</div>
			</div>
			<div class="form-group" >
				<label for='number' class='col-sm-5 control-label'><?php echo SMS_NUMBER_DIS ?></label>
				<div class='col-sm-4'>
					<input name='number' class='form-control input-sm' type="text" checkPhoneNumber='true'>
				</div>
			</div>
			<div class="form-group" >
				<label for='text' class='col-sm-5 control-label'><?php echo SMS_TEXT_DIS ?></label>
				<div class='col-sm-4'>
					<textarea name='text' class='form-control' cols='40' rows='8' id='smsmessageId'
							  onkeyup="countAndLimitChars('smscountline', 'smsmessageId', '<?php echo SMS_REMAINING_CHARS_DIS ?>')"
							  onkeydown="countAndLimitChars('smscountline', 'smsmessageId', '<?php echo SMS_REMAINING_CHARS_DIS ?>')"></textarea>
					<span id="smscountline" class="help-block"><?php echo SMS_REMAINING_CHARS_DIS ?>: 670</span>
				</div>
			</div>
			<div class='text-center'><input type='submit' class='btn btn-default' value='Send'/></div>
		</form>
		<script>
			$("#sendSMS").validate();
		</script>
		<?php if (is_dir("/tmp/sms/in")): ?>
			<br/>
			<table class='table table-striped table-bordered' style='max-width:600px; margin:auto;'>
				<tr>
					<th colspan='2' class='text-center'><?php echo SMS_INBOX_DIS ?></th>
				</tr>
				<?php foreach (glob($dir . "*.sms") as $filename) : ?>

					<tr>
						<td>
							<a onclick='contentDisp("/tmp/sms/in/<?php echo basename($filename) ?>")' onmouseover='$(this).css("cursor", "pointer")'>
								<?php echo basename($filename) ?>
							</a>
						</td>
						<td>
							<a class='popup_download' onclick='javascript:del("<?php echo basename($filename) ?>", "sms")'>
								<img src='./includes/images/delete.png'>
							</a>
						</td>
					</tr>
				<?php endforeach; ?>
			</table>
			<?php
		endif;

		if (is_dir("/tmp/sms/failout/")) :
			?>
			<br/>
			<table class='table table-striped table-bordered' style='max-width:600px; margin:auto;'>
				<tr>
					<th colspan='5' class='text-center'><?php echo SMS_FAIL_DIS ?></th>
				</tr>
				<tr>
					<th ><?php echo SMS_DATE_DIS ?></th>
					<th ><?php echo SMS_DESTINATION_DIS ?></th>
					<th ><?php echo SMS_PORT_DIS ?></th>
					<th ><?php echo SMS_LOG_DIS ?></th>
					<th ></th>
				</tr>
				<?php
				if ($handle = @opendir($dirFail)) :
					while (false !== ($file = readdir($handle))) :
						if ($file == "." || $file == "..") {
							continue;
						}

						if (!file_exists($dirFail . $file . '/message')) {
							continue;
						}

						$content = file($dirFail . $file . '/message');
						?>
						<tr>
							<td><?php echo date("d M Y H:i", filectime($dirFail . $file . '/message')) ?></td>
							<?php
							foreach ($content as $line) :
								if (strpos($line, "port") !== false) :
									$v = explode("=", $line);
									?>
									<td><?php echo $v[1] ?></td>
									<?php
								endif;
								if (strpos($line, "num") !== false) :
									$v = explode("=", $line);
									?>
									<td><?php echo $v[1] ?></td>
									<?php
								endif;
							endforeach;
							?>
							<td><?php echo @file_get_contents($dirFail . $file . '/message.log'); ?></td>
							<td>
								<a class='popup_download' onclick='javascript:del("<?php echo $file ?>", "smsFail")'>
									<img src='./includes/images/delete.png'>
								</a>
							</td>
						</tr>
						<?php
					endwhile;
					closedir($handle);
				endif;
				?>
			</table>
		<?php endif; ?>
		<br/>
		<?php
		$ret .= ob_get_clean();

		return $ret;
	}

}
?>
