<?php
class Telnet {
	/* [ATTRIBUTS] */
	private $_m;

	private $_data_list = array(
		'cmd' 		=> array(
			'button-value'	=> 'TELNET_BUTTON_CMD_DIS',
			'default' 	=> '',
			'key' 		=> 'cmd',
			'title'		=> 'TELNET_DATA_CMD_DIS',
			'tooltip'	=> 'TELNET_DATA_CMD_TOOLTIP',
		),
		'telnetOutput' 	=> array(
			'default'	=> 'TELNET_DEFAULT_OUTPUT_DIS',
			'empty'		=> 'TELNET_EMPTY_OUTPUT_DIS',
			'error'		=> 'TELNET_EMPTY_VALUE_ERROR_DIS',
			'error-key'	=> 'telnet_error', 
			'key'		=> 'telnetOutput',
			'value'		=> 'TELNET_WAITING_MESSAGE',
		),
	);

	/* [CONSTRUCTOR] */
        function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->_m = $m;
	}

	/* [PUBLIC METHODS] */
	public function display($id_ajax = 'sendCmd') {
		// header
		$name = "TELNET_TITLE_DIS";
		include('./includes/header.php');

		// display content
		$ret .=	  "<div id='{$this->_data_list['telnetOutput']['error-key']}' class='text-center' style='color: red; font-size: 13px; margin-top: 20px; margin-bottom: -20px;'></div>\n"
			. "<div id='content' style='margin-top:45px;'>\n"
			. $this->_displayTelnetInput($this->_data_list['cmd'], $id_ajax, "\t\t")
			. $this->_displayTelnetOutput($this->_data_list['telnetOutput'], "\t")
			. $this->_displayAjaxRequest($this->_data_list['cmd'], $this->_data_list['telnetOutput'], $id_ajax)
			. "</div>\n";

		return $ret;
	}

	/* [PRIVATE METHODS] */
	private function _displayTelnetInput($cmd, $id_ajax, $tab = "\t") {
		$html	= "$tab<div style='display:inline-flex;width:100%;'>\n"
			. "$tab\t<label style='margin-left:15%;padding-top:8px;' for='label_{$cmd['key']}'>". constant($cmd['title']) ."</label>\n"
                        . "$tab\t<div style='float:left;margin-left:2%;width:52%;' data-toggle='tooltip' title='". constant($cmd['tooltip']) ."'>\n"
                        . "$tab\t\t<input type='text' name='data[{$cmd['key']}]' id='id_{$cmd['key']}' value='{$cmd['default']}' style='width:100%;'>\n"
                        . "$tab\t</div>\n"
			. "$tab\t<div style='margin-left:2%;'>\n"
			. "$tab\t\t<button id='id_$id_ajax' class='btn btn-default' value='1'>". constant($cmd['button-value']) ."</button>\n"
			. "$tab\t</div>\n"
                	. "$tab</div>\n";
		return $html;
	}

	private function _displayTelnetOutput($param, $tab = "\t") {
		$html 	= "$tab<div id='id_{$param['key']}' style='overflow:auto;padding-left:10px;background-color:#F0F0F0;border:1px solid #CCCCCC;height:200px;width:90%;margin:auto;margin-top:25px;'>\n"
			. "$tab\t". constant($param['default']). "\n"
			. "$tab</div>\n"
			. "$tab<script type='text/javascript'>\n"
			. "$tab\tvar bottom = $('#id_{$param['key']}').attr('scrollHeight');\n"
			. "$tab\t$('#id_{$param['key']}').scrollTop(bottom);\n"
			. "$tab</script>\n";
		return $html;
	}

	private function _displayAjaxRequest($cmd, $output, $id_ajax) {
		$waiting = '<img style="display:block; margin-left:auto; margin-right:auto;" src="./includes/images/waitlogo1.gif"><br/><div class="text-center">'. constant($output['value']) .'</div>';
		ob_start();
		?>
	<script type="text/javascript">
		window.ajax_loading = false;
		$('button').click(function (element) {
			// init
			if (window.ajax_loading) {
				return;
			}
			var cmdValue = $('#id_<?php echo $cmd['key']; ?>').val();
			// check the value
			if (cmdValue == '') {
				$('#<?php echo $output['error-key']; ?>').html('<?php echo constant($output['error']); ?>');
				return;
			}
			// send AJAX request
			window.ajax_loading = true;
			$('#<?php echo $output['error-key']; ?>').html('');
			$('#id_<?php echo $id_ajax; ?>').prop('disabled', true);
			$('#id_<?php echo $output['key']; ?>').html('<?php echo $waiting; ?>');
			$.ajax({
				cache: false,
				data: {
					<?php echo $cmd['key']; ?>: cmdValue,
				},
				error: function (statusText, errorThrow) {
					window.ajax_loading = false;
					$('#id_<?php echo $id_ajax; ?>').prop('disabled', false);
					$('#id_<?php echo $output['key']; ?>').html(errorThrow);
				},
				success: function (data) {
					var regex = new RegExp('^<br.*\/>.*');
					if (regex.test(data)) {
						data = '<?php echo constant($output['empty']); ?>';
					}
					window.ajax_loading = false;
					$('#id_<?php echo $id_ajax; ?>').prop('disabled', false);
					$('#id_<?php echo $output['key']; ?>').html(data);
				},
				timeout: 30000,
				type: 'POST',
				url: './modules/Telnet/isgw_request.php',
			});
		});
	</script>
		<?php
		return ob_get_clean() ."\n";
	}
}
?>
