<?php

class ActivateWizard
{
	// dialplan variables
	var $fromDirection = 'fromDirection';
	var $toDirection   = 'toDirection'  ;
	var $fromId	   = 'fromId'	    ;
	var $toId	   = 'toId'	    ;
	var $dest	   = 'dest'	    ;
	var $newDest	   = 'newDest'	    ;
	var $src	   = 'src'	    ;
	var $newSrc	   = 'newSrc'	    ;

	// dialplan rules
	var $main_rules	    = array();
	var $dialplan_rules = array(); 

	// class variables
	var $network_wizard   = NULL;
	var $scenarios_wizard = NULL;
	var $sip_wizard	      = NULL;
	var $pstn_wizard      = NULL;

	// settings
	var $scenario_settings = '';
	var $sip_settings      = '';
	var $pstn_settings     = '';
	var $network_settings  = '';

	// file
	var $file_conf 	= '/tmp/wizard-voip.conf';

	function __construct($wizard_cfg = array())
	{
		if (count($wizard_cfg) == 0)
		{
			return;
		}

		if (isset($wizard_cfg['Dialplan']))
		{
			unset($wizard_cfg['Dialplan']);
		}

		// getting the Network Settings and the parameters to keep
		$keep_parameters = array();
		if (isset($wizard_cfg['Configuration']))
		{
			$keep_parameters['acl']    = $wizard_cfg['Configuration']['save_acl'];
			$keep_parameters['provisioning'] = $wizard_cfg['Configuration']['save_provisioning'];
			$keep_parameters['cloud']  = $wizard_cfg['Configuration']['save_cloud'];
			$keep_parameters['prefix'] = $wizard_cfg['Configuration']['save_prefix'];

			require_once('./modules/Wizard/network_wizard_popup.php');	
			$this -> network_wizard   = new NetworkWizard();
			$this -> network_settings = $wizard_cfg['Network'];
		}
		else
		{
			$keep_parameters['acl']    = $wizard_cfg['Network']['save_acl'];
			$keep_parameters['provisioning'] = $wizard_cfg['Network']['save_provisioning'];
			$keep_parameters['cloud']  = $wizard_cfg['Network']['save_cloud'];
			$keep_parameters['prefix'] = $wizard_cfg['Network']['save_prefix'];
		}

		// getting the Scenarios Settings
		require_once('./modules/Wizard/scenarios_wizard_popup.php');	
		$this -> scenarios_wizard  = new ScenariosWizard(false);
		if (isset($_SESSION['pbx'])) { 
			$this -> scenario_settings = 2;
		} else {
        	$this -> scenario_settings = $wizard_cfg['Scenarios']['scenario'];
    	}
    	
		// getting the Sip Settings
		require_once('./modules/Wizard/sip_wizard_popup.php');	
		$this -> sip_wizard   = new SipWizard($this -> scenario_settings);
		$this -> sip_settings = $this -> sip_wizard -> organize_settings($wizard_cfg['Sip']);

		// getting the Pstn Settings
		require_once('./modules/Wizard/pstn_wizard_popup.php');	
		$this -> pstn_wizard   = new PstnWizard($this -> scenario_settings, false);
		$this -> pstn_settings = $this -> pstn_wizard -> organize_settings($wizard_cfg['Pstn']);

		// set the Dialplan rules
		$this -> main_rules     = array($this -> dest => '.*', $this -> newDest => "\\1", $this -> src => '.*', $this -> newSrc => "\\1");
		$this -> dialplan_rules = $this -> _set_dialplan_rules($this -> scenario_settings, $this -> sip_settings, $this -> pstn_settings);

		// generate config file to activate 
		$this -> _save_config_file($this -> scenario_settings, $keep_parameters, $this -> network_settings, $this -> sip_settings, $this -> pstn_settings, $this -> dialplan_rules);
	}

	// private 
	function _set_dialplan_rules ($scenario, $sip_settings, $pstn_settings)
	{
		if ($scenario == 2)
		{ 
			return $this -> _set_pbx_dialplan_rules($pstn_settings);
		}

		return $this -> _set_gateway_dialplan_rules($sip_settings, $pstn_settings['extern']);
	}

	function _get_to_direction ($type)
	{
		// setting toDirection 
		if (preg_match("#pri#", $type) || preg_match("#bri#", $type))
		{
			return 'isdn';
		}
		else if (preg_match('#fxs#', $type) || preg_match("#fxo#", $type))
		{
			return 'analog';
		}
		else if (preg_match("#gsm#", $type))
		{
			return 'gsm';
		}
		else if (preg_match('#lte#', $type))
		{
			return 'lte';
		}
	}

	function _set_gateway_dialplan_rules ($sip_settings, $pstn_settings)
	{
		foreach ($pstn_settings as $port_type => $parameters)
		{
			$dialplan_rules['Dialplan-Extern-'. $port_type] = $this -> main_rules;
	
			// update dialplan rules (SIP => PSTN)
			$dialplan_rules['Dialplan-Extern-'. $port_type][$this -> fromDirection] = 'sip' ;
			$dialplan_rules['Dialplan-Extern-'. $port_type][$this -> toDirection]   = $this -> _get_to_direction($port_type);
	
			$dialplan_rules['Dialplan-Extern-'. $port_type][$this -> fromId] = $sip_settings['name']  ;
			$dialplan_rules['Dialplan-Extern-'. $port_type][$this -> toId]   = $parameters['group'];
		}

		return $dialplan_rules;
	}

	function _set_pbx_dialplan_rules ($pstn_settings)
	{
		// TODO: on Voip.php file: if ($_GET['pbx'] == "3CX") { from_sip_src_setting=from_display; } ..... how the $_GET['pbx'] is initialized
		$dialplan_rules = $this -> main_rules; 

		$dialplan_rules_intern = array();
		$dialplan_rules_extern = array();

		// setting fromDirection and toDirection
		$dialplan_rules[$this -> fromDirection] = 'sip' ;

		// extern dialplan rules
		if (isset($pstn_settings['extern']))
		{
			$dialplan_rules_extern = $this -> _set_extern_pbx_dialplan_rules($pstn_settings['extern'], $dialplan_rules);
		}

		// intern dialplan rules
		if (isset($pstn_settings['intern']))
		{
			$dialplan_rules_intern = $this -> _set_intern_pbx_dialplan_rules($pstn_settings['intern'], $dialplan_rules);		
		}

		return array_merge($dialplan_rules_extern, $dialplan_rules_intern);
	}

	function _set_extern_pbx_dialplan_rules ($pstn_extern, $dialplan_rules)
	{
		foreach ($pstn_extern as $port_type => $parameters)
		{
			$extern["Dialplan-Extern-$port_type"] = $dialplan_rules; 

			$extern["Dialplan-Extern-$port_type"][$this -> toDirection] = $this -> _get_to_direction($port_type);	
			if(isset($_SESSION['pbx'])) {
				$extern["Dialplan-Extern-$port_type"][$this -> fromId] = $_SESSION['pbx'] . "-" . $parameters['group']; 
			} else {
				$extern["Dialplan-Extern-$port_type"][$this -> fromId] = "SIP-". $parameters['group']; 
			}
			$extern["Dialplan-Extern-$port_type"][$this -> toId]   = $parameters['group'];
		}

		return $extern;
	}

	function _set_intern_pbx_dialplan_rules ($pstn_intern, $dialplan_rules)
	{
		foreach ($pstn_intern as $port_type => $intern_parameters)
		{
			foreach ($intern_parameters as $port => $parameters)
			{
				$group_name = "Intern-$port_type-$port";

				$intern["Dialplan-$group_name"] = $dialplan_rules;

				$intern["Dialplan-$group_name"][$this -> toDirection] = $this -> _get_to_direction($port_type);	
				if(isset($_SESSION['pbx'])) {
					$intern["Dialplan-$group_name"][$this -> fromId] = $_SESSION['pbx'] . "-" .$group_name;
				} else {
					$intern["Dialplan-$group_name"][$this -> fromId] = "SIP-" .$group_name;
				}
				$intern["Dialplan-$group_name"][$this -> toId]   = $group_name;
			}
		}

		return $intern;
	}

	function _save_config_file ($scenario, $parameters_saved, $network_settings, $sip_settings, $pstn_settings, $dialplan_rules)
	{
		// scenario + parameters saved
		$wizard_str  = "Scenario=$scenario\n";
		foreach ($parameters_saved as $key => $value) 
		{
			$wizard_str .= "$key=$value\n";
		}
		$wizard_str .= "\n";

		// Network settings
		if (!(is_null($this -> network_wizard)))
		{
			$wizard_str .= "[Network]\n";
			foreach ($network_settings as $parameter => $value)
			{	
				$wizard_str .= $parameter ."=". $value ."\n";
			}
			$wizard_str .= "\n";
		}

		// SIP / PBX settings
		$wizard_str .= '['. ($scenario == 2 ? 'Pbx' : 'Sip') ."]\n";
		foreach ($sip_settings as $parameter => $value)
		{
			$wizard_str .= $parameter ."=". $value ."\n";
		}
		$wizard_str .= "\n";

		// PSTN settings
		if (isset($pstn_settings['extern']))
		{
			foreach ($pstn_settings['extern'] as $port_type => $parameters)
			{
				$wizard_str .= "[Pstn-Extern-$port_type]\n";
				foreach ($parameters as $parameter => $value)
				{
					$wizard_str .= $parameter ."=". $value ."\n";
				}
				$wizard_str .= "\n";
			}
		}

		if (isset($pstn_settings['intern']))
		{
			foreach ($pstn_settings['intern'] as $port_type => $port_list)
			{
				foreach ($port_list as $port => $array_parameter)
				{
					$wizard_str .= "[Pstn-Intern-$port_type-$port]\n";
					foreach ($array_parameter as $parameter => $value)
					{
						$wizard_str .= $parameter ."=". $value ."\n";
					}
					$wizard_str .= "\n";
				}
			}
		}

		// Dialplan settings
		foreach (array_keys($dialplan_rules) as $key_dialplan)
		{
			$wizard_str .= "[$key_dialplan]\n";
			foreach ($dialplan_rules[$key_dialplan] as $parameter => $value)
			{
				$wizard_str .= $parameter ."=". $value ."\n";
			}
			$wizard_str .= "\n";
		}

		//save into a film
		$fp = fopen($this -> file_conf, "w+");
		fputs($fp, html_entity_decode($wizard_str));
		fclose($fp);	
	}

	function _display_dialplan_rules($rules)
	{
		ob_start();
?>
			<p class='text-center h4'><?php echo WIZARD_DIALPLAN_SETTINGS_DIS; ?></p>
			<table class='table table-striped table-bordered'>
				<tr>
					<th>	<?php echo DIALPLAN_DIRECTION_DIS; ?>	</th>
					<th>	<?php echo DIALPLAN_FROM_ID_DIS; ?>	</th>
					<th>	<?php echo DIALPLAN_TO_ID_DIS; ?>	</th>
				</tr>
<?php
		$html_str = ob_get_clean();

		foreach (array_keys($rules) as $key_dialplan)
		{
			$html_str .=	  "\t\t\t\t<tr>\n"
					. "\t\t\t\t\t<td>". $rules[$key_dialplan][$this -> fromDirection] .'-'. $rules[$key_dialplan][$this -> toDirection] ."</td>\n"
					. "\t\t\t\t\t<td>". $rules[$key_dialplan][$this -> fromId] ."</td>\n"
					. "\t\t\t\t\t<td>". $rules[$key_dialplan][$this -> toId] ."</td\n>"
					. "\t\t\t\t</tr>\n"
					. "\t\t\t\t<tr>\n"
					. "\t\t\t\t\t<td>". $rules[$key_dialplan][$this -> toDirection] .'-'. $rules[$key_dialplan][$this -> fromDirection] ."</td>\n"
					. "\t\t\t\t\t<td>". $rules[$key_dialplan][$this -> toId] ."</td>\n"
					. "\t\t\t\t\t<td>". $rules[$key_dialplan][$this -> fromId] ."</td\n>"
					. "\t\t\t\t</tr>\n";
		}

		ob_start();
?>
			</table>
<?php
		return $html_str . ob_get_clean();
	}

	// public 
	function get_modal_content ()
	{
		$html_str = '';

		// display network
		if (!(is_null($this -> network_wizard)))
		{
			$html_str .= $this -> network_wizard -> get_summary_settings($this -> network_settings);
		}

		// display scenario
		$html_str .= $this -> scenarios_wizard -> get_summary_settings($this -> scenario_settings);

		// display sip
		$html_str .= $this -> sip_wizard -> get_summary_settings($this -> scenario_settings, $this -> sip_settings);

		// display pstn
		$html_str .= $this -> pstn_wizard -> get_summary_settings($this -> scenario_settings, $this -> pstn_settings);

		// display dialplan rules
		$html_str .= $this -> _display_dialplan_rules($this -> dialplan_rules);	

		return $html_str;
	}
}
?>
