<?php

if (!defined('_XML_PARSE_DATA')) {
	define('_XML_PARSE_DATA', true);

	function xmlParseData ($xmldata, $parent = 'root') {

		// higher backtrack-limit if data are over 7000 bytes
		if (strlen($xmldata) > 7000) {
			ini_set('pcre.backtrack_limit', '500000');
		}

		// remove all leading tabs
		$tmpdata = explode("\n", $xmldata);
		for ($i = 0; $i < count($tmpdata); $i++) {
			preg_match("/(?<tabs>^\t*)/s", $tmpdata[$i], $matches);
			if (strlen($matches['tabs']) == 0) {
				unset($matches);
				continue;
			}
			$tmpdata[$i] = str_replace($matches['tabs'], '', $tmpdata[$i]);
			unset($matches);
		}
		$workdata = implode("\n", $tmpdata);
		unset($tmpdata);

		// remove all comments
		if (preg_match_all('/(?<comments><!--.*?-->)/s', $workdata, $matches)) {
			foreach ($matches['comments'] as $comment) {
				$workdata = str_replace($comment, '', $workdata);
			}
			unset($matches);
		}

		// save parent
		$ret['parent'] = $parent;
		$ret['id'] = uniqid();

		// get name of current section
		if (!preg_match('/<(?<name>[0-9a-zA-Z]*)>/', $workdata, $current) || !preg_match('/<\/(' . $current['name'] . ')>/', $workdata)) {
			return(false);
		}
		$ret['name'] = $current['name'];

		// get contents of current section
		preg_match('/<' . $current['name'] . '>(?<data>.*?)<\/' . $current['name'] . '>/s', $workdata, $current);

		$ret['data'] = $current['data'];
		unset($current);

		// if there are no more xml-style subsections, return data.
		if (!preg_match('/<([0-9a-zA-Z]*)>/', $ret['data'])) {
			return($ret);
		}

		// check if there are complete subsections. if not, return data.
		if (!preg_match('/<(?<sectionname>[0-9a-zA-Z]*)>/', $ret['data'], $result) || !preg_match('/<\/' . $result['sectionname'] . '>/', $ret['data'])) {
			return($ret);
		}

		// parse subsections
		$tmp_data = $ret['data'];
		while (strlen($tmp_data) != 0) {
			// get name of first section
			preg_match('/<(?<name>[0-9a-zA-Z]*)>/', $tmp_data, $match);
			$section_name = (!empty($match) ? $match['name'] : '');
			unset($match);

			// get data of first section
			if (preg_match('/(<' . $section_name . '>.*<\/' . $section_name . '>)/s', $tmp_data, $sec_data)) {
				if (($tmp = xmlParseData($sec_data[1], $ret['id'])) != false) {
					$ret['subsection'][$tmp['id']] = $tmp;
					unset($ret['subsection'][$tmp['id']]['id']);
					unset($tmp);
				}
				unset($sec_data);
			}

			// remove this part of data-string
			$tmp_data = trim(substr($tmp_data, strpos($tmp_data, '</' . $section_name . '>') + strlen('</' . $section_name . '>')));
		}
		unset($tmp_data);

		// if data of this section is a subsections, remove data-field
		if (isset($ret['subsection'])) {
			unset($ret['data']);
		}

		return($ret);
	}
} /* _XML_PARSE_DATA */

?>
