<?php

require_once('/usr/local/www/berogui/includes/isgwtelnet.php');
require_once ("/usr/local/php/include/apiCall.class.php");

class AnalogOffHook extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {
		//sanitize
		$this->_allowedParameters += array('Port'=>'int-range','Disable'=>'int-range');
		$this->_sanitizeOptions = array('Port'=> array('min' =>1, 'max'=>24));
		
		if ($this->sanitizeInputs()==false) return $this->_execResult;
		
		if (!isset($this->_parameters['Port'])) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}
		
		if (isset($this->_parameters['Disable'])) {
			$enable = 0;
		}
		else {
			$enable = 1;
		}
		
		$port = $this->_parameters['Port'];
		
		$isgw = new isgwtelnet();
		if (!($result = $isgw->isgw_login())) {
			$this->_execResultString = 'error:login_failed;';
			$this->_execResult = false;
			$this->_execResponseCode = 500;
			return($this->_execResult);
		}

		$this->_execResultString = trim($isgw->isgw_analog_offhook($enable, $port));
		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>