<?php
/**
 * Zeigt alle Einträge von der Tabelle whitelist der Datenbank an
 * 
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Dos {

	/**
	 *
	 * @var beroConf Instance root db
	 */
	private 	$bc,
			$m_attr,
			$q_attr,
			$start_attr,
			$order_attr,
			$sort_attr;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	private		$form_id = 'dossettingsform';

	function __construct($m, $get = array(), $post = array(), $session = array()) {
		// loading beroConf
		require_once('/usr/fallback/beroConf.php');
		$this->bc = new beroConf('root');

		// set main GET variable
		$this->m_attr = $m;

		// check GET variable
		$this->q_attr 	  = isset($get['q']) 	 ? Helper::sanitizeGet($get['q']	, 'q'	 ) : 0;
		$this->start_attr = isset($get['start']) ? Helper::sanitizeGet($get['start']	, 'start') : 0 ;
		$this->order_attr = isset($get['order']) ? Helper::sanitizeGet($get['order']	, 'order') : 0 ;
		$this->sort_attr  = isset($get['sort'])  ? Helper::sanitizeGet($get['sort']	, 'sort' ) : 0 ;

		// get error from modal or submit execution
		if (isset($get['error'])) {
			$this->isRequestRejected = true;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}
	}

	private function print_zero_on_empty_value ($ba, $key) {
		$val = $ba->get ($key);
		if (strlen($val) == 0) {
			return "0";
		}
		return $val;
	}
	
	/**
	 * @return string HTML code
	 */
	private function _display_tab_dos_settings ($m, $ba, $has_lan_wan) {
		// init	
		$ifaces_stack = array(
			// standard SBC
			0 => array(
				0 => array(
					'header' => 'LAN Stack',
					'suffix' => '_lan',
				),
				1 => array(
					'header' => 'WAN Stack',
					'suffix' => '_wan',
				),
			),
			// Cloud SBC
			1 => array(
				0 => array(
					'header' => 'WAN Stack',
					'suffix' => '_wan',
				),
				1 => array(
					'header' => 'LAN/VPN Stack',
					'suffix' => '_lan',
				),
			),
		);

		$ifaces_stack = $ifaces_stack[$this->bc->get('root', 'is-sbc-vm') == 1 ? 1 : 0];
		if (!$has_lan_wan) {
			unset($ifaces_stack[1]);
		}

		// build
		$html_str =	"\n<!--BEGIN TAB1 //-->\n"
							.	"<div id='tabs-1'>\n"
							. "\t<div id='dossettingserror' style='text-align:center;color:red;'><b></b></div>\n"
							. "\t<form name='dossettingsform' id='{$this->form_id}' class='form-horizontal' action='modules/Dos/dos_submit.php' style='margin-top: 20px;' method='POST'>\n";
		foreach ($ifaces_stack as $iface) {
			$html_str .= $this->_buildStackTable($ba, $iface['header'], $iface['suffix']);
		}

		$html_str .= 	"\t\t<div class='text-center'>\n"
								.	"\t\t\t<input type='hidden' name='action' value='save'>\n"
								.	"\t\t\t<input id='submitDosSettings' name='submit' class='btn btn-default'  type='submit' value='". BUTTON_SAVE ."' style='margin-top:20px;'>\n"
								. "\t\t</div>\n"
								. "\t</form>\n"
								. "</div>\n";

		return $html_str;
	}

	private function _buildStackTable($ba, $header, $suffix) {
		// init
		$packets_list = array(
			0 => 'options',
			1 => 'invite',
			2 => 'register',
			3 => 'other',
		);
		// built
		$table = 	"\t\t<h2>{$header}</h2>\n"
						.	"\t\t<div>\n"
						. "\t\t\t<table class='table table-striped table-bordered' style='max-width:600px; margin:auto;'>\n"
						. "\t\t\t\t<tr><th>". DOS_PACKETTYPE ."</th><th>". DOS_MAXPACKETS ."</th><th>". DOS_TIMEFRAME ."</th></tr>\n";
		
		foreach ($packets_list as $key => $packet) {
			$maxpackets = "blacklist_max_{$packet}_packets$suffix"; 
			$timeframe = "blacklist_{$packet}_timeframe$suffix";
			$table .= "\t\t\t\t<tr>\n"
							.	"\t\t\t\t\t<td><b>". strtoupper($packet) ."</b></td>\n"
							. "\t\t\t\t\t<td><input type='text' class='form-control' isFormTable='dossettingserror' name='$maxpackets' value='{$this->print_zero_on_empty_value($ba, $maxpackets)}'></td>\n"
							. "\t\t\t\t\t<td><input type='text' class='form-control' isFormTable='dossettingserror' name='$timeframe' value='{$this->print_zero_on_empty_value($ba, $timeframe)}'></td>\n"
							. "\t\t\t\t</tr>\n";
		}

		$block = "blacklist_blockduration$suffix";
		$table .= "\t\t\t\t<tr><td><b>". DOS_BLACKLIST_BLOCKDURATION ."</b></td><td colspan='2'><input type='text' class='form-control' isFormTable='dossettingserror' name='$block' value='{$this->print_zero_on_empty_value($ba, $block)}'></td></tr>\n"
						.	"\t\t\t</table>\n"
						. "\t\t</div>\n";
		return $table;		
	}

	/**
	 * @return string HTML code
	 */
	private function _display_tab_dos_whitelist ($m, $q, $ba, $url_opts, $next_add, $start, $span, $has_lan_wan)
	{
		
		$suffix = "";
		//Das Objekt funktions wird erzeugt um später die Navigationsleiste zu erzeugen.
		

		include "./includes/functions.php";
		$functions = new functions();
		$whitelist_table = $this->dynamic_table_whitelist($has_lan_wan);

		//Erzeugung der Navigationsleiste.
		$query = $ba->select('SELECT * FROM whitelist');
		$record_count = sqlite_num_rows($query);

		$html_str = 	"\n\n". '<!--BEGIN TAB2 //-->' ."\n\n" .
				'<div id="tabs-2">' ."\n";

		ob_start();
		?>
		<script>
			function del(table, option) {
				conf = confirm('<?php echo DOS_DELETE_MESS1_DIS ?>? ');
				if (conf == false) {
					return false;
				} else {
					window.location = './misc/delete.php?m=<?php echo $m ?>&id=' + option + '&table=' + table;
				}
			}
			function delblacklist(table, option, stack) {
				conf = confirm('<?php echo DOS_DELETE_MESS1_DIS ?>? ');
				if (conf == false) {
					return false;
				} else {
					window.location = './misc/delete.php?m=<?php echo $m ?>&id=' + option + '&stack=' + stack + '&table=' + table;
				}
			}
			function clearblacklist() {
				conf = confirm('<?php echo DOS_CLEAR_BLACKLIST_WARNING ?>? ');
				if (conf == false) {
					return false;
				} else {
					window.location = './misc/delete.php?m=<?php echo $m ?>&table=blacklist';
				}
			}
		</script>
		
		
		<div class='modal fade bs-example-modal-lg' id='dos-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
			<div class='modal-dialog modal-lg'>
				<div class='modal-content'>
					<div class='modal-header'>
						<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
						<h4 class='modal-title' id='myModalLabel'><?php echo DOS_TITLE_DIS ?></h4>
					</div>
					<div class='modal-body'>
					</div>
				</div>
			</div>
		</div>
		<br>
		<div id='container'>
			<?php echo $whitelist_table ?>
		</div>
		<br>
		<div class='text-center'>
			<a class='btn btn-default' href='modules/Dos/dos_popup.php?start=<?php echo $next_add ?>' data-remote='false' data-toggle='modal' data-target='#dos-popup' style='color:#a31d26;'>
				<?php echo BUTTON_ADD . "\n"?>
			</a>
		</div>
		<script type="text/javascript"> 
			$('#dos-popup').on('show.bs.modal', function (e) {
				var link = $(e.relatedTarget);
				$('.modal-body').load(link.attr('href'));
			});
		</script>

		<div class='text-center'>
			<?php echo $functions->displayNavigationBlock($m, $q, $url_opts, $start, $span, $record_count) . "\n"?>
		</div>
		<?php
		
		$html_str .= 	ob_get_clean() . "\n" .
				'</div>' ."\n";

		return $html_str;
	}
	
	/**
	 * @return string HTML code
	 */
	private function _display_tab_blacklist_settings()
	{
		$blacklist_table = $this->dynamic_table_blacklist();

		$html_str = 	"\n\n". '<!--BEGIN TAB3 //-->' ."\n\n" .
				'<div id="tabs-3">' ."\n";

		ob_start();
		?>
		<div class='modal fade bs-example-modal-lg' id='dos-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
			<div class='modal-dialog modal-lg'>
				<div class='modal-content'>
					<div class='modal-header'>
						<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
						<h4 class='modal-title' id='myModalLabel'><?php echo DOS_TITLE_DIS ?></h4>
					</div>
					<div class='modal-body'>
					</div>
				</div>
			</div>
		</div>
		<br>
		<div id='container'>
			<?php echo $blacklist_table ?>
		</div>
		<br>

		<script type="text/javascript">
			$('#dos-popup').on('show.bs.modal', function (e) {
				var link = $(e.relatedTarget);
				$('.modal-body').load(link.attr('href'));
			});
		</script>

		<div class="text-center">
			<button type='submit' class='btn btn-default' onclick='clearblacklist();'><?php echo DOS_BLACKLIST_CLEAR_ALL ?></button>
		</div>
		<?php
		
		$html_str .= 	ob_get_clean() . "\n" .
				'</div>' ."\n";

		return $html_str;
	}

	

	/**
	 * @return string HTML code
	 */
	private function _display_tabs($m, $q, $ba, $url_opts, $next_add, $start, $span)
	{
			$bc = new beroConf('root');
			if ($bc->get('root', 'lan-mode') == 'lan-wan') {
				$has_lan_wan = 1;
			}
			$html_str =     '<br/>' . "\n" . '<br/>' . "\n" .
			'<script>' . "\n" .
			"\t" . '$(function() {' . "\n" .
			"\t\t" . '$( "#tabs" ).tabs({active:0})' . "\n" .
			"\t" . '});' . "\n" .
			'</script>' . "\n" .
			"\n\n" . '<!-- BEGIN TABS //-->' . "\n\n" .
			'<div id="tabs" class="">' . "\n" .
			"\t".'<ul>' . "\n";

			
			$html_str .=
			'<li><a href="#tabs-1">DoS Settings</a></li>' . "\n" .
			'<li><a href="#tabs-2">Whitelist</a></li>' . "\n" .
			'<li><a href="#tabs-3">Blacklist</a></li>' . "\n" ;
			$html_str .= "\t".'</ul>' . "\n" ;
			
			$html_str .=
				$this -> _display_tab_dos_settings ($m, $ba, $has_lan_wan) . "\n" .
				$this -> _display_tab_dos_whitelist ($m, $q, $ba, $url_opts, $next_add, $start, $span, $has_lan_wan) . "\n" .
				$this -> _display_tab_blacklist_settings ($has_lan_wan) . "\n";
			
			$html_str .=
			"\n\n" . '<!-- END TABS //-->' . "\n" .
			'</div>' . "\n\n";

		return $html_str;
	}

	/**
	 * Die einträge der whitelist Tabelle werden formatiert angezeigt
	 * 
	 * @return string HTML Inhalt
	 */

	function display() {
	
		// args
		$m = $this->m_attr;
		$q = $this->q_attr;
		$start = $this->start_attr;
		$order = $this->order_attr;
		$sort = $this->sort_attr;

		$ba = new beroAri();

		$bc = new beroConf('root');
		$span = 15;
		$query = $ba->select('SELECT * FROM whitelist');
		$record_count = sqlite_num_rows($query);
		$test = $record_count / $span;
		$test = (int) $test;
		if ($record_count == 0) {
			$next_add = 0;
		} else {
			$next_add = ($test * $span);
		}
		$start = $start == '' ? 0 : $start;
		$order = $order;
		$sort = $sort;


		$name = "DOS_TITLE_DIS";
		include('./includes/header.php');

		if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		$url_opts = array();
		$url_opts['sort'] = $sort;
		$url_opts['order'] = $order;

		// javascript code to check data filled
		ob_start();
		?>
		<script>
			var listRules = {
					rules: {
						blacklist_blockduration_lan: {
							range: [0, 86400]
						},
						blacklist_max_options_packets_lan: {
							range: [0, 86400]
						},
						blacklist_options_timeframe_lan: {
							range: [0, 86400]
						},
						blacklist_max_invite_packets_lan: {
							range: [0, 86400]
						},
						blacklist_invite_timeframe_lan: {
							range: [0, 86400]
						},
						blacklist_max_register_packets_lan: {
							range: [0, 86400]
						},
						blacklist_register_timeframe_lan: {
							range: [0, 86400]
						},
						blacklist_max_other_packets_lan: {
							range: [0, 86400]
						},
						blacklist_other_timeframe_lan: {
							range: [0, 86400]
						},
						blacklist_blockduration_wan: {
							range: [0, 86400]
						},
						blacklist_max_options_packets_wan: {
							range: [0, 86400]
						},
						blacklist_options_timeframe_wan: {
							range: [0, 86400]
						},
						blacklist_max_invite_packets_wan: {
							range: [0, 86400]
						},
						blacklist_invite_timeframe_wan: {
							range: [0, 86400]
						},
						blacklist_max_register_packets_wan: {
							range: [0, 86400]
						},
						blacklist_register_timeframe_wan: {
							range: [0, 86400]
						},
						blacklist_max_other_packets_wan: {
							range: [0, 86400]
						},
						blacklist_other_timeframe_wan: {
							range: [0, 86400]
						},
					}
			};
			$(document).ready(function () {
				$("#<?php echo $this->form_id; ?>").validate(listRules);
				$('#<?php echo $this->form_id; ?>').change(function() {
					$('#dossettingserror').hide();
				});
			});
		</script>
		<?php

		$ret .= "\n" . ob_get_clean() . $this -> _display_tabs($m, $q, $ba, $url_opts, $next_add, $start, $span);
		return $ret; 
	}

	/**
	 * Liefert den HTML Code für die Tabelle
	 * 
	 * @return string HTLM code für die Tabelle
	 */

	function dynamic_table_whitelist($has_lan_wan) {
		//ein neues Datenbankobjekt wird erzeugt.
		$ba = new beroAri();
		require_once("./includes/lang.php");
		$start = $this->start_attr;

		//Das Header der Tabelle sind die Spaltennamen von whitelist
		$columns = $ba->column_type('whitelist');
		$i = 0;
		if ($has_lan_wan) {
			$columnsToShow = array("address","netmask","sipstack");
			$colName = array("address" => DOS_WHITELIST_ADDRESS, "netmask" => DOS_WHITELIST_NETMASK_PREFIX, "sipstack" => "SIP Stack");
		}
		else {
			$columnsToShow = array("address","netmask");
			$colName = array("address" => DOS_WHITELIST_ADDRESS, "netmask" => DOS_WHITELIST_NETMASK_PREFIX);
		}
		$cols = "\n";
		foreach ($columns as $column => $type) {
			if (in_array($column, $columnsToShow))
				$cols .= "\t\t\t\t<th>" . $colName[$column] . "</th>\n";
		}
		$cols .=  "\t\t\t\t<th></th>\n\n";
		/* Die Einträge werden von der Tabelle whitelist gelesen, formatiert und in einer
		  Tabelle geschrieben, zusätzlich werden 2 Knöpfe eingebaut: modify und delete */
		$page = (($start / 15) + 1);
		if (!$start)
			$start = 0;
		$id = 0;

		for ($j = 1; $j <= $page; $j++) {
			$query = $ba->select('SELECT * FROM whitelist ORDER BY id asc limit 15 offset ' . $start);
			$rows = '';
			while ($entry = $ba->fetch_array($query)) {
				$rows .= "\t\t\t\t<tr>\n";
				for ($i = 0; $i < (count($columnsToShow)); $i++) {
					$col_name = $columnsToShow[$i];
					
					if ($col_name == "sipstack") {
						if ($entry[$col_name] == "LAN") {
							$val = "LAN";
						}
						else if ($entry[$col_name] == "WAN") {
							$val = "WAN";
						}
						else {
							$val = "ANY";
						}
					}
					else {
						$val = $entry[$col_name];
					}
					$rows .= "\t\t\t\t\t<td>" . $val . "</td>\n";
				}
				
				$id = $entry['id'];
				$rows .= "\t\t\t\t\t<td class='buttons'>
						<a href='modules/Dos/dos_popup.php?id=" . $id .  "' data-remote='false' data-toggle='modal' data-target='#dos-popup' class='popup_download'>
							<img src='./includes/images/modify.png'>
						</a>&nbsp;
						<a class='popup_download' onclick=\"del('whitelist','" . $id . "');\">
            	    		<img src='./includes/images/delete.png'>
						</a>
					</td>
				</tr>\n";
			}
		}

		$table = "\n			<table class='table table-striped table-bordered' style='max-width:600px; margin:auto;'>"
			. $cols
			. $rows
			. "			</table>\n";
		//Rückgabe: Erzeugte Tabelle mit den Einträgen der Tabelle whitelist der Datenbank
		return $table;
	}

	function dynamic_table_blacklist() {
		require_once ("./includes/lang.php");
		require_once "./includes/isgwtelnet.php";
		$i = 0;

		$cols .= "<th>" . DOS_BLACKLIST_ID . "</th>";
		$cols .= "<th>" . DOS_BLACKLIST_TIME . "</th>";
		$cols .= "<th>" . DOS_BLACKLIST_IP . "</th>";
		$cols .= "<th>" . "SIP Stack" . "</th>";

		$isgw = new isgwtelnet ();
		$result = $isgw->isgw_login ();
		$blacklistresult = $isgw->isgw_blacklist ();

		$bl_rows = explode ( "\n", $blacklistresult );
		$i = 0;

		foreach ( $bl_rows as $value ) {
			$id = - 1;
			if (strncmp ( "id:", $value, 3 ) != 0) {
				continue;
			}

			$rvals = explode ( " ", $value );

			if (count ( $rvals ) != 4) {
				continue;
			}

			$rows .= "<tr>";
			$counter = 0;
			foreach ( $rvals as $rval ) {

				$xval = explode ( ":", $rval );

				if ($id == - 1) {
					$id = $xval [1];
				}
				if ($counter == 3) {
					$stack = $xval [1];
				}
				$rows .= "<td>" . strtoupper ( $xval [1] ) . "</td>";
				$counter ++;
			}
			$rows .= "<td class='buttons'>

			<a class='popup_download' onclick=\"delblacklist('blacklist','" . $id . "','" . $stack . "');\">
			<img src='./includes/images/delete.png'>
			</a>
			</td></tr>";
		}

		$table = "<table class='table table-striped table-bordered' style='max-width:600px; margin:auto;'>" . "<tr>" . $cols . "<th></th>" . "</tr>" . $rows . "</table>";
		// Rückgabe: Erzeugte Tabelle mit den Einträgen der Tabelle whitelist der Datenbank
		return $table;
	}
}
?>
