<?php
$berogui = '/usr/local/www/berogui';

/* [INTERN FUNCTIONS] */
function buildSingleDownload($ftFile) {
	$html = "<form name='download_logfile' action='modules/FulltraceGui/fulltracegui_download.php?option=single_logfile' method='POST' class='form-horizontal'>\n"
				.	"\t<div class='form-group'>\n"
				. "\t\t<label for='logfile_name' class='col-sm-5 control-label'>{$ftFile['name']}</label>\n"
				.	"\t\t<div class='col-sm-1'>\n"
				. "\t\t\t". round(($ftFile['size'] / 1024), 2) ."kB\n"
				. "\t\t</div>\n"
				. "\t\t<div class='col-sm-3'>\n"
				. "\t\t\t<input type='hidden' name='logfile_name' value='{$ftFile['name']}'/>\n"
				. "\t\t\t<input type='submit' class='btn btn-default' value='Download'/>\n"
				. "\t\t</div>\n"
				. "\t</div>\n"
				. "</form>\n";
	return $html;
}

/* [CHECKING SESSION] */
$IS_TIMEOUT = false;
$IS_AJAX_REQUEST = true;
include("$berogui/includes/session.php");
if ($IS_TIMEOUT) {
	header("{$_SERVER['SERVER_PROTOCOL']} 408 Timeout");
	exit(0);
}

/* [CHECKING POST] */
require_once("$berogui/includes/Helper/Helper.php");

$exec_ajax = 1;
$invalid = array();

$post = array(
	'action'	=> 'select',
);

$options = array(
	'action'	=> array('download', 'notif', 'refresh-single-file'),
);

$_POST = Helper::sanitizePost($_POST, $post, $exec_ajax, $invalid, $options);

$action = $_POST['action'];
unset($_POST);

/* [EXECUTING] */
if (!$exec_ajax) {
	header("{$_SERVER['SERVER_PROTOCOL']} 400 Bad Request");
	exit(0);
}

require_once("/usr/fallback/beroConf.php");
$bc = new beroConf('root');

$response = array();

switch ($action) {
case 'download':
	$response = array('completed' => 0);
	if ($bc->get('root', 'trace-state') == 'COMPLETED') {
		$response = array('completed' => 1);
	}
	break;
case 'notif':
	$response = array('show' => 0);
	if ($bc->get('root', 'trace-state') == 'COMPLETED') {
		$response = array('show' => 1);
	}
	break;
case 'refresh-single-file':
	// init
	include('/usr/local/php/include/fulltrace.Class.php');
	$ft = new fulltrace($bc);
	// get data
	foreach ($ft->get_runtime_files() as $ftFile) {
		if (empty($ftFile)) {
			continue;
		}
		$ftFiles[] = array('name' => basename($ftFile), 'size' => filesize($ftFile));
	}
	// build html
	$response = array('html' => '');
	foreach ($ftFiles as $ftFile) {
		$response['html'] .= buildSingleDownload($ftFile);
	}
	echo $response['html'];
	exit(0);
	break;
}

echo Helper::jsonEncode($response);
exit(0);
?>
