<?php
/**
 * @file
 * Modal form für das Anlegen und Bearbeiten von SIP Konten
 */
require_once ("/usr/local/www/berogui/includes/Helper/Helper.php");

$load_popup = 1;
$invalid = array();

/* [CHECKING GET VARIABLE] */
$list_get = array(      'start' => 'int>=0',
			'id'	=> 'id'	   ,
			'page'	=> 'int>=0');

unset($_GET['type'], $_GET['profile']);

$_GET = Helper::sanitizeGet($_GET, $list_get, $load_popup, $invalid);

$page = $_GET['page'];
$_GET['type'] = 'manual';
$_GET['profile'] = 'undefined';

/* [CHECKING POST] */
unset($_POST);

/* [DISPLAYING POPUP] */
if (!$load_popup) {
	echo "<script>window.location='../../index.php?m=Sip&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
        exit(1);
}

chdir("../..");

include "./includes/variables.php";
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include "./misc/database.php";
$ba = new beroAri();
require_once ('./includes/lang.php');
require_once ('./includes/Helper/HelperSip.php');
require_once('/usr/local/www/berogui/includes/session.php');
include("./misc/config_parameter.php");

$is_sbc_vm = $ba->get('is_sbc_vm') == 1 ? 1 : 0;
$isgw_bin = array(
	0 => "/usr/local/bin/isgw -E",
	1 => "/usr/local/beroNet/sbin/isgw.sh -E",
);

Helper::exec($is_sbc_vm, $isgw_bin[$is_sbc_vm], $output);
$enumStatus = preg_match('/ENUM SUPPORT/', implode(" ", $output));

$name = '"general"';
$query_comp = $ba->select("SELECT * FROM sip");
while ($entry = $ba->fetch_array($query_comp)) {
	if ($entry['id'] != $_GET['id']) {
    $name.=',' . '"' . $entry['name'] . '"';
  } else if (isset($_GET['copy'])) {
    $name.=',' . '"' . $entry['name'] . '"';
  }
}

$guiMode = $ba -> get('gui_mode');
if ($guiMode == "") {
	$guiMode = "advanced";
}
?>

<script type="text/javascript" src="misc/script/sip.js"></script>
<script type="text/javascript">
    var validator = $("#sipp").validate({
        rules: {
            name: {
            	required: true,
               	specChar: true,
                checkBlank: true,
                compareName: [<?php echo $name; ?>]
            },
            user: "specChar",
				displayname: {
					checkManual: true,
				},
            auth_user: "specChar",
            secret: {
			specChar: true,
			forbidPassword: {
				depends: function () {
					if ($('#password-dummy').val() == '1') {
						return '*****' == $('#secret').val();
					}
					return false;
				}
			}
		},
    	'matchtype[]': {
            required: {
                depends: function (element) {
                    return $("#profile").val() == "manual";
                }
            }
        },
        'srtp_crypto_suites[]': {
            required: {
                depends: function () {
                    return ($("#srtp_mode").val() === "mandatory" || $("#srtp_mode").val() === "optional");
            	}
			}
		},
		dialplan_international_prefix: {
			checkPhoneNumber: true,
		},
		from_sip_dest_setting_manual: {
			checkManual: "#from_sip_dest_setting_manual:visible",
		},
		from_sip_src_setting_manual: {
			checkManual: "#from_sip_src_setting_manual:visible",
		},
		matchtype_manual: {
		    	checkManual: "#matchtype_manual:visible",
		},
		sip_contact_user_setting_manual: {
			checkManual: "#sip_contact_user_setting_manual:visible",
		},
                sip_from_user_setting_manual: {
                    checkManual: "#sip_from_user_setting_manual:visible",
                },
                sip_from_display_setting_manual: {
                    checkManual: "#sip_from_display_setting_manual:visible",
                },
		sip_international_code: {
			checkPhoneNumber: true,
		},
		sip_national_code: {
			digits: true,
		},
                sip_pai_user_setting_manual: {
                    checkManual: "#sip_pai_user_setting_manual:visible",
                },
                sip_ppi_user_setting_manual: {
                    checkManual: "#sip_ppi_user_setting_manual:visible",
                },
		sip_to_user_setting_manual: {
			checkManual: "#sip_to_user_setting_manual:visible",
		},
		sip_domain: {
			checkHostname: true,
		},
                sip_proxy: {
                    checkHostname: true,
                    required: {
                        depends: function () {
                            return ($("#sip_registrar").is(":blank") && !$("#enum_search_domain").is(":visible"));
                        }
                    },
                    sipPortCheck: "<?php echo HelperSip::udpports($ba); ?>"
                },
                sip_registrar: {
                    checkHostname: true,
                    required: {
                        depends: function () {
                            return ($("#sip_proxy").is(":blank") && !$("#enum_search_domain").is(":visible"));
                        }
                    },
                    sipPortCheck: "<?php echo HelperSip::udpports($ba); ?>"
                },
                enum_search_domain: {
                    required: true,
                    checkHostname: true,
                },
                regrefresh: {
                    required: true,
                    range: [30, 86400]
                },
                regrefresh_failed: {
                    required: true,
                    range: [10, 3600]
                },
		sip_custom_port: {
			range: [1025, 65535]
		},
		stunserver: {
			checkHostname: true,
		},
		externip: {
			checkHostname: true,
		},
		callgroup_name: {
			alphanumeric: true,
		},
		callgroup_priority: {
			range: [0, 100]
		},
		max_simultaneous_calls: {
			range: [0, 255]
		},
		failover_timeout: {
			range: [0, 60]
		},
		keepalive_interval: {
			required: true,
			range: [0, 86400]
		},
		addit_options: {
			checkManual: true
		},
		dns_change_minimum_registration_time: {
			range: [0, 3600]
		}

    	}
        });
        $("#sip_registrar").keyup(function () {
            required();
        });
        $("#sip_proxy").keyup(function () {
            required();
        });

        var i = 1;
        function show_advanced() {
            var state = true;
            if (i++ % 2 === 0) {
                $(".advanced").show();
                $(".linkAdvanced").html('<?php echo SIP_SIMPLE_DIS; ?>');
                state = true;
            } else {
                $(".advanced").hide();
                $(".linkAdvanced").html('<?php echo SIP_ADVANCED_DIS; ?>');
                state = false;
            }
			      hide_server($('#enum_support').prop('checked'));
            hide_reg(document.getElementById('register').checked, state);
            hide_validation(document.getElementById('validation').checked, state);
            options(document.getElementById('stunradio').checked, document.getElementById('externipradio').checked, state);
			srtp();
		    options($('#stunradio').prop('checked'), $('#externipradio').prop('checked'));
        }

        function openPopup(page) {
            profile = $("[id='" + $("#type").val() + "']").val();
            type = $("#type").val();
            var result = null;
            $('.modal-body').load("modules/Sip/sip_popup.php?start=" + page + "&profile=" + encodeURI(profile) + "&type=" + encodeURI(type), function (res) {
                //result = res;
                //$('.modal-body').html(result);
            });
        }

        $(document).ready(function () {
					dnsRegistration	($('#dnssrv').is(':checked'));
					tlsSettings		($('#sip_transport').find(":selected").val() == "tls");
					matchtype		($('select#matchtype').val().includes('manual'));
					required();
            $('[data-toggle="tooltip"]').tooltip({placement : 'auto bottom', html : true, trigger : 'hover'});
        });
        $('#sip-tab a').click(function (e) {
            e.preventDefault();
			$(this).tab('show');
        });

		$('#sip-tab a').on('hide.bs.tab', function (e) {
			var valid = true;
			var tab=e.target.getAttribute('href');
			$(tab).find("input").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			$(tab).find("select").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			if (!valid)
				e.preventDefault();
		});

	// EVENT LISTENERS

		$('#secret').change(function() {
			$('#password-dummy').val('1');
		});

		$('#dnssrv').change(function() {
			dnsRegistration($('#dnssrv').is(':checked'));
		});

		$('#sip_transport').change(function() {
			tlsSettings($('#sip_transport').find(":selected").val() == "tls");
		});

		$('select#matchtype').change(function() {
			matchtype($('select#matchtype').val().includes('manual'));
		});

</script>

<?php
require_once "./includes/isgwtelnet.php";
require_once "./includes/profileParser.php";

function getProfile($ba) {
	//sip profiles are deactivated for now
	return "manual";
	// -> inactive code
	if (isset($_GET['id']))
		return HelperSip::getValue($ba, $_GET['id'], 'profile', $fixedSettings);
	else if ($_GET['type'] == "manual")
		return $_GET['type'];
	else
		return $_GET['type'] . "-" . $_GET['profile'];
}

/* ### ADVANCED SIP TAB ### */
function display_sip_tab($ba, $config, $simple_class, $stacks, $natoptSettings) {
	ob_start(); ?>
			<div class='form-group sip_stack <?php echo $simple_class; ?>'>
			    <label for='sip_stack' class='col-sm-3 control-label'><?php echo SIP_STACK_DIS; ?></label>
			    <div class='col-sm-8'>
					<?php echo HelperSip::dropdown($ba, $_GET['id'], "sip_stack", $fixedSettings, $stacks); ?>
			    </div>
			</div>
			<div class='form-group sip_transport <?php echo $simple_class; ?>'>
			    <label for='sip_transport' class='col-sm-3 control-label'><?php echo SIP_STACKS_SIP_TRANSPORT_DIS; ?></label>
			    <div class='col-sm-8'>
					<?php echo HelperSip::dropdown($ba, $_GET['id'], "sip_transport", $fixedSettings, array("udp" => "UDP", "tcp" => "TCP", "tls" => "TLS")); ?>
			    </div>
			</div>
			<div id='sips_on_tls_group' class='form-group sips_on_tls <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_SIPS_ON_TLS_TOOLTIP; ?>'>
				<label for='sips_on_tls' class='col-sm-3 control-label'><?php echo SIP_SIPS_ON_TLS_DIS; ?></label>
				<div class='col-sm-8 form-checkbox'>
				<?php echo HelperSip::checkboxConfig($ba, $_GET['id'], 'sips_on_tls', $config, true); ?>
				</div>
			</div>
			<div class='form-group sip_custom_port <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_PORT; ?>'>
			    <label for='sip_custom_port' class='col-sm-3 control-label'><?php echo SIP_PORT_DIS; ?></label>
			    <div class='col-sm-8'>
					<?php echo HelperSip::textField($ba, $_GET['id'], "sip_custom_port", $fixedSettings); ?>
			    </div>
			</div>

			<hr>

			<div class='form-group natoptions <?php echo $simple_class; ?>'>
			    <label for='option' class='col-sm-3 control-label'><?php echo SIP_OPTIONS_DIS; ?></label>
			    <div class='col-sm-8'>
				<div class='radio pull-left'>
				    <label><input name='option' id='nonatradio' type='radio' value='nonat' <?php echo $natoptSettings['nonat']; ?> ><?php echo SIP_NONAT_DIS; ?></label>
				</div>
				<div class='clearfix'></div>
				<div class='radio pull-left'>
				    <label><input name='option' id='stunradio' type='radio' value='stun' <?php echo $natoptSettings['stun']; ?> ><?php echo SIP_STUNSERVER_DIS; ?></label>
				</div>
				<div class='clearfix'></div>
				<div class='radio pull-left'>
				    <label><input name='option' id='externipradio' type='radio' value='externip' <?php echo $natoptSettings['externip']; ?> ><?php echo SIP_EXTERNIP_DIS; ?></label>
				</div>
				<div class='clearfix'></div>
			    </div>
			</div>
			<div class='form-group options <?php echo $simple_class; ?>'>
			    <label for='stunserver' class='col-sm-3 control-label stun'><?php echo SIP_STUNSERVER_DIS; ?></label>
			    <label for='externip' class='col-sm-3 control-label externip'><?php echo SIP_EXTERNIP_DIS; ?></label>
			    <div class='col-sm-8'>
				<div class='stun'><?php echo HelperSip::textField($ba, $_GET['id'], "stunserver", $fixedSettings); ?></div>
				<div class='externip'><?php echo HelperSip::textField($ba, $_GET['id'], "externip", $fixedSettings); ?></div>
			    </div>
			</div>
			<div class='form-group s2s_nat_opener <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_NAT_OPENER_TOOLTIP; ?>'>
            	<label for='s2s_nat_opener' class='col-sm-3 control-label'><?php echo SIP_NAT_OPENER_HEADER; ?></label>
            	<div class='col-sm-8'>
            		<?php echo s2s_nat_opener($ba, 's2s_nat_opener', $config); ?>
            	</div>
          	</div>
	<?php
  	return ob_get_clean();
}

/* ### MEDIA TAB ### */
function display_media_tab($ba, $config, $simple_class) {
  	ob_start(); ?>
            <div class='form-group t38 <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo T38; ?>'>
            	<label for='t38' class='col-sm-3 control-label'><?php echo DIALPLAN_T38_SUPPORT_DIS; ?></label>
           		<div class='col-sm-8'>
            		<?php echo t38($ba, $config); ?>
            	</div>
          	</div>
          	<div class='form-group dtmfmode <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo DTMFMODE; ?>'>
            <label for='dtmfmode' class='col-sm-3 control-label'><?php echo DIALPLAN_DTMF_MODE_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo dtmfmode($ba, $config); ?>
            	</div>
          	</div>
         	<div class='form-group srtp_mode <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SRTP_MODE; ?>'>
            	<label for='srtp_mode' class='col-sm-3 control-label'><?php echo DIALPLAN_SRTP_MODE_DIS; ?></label>
           		<div class='col-sm-8'>
            		<?php echo srtp_mode($ba, $config); ?>
            	</div>
          	</div>
          	<div class='form-group srtp_crypto_suites <?php echo $simple_class; ?>'>
            	<label for='srtp_crypto_suites[]' class='col-sm-3 control-label'><?php echo DIALPLAN_SRTP_CRYPTO_SUITES_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo srtp_crypto_suites($ba, $config); ?>
            	</div>
          	</div>
			<div class='form-group s2s_rtp_handling_method<?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo S2S_RTP_HANDLING_METHOD_LABEL ?>'>
				<label for='s2s_rtp_handling_method' class='col-sm-3 control-label'><?php echo S2S_RTP_HANDLING_METHOD_LABEL; ?></label>
				<div class='col-sm-8'>
					<?php echo s2s_rtp_handling_method($ba, 's2s_rtp_handling_method', $config); ?>
				</div>
			</div>

			<hr>

          	<div class='form-group codecs <?php echo $simple_class; ?>'>
            	<label for='codecs' class='col-sm-3 control-label'><?php echo DIALPLAN_CODECS_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo codecs($ba, $config); ?>
            	</div>
          	</div>
  <?php
  return ob_get_clean();
}

/* ### CALL SETTINGS TAB ### */
function display_callprogress_tab($ba, $config, $simple_class) {
  	ob_start(); ?>
			<div class='form-group call_transfer_method <?php echo $simple_class; ?>'>
			    <label for='call_transfer_method' class='col-sm-3 control-label'><?php echo SIP_CALL_TRANSFER_METHOD_DIS; ?></label>
			    <div class='col-sm-8'>
					<?php echo HelperSip::dropdown($ba, $_GET['id'], "call_transfer_method", $fixedSettings, array("refer" => "refer", 
						"reinvite" => "reinvite")); ?>
			    </div>
			</div>
			<div class='form-group wait_for_cancel <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo WAIT_FOR_CANCEL; ?>'>
            	<label for='wait_for_cancel' class='col-sm-3 control-label'><?php echo DIALPLAN_WAIT_FOR_CANCEL_DIS; ?></label>
            	<div class='col-sm-8 form-checkbox'>
            		<?php echo wait_for_cancel($ba, $config); ?>
            	</div>
          	</div>

		  	<hr>

			<div class="row <?php echo $simple_class; ?>">
            	<p class="lead text-center"><?php echo SIP_FAILOVER_DIS; ?></p>
          	</div>
			<div class='form-group callgroup_name <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo CALLGROUP_TOOLTIP; ?>'>
			    <label for='callgroup_name' class='col-sm-3 control-label'><?php echo CALLGROUP_NAME; ?></label>
			    <div class='col-sm-8'>
					<?php echo HelperSip::textField($ba, $_GET['id'], "callgroup_name", $fixedSettings); ?>
			    </div>
			</div>
			<div class='form-group callgroup_priority <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo CALLGROUP_PRIORITY_TOOLTIP; ?>'>
			    <label for='callgroup_priority' class='col-sm-3 control-label'><?php echo CALLGROUP_PRIORITY; ?></label>
			    <div class='col-sm-8'>
					<?php echo HelperSip::textField($ba, $_GET['id'], "callgroup_priority", $fixedSettings); ?>
			    </div>
			</div>
			<div class='form-group call_limit <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo MAX_SIMULTANEOUS_CALLS_TOOLTIP; ?>'>
			    <label for='call_limit' class='col-sm-3 control-label'><?php echo MAX_SIMULTANEOUS_CALLS; ?></label>
			    <div class='col-sm-8'>
					<?php echo HelperSip::textField($ba, $_GET['id'], "max_simultaneous_calls", $fixedSettings); ?>
			    </div>
			</div>
          	<div class='form-group failover_proxy <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo FAILOVER_ACCOUNT; ?>'>
            	<label for='failover_proxy' class='col-sm-3 control-label'><?php echo DIALPLAN_FAILOVER_ACCOUNT_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo failover_proxy($ba, $config); ?>
            	</div>
          	</div>
          	<div class='form-group failover_timeout <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo FAILOVER_TIMEOUT; ?>'>
            	<label for='failover_timeout' class='col-sm-3 control-label'><?php echo DIALPLAN_FAILOVER_TIMEOUT_DIS; ?></label>
            	<div class='col-sm-8'>
					<?php echo sip_input_text($ba, 'failover_timeout', $config, "0"); ?>
            	</div>
          	</div>

			<hr>

		  	<div class="row <?php echo $simple_class; ?>">
            	<p class="lead text-center"><?php echo MENU_CALL_PROGRESS; ?></p>
          	</div>
          	<div class='form-group s2i_cpt <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo CALL_PROGRESS_TABLE; ?>'>
            	<label for='s2i_cpt' class='col-sm-3 control-label'><?php echo DIALPLAN_CALL_PROGRESS_TABLE_S2I_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo s2i_cpt($ba, $config); ?>
            	</div>
          	</div>
          	<div class='form-group i2s_cpt <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo CALL_PROGRESS_TABLE; ?>'>
            	<label for='i2s_cpt' class='col-sm-3 control-label'><?php echo DIALPLAN_CALL_PROGRESS_TABLE_I2S_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo i2s_cpt($ba, $config); ?>
           		</div>
          	</div>
          	<div class='form-group link_to_cpt <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo "Call Progress Table"; ?>'>
           		<label for='link_to_cpt' class='col-sm-3 control-label'><?php echo  ""; ?></label>
           		<div class='col-sm-8'>  
           			<?php echo DIALPLAN_CALL_PROGRESS_TABLE_LINK_LABEL; ?>
           			<a href='index.php?m=CallProgress' id='callprogress'><?php echo DIALPLAN_CALL_PROGRESS_TABLE_LINK_TEXT; ?></a>
           		</div>
        	</div>
  	<?php
  	return ob_get_clean();
}

/* ### HEADER TAB ### */
function display_headers_tab($ba, $config, $simple_class) {
  ob_start(); ?>	
          	<div class='form-group sip_to_user_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_TO_USER_SETTING; ?>'>
            	<label for='sip_to_user_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_TO_USER_SETTING_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo called_party_number_sip($ba, 'sip_to_user_setting', $config); ?>
            	</div>
          	</div>
          	<div class='form-group sip_from_user_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_FROM_USER_SETTING; ?>'>
            	<label for='sip_from_user_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_FROM_USER_SETTING_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo caller_id_mapping_sip($ba, 'sip_from_user_setting', $config); ?>
            	</div>
          	</div>
          	<div class='form-group sip_from_display_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_FROM_DISPLAY_SETTING; ?>'>
            	<label for='sip_from_display_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_FROM_DISPLAY_SETTING_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo caller_id_mapping_sip($ba, 'sip_from_display_setting', $config); ?>
            	</div>
          	</div>
          	<div class='form-group sip_pai_user_setting<?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_PAI_USER_SETTING; ?>'>
            	<label for='sip_pai_user_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_PAI_USER_SETTING_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo caller_id_mapping_sip($ba, 'sip_pai_user_setting', $config); ?>
            	</div>
          	</div>
          	<div class='form-group sip_ppi_user_setting<?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_PPI_USER_SETTING; ?>'>
            	<label for='sip_ppi_user_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_PPI_USER_SETTING_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo caller_id_mapping_sip($ba, 'sip_ppi_user_setting', $config); ?>
            	</div>
          	</div>
          	<div class='form-group sip_contact_user_setting<?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_CONTACT_USER_SETTING; ?>'>
            	<label for='sip_contact_user_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_CONTACT_USER_SETTING_DIS; ?></label>
           		<div class='col-sm-8'>
            		<?php echo caller_id_mapping_sip($ba, 'sip_contact_user_setting', $config); ?>
            	</div>
          	</div>

			<hr>

		  	<div class="row <?php echo $simple_class; ?>">
            	<p class="lead text-center"><?php echo DIALPLAN_ADDITIONAL_CONFIG_DIS; ?></p>
          	</div>
  		 	<div class='form-group 1tr119 <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_1TR119_TOOLTIP; ?>'>
				<label for='1tr119' class='col-sm-3 control-label'><?php echo SIP_1TR119_DIS; ?></label>
				<div class='col-sm-8 form-checkbox'>
					<?php echo HelperSip::checkboxConfig($ba, $_GET['id'], '1tr119', $config); ?>
				</div>
		 	</div>
          	<div class='form-group ie_on_sip <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo IE_ON_SIP; ?>'>
            	<label for='ie_on_sip' class='col-sm-3 control-label'><?php echo DIALPLAN_IE_ON_SIP_DIS; ?></label>
            	<div class='col-sm-8 form-checkbox'>
            		<?php echo ie_on_sip($ba, $config); ?>
            	</div>
          	</div>
  	<?php
  	return ob_get_clean();
}

/* ### NUMBER FORMATTING TAB ### */
function display_numberformatting_tab($ba, $config, $simple_class, $newentryflag) {
  	ob_start(); ?>
          	<div class="row <?php echo $simple_class; ?>">
            	<p class="lead text-center"><?php echo SIP_POPUP_NUMBERFORMATTING_PROVIDER; ?></p>
          	</div>
          	<div class='form-group sip_international_code <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_COUNTRY_CODE; ?>'>
            	<label for='sip_international_code' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_INTERNATIONAL_CODE_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo sip_input_text($ba, 'sip_international_code', $config, $ba->get('international_code'), "[+0-9]*"); ?>
            	</div>
          	</div>
		   	<div class='form-group sip_national_code <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN_CITY_CODE; ?>'>
            	<label for='sip_national_code' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP_NATIONAL_CODE_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo sip_input_text($ba, 'sip_national_code', $config, $ba->get('national_code'), "[0-9]*"); ?>
            	</div>
          	</div>

			<div class="clearfix"></div>

			<div class="row <?php echo $simple_class; ?>">
            	<p class="lead text-center"><?php echo DIALPLAN_PSTN_TO_SIP_DIS; ?></p>
          	</div>
          	<div class='form-group isdn2sip_destination_numformat <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN2SIP_DESTINATION_NUMFORMAT; ?>'>
            	<label for='isdn2sip_destination_numformat' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN2SIP_DESTINATION_NUMFORMAT_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo isdn2sip_destination_numformat($ba, $config, $newentryflag == 0 ? "VAZ_UNKNOWN" : "VAZ_PLUS"); ?>
            	</div>
          	</div>
          	<div class='form-group isdn2sip_source_numformat <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo ISDN2SIP_SOURCE_NUMFORMAT; ?>'>
            	<label for='isdn2sip_source_numformat' class='col-sm-3 control-label'><?php echo DIALPLAN_ISDN2SIP_SOURCE_NUMFORMAT_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo isdn2sip_source_numformat($ba, $config, $newentryflag == 0 ? "VAZ_UNKNOWN" : "VAZ_PLUS"); ?>
            	</div>
          	</div>
          	<div class='form-group use_privacy_header <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo USE_PRIVACY_HEADER_TOOLTIP; ?>'>
            	<label for='use_privacy_header' class='col-sm-3 control-label'><?php echo DIALPLAN_USE_PRIVACY_HEADER_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo use_privacy_header($ba, $config); ?>
            	</div>
          	</div>

          	<div class="clearfix"></div>

          	<div class="row <?php echo $simple_class; ?>">
            	<p class="lead text-center"><?php echo DIALPLAN_SIP_TO_PSTN_DIS; ?></p>
          	</div>

		   	<div class='form-group dialplan_international_prefix <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo INTERNATIONAL_PREFIX_TOOLTIP; ?>'>
            	<label for='dialplan_international_prefix' class='col-sm-3 control-label'><?php echo DIALPLAN_DIALPLAN_INTERNATIONAL_PREFIX_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo dialplan_international_prefix($ba, $config); //default="00" ?>
            	</div>	
          	</div>
          	<div class='form-group sip2dialplan_dad_prefix_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo FROMSIP_PREFIX_SETTING_TOOLTIP; ?>'>
            	<label for='sip2dialplan_dad_prefix_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP2DIALPLAN_DAD_PREFIX_SETTING_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo sip2dialplan_dad_prefix_setting($ba, $config); ?>
            	</div>
          	</div>
          	<div class='form-group sip2dialplan_oad_prefix_setting <?php echo $simple_class; ?>'data-toggle='tooltip' title='<?php echo FROMSIP_PREFIX_SETTING_TOOLTIP; ?>'>
           		<label for='sip2dialplan_oad_prefix_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_SIP2DIALPLAN_OAD_PREFIX_SETTING_DIS; ?></label>
           		<div class='col-sm-8'>
           			<?php echo sip2dialplan_oad_prefix_setting($ba, $config); ?>
           		</div>
          	</div>

          	<div class="clearfix"></div>

			<div class="row <?php echo $simple_class; ?>">
            	<p class="lead text-center"><?php echo DIALPLAN_OPTIONS_DIS; ?></p>
          	</div>

		  	<div class='form-group from_sip_src_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo FROM_SIP_SRC_SETTING; ?>'>
            	<label for='from_sip_src_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_FROM_SIP_SRC_SETTING_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo from_sip_src_setting($ba, $config); ?>
            	</div>
          	</div>
          	<div class='form-group from_sip_dest_setting <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo FROM_SIP_DEST_SETTING; ?>'>
            	<label for='from_sip_dest_setting' class='col-sm-3 control-label'><?php echo DIALPLAN_FROM_SIP_DEST_SETTING_DIS; ?></label>
            	<div class='col-sm-8'>
            		<?php echo from_sip_dest_setting($ba, $config); ?>
           		</div>
          	</div>
  	<?php
  	return ob_get_clean();
}

function display_more_tab($ba, $config, $simple_class) {
  	ob_start(); ?>
          	<div class='form-group qvalue<?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_QVALUE_TOOLTIP; ?>'>
            	<label for='qvalue' class='col-sm-3 control-label'><?php echo SIP_QVALUE_HEADER; ?></label>
            	<div class='col-sm-8'>
            		<?php echo qvalue($ba, 'qvalue', $config); ?>
            	</div>
          	</div>
 			<div class='form-group tr_notruf <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_TR_NOTRUF_TOOLTIP; ?>'>
				<label for='t38' class='col-sm-3 control-label'><?php echo SIP_TR_NOTRUF_DIS; ?></label>
				<div class='col-sm-8 form-checkbox'>
					<?php echo HelperSip::checkboxConfig($ba, $_GET['id'], 'tr_notruf', $config); ?>
				</div>
			</div>
	    	<div class='form-group addit_options <?php echo $simple_class; ?>'  data-toggle='tooltip' title='<?php echo ADDIT_OPTIONS; ?>'>
            	<label for='addit_options' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DIS; ?></label>
            	<div class='col-sm-8'>
            		<textarea name='addit_options' id='addit_options' class='form-control' rows='5'></textarea>
            	</div>
          	</div>
            <div class='form-group addit_options <?php echo $simple_class; ?>'>
            	<label for='extra_tooltip' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DOC_DIS; ?></label>
            	<div class='col-sm-8'>
              		<p id='extra_tooltip' class='form-control-static' style='height: 170px; overflow: auto; border: 1px solid #A31D26; resize:both;'></p>
            	</div>
            </div>
  	<?php
  	return ob_get_clean();
}

$newentryflag = 0;
if (!isset($_GET['id']) && !isset($_GET['profile'])) {
	$newentryflag = 1;
	?>
	<form class='form-horizontal' name='profile'>
	    <div class='form-group'>
		<label for='name' class='col-sm-3 control-label'><?php echo SIP_PROFILE_DIS; ?></label>
		<div class='col-sm-8'><?php echo HelperSip::profiles(); ?></div>
	    </div>
	    <br /><br />
	    <div class='text-center'><button  class='btn btn-default' onclick="openPopup('<?php echo $page; ?>');" type='button'><?php echo BUTTON_NEXT; ?></button></div>
	</form>
	<?php
} else {
	if (strlen ($_GET['id']) == 0) {
		$newentryflag = 1;
	}

	$fixedSettings = array();
	?>
	<script>
		$(document).ready(function () {
		    hide_reg(document.getElementById('register').checked);
		    hide_validation(document.getElementById('validation').checked);
		    hide_server($('#enum_support').prop('checked'));
		    srtp();
		    $('#srtp_mode').change(function () {
			srtp();
		    });
		    options($('#stunradio').prop('checked'), $('#externipradio').prop('checked'));
	<?php
//Profil auslesen
	if (getProfile($ba) != "manual") {
		$profileParser = new profileParser(getProfile($ba));
		$userSettings = $profileParser->getUserSettings();
		$fixedSettings = $profileParser->getFixedSettings();
		//Allgemeiner Hilfetext anzeigen
		if ($profileParser->getHelpText() !== null) {
			?>
				    $('.help').html('<i><?php echo $profileParser->getHelpText(); ?></i>');
			<?php
		}
		//Help Text for tooltip überschreiben falls ein Text zur Verfügung in dem Profil steht
		foreach ($userSettings as $value) {
			if ($profileParser->getFieldHelp($value) !== null) {
				?>
					    $('.<?php echo $value; ?>').prop('data-toggle', 'tooltip');
					    $('.<?php echo $value; ?>').prop('data-placement', 'auto bottom');
					    $('.<?php echo $value; ?>').prop('data-trigger', 'hover');
					    $('.<?php echo $value; ?>').attr('data-original-title', '<?php echo $profileParser->getFieldHelp($value); ?>');
				<?php
			}
		}
		?>

			    $('.more').addClass('advanced');
		<?php
		//Felder im Formular die nicht user settings sind
		$diffArray = array_diff(HelperSip::$fields, $userSettings);
		foreach ($diffArray as $value) {
			if ($value === "stunserver" || $value === 'externip') {
				?>
					    $('.natoptions').addClass('advanced');
				<?php
			}
			?>
				    $('.<?php echo $value; ?>').addClass('advanced');
			<?php
		}
		?>
			    show_advanced();
		<?php
	}
	?>
		});
	</script>
	<?php
	$natoptSettings = array('stun' => '', 'externip' => '', 'nonat' => '');
	HelperSip::getValue($ba, $_GET['id'], "stunserver", $fixedSettings) == "" ? $natoptSettings['stun'] = "" : $natoptSettings['stun'] = "checked";
	HelperSip::getValue($ba, $_GET['id'], "externip", $fixedSettings) == "" ? $natoptSettings['externip'] = "" : $natoptSettings['externip'] = "checked";
	HelperSip::getValue($ba, $_GET['id'], "externip", $fixedSettings) == "" && HelperSip::getValue($ba, $_GET['id'], "stunserver", $fixedSettings) == "" ? $natoptSettings['nonat'] = "checked" : $natoptSettings['nonat'] = "";

	$bc = new beroConf('root');
	if ($bc->get('root', 'is-sbc-vm') == 1) {
		$stacks['wan'] = 'WAN'. ($ba->get('stack_active_wan') == 0 ? ' (deactivated)' : '');
		if ($bc->get('root', 'is-vpn-running') == 1) {
			$stacks['lan'] = 'LAN/VPN';
		}
		$stacks['localhost'] = 'localhost';
	} else {
		$stacks = array('lan' => 'LAN', 'localhost' => 'localhost');
		if ((int) $ba->get('stack_active_lan') === 0){
			$stacks['lan'] = 'LAN (deactivated)';
		}
		if ($bc->get('root', 'lan-mode') == 'lan-wan' && ((int) $ba->get('stack_active_wan') === 1)) {
			$stacks['wan'] = 'WAN';
		}
		if (is_dir('/home/admin/apps/openvpn/') && ((int) $ba->get('stack_active_vpn') === 1)) {
			$stacks['vpn'] = 'VPN';
		}
	}

	$simple_class = '';
	if ($guiMode == 'simple' && getProfile($ba) == "manual") {
		$simple_class = 'simple';
	}
	?>
	<div class='help'></div>
	<div>
	    <!-- Nav tabs -->
	    <ul class='nav nav-tabs' role='tablist' id='sip-tab'>
		    <li role='presentation' class='active'><a href='#settings' aria-controls='settings' role='tab' data-toggle='tab'><?php echo SIP_POPUP_SETTINGS_TAB; ?></a></li>
			<?php if ($guiMode == 'advanced') { ?>
				<li role='presentation'><a href='#adv-sip-tab' aria-controls='adv-sip-tab' role='tab' data-toggle='tab'><?php echo SIP_POPUP_SIP_TAB; ?></a></li>
        		<li role='presentation'><a href='#media-tab' aria-controls='media-tab' role='tab' data-toggle='tab'><?php echo SIP_POPUP_MEDIA_TAB; ?></a></li>
				<li role='presentation'><a href='#callprogress-tab' aria-controls='callprogress-tab' role='tab' data-toggle='tab'><?php echo SIP_POPUP_CALLPROGRESS_TAB; ?></a></li>
        		<li role='presentation'><a href='#headers-tab' aria-controls='headers-tab' role='tab' data-toggle='tab'><?php echo SIP_POPUP_HEADERS_TAB; ?></a></li>
        		<li role='presentation'><a href='#numberformatting-tab' aria-controls='numberformatting-tab' role='tab' data-toggle='tab'><?php echo SIP_POPUP_NUMBERFORMATTING_TAB; ?></a></li>
        		<li role='presentation'><a href='#more-tab' aria-controls='more-tab' role='tab' data-toggle='tab'><?php echo SIP_POPUP_MORE_TAB; ?></a></li>
			<?php } ?>
	    </ul>

	    <form name='sipp' id='sipp' action='modules/Sip/sip_submit.php' method='POST' class='form-horizontal'>
		<div class='tab-content'>
			<div role='tabpanel' class='tab-pane active' id='settings' style="padding-top: 20px;">
				<input type=hidden name='start' value='<?php echo $page; ?>'>
				<input type=hidden name='profile' id='profile' value='<?php echo getProfile($ba); ?>'>
				<input type='hidden' name='dummy' id='password-dummy' style='display:none' value='0'>

				<div class='form-group name' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_NAME; ?>'>
			   		<label for='name' class='col-sm-3 control-label'><?php echo SIP_NAME_DIS; ?></label>
			   		<div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "name", $fixedSettings); ?>
			    	</div>
				</div>
				<div class='form-group sip_proxy' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_PROXY; ?>'>
			    	<label for='sip_proxy' class='col-sm-3 control-label'><?php echo SIP_PROXY_DIS; ?></label>
			    	<div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "sip_proxy", $fixedSettings); ?>
			    	</div>
				</div>
				<div class='form-group sip_registrar' data-toggle='tooltip'  title='<?php echo TRUNKS_SIP_REGISTRAR; ?>'>
			    	<label for='sip_registrar' class='col-sm-3 control-label'><?php echo SIP_REGISTRAR_DIS; ?></label>
			    	<div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "sip_registrar", $fixedSettings); ?>
			    	</div>
				</div>
				<div class='form-group sip_domain <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_DOMAIN; ?>'>
			    	<label for='sip_domain' class='col-sm-3 control-label'><?php echo SIP_DOMAIN_DIS; ?></label>
			    	<div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "sip_domain", $fixedSettings); ?>
			    	</div>
				</div>
				<?php if ($enumStatus === 0) { ?>
				<div class='form-group enum_search_domain <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_ENUM_SEARCH_DOMAINS; ?>'>
				    <label for='enum_search_domain' class='col-sm-3 control-label'><?php echo SIP_ENUM_SEARCH_DOMAINS_DIS; ?></label>
				    <div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "enum_search_domain", $fixedSettings); ?>
				    </div>
				</div>
				<div class='form-group enum_support <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo SIP_ENUM_SUPPORT_DIS; ?>'>
				    <label for='enum_support' class='col-sm-3 control-label'><?php echo SIP_ENUM_SUPPORT_DIS; ?></label>
				    <div class='col-sm-8 form-checkbox'>
					<?php echo HelperSip::checkbox($ba, $_GET['id'], "enum_support", $fixedSettings, 
						"onchange='hide_server(this.checked);'"); ?>
				    </div>
				</div>
				<?php } ?>
				<div class='form-group dnssrv <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo DNS_SRV_TOOLTIP; ?>'>
					<label for='dnssrv' class='col-sm-3 control-label'><?php echo DNS_SRV_DIS; ?></label>
					<div class='col-sm-8 form-checkbox'>
						<?php echo dnssrv($ba, $config); ?>
					</div>
				</div>	
				<div id='dns_change_behavior' class='form-group dns_change_registration_behaviour <?php echo $simple_class; ?>'>
					<label for='dns_change_registration_behaviour' class='col-sm-3 control-label'><?php echo DNS_CHANGE_REGISTRATION_BEHAVIOUR_LABEL; ?></label>
					<div class='col-sm-8'>
					<?php echo HelperSip::dropdown($ba, $_GET['id'], "dns_change_registration_behaviour", $fixedSettings, array("change_when_no_calls" => DNS_SRV_CHANGE_WHEN_NO_CALLS, "change_immediately" => DNS_SRV_CHANGE_IMMEDIATELY, "stay_on_lower_priority" => DNS_SRV_STAY_ON_LOWER_PRIO,)); ?>
					</div>
				</div>

				<div id='dns_change_time' class='form-group dns_change_minimum_registration_time <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo DNS_CHANGE_MINIMUM_REGISTRATION_TIME_TOOLTIP; ?>'>
					<label for='dns_change_minimum_registration_time' class='col-sm-3 control-label'><?php echo DNS_CHANGE_MINIMUM_REGISTRATION_TIME_LABEL; ?></label>
					<div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "dns_change_minimum_registration_time", $fixedSettings, "900"); ?>
					</div>
				</div>

				<hr>

				<div class='form-group user' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_USER; ?>'>
			    	<label for='sip_domain' class='col-sm-3 control-label'><?php echo SIP_USER_DIS; ?></label>
			    	<div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "user", $fixedSettings); ?>
			    	</div>
				</div>
				<div class='form-group auth_user <?php echo $simple_class; ?>'>
			    	<label for='auth_user' class='col-sm-3 control-label'><?php echo SIP_AUTH_USER_DIS; ?></label>
			    	<div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "auth_user", $fixedSettings); ?>
			    	</div>
				</div>
				<div class='form-group secret' data-toggle='tooltip' title='<?php echo SIP_DISPLAYNAME_TOOLTIP; ?>'>
			    	<label for='displayname' class='col-sm-3 control-label'><?php echo SIP_DISPLAYNAME_DIS; ?></label>
			   		<div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "displayname", $fixedSettings); ?>
			    	</div>
				</div>
				<div class='form-group secret' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_SECRET; ?>'>
			    	<label for='secret' class='col-sm-3 control-label'><?php echo SIP_SECRET_DIS; ?></label>
			    	<div class='col-sm-8'>
						<?php echo HelperSip::passwordField($ba, $_GET['id'], "secret", $fixedSettings); ?>
			    	</div>
				</div>
				<div class='form-group matchtype <?php echo $simple_class; ?>'>
			    	<label for='matchtype[]' class='col-sm-3 control-label'><?php echo SIP_MATCHTYPE_DIS; ?></label>
			    	<div class='col-sm-8'>
						<?php echo HelperSip::matchtype($ba, $_GET['id'], $fixedSettings); ?>
			    	</div>
				</div>
				<div id='matchtype_manual_group' class='form-group matchtype_manual <?php echo $simple_class; ?>'>
					<label for='matchtype_manual' class='col-sm-3 control-label'><?php echo SIP_MATCHTYPE_MANUAL_DIS; ?></label>
					<div class='col-sm-8'>
					<!--$manual = self::getValue($ba, $id, "matchtype_manual", $fixedSettings);-->
						<?php echo HelperSip::textField($ba, $_GET['id'], "matchtype_manual", $fixedSettings); ?>
					</div>
				</div>

				<hr>

				<div id="validatecheckbox" class='form-group validation' data-toggle='tooltip' data-html="true" title='<?php echo TRUNKS_SIP_VALIDATION; ?>'>
			    	<label for='validation' class='col-sm-3 control-label'><?php echo SIP_VALIDATION_DIS; ?></label>
			    	<div class='col-sm-8 form-checkbox'>
						<?php echo HelperSip::checkbox($ba, $_GET['id'], "validation", $fixedSettings, "onchange='hide_validation(this.checked);'"); ?>
			    	</div>
				</div>
				<div id='keepalive_int' class='form-group keepalive_interval <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_KEEPALIVE_INTERVAL; ?>'>
			    	<label for='keepalive_interval' class='col-sm-3 control-label'><?php echo SIP_KEEPALIVE_INTERVAL_DIS; ?></label>
			    	<div class='col-sm-8'>
						<?php echo HelperSip::textField($ba, $_GET['id'], "keepalive_interval", $fixedSettings, "30"); ?>
			    	</div>
				</div>
				<div id="regcheckbox" class='form-group register' data-toggle='tooltip' data-html="true" title='<?php echo TRUNKS_SIP_REGISTER; ?>'>
			    	<label for='register' class='col-sm-3 control-label'><?php echo SIP_REGISTER_DIS; ?></label>
			    	<div class='col-sm-8 form-checkbox'>
						<?php echo HelperSip::checkbox($ba, $_GET['id'], "register", $fixedSettings, "onchange='hide_reg(this.checked);'"); ?>
			    	</div>
				</div>
				<div id="regrefresh_on_validation_fail" class='form-group regrefresh_on_validation_fail' data-toggle='tooltip' data-html="true" title='<?php echo TRUNKS_SIP_REGREFRESH_ON_VALIDATION_FAIL; ?>'>
			    	<label for='regrefresh_on_validation_fail' class='col-sm-3 control-label'><?php echo SIP_REGREFRESH_ON_VALIDATION_FAIL; ?></label>
			    	<div class='col-sm-8 form-checkbox'>
						<?php echo HelperSip::checkbox($ba, $_GET['id'], "regrefresh_on_validation_fail", $fixedSettings); ?>
			    	</div>
				</div>
				<div id='reg' class='regrefresh regrefresh_failed <?php echo $simple_class; ?>'>
			    	<div class='form-group regrefresh' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_REGREFRESH; ?>'>
						<label for='regrefresh' class='col-sm-3 control-label'><?php echo SIP_REGISTRATION_INTERVALL_DIS; ?></label>
			    		<div class='col-sm-8'>
							<?php echo HelperSip::textField($ba, $_GET['id'], "regrefresh", $fixedSettings, "300"); ?>
			    		</div>
					</div>
					<div id='reg' class='form-group regrefresh_failed' data-toggle='tooltip' title='<?php echo TRUNKS_SIP_REGREFRESH_FAILED; ?>'>
			    		<label for='regrefresh_failed' class='col-sm-3 control-label'><?php echo SIP_REGISTRATION_INTERVALL_FAILED_DIS; ?></label>
			    		<div class='col-sm-8'>
							<?php echo HelperSip::textField($ba, $_GET['id'], "regrefresh_failed", $fixedSettings, "10"); ?>
			    		</div>
					</div>
				</div>

				<div class='text-center <?php echo $simple_class; ?>'>
				<?php if (getProfile($ba) != "manual") { ?>
				    <a href='#' onclick='show_advanced();' class='linkAdvanced'><?php echo SIP_ADVANCED_DIS; ?></a>&nbsp;&nbsp;
				<?php }
			    	$config = HelperSip::getValue($ba, $_GET['id'], 'config', $fixedSettings);
				?>
				</div>
		    </div>
			<div role='tabpanel' class='tab-pane' id='adv-sip-tab' style="padding-top: 20px;">
          		<?php echo display_sip_tab($ba, $config, $simple_class, $stacks, $natoptSettings); ?>
	   		</div>
			<div role='tabpanel' class='tab-pane' id='media-tab' style="padding-top: 20px;">
          		<?php echo display_media_tab($ba, $config, $simple_class); ?>
	   		</div>
       		<div role='tabpanel' class='tab-pane' id='callprogress-tab' style="padding-top: 20px;">
         		 <?php echo display_callprogress_tab($ba, $config, $simple_class); ?>
        	</div>
        	<div role='tabpanel' class='tab-pane' id='headers-tab' style="padding-top: 20px;">
          		<?php echo display_headers_tab($ba, $config, $simple_class); ?>
			</div>
        	<div role='tabpanel' class='tab-pane' id='numberformatting-tab' style="padding-top: 20px;">
          		<?php echo display_numberformatting_tab($ba, $config, $simple_class, $newentryflag); ?>
        	</div>
        	<div role='tabpanel' class='tab-pane' id='more-tab' style="padding-top: 20px;">
          		<?php echo display_more_tab($ba, $config, $simple_class); ?>
        	</div>
		</div>

		<div class='text-center' style='margin:10px;'><i><?php echo REQUIRED_FIELDS; ?></i></div>

		<?php
		if (isset($_GET['id']) || getProfile($ba) != "manual") {
			HelperSip::showdefmc($fixedSettings, $is_sbc_vm);
		} else {
			HelperSip::showConfAdd($is_sbc_vm);
		}

		//if copy parameter is given, don't set id and create new SIP Group
		if (isset($_GET['id']) && !isset($_GET['copy'] ) ) { ?>
			<input type='hidden' name='alt_name' value='<?php echo HelperSip::getValue($ba, $_GET['id'], "name", $fixedSettings); ?>'><input type='hidden' name='id_upd' value='<?php echo $_GET['id']; ?>'>
			<?php
		} ?>

		<div class='text-center'>
		    <button type='submit' class='btn btn-default' onclick='selectall();'><?php echo BUTTON_SAVE; ?></button>
		</div>
	    </form>
	</div>
	<?php
}
