<?php
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
require_once('/usr/local/www/berogui/includes/Helper/HelperHtml.php');
class SipLicense {

	private	$_m = '',
					$_ret = '',
					$_response = '';

	private $_is_sbc_vm = 0;

	private $_tabs = array(
						'1' => array(
							'display' => '_licenseDiplayInfoTab',
							'form' 		=> array(
								'action'=> 'info-siplicense',
								'id'		=> 'form-info-siplicense',
								'name'	=> 'info-siplicense',
								'style'	=> '',
								'uri'		=> 'SipLicense/siplicense_submit.php',
							),
							'header'	=> 'SIP_LICENSE_HEADER_DIS'
						),
						'2' => array(
							'display'	=> '_licenseDisplayUploadTab',
							'form' 		=> array(
								'action'=> 'upload-siplicense',
								'id'		=> 'form-upload-siplicense',
								'name'	=> 'upload-siplicense',
								'style'	=> '',
								'uri'		=> 'SipLicense/siplicense_submit.php',
							),
							'header'	=> 'SIP_LICENSE_UPLOAD_DIS',
						),
					);

	private $_s2s_licenses = null;

	private $_isgw = null;

	/* [CONSTRUCTOR] */
	function __construct($m, $get = array(), $post = array()) {
		$this->_m = $m;

		// fetch device
		require_once('/usr/fallback/beroConf.php');
		$bc = new beroConf('root');
		$this->_is_sbc_vm = $bc->get('root', 'is-sbc-vm') == 1 ? 1 : 0;

		require_once('/usr/local/www/berogui/includes/isgwtelnet.php');
		$this->_isgw = new isgwtelnet();
		$this->_isgw->isgw_login();

		// reload sip license
		require_once('/usr/local/www/berogui/includes/Helper/HelperSip.php');
		if (isset($get['reload'])) {
			HelperSip::reloadSipLicense($this->_isgw);
			Helper::activate('1');
		}

		// fetch sip license
		$this->_s2s_licenses = HelperSip::getSip2SipLicenses($this->_isgw);
		if (is_null($this->_s2s_licenses)) {
			unset($this->_tabs['1']);
		}

		// remove upload tab on cloud sbc
		if ($this->_is_sbc_vm) {
			unset($this->_tabs['2']);
		}

		// include header
		$name = 'SIP_LICENSE_HEADER_DIS';
		include('./includes/header.php');
		$ret .= "\n";
		$this->_ret = $ret;

		// set response from submit
		if (isset($get['response'])) {
			$this->_response = $this->_setResponse($get['response']);
			unset($get);
		}
	}

	/* [PUBLIC METHODS] */
	public function display() {
		// build tabs
		$tabs = '';
		$tabs_menu = '';
		foreach ($this->_tabs as $id => $tab) {
			$tabs_menu .= "\t\t<li><a href='#tabs-$id'>". constant($tab['header']) ."</a></li>\n";

			$function = $tab['display'];
			$tab['form']['uri'] = 'SipLicense/siplicense_submit.php';
			$tabs .= $this->$function($id, $tab['form'], "\t");
		}
		return $this->_ret . HelperHtml::buildTabs('tabs', $this->_response, $tabs_menu, $tabs);
	}

	/* [PRIVATE METHODS] */
	private function _licenseDiplayInfoTab($id, $form, $tab = "") {
		// get values
		$sessions = '';
		$transparant = '';
		if (preg_match('/^([0-9]+):([0-9]+)$/', trim($this->_s2s_licenses['sip2sip_number_of_licenses']), $matched)) {
			$sessions = $matched[2];
			$transparent = $matched[1];
		}
		// main form 
		ob_start();
		?>
		<div class='form-group'>
			<label class='col-sm-5 control-label'><?php echo SIP_LICENSE_STATE_DIS; ?></label>
			<div class='col-sm-4'>
				<p class="form-control-static h5" style='padding-top:0px'><?php echo constant(trim($this->_s2s_licenses['sip2sip_license_status'])); ?></p>
			</div>
		</div>
	<?php if (!$this->_is_sbc_vm) { ?> 
		<div class='form-group'>
			<label class='col-sm-5 control-label'><?php echo SIP_LICENSE_SESSIONS_DIS; ?></label>
			<div class='col-sm-4'>
				<p class="form-control-static h5" style='padding-top:0px'><?php echo $sessions; ?></p>
			</div>
		</div>
	<?php } ?>
		<div class='form-group'>
			<label class='col-sm-5 control-label'><?php echo SIP_LICENSE_TRANSPARENT_SESSIONS_DIS; ?></label>
			<div class='col-sm-4'>
				<p class="form-control-static h5" style='padding-top:0px'><?php echo $transparent; ?></p>
			</div>
		</div>
	<?php if (!$this->_is_sbc_vm) { ?>
		<div class='text-center'>
			<input type='button' class='btn btn-default' value='<?php echo BUTTON_DELETE ?>' onclick="javascript:if (confirm('<?php echo SIP_LICENSE_DELETE_MESS_DIS; ?>?') == true) window.location.href = 'misc/deletefile.php?m=<?php echo $this->m_attr ?>&option=sip_license';">
		</div>
		<?php
		}
		$content['main-form'] = ob_get_clean();

		return HelperHtml::tab($id, $form, null, $content, null, $tab);
	}

	private function _licenseDisplayUploadTab($id, $form, $tab = "") {
		ob_start();
		?>
		<div class='form-group' style='margin-top:15px;'>
			<label for='uploadfile' class='col-sm-5 control-label'><?php echo SIP_LICENSE_UPLOAD_DIS; ?></label>
			<div class='col-sm-4 form-checkbox'>
				<input type='file' size='28' name='uploadfile' required>
			</div>
		</div>
		<div class='text-center' style='margin-top:25px;'>
			<input type="submit" class="btn btn-default" data-toggle="tooltip" title="<?php echo BACK_RES_UPLOAD ?>" value="<?php echo BUTTON_UPLOAD ?>">
		</div>
		<?php
		$content['main-form'] = ob_get_clean();
		return HelperHtml::tab($id, $form, null, $content, null, $tab);
	}

	private function _setResponse($which) {
		$response = '';
		switch ($which) {
		case '1':
			return "<div class='text-center' style='padding-top:15px;'><font color='green'>". SIP_STACKS_UPLOAD_SUCCESS_DIS ."</font></div>";
		case '-1':
			$response = SIP_LICENSE_INVALID_FILENAME_DIS;
			break;
		case '-2':
			$response = SIP_STACKS_FILE_SIZE_DIS;
			break;
		case '-3':
			$response = SIP_LICENSE_EMPTY_FILE_DIS;
			break;
		}
		return "<div class='text-center' style='padding-top:15px;'><font color='red'>$response</font></div>";
	}
}
?>
