<?php

/**
 * Implementiert die Statistikseite über Portinformationen
 * @author Miguel Palmer <mp@beronet.com>
 */
class StateStatistic {

	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array(), $session = array()) {}

	function portTable($rows) {

		$ret .= "<table class='table table-striped table-bordered' style='width:90%; margin:auto;'>";
		$ret .= "<tr><th colspan='6' class='text-center'>" . PORTS_STAT_TABLE_HEADER_DIS . "</th></tr>";
		$ret .= "<tr><td><b>" . PORTS_STAT_PORT_DIS . "</b></td>";
		$ret .= "<td><b>" . PORTS_STAT_DIRECTION_DIS . "</b></td><td><b>" . PORTS_STAT_CALLS_DIS . "</b></td>
				<td><b>" . PORTS_STAT_CONNECTED_DIS . "</b></td><td><b>" . PORTS_STAT_CONNECTED_TIME_DIS . "</b></td>
				<td><b>" . PORTS_STAT_LESS_10_SEC_DIS . "</b></td></tr>";

		$i = 0;
		foreach ($rows as $value) {
			if (strstr($value, "SESSION STATISTICS")) continue;
			if (strstr($value, "-----")) continue;
			if (strstr($value, "CALLS TOTAL")) continue;

			//get PORT and Type
			$tmp = explode("=>", $value);
			$tmp2 = explode(":", $tmp[0]);
			$port = substr($tmp2[0], 6, 1);
			if ($port == "S") $port = "SIP";
			$tmp3 = explode(" ", $tmp2[1]);
			$type = $tmp3[2];
			$type = str_replace("_TO_", " &#8594; ", $type);

			if (!$port) {
				continue;
			}

			$arr[$i]["port"] = $port;
			$arr[$i]["type"] = $type;

			//get total calls
			$tmp2 = explode("(", $tmp[1]);
			$arr[$i]["$type"]["calls"] = $tmp2[0];
			$tmp3 = explode(" ", $tmp2[1]);
			$arr[$i]["$type"]["connected"] = $tmp3[0];

			//get ctime
			$tmp2 = explode(" ", $tmp[2]);
			$tmp3 = explode(")", $tmp2[4]);
			$arr[$i]["$type"]["ctime"] = $tmp3[0];

			//get less t 10
			$tmp2 = explode("(", $tmp[3]);
			$tmp3 = explode(" ", $tmp2[1]);
			$arr[$i]["$type"]["lt10"] = $tmp3[0];
			$i++;
		}

		$i = 0;
		if ($arr) {
			foreach ($arr as $value) {
				$ret .= "<tr>";
				$ret .= "<td>" . $value["port"] . "</td>";
				$ret .= "<td>" . $value["type"] . "</td>";
				$ret .= "<td>" . $value[$value["type"]]["calls"] . "</td>";
				$ret .= "<td>" . $value[$value["type"]]["connected"] . "</td>";
				$ret .= "<td>" . $value[$value["type"]]["ctime"] . "</td>";
				$ret .= "<td>" . $value[$value["type"]]["lt10"] . "</td>";
				$ret .= "</tr>";
				$i++;
			}
		}

		$ret .= "</table>";

		return $ret;
	}

	function infoTable ($info) {

		//general statistic information
		$ret .= "<table class='table table-striped table-bordered' style='width:60% !important; margin:auto; margin:auto'>";
		$ret .= "<tr><th colspan='2' class='text-center'>" . PORTS_STAT_TABLE_INFO_DIS . "</th></tr>";
		$ret .= "<tr><td>" . PORTS_STAT_SIP2DP_DIS . "</td><td>" . $info['sip2DP'] . "</td></tr>";
		$ret .= "<tr><td>" . PORTS_STAT_MAXS2S_DIS . "</td><td>" . $info['s2sm']   . "</td></tr>";
		$ret .= "<tr><td>" . PORTS_STAT_TOTAL_DIS  . "</td><td>" . $info['total']  . "</td></tr>";
		$ret .= "<tr><td>" . PORTS_STAT_UPTIME_DIS . "</td><td>" . $info['uptime'] . "</td></tr>";
		$ret .= "</table>";

		$ret .= "<br><form action='/app/berogui/index.php?m=StateStatistic' method='post' class='text-center'><input type='submit' value='".BUTTON_RESET."' name='reset' class='btn btn-default'></input></form>";
		
		return $ret;
	}

	/**
	 * Generates the HTML page
	 * @return string
	 */
	function display() {

		require_once "./includes/isgwtelnet.php";
		$name = "PORTS_STAT_TITLE_DIS";
		include('./includes/header.php');

		$isgw = new isgwtelnet();
		$result = $isgw->isgw_login();
		if ($result == false) {
			return $ret;
		}

		if (isset($_POST['reset'])) {
			$isgw->isgw_resetstatistic();
			$msg = "<br><div class='text-center'><img src='./includes/images/punkt_gruen.gif' style='padding-right: 10px'><span style='vertical-align:middle'>".PORTS_STAT_RESET_DIS."</span></div>";
		}

		$portStat = explode("\n", $isgw->isgw_portstatistic());
		$sessionStat = explode("\n", $isgw->isgw_actualcalls());

		$info = array();

		$info['uptime'] = str_replace("ISGW uptime: ", "", $isgw->isgw_uptime());

		foreach ($sessionStat as $value) {
			//add s2s statistic to ports array
			if (strstr($value, "SIP_TO_SIP") && strstr($value, "avg")) {
				$value = "SIP   S: " . $value;
				array_push($portStat, $value);
			}
			if (strstr($value, "TOTAL") && strstr($value, "avg")) {
				$tc = explode(" ", $value);
				$info['total'] = $tc[9];
			}
			if (strstr($value, "SIP_TO_DP")) {
				$info['sip2DP'] = end(explode(" ", $value));
			}
			if (strstr($value, "S2S_MAX")) {
				$s2sma = explode(" ", $value);
				$info['s2sm'] = $s2sma[7];
			}
		}

		$ret .= $msg . "<br>";
		$ret .= $this->portTable($portStat);
		$ret .= "<br>";
		$ret .= $this->infoTable($info);

		return $ret;
	}
}

?>