<?php
$m = 'UpdateTool';
$berogui_path = '/usr/local/www/berogui';

/* [CHECKING SESSION] */
$newTarget = "/app/berogui/index.php?m=$m";
include("$berogui_path/includes/session.php");
unset($newTarget);

/* [CHECKING GET] */
unset($_GET);

/* [CHECKING POST] */
require_once("$berogui_path/includes/Helper/Helper.php");
unset($_POST['submit']);

$parameters = require("$berogui_path/modules/UpdateTool/updatetool_parameters_sbcvm.php");
$parameters = array_merge($parameters['tab-1']['data'], $parameters['tab-2']['data']);
Helper::setDataValidator($parameters, $list_data, $options_data);

$exec_ajax = 1;
$data = Helper::sanitizePost($_POST['data'], $list_data, $exec_ajax, $invalid, $options_data);
unset($_POST);

/* [EXECUTING AJAX] */
if (!$exec_ajax) {
	Helper::redirectOnInvalidData($m, $invalid);
}

// clean /etc/cron.* directories
if (!Helper::cleanCronDirectories('sbcvm-update', $options_data['sbcvmupdate-mode'])) {
	Helper::redirectOnError($m, 2, null);
}

// copy/past to cron.$frame directory
if($data['sbcvmupdate-mode'] != 'manual') {
	if (!Helper::system(1, "cp /usr/local/beroNet/bin/sbcvm-update /etc/cron.{$data['sbcvmupdate-mode']}/", $output)) {
		Helper::redirectOnError($m, 3, $output);
	}
}	

// update database
require_once("/usr/fallback/beroConf.php");
$bc = new beroConf('root');
foreach ($data as $key => $value) {
	if ($parameters[$key]['save']) {
		$bc->set('root', $key, $value);
	}
}

// if a available package (rc version) and sbcvm-has-update variables are set
// and a submit is executed with onlystable == 1, we remove the sbcvm-has-update variable
if ($data['sbcvmupdate-mode'] == 'manual') {
	if (preg_match('/.*-rc-*/', $bc->get('root', 'sbcvm-available-package'))) {
		if ($data['sbcvmupdate-onlystable'] == 1) {
			$bc->delete('root', 'sbcvm-has-update');
		}
		else {
			$bc->set('root', 'sbcvm-has-update', 1);
		}
	}
}

// redirect
Helper::redirectAfterSubmit($bc, $m, '&success=1');
?>
