<?php
require_once ("/usr/local/php/include/apiCall.class.php");

class FirmwareGetAppFsVersion extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		if (!file_exists('/usr/local/FILENAME')) {
			$this->_execResult = false;
			$this->_execResponseCode = 404;
			return($this->_execResult);
		}

		$contents = file_get_contents('/usr/local/FILENAME');

		preg_match('/appfs-(.*).tar.gz/', $contents, $matches);

                if (isset($matches[1]) && strlen($matches[1]) > 0) {
                        $this->_execResultString .= ':' . $matches[1] . ';';
                } else {
                        $this->_execResult = false;
                }

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . ($this->_execResult ? $this->_execResultString : 'error'));
	}

}?>