<?PHP
$m = 'State';
$berogui_path = "/usr/local/www/berogui";

/* [INCLUDE] */
include('/usr/fallback/beroConf.php');
include($berogui_path ."/includes/isgwtelnet.php");
include_once($berogui_path ."/includes/Helper/Helper.php");

$exec_ajax = 1;
$invalid = array();

/* [CHECKING SESSION] */
$IS_TIMEOUT = false;
$IS_AJAX_REQUEST = true;
include("$berogui_path/includes/session.php");
if ($IS_TIMEOUT) {
	header("{$_SERVER['SERVER_PROTOCOL']} 408 Timeout");
	exit(0);
}


/* [CHECKING GET REQUEST] */
unset($_GET);

/* [CHECKING POST REQUEST] */
$list_post = array('lif_gsm' => 'int>=0', 'port_gsm' => 'int>=0', 'port_isdn' => 'int>=0', 
	'reloadsip' => 'bool', 'reloadisdn' => 'bool', 'reloadgsm' => 'bool', 'refresh_state' => 'bool');

$_POST = Helper::sanitizePost($_POST, $list_post, $exec_ajax, $invalid);

/* [EXECUTING AJAX] */
if (!$exec_ajax) {
        echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
        exit(1);
}

$isgw = new isgwtelnet();
if (($result = $isgw->isgw_login()) == false) {
	echo "<script>window.location='../../index.php?m=$m&isgwerror=1'</script>";
	exit(1);
}

require_once("$berogui_path/misc/database.php");
$ba = new beroAri();
require_once("$berogui_path/includes/lang.php");

if ($_POST['refresh_state'] == true) {

	$bc = new beroConf('root');
	require_once($berogui_path . "/modules/State/State.php");
	$State = new State('State');

	$hw_tables = '';
	$sbcvm_table = '';

	if ($ba->get('is_sbc_vm') == 1) {
		$sbcvm_table = $State->sbcvmProcessTable($bc, $bc->get('root', 'is-vpn-running') == 1);
	}
	else {
		$hw_tables = $State->isdn_state_table($isgw)
								.$State->analog_state_table($isgw)
								.$State->cas_state_table($isgw)
								.$State->gsm_state_table($ba,$isgw)
								.$State->pcm_state_table($ba,$isgw)
								.$State->nic_state_table($bc);
	}

	$sip = $State->sip_state_table($ba,$isgw);
	$capi = $State->capi_state_table($isgw);
	$cloud = $State->cloud_state_table($ba,$bc);

	echo ($hw_tables . $sip . $sbcvm_table . $capi . $cloud);
}

if ($_POST['reloadisdn'] == "true") {
	$isgw_response = $isgw->port_restart($_POST['port_isdn']);
	$restarted = ((preg_match('/OK/', $isgw_response) == 1) ? 1 : 0);
	if ($restarted == 1) {
		$response = '<div><img src="./includes/images/punkt_gruen.gif" style="padding-right: 10px"><font color="black">Port '.$_POST['port_isdn'].' - Restart successful</font></div>';
	} else {
		$response = '<div><img src="./includes/images/punkt_rot.gif" style="padding-right: 10px"><font color="black">Port '.$_POST['port_isdn'].' - Restart failed</font></div>';
	}
}

else if ($_POST['reloadgsm'] == "true") {
	$isgw_response = $isgw->port_restart_gsm($_POST['port_gsm'], $_POST['lif_gsm']);	
	$restarted = ((preg_match('/STARTED/', $isgw_response) == 1) ? 1 : 0); 
	if ($restarted == 1) {
		$response = '<div><img src="./includes/images/punkt_gruen.gif" style="padding-right: 10px"><font color="black">LI '.$_POST['lif_gsm'].' - Restart successful</font></div>';
	} else {
		$response = '<div><img src="./includes/images/punkt_rot.gif" style="padding-right: 10px"><font color="black">LI '.$_POST['lif_gsm'].' - Restart failed</font></div>';
	}
} 

else if ($_POST['reloadsip'] == "true") {
	$isgw_response = $isgw->isgw_sipreload();
	$restarted = ((preg_match('/reloaded/', $isgw_response) == 1) ? 1 : 0);
	if ($restarted == 1) {
		$response = '<div><img src="./includes/images/punkt_gruen.gif" style="padding-right: 10px"><font color="black">Reloading SIP successful</font></div>';
	} else {
		$response = '<div><img src="./includes/images/punkt_rot.gif" style="padding-right: 10px"><font color="black">Reloading SIP failed</font></div>';
	}
}

//return response
if (!empty($response)) {
	echo "$response";
}

?>
