<?php
require_once ("/usr/local/php/include/apiCall.class.php");
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/local/www/berogui/includes/isgwtelnet.php');

class TelephonyGetCdr extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		$ba = new beroAri();

		if (isset($this->_parameters['LoggingActive'])) {
			$ba->set('logcdr', (($this->_parameters['LoggingActive'] == 1) ? '1' : '0'));
			return($this->_execResult);
		}

		$action = $this->_parameters['Action'];
		switch ($action) {
			case 'download':
			case 'download_old':
				$this->_execResponseCode = false;
				if ($ba->get('logcdr') != '1') {
					$this->_execResultString = 'error:logging_of_cdr_is_not_active;';
					$this->_execResult = false;
					$this->_execResponseCode = 404;
					return($this->_execResult);
				}
	
				//we do not rotate the file when download_old is called
				if ($action == "download") {
					//this should create a /tmp/isgw.cdr.1
					$isgw = new isgwtelnet();
					$isgw->isgw_login();
					$isgw->rotate_cdr();
					sleep(4);
				}
	
				if (!file_exists('/tmp/isgw.cdr.1')) {
					$this->_execResultString = 'error:cdr_are_not_available;';
					$this->_execResult = false;
					$this->_execResponseCode = 404;
					return($this->_execResult);
				}
				break;
			case 'delete':
				@unlink('/tmp/isgw.cdr.1');
				@unlink('/tmp/isgw.cdr.2');
				break;
			default:
				$this->_execResultString = 'error:invalid_parameters;';
				$this->_execResult = false;
				$this->_execResponseCode = 405;
				break;
		}

		return($this->_execResult);
	}

	function display () {
		$action = $this->_parameters['Action'];
		if ((($action == 'download') || ($action == 'download_old')) && ($this->_execResult == true)) {
			copy('/tmp/isgw.cdr.1', '/tmp/isgw.cdr.2');
			$file = file_get_contents('/tmp/isgw.cdr.2');

			header('Content-Type: application/force-download');
			header('Content-Disposition: attachment; filename=isgw.cdr' . "\r\n\r\n");
			header('Content-Length: ' . strlen($file) . "\n\n");
			return($file);
		}

		return($this->_name . ':' . $this->_execResultString);
	}

}?>