<?php
class HelperHtml {

	public static function actionButton($btn, $tab = "") {
		$button = "$tab<div class='text-center' style='display:inline-block;'>\n"
			      .	"$tab\t<form id='{$btn['form']['id']}' name='{$btn['form']['name']}' action='{$btn['form']['action']}' method='{$btn['form']['method']}'>\n"
						. (isset($btn['action']) && strlen($btn['action']) ? "$tab\t\t<input type='hidden' name='action' value='{$btn['action']}'/>\n" : '')
						. (isset($btn['option']) && strlen($btn['option']) ? "$tab\t\t<input type='hidden' name='option' value='{$btn['option']}'/>\n" : '')
						. "$tab\t\t<button class='btn btn-default' type='submit' data-toggle='tooltip' title='' data-original-title='{$btn['tooltip']}'>{$btn['value']}</button>\n"
						. "$tab\t</form>\n"
						. "$tab</div>\n";
		return($button);
	}

	public static function actionButtonsInline($btns, $tab = "") {
		$buttons = '';
		foreach ($btns as $btn) {
			$buttons .= self::actionButton($btn, "$tab\t");
		}
		return(
			"$tab<div class='text-center'>\n"
		. $buttons
		. "$tab</div>\n"
		);
	}

	public static function actionButtonByJavascript($img, $id, $options, $tab = "") {
		$button = "$tab<a class='popup_download' onclick=\"deleteById('$id', '{$options['action-delete']}', '{$options['m']}', '{$options['script-delete']}', '". constant($options['msg-delete']) ."');\">\n"
						.	"$tab\t<img src='./includes/images/$img.png' onmouseover=\"Tip('". constant($options['btn-delete']) ."')\" onmouseout='UnTip()'>\n"
						. "$tab</a>\n";
		return $button;
	}

	public static function actionButtonByModal($img, $url, $modal, $tooltip, $tab = "") { 
		$button =	"$tab<a href='$url' data-remote='false' data-toggle='modal' data-target='#$modal' class='popup_download'>\n"
						. "$tab\t<img src='./includes/images/$img.png' onmouseover=\"Tip('". constant($tooltip) ."')\" onmouseout='UnTip()'>\n"
						. "$tab</a>&nbsp\n";
		return $button;
	}

	public static function buildTabs($id, $msg, $menu, $content, $tab = "") {
		$tabs = "$tab<script>\n"
					. "$tab\t$(function() {\n"
					. "$tab\t\t$('#$id').tabs({active:0});\n"
					. "$tab\t});\n"
					. "$tab</script>\n"
					. $msg
					. "$tab<!-- BEGIN TABS --!>\n"
					. "$tab<div id='$id' style='margin-top:20px;'>\n"
					. "$tab\t<ul>\n"
					. $menu
					. "$tab\t</ul>\n"
					. $content
					. "$tab</div>\n"
					. "$tab<!-- END TABS --!>\n";
		return $tabs;
	}

	public static function buttons($param, $value, $options = array(), $tab = "\t") {
		// TODO: replace isset by array_merge
		// init
		$options = array_merge(array(
			'disabled' => false,
			'name'     => 'submit',
			'style'    => '',
			'action'   => '',
			'type'     => 'submit',
		), $options);

		$button = "$tab<div class='text-center' style='{$options['style']}'>\n"
						. (isset($options['image']) ? "$tab{$options['images']}" : '');
		// build
		if (is_null($options['options'])) {
			// one button
			$value = defined($value) ? constant($value) : $value;
			$disabled = $options['disabled'] ? ' disabled' : '';
			$title = isset($options['title']) ? defined($options['title']) ? constant($options['title']) : $options['title'] : '';
			$button .= (strlen($options['action']) ? "$tab\t<input type='hidden' name='action' value='{$options['action']}'/>" : '')
				      . "$tab\t<input id='id_$param' type='{$options['type']}' name='{$options['name']}' class='btn btn-default' title='$title' value='$value'$disabled>\n";
		}
		else {
			// multiple buttons
			foreach ($options['options'] as $key => $btn) {
				$title = isset($btn['title']) ? defined($btn['title']) ? constant($btn['title']) : $btn['title'] : '';
				$value = defined($btn['value']) ? constant($btn['value']) : $btn['value'];
				$button .= "$tab\t<input id='id_$key' type='{$options['type']}' class='btn btn-default action' title='$title' value='$value' value2='$key'>\n";
			}
		}
		$button .= "$tab</div>\n";

		// return
		return $button;
	}

	public static function dynamicTable($header, $datas, $options, $tab = "") {
		$id = $options['checkall-id'];
		$table = 	"$tab<div class='container table-responsive' style='{$options['table-style']}'>\n"
						. "$tab\t<table class='table table-striped table-bordered'>\n"
						. "$tab\t\t<thead><tr><th class='checkall'><div data-toggle='tooltip' title='Check all'><input type='checkbox' id='$id'></div></th><th>". implode('</th><th>', $header) ."</th></tr></thead>\n";
		if (!empty($datas)) {
			$table .= "$tab\t\t<tbody>\n";
			foreach ($datas as $id => $data) {
				$table .= "$tab\t\t\t<tr>\n"
								.	"$tab\t\t\t\t<td class='checkall'><form><input type='checkbox' name='entryid' class='entryid {$options['action-delete']}' value1='$id' value2='". (isset($data['name']) ? $data['name'] : '') ."'></form></td>\n"
								. "$tab\t\t\t\t<td>". implode('</td><td>', $data) ."</td>\n"
								. "$tab\t\t\t\t<td>\n"
								. self::actionButtonByModal('modify', "{$options['url-edit']}&id=$id", $options['modal-id'], $options['btn-modify'], "$tab\t\t\t\t\t")
								. (isset($options['btn-copy']) ? self::actionButtonByModal('copy', "{$options['url-edit']}?id=$id&copy=1", $options['modal-id'], $options['btn-copy'], "$tab\t\t\t\t\t") : '')
								. self::actionButtonByJavascript('delete', $id, $options, "$tab\t\t\t\t\t")
								.	"$tab\t\t\t\t</td>\n"
								. "$tab\t\t\t</tr>\n";
			}
			$table .= "$tab\t\t</tbody>\n";
		}
		$table .= "$tab\t</table>\n"
						. "$tab\t<img src='./includes/images/arrow.jpg' style='margin-left:10px;margin-right:5px;'><a href=\"javascript:void deleteAll('{$options['action-delete']}', '{$options['m']}', '{$options['script-delete']}', '". constant($options['msg-delete']) ."');\">". constant($options['btn-delete-all']) ."</a>\n"
						.	"$tab</div>\n"
						. self::modalButton($options, $tab)
						. self::dynamicTableJavascript($options);
		return $table;
	}

	public static function dynamicTableJavascript($options) {
		ob_start();
		?>
		<script>
			$('#<?php echo $options['checkall-id']; ?>').click(function() {
				var checkall = this.checked;
				$('.entryid').each(function() {
					this.checked = checkall;
				});
			});
		</script>
		<?php
		return ob_get_clean() ."\n";
	}

	public static function fieldButtonTest($idwait, $idbtn, $idtest, $tab = "\t") {
		$button = "$tab\t\t<div id='$idwait' class='text-center' style='display:none;'>\n"
			      . "$tab\t\t\t<img src='./includes/images/waitlogo1.gif'>\n"
						. "$tab\t\t</div>\n"
						. "$tab\t\t<div id='$idbtn' class='text-center' style='display:block;'>\n"
						. "$tab\t\t\t<input type='button' id='$idtest' class='btn btn-default' value='". BUTTON_TEST ."'>\n"
						. "$tab\t\t</div>\n";
		return($button);
	}

	public static function fieldButtonsInline($label, $btns, $options = array(), $tab = "\t") {
		$default_options = array(
			'class-div'		=> 'col-sm-4', 
			'class-label'	=> 'col-sm-5 control-label', 
			'image'				=> '',
		);
		$options = array_merge($default_options, $options);
		$buttons = 	"$tab<div class='form-group'>\n"
							. "$tab\t<label for='download' class='{$options['class-label']}'>". constant($label) ."</label>\n"
							. "$tab\t<div class='{$options['class-div']}'>\n";
		foreach ($btns as $btn) {
			unset($id);
			extract($btn);
			$id = is_null($id) ? '' : "id='$id'";
			$value = defined($value) ? constant($value) : $value;
			$title = defined($title) ? constant($title) : $title;
			$javascript = is_null($javascript) ? '' : $javascript;
			$buttons .= "$tab\t\t<input type='button' class='btn btn-default' $id value='$value' title='$title' onclick=\"$javascript\" data-toogle='tooltip'". ($disabled ? ' disabled' : '') .">\n";
		}
		$buttons .= "$tab\t</div>\n"
							.	(strlen($options['image']) > 0 ? "$tab\t<div class='col-sm-4'>{$options['image']}</div>\n" : '')
							.	"$tab</div>\n";
		return $buttons;
	}

	public static function fieldCheckbox($param, $value, $options, $tab = "\t") {
		$checked = $value ? ' checked' : '';
		$style = isset($options['style']) ? " style='{$options['style']}'" : '';
		$checkbox =	"$tab<div class='form-group $param' data-toggle='tooltip' title=\"". (defined($options['tooltip']) ? constant($options['tooltip']) : $options['tooltip']) ."\">\n"
							. "$tab\t<label for='$param' class='col-sm-5 control-label'>". (defined($options['title']) ? constant($options['title']) : $options['title']) ."</label>\n"
							. "$tab\t<div class='col-sm-4 form-checkbox'$style>\n"
							. "$tab\t\t<input type='hidden' name='data[$param]' value='0'>\n"
							. "$tab\t\t<input type='checkbox' name='data[$param]' id='id_$param' value='1'$checked>\n"
							. "$tab\t</div>\n"
							. (isset($options['third-column']) ? "$tab\t{$options['third-column']}\n" : "")
							. "$tab</div>\n";
		return $checkbox;
	}

	public static function fieldLink($param, $value, $options, $tab = "\t") {
		$style = array(
			'div-a' => '',
		);
		$style = array_merge($style, $options['style']);
		$link = "$tab<div class='form-group $param' data-toogle='tooltip' title=\"". (defined($options['tooltip']) ? constant($options['tooltip']) : $options['tooltip']) ."\">\n"
					.	"$tab\t<label for='$param' class='col-sm-5 control-label'>". (defined($options['title']) ? constant($options['title']) : $options['title']) ."</label>\n"
					. "$tab\t<div class='col-sm-4 form-link' style='{$style['div-a']}'>\n"
					. "$tab\t\t<a href='{$options['link']}' target='_blank'>". (defined($options['message']) ? constant($options['message']) : $options['message']) ."</a>\n"
					. "$tab\t</div>\n"
					. "$tab</div>\n";
		return $link;
	}

	public static function fieldNote($header, $message, $options = array(), $tab = "\t") {
		$options = array_merge(array(
			'width' => '50',
		), $options);
		$box = "$tab<table class='table table-striped table-bordered' style='width:{$options['width']} !important; margin:auto; margin-top:20px;'>\n"
				 . "$tab\t<tr><th class='text-center'>$header</th></tr>\n"
				 . "$tab\t<tr><td>$message</td></tr>\n"
				 . "$tab</table>\n";
		return($box);
	}

	public static function fieldPorts($param, $lifs, $options, $tab = "\t") {
		// options
		$default_options = array(
			'div-id' 		=> '',
			'div-style'	=> '',
		);
		$options = array_merge($default_options, $options);
		// class
		$class = array(
			'label' => 'col-sm-5 control-label',
		);
		if (!empty($options['class'])) {
			$class = array_merge($class, $options['class']);
		}	
		$ports = 	"$tab<div class='form-group {$param}[]' id='{$options['div-id']}' style='{$options['div-style']}'>\n"
						.	"$tab\t<label for='{$param}[]' class='{$class['label']}'>". (defined($options['title']) ? constant($options['title']) : $options['title']) ."</label>\n"
						. "$tab\t<div class='col-sm-6'>\n";
		foreach ($lifs as $key => $lif) {
			$ports .= "$tab\t\t<div class='left' style='margin-left:50px;'>\n"
							. "$tab\t\t\t<div><b>Li$key({$lif['type']})</b></div>\n"
							. "$tab\t\t\t<div>\n";
			foreach($lif['ports'] as $port) {
				$ports .= "$tab\t\t\t\t<div>Port $port <input type='checkbox' class='aport' name='data[$param][]' value='$port'></div>\n";
			}
			$ports .= "$tab\t\t\t</div>\n"
							.	"$tab\t\t</div>\n";
		}
		$ports .= "$tab\t</div>\n"
						.	"$tab</div>\n";
		return $ports;
	}

	public static function fieldSelect($param, $key_sel, $options, $tab = "\t") {
		$class = array(
			'label' => 'col-sm-5 control-label', 
		);
		if (!empty($options['class'])) {
			$class = array_merge($class, $options['class']);
		}
		// set selected field
		$selected[$key_sel] = ' selected';

  	$select = "$tab<div class='form-group $param' data-toggle='tooltip' title=\"". (defined($options['tooltip']) ? constant($options['tooltip']) : $options['tooltip']) ."\">\n"
  					. "$tab\t<label for='$param' class='{$class['label']}'>". constant($options['title']) ."</label>\n"
  					. "$tab\t<div class='col-sm-4'>\n"
						. "$tab\t\t<select class='form-control input-sm' name='data[$param]' id='id_$param'>\n";

		foreach ($options['options']['select'] as $key => $value) {
			$select .= "$tab\t\t\t<option value='$key'{$selected[$key]}>". (defined($value) ? constant($value) : $value) ."</option>\n";
		}
                       
		$select .= "$tab\t\t</select>\n"
						.  "$tab\t</div>\n"
						.  "$tab</div>\n";
	
		return $select;
	}

	public static function fieldText($param, $value, $options, $tab = "\t") {
		$class = array(
			'div-id'		=> '',
			'div-style'	=> '',
			'input'			=> 'form-control input-sm',
			'input-div'	=> 'col-sm-4',
			'label'			=> 'col-sm-5 control-label',
			'main-div'	=> 'form-group',
		);
		if (!empty($options['class'])) {
			$class = array_merge($class, $options['class']);
		}
		$options['disabled'] = $options['disabled'] ? ' disabled' : '';
		$tooltip = defined($options['tooltip']) ? constant($options['tooltip']) : $options['tooltip'];
		$input =  "$tab<div class='{$class['main-div']} $param' data-toggle='tooltip' title=\"$tooltip\" id='{$options['div-id']}' style='{$options['div-style']}'>\n"
						. "$tab\t<label for='$param' class='{$class['label']}'>". (defined($options['title']) ? constant($options['title']) : $options['title']) ."</label>\n"
         		. "$tab\t<div class='{$class['input-div']}' style='{$options['style-div']}'>\n"
       			. "$tab\t\t<input type='text' class='{$class['input']}' name='data[$param]' id='id_$param' value='$value' style='{$options['style-input']}'{$options['disabled']}>\n"
						. (isset($options['third-column']) ? $options['third-column'] : '')
       			. "$tab\t</div>\n"
       			. "$tab</div>\n";
		return $input;
	}

	public static function fieldText2($param, $value, $options, $tab = "\t") {
		$class = array(
			'input-1'		=> 'form-control input-sm',
			'input-2'		=> 'form-control input-sm',
			'input-div'	=> 'col-sm-4',
			'label'			=> 'col-sm-5 control-label',
			'main-div'	=> 'form-group',
		);
		if (!empty($options['class'])) {
			$class = array_merge($class, $options['class']);
		}
		// output
		$value = explode(';', $value);
		$input =  "$tab<div class='{$class['main-div']} $param' data-toggle='tooltip' title=''>\n"
						. "$tab\t<label for='$param' class='{$class['label']}'>". (defined($options['title']) ? constant($options['title']) : $options['title']) ."</label>\n"
				. "$tab\t<div class='{$class['input-div']}'>\n"
       			. "$tab\t\t<input type='text' class='{$class['input-1']}' style='width:49%;display:inline-block;' placeholder='{$options['placeholder1']}' name='data[$param][1]' id='id_{$param}_1' value='{$value[0]}' title='". constant($options['tooltip'][1]) ."' data-toggle='tooltip'>\n"
       			. "$tab\t\t<input type='text' class='{$class['input-2']}' style='width:49%;display:inline-block;' placeholder='{$options['placeholder2']}' name='data[$param][2]' id='id_{$param}_2' value='{$value[1]}' title='". constant($options['tooltip'][2]) ."' data-toggle='tooltip'>\n"
       			. "$tab\t</div>\n"
       			. "$tab</div>\n";
		return $input;
	}

	public static function fieldUpload($param, $value, $options, $tab = "\t") {
		// merge options
		$options = array_merge(array(
			'tooltip' => '',
		), $options);
		// build div header
		$divh = "$tab<div class='form-group'>\n";
		if (defined($options['tooltip'])) {
			$divh = "$tab<div class='form-group' data-toggle='tooltip' title='". constant($options['tooltip']) ."'>\n";
		}
		else if (strlen($options['tooltip'])) {
			$divh = "$tab<div class='form-group' data-toggle='tooltip' title='{$options['tooltip']}'>\n";
		}
		$upload = $divh
			      .	"$tab\t<label for='uploadfile' class='col-sm-5 control-label'>". constant($options['title']) ."</label>\n"
						. "$tab\t<div class='col-sm-4 form-checkbox'>\n"
						. "$tab\t\t<input type='file' size='28' name='$param'>\n"
						. "$tab\t</div>\n"
						. "$tab</div>\n";
		return($upload);
	}

	public static function form($content, $options = null, $tab = "\t") {
		$default_options = array(
			'action'  => '',
			'class'	  => 'form-horizontal',
			'enctype' => 'multipart/form-data',
			'id'		  => '',
			'method'  => 'POST',
			'style'	  => '',
			'title'	  => '',
		);
		$options = array_merge($default_options, $options);

		$form = "$tab<form action='{$options['action']}' method='{$options['method']}' class='{$options['class']}' id='{$options['id']}' style='{$options['style']}' enctype='{$options['enctype']}'>\n"
					.	(strlen($options['title']) ? "\t$tab<p class='text-center lead'>". constant($options['title']) ."</p>\n" : '')
					. $content
					. "$tab</form>\n";

		return $form;
	}

	public static function modalButton($options, $tab = "") {
		$btn = 	"$tab<div class='text-center'>\n"
					.	"$tab\t<a href='{$options['url-add']}' id='{$options['href-id']}' role='button' data-remote='false' data-toggle='modal' data-target='#{$options['modal-id']}' class='btn btn-default' style='color:#a31d26'>". constant($options['btn-add']) ."</a>\n"
					. "$tab</div>\n"
					. "$tab<div class='modal fade bs-example-modal-lg' id='{$options['modal-id']}' tabindex='-1' role='dialog' aria-labelledby='{$options['modal-id-title']}' aria-hidden='true'>\n"
					. "$tab\t<div class='modal-dialog modal-lg'>\n"
					. "$tab\t\t<div class='modal-content'>\n"
					. "$tab\t\t\t<div class='modal-header'>\n"
					. "$tab\t\t\t\t<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>\n"
					. "$tab\t\t\t\t<h4 class='modal-title' id='{$options['modal-id-title']}'>". constant($options['modal-title']) ."</h4>\n"
					. "$tab\t\t\t</div>\n"
					. "$tab\t\t\t<div class='modal-body'></div>\n"
					. "$tab\t\t</div>\n"
					. "$tab\t</div>\n"
					. "$tab</div>\n";
		ob_start();
		?>
		<script>
			$(document).ready(function () {
				$('#<?php echo $options['modal-id']; ?>').on('show.bs.modal', function(e) {
					var link = $(e.relatedTarget);
					$('.modal-body').load(link.attr('href'));
				});
				$('#<?php echo $options['modal-id']; ?>').on('hidden.bs.modal', function (e) { 
					$('.modal-body').empty(); 
				});
			});
		</script>
		<?php
		return $btn;
	}

	public static function section($id, $content, $options = array(), $tab = '') {
		$section =	"$tab<section id='$id'>\n"
							.	$content
							. "$tab</section>\n";
		return $section;
	}

	public static function tab($id, $form, $javascript, $content, $data_validate = array(), $tabulation = '') {
		$tab =	"$tabulation<!-- BEGIN TAB$id --!>\n"
					.	"$tabulation<div id='tabs-$id'>\n";
		if (isset($content['main-form'])) {
			$tab .=	"$tabulation\t<form id='{$form['id']}' name='{$form['name']}' action='modules/{$form['uri']}' class='form-horizontal' ENCTYPE='multipart/form-data' method='POST' style='{$form['style']}'>\n"
						. (isset($form['action']) && strlen($form['action']) ? "$tabulation\t\t<input type='hidden' name='action' value='{$form['action']}' id='id-action-$id'/>\n" : '')
						. $content['main-form']
						. "$tabulation\t</form>\n";
		}
		else {
			$tab .= "$tabulation\t<form class='form-horizontal'>\n"
						.	$content
						. "$tabulation\t</form>";
		}
		$tab .= (isset($content['2nd-form']) ? $content['2nd-form'] : '')
					. ($form['has-required'] ? "$tabulation\t<div class='text-center' style='margin-top:20px;'><i>". REQUIRED_FIELDS ."</i></div>\n" : '')
					. (is_null($javascript) ? '' : $javascript)
					. (empty($data_validate) ? '' : self::validateJavascript($form, $data_validate))
					. "$tabulation</div>\n";
		return $tab;
	}

	public static function table($title, $lines, $options = array(), $tab = '') {
		$table = 	"$tab<table class='{$options['class']}' style='{$options['style']}'>\n"
						.	"$tab\t<tr><th colspan='{$options['colspan']}' class='{$options['class-th']}'>". (defined($title) ? constant($title) : $title) ."</th></tr>\n";
		foreach ($lines as $line) {
			$table .= "$tab\t<tr><td>". implode('</td><td>', $line) ."</td></tr>\n";
		}	
		$table .= "$tab</table>\n";
		return $table;
	}

	public static function validateJavascript($form, $data_validate) {
		$java = '';
		foreach ($data_validate as $key => $params) {
			if (is_null($params['validator-java'])) {
				continue;
			}
			else if (is_array($params['validator-java'])) {
				foreach ($params['validator-java'] as $id => $validator) {
					$java .= "\t\t\t\t\t'data[$key][$id]': { $validator },\n";
				}
			}
			else if (isset($params['is-nodes'])) {
				$java .= "\t\t\t\t\t'data[$key][]': { {$params['validator-java']} },\n";
			}
			else {
				$java .= "\t\t\t\t\t'data[$key]': { {$params['validator-java']} },\n";
			}
		}
		return 	"\t<script>\n"
					.	"\t\t$(document).ready(function() {\n"
					. "\t\t\t$('#{$form['id']}').validate({\n"
					. "\t\t\t\trules: {\n"
					. $java
					. "\t\t\t\t}\n"
					. "\t\t\t});\n"
					. "\t\t});\n"
					. "\t</script>\n";
	}
}
