<?php
$version_file = "/usr/local/VERSION";

// default value
$year = "2019";
$serial = "";

//update year 
$import_year = @file_get_contents($version_file);
preg_match("/YEAR=([0-9]*)/", $import_year, $output_year);

if (isset($output_year[1])) {
        $year = $output_year[1];
}
else {
        // get year from server
        exec("/bin/cat /usr/conf/misc.conf | /bin/grep ntphost | /usr/bin/cut -d '=' -f 2", $ntphost);
        if (isset($ntphost[0]) && strlen($ntphost[0]) > 0) {
                exec("/bin/ping -c 1 $ntphost[0]", $output, $retval);
                $dns_works = (($retval == 0) ? 1 : 0);

                if ($dns_works) {
                        system("/usr/local/bin/rdate -ns $ntphost[0]");
                        $year = date('Y');
                }
        }
}

//get serial number
$serial = Helper::getSerial(!file_exists("/sys/class/beronet/gateway/serial"));
?>

<!-- General HTML Modal code -->
<div class='modal fade bs-example-modal-lg' id='general-popup' tabindex='-1' role='dialog' aria-labelledby='generalModalLabel' aria-hidden='true'>
	<div class='modal-dialog modal-lg'>
		<div class='modal-content'>
			<div class='modal-header'>
				<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
				<h4 class='modal-title' id='generalModalLabel'></h4>
			</div>
			<div class='modal-body general'></div>
		</div>
	</div>
</div>

<!-- Javascript code for Easy Wizard configuration popup -->
<script type="text/javascript">

	$('#general-popup').on('show.bs.modal', function(e) {

		$.ajax({
			type: 'POST',
			url: 'modules/Wizard/wizard_popup.php',
			data: { init: true, settings: 'Network', save_net: true, save_cloud: true, save_prefix: true},
			success: function (data) {
				$('.modal-body.general').html(data);
			},
			failure: function (errMsg) {
				alert(errMsg);
			}
		});
	});

	$('#general-popup').on('hidden.bs.modal', function (e) { 
		$('.modal-body.general').empty(); 
	});

</script>

<!-- footer -->
<div class="clearfix"></div>
<div class="row text-muted footer">

    <!-- copyright text -->
    <div class="col-lg-6" style="line-height: 2.7;">
        Copyright &copy; <?php echo $year; ?> beroNet GmbH, Germany
    </div>
    <div class="col-lg-6" style="line-height: 2.7; text-align: right;">
		<a href='http://wiki.beronet.com/index.php/BerofixDocuV3' target="_blank" id="help" style="float:right;">
			<img src="<?php echo $helpPath."help_button.png"; ?>" alt="Help"/>
	    </a>
		<span style="float:right; margin-right:15px;"><?php echo $serial; ?></span>
    </div>
<!-- footer -->
</div>
</div>
</body>
</html>

