<?PHP
$m = 'PstnHardware';
$berogui_path = "/usr/local/www/berogui";

/* [CHECKING SESSION] */
$newTarget = "/app/berogui/index.php?m=$m";
include($berogui_path .'/includes/session.php');
unset($newTarget);

/* [INCLUDE] */
include_once($berogui_path ."/misc/database.php");
include_once($berogui_path ."/includes/Helper/Helper.php");
include_once($berogui_path ."/includes/Helper/HelperPstn.php");

/* [FUNCTIONS] */
function intToHex($int) {
	return '0x'.dechex($int);
}

/* [MAIN VARIABLES] */
$exec_ajax = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
unset($_GET);

/* [CHECKING POST REQUEST] */
unset($_POST['m']);


$list_post = array(
	// GENERAL
	'id_upd' => 'id', 'master' => array('||', 'select', 'int>=0'), 'type' => 'select', 'portswitch' => 'bool', 'set_hw' => 'bool',
	// PCM
	'pcm_ip' => 'hostname', 'pcm_server' => 'bool', 'pcm_server_port' => 'int-range',
	// COUNTRY
	'country' => 'select'   , 'ohs'  => 'select'	, 'rt' => 'select', 'rz'          => 'bool', 'dcv' => 'select',
	'mini'    => 'select'	, 'acim' => 'select'	, 'ilim' => 'bool', 'boostringer' => 'bool',
	'wait4idle' => 'int-range', 'ring_oscillator_on' => 'int-range', 'ring_oscillator_off' => 'int-range',
);

$list_post_options = array(
	'master'          => array('all', 'pcm')					,
	'type'            => array('analog', 'cas', 'gsm', 'isdn', 'lte', 'cashw')	,
	'pcm_server_port' => array('min' => 1, 'max' => 65535)                          ,
	'country'         => HelperPstn::getCountriesList()                             ,
	'ohs'             => array('ohs=0|ohs2=0', 'ohs=0|ohs2=1', 'ohs=1|ohs2=0')      ,
	'rt'              => array('rt=0|rt2=0', 'rt=1|rt2=0', 'rt=1|rt2=1')            ,
	'dcv'             => array_map(intToHex, range(0, 4)) /*min = 0x0 - max = 0x3*/	,
	'mini'            => array_map(intToHex, range(0, 4)) /*min = 0x0 - max = 0x3*/	,
	'acim'            => array_map(intToHex, range(0,15)) /*min = 0x0 - max = 0xf*/	,
	'wait4idle'       => array('min' => 1000, 'max' => 10000)                       ,
	'ring_oscillator_on' => array('min' => 100, 'max' => 8000)                       ,
	'ring_oscillator_off'=> array('min' => 100, 'max' => 8000)                       ,
);

// TODO: instead defining a variable as 'casmode$i', use 'casmode[]'
// TODO: gather the module list into an unique file
$mode_isdn = array('nt', 'te');
$modules =  array('bf1S0', 'bf2S0', 'bf4S0', 'bf1E1', 'bf2E1', 'bf1GSM', 'bf2GSM', 'bf1LTE', 'bf2LTE', 'bf1FXS', 'bf2FXS', 'bf4FXS', 'bf8FXS', 'bf16FXS', 'bf32FXS', 'bf1FXO', 'bf2FXO', 'bf4FXO', 'bf8FXO', 'bf2S02FXS', 'bf1t1e1', 'bf2t1e1', 'bf4t1e1', 'cas', 'hdlc');

// TODO: this part shoud be avoided if we use 'my_parameter[]' instead of 'my_parameterId1', 'my_parameterId2' and so one
$generic_post = array(
	// GENERAL
	'interface_type' => 'select', 'card_type' => 'select',
	// ANALOG
	// CAS
	'casmode' => 'select', 'coding' => 'select', 't1e1' => 'bool',
	// GSM 
	'pingsm' => 'int-length', 'smscgsm' => 'international-code', 'codecgsm' => 'select',
	// ISDN
	'mode'    => 'select', 'ptp'   => 'bool'     , 'lt'     => 'bool'      , 'permanentl1'   => 'bool',
	'crc'     => 'bool'  , 'crlen' => 'int-range', 'cidlen' => 'int-range' , 'crystal_clock' => 'bool',
	'sync_li' => 'match' ,
	// LTE
	'pinlte'        => 'int-length', 'smsclte' => 'international-code', 'codeclte' => 'select', 'provider_mode' => 'int-range',
	'provider_ids'  => array('||', 'select', 'config-option'),
);

$generic_options = array(
	'card_type'     => $modules                                     ,
	'casmode'       => $mode_isdn                                   ,
	'cidlen'        => array('min' => 0, 'max' => 2)                ,
	'codecgsm'      => array(1, 2, 4, 8, 16)                        ,
	'codeclte'      => array(1, 2, 4, 8, 16, 32, 64, 128)           ,
	'coding'        => array('B8ZS', 'AMI')                         ,
	'crlen'         => array('min' => 0, 'max' => 2)                ,
	'interface_type'=> $modules                                     ,
	'mode'          => $mode_isdn                                   ,
	'pingsm'        => array('operator' => '>=', 'length' => 4)     ,
	'pinlte'        => array('operator' => '>=', 'length' => 4)     ,
	'provider_ids'  => array('Scanning Now', 'No Scan Results', 'No ISGW', '--------'),
	'provider_mode' => array('min' => 0, 'max' => 2)                ,
	'sync_li'       => '^auto$|^crystal$|^isdn-[0-9]+|^cas-[0-9]+$'
);

foreach ($generic_post as $key => $value) {
	foreach($_POST as $param => $val) {
		unset($match);
		if (preg_match('/^'.$key.'([0-9]+)$/', $param, $match)) {
			$list_post[$match[0]] = $value;
			if (isset($generic_options[$key])) {
				$list_post_options[$match[0]] = $generic_options[$key];
			}
		}
	}
}

$_POST = Helper::sanitizePost($_POST, $list_post, $exec_ajax, $invalid, $list_post_options);

/* [EXECUTING AJAX] */
if (!$exec_ajax) {
        echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
        exit(1);
}

$ba = new beroAri();
$helperPstn = new HelperPstn();
$helperPstn->saveHardwareConfiguration($ba, $_POST);
Helper::activate(3, true, $m, ACTIVATE);

echo "<script>window.location='../../index.php?m=$m'</script>";
exit(1);
?>
