<?php
require_once("/usr/local/www/berogui/includes/Helper/Helper.php");

$exec_ajax = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
unset($_GET);

/* [CHECKING SESSION] */
$newTarget = '/app/berogui/index.php?m=Sip';
require_once('/usr/local/www/berogui/includes/session.php');
unset($newTarget);

/* [CHECKING POST REQUEST] */
unset($_POST['start'], $_POST['dummy']);

require_once("/usr/local/www/berogui/misc/config_parameter.php");
require_once("/usr/local/www/berogui/includes/Helper/HelperSip.php");

// TODO: the SIP POST options should be directly into the HelperSip rather the config_parameter file
$list_sip_post = HelperSip::getPostParameters(get_sip_post_options());

$data = Helper::sanitizePost($_POST, $list_sip_post['post'], $exec_ajax, $invalid, $list_sip_post['options']);

/* [EXECUTING SUBMIT] */
if (!$exec_ajax) {
	echo "<script>window.location='../../index.php?m=Sip&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

/**
 * Speichert die SIP Konten
 */
chdir("../..");

include "./includes/variables.php";
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include "./misc/database.php";
$ba = new beroAri();

function parameters(&$data, $config = "") {
	$default = Helper::getDefaultConfig();

	foreach ($data as $key => $value) {
		$data[$key] = str_replace("'", "\"", $data[$key]);
	}

	foreach (HelperSip::$configSave as $option) {
		if (isset($data[$option]) && $data[$option] != $default[$option]) {
			$config .= ",{$option}={$data[$option]}";
		}
		unset($data[$option]);
	}

	foreach (array('srtp_crypto_suites', 'codecs') as $key) {
		if (count($data[$key])) {
			$config .= ",$key=". implode(':', $data[$key]);
		}
		unset($data[$key]);
	}

	foreach (array(
		'sip_to_user_setting', 'sip_from_user_setting', 'sip_from_display_setting', 'sip_pai_user_setting', 'sip_ppi_user_setting', 'sip_contact_user_setting',
		'from_sip_src_setting', 'from_sip_dest_setting',
	) as $key) {
		if (isset($data[$key])) {
			if ($data[$key] == 'manual') {
				$config .= ",$key={$data["{$key}_manual"]}";
			}
			else if ($data[$key] != $default[$key]) {
				$config .= ",$key={$data[$key]}";
			}
		}
		unset($data[$key], $data["{$key}_manual"]);
	}

	//Additional config string hinzufügen.
	if (strlen($data['addit_options'])) {
		$config .= "," . str_replace(array("\r\n", "\n", "\r"), ",", $data['addit_options']);
	}
	unset($data['addit_options']);

	return(trim($config, ','));
}

if (!in_array('manual', $data['matchtype'])) {
	unset($data['matchtype_manual']);
}
$data['matchtype'] = implode('|', $data['matchtype']);

$data['register_option'] = "no-validate no-options-keepalive";
if ($data['validation'] == 1) {
	$data['register_option'] = "validate options-keepalive";
}

switch ($data['option']) {
case 'nonat':
	$data['externip'] = '';
	$data['stunserver'] = '';
	break;
case 'externip':
	$data['stunserver'] = '';
	break;
case 'stun':
	$data['externip'] = '';
	break;
default:
	break;
}
unset($data['option']);

$data['config'] = parameters($data);

$update = $data['id_upd'];
unset($data['id_upd']);

$old_sip_custom_port = "";
$sip_bindport = ""; // get default bindport configured for stack
if (in_array($data['sip_stack'], array("lan","wan","vpn") )) {
	$sip_bindport = $ba->get("sip_bindport_" . $data['sip_stack']);
}

//After modify
if ($update) {
	$id = sqlite_escape_string($update);
	$alt_name = sqlite_escape_string($data['alt_name']);
	$old_sip_custom_port = stripslashes(sqlite_fetch_single($ba->select("select sip_custom_port from sip where id=\"" . sqlite_escape_string($id) . "\"")));
	unset($data['alt_name']);

	if ($data['secret'] == '*****') {
		// dont set secret if not changed
		unset($data['secret']);
	}

	$ba->updateTable('sip', $id, $data);

	if (!$ba->is_error()) {
		$name = sqlite_escape_string($data['name']);

		$query = $ba->update("UPDATE dialplan SET toId='p:$name' WHERE toDirection='sip' and toId='p:$alt_name'");
		$query = $ba->update("UPDATE dialplan SET fromId='p:$name' WHERE fromDirection='sip' AND fromId='p:$alt_name'");
		$query = $ba->update("UPDATE dialplan SET fromId='d:$name' WHERE fromDirection='sip' and fromId='d:$alt_name'");
		$query = $ba->update("UPDATE dialplan SET fromId='t:$name' WHERE fromDirection='sip' and fromId='t:$alt_name'");
		$query = $ba->update("UPDATE dialplan SET fromId='a:$name' WHERE fromDirection='sip' and fromId='a:$alt_name'");
	
		if (!$ba->get('is_sbc_vm') !== 1) {
			$query = $ba->update("UPDATE isdn SET monitored_sip_peer='$name' WHERE monitored_sip_peer='$alt_name'");
		}
	}
} else { //Add new SIP account
	$ba->insertTable('sip', null, $data);
}

$activationLevel = 1; // set activation level (sip_custom_ports needs isgw restart)

// if sip_custom_port changes or initially differs from configured stack port -> orange activate
if ( ( empty($update) && (!empty($data['sip_custom_port']) && $data['sip_custom_port'] != $sip_bindport) ) || ($update && $data['sip_custom_port'] != $old_sip_custom_port) ) {
	$activationLevel = 2;
}

Helper::activate($activationLevel);

if (!$ba->is_error()) {
	echo "<script>window.location='../../index.php?m=Sip'</script>";
} else {
	echo "<script>alert('" . $ba->error() . "');</script>";
}
