<?php

class VpnHelper {

	static public function getData($ba, array $parameters) {
		return [
			'clients' => self::getDataClients(),
			'servers'	=> self::getDataServers($ba, $parameters['server']['data']),
		];
	}

	static public function getDataClients($file = '/var/log/openvpn/status.log') {
		$status = [];
		if (file_exists($file)) {
			$log = explode("\n", file_get_contents($file));
			if (!empty($log)) {
				$nb = 0;
				$key_start = array_search('Common Name,Real Address,Bytes Received,Bytes Sent,Connected Since', $log);
				$key_end = array_search('ROUTING TABLE', $log);
				for ($i = ($key_start + 1); $i < $key_end; $i++) {
					$exploded = explode(",", $log[$i]);
					$status[$nb]['commonName'] = $exploded[0];
					$status[$nb]['realIpaddr'] = preg_replace('/:[0-9]+/', '', $exploded[1]);
					$status[$nb]['bytesRcvd'] = $exploded[2];
					$status[$nb]['bytesSent'] = $exploded[3];
					$status[$nb]['connectedSince'] = $exploded[4];
					$nb++;
				}
				$nb = 0;
				$key_start = array_search('Virtual Address,Common Name,Real Address,Last Ref', $log);
				$key_end = array_search('GLOBAL STATS', $log);
				for ($i = ($key_start + 1); $i < $key_end; $i++) {
					$exploded = explode(",", $log[$i]);
					$status[$nb]['virtIpaddr'] = $exploded[0];
					$status[$nb]['lastRef'] = $exploded[3];
				}
			}
		}
		return $status;
	}

	static public function getDataServers($ba, array $parameters) {
		$data = [];
		$query = $ba->select('SELECT * FROM sbc_vpns');
		while ($entry = $ba->fetch_array($query)) {
			foreach ($parameters as $key => $params) {
				$data[$entry['id']][$key] = $entry[$key];
			}
		}
		return $data;
	}
}

?>
